/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.form;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.taxc.vo.TaxAmountLineVo;
import kd.bos.ext.taxc.vo.TaxAmountMaterialLineVo;
import kd.bos.ext.taxc.vo.TaxLineVo;
import kd.bos.ext.taxc.vo.TaxMaterialLineVo;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.helper.TaxHelper;
import kd.fi.arapcommon.util.EmptyUtils;

public class TaxCodeEditPlugin
extends AbstractBillPlugIn {
    private static Log logger = LogFactory.getLog(TaxCodeEditPlugin.class);
    private boolean propertyChanged = true;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"e_taxcode", "btnok"});
        DynamicObject entity = this.getModel().getDataEntity();
        String entityType = this.getModel().getDataEntityType().getName();
        long countryId = entity.getLong("org.country.id");
        Date bizdate = null;
        bizdate = "ar_finarbill".equals(entityType) ? entity.getDate("invoicedate") : entity.getDate("bizdate");
        this.filterTaxCode(countryId, bizdate, entityType);
    }

    private void filterTaxCode(long countryId, Date bizdate, String entityType) {
        BasedataEdit baseDataCtr = (BasedataEdit)this.getControl("e_taxcode");
        baseDataCtr.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            QFilter filter4;
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            QFilter filter1 = new QFilter("country", "=", (Object)countryId);
            QFilter filter2 = new QFilter("startdate", "<=", (Object)bizdate);
            QFilter filter3 = new QFilter("enddate", ">=", (Object)bizdate);
            qFilters.add(filter1);
            qFilters.add(filter2);
            qFilters.add(filter3.or(QFilter.isNull((String)"enddate")));
            if ("ar_finarbill".equals(entityType) || "ar_busbill".equals(entityType)) {
                filter4 = new QFilter("taxcodeproperty", "=", (Object)"xx");
                qFilters.add(filter4);
            }
            if ("ap_finapbill".equals(entityType) || "ap_busbill".equals(entityType)) {
                filter4 = new QFilter("taxcodeproperty", "=", (Object)"jx");
                qFilters.add(filter4);
            }
            showParameter.getListFilterParameter().getQFilters().addAll(qFilters);
        });
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        int index = e.getChangeSet()[0].getRowIndex();
        switch (key) {
            case "e_taxcode": {
                this.taxCodeCheck(index);
                break;
            }
            case "e_amount": {
                this.checkAndSetDetailEntryTax(false);
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getOperationKey();
        logger.info("calculatetaxc clicked");
        if ("calculatetaxc".equals(itemKey)) {
            this.checkAndSetDetailEntryTax(true);
        }
    }

    private void checkAndSetDetailEntryTax(boolean wholeEntry) {
        boolean ar = this.getModel().getDataEntityType().getAppId().equals("ar");
        boolean needTax = TaxHelper.isNeedTax(this.getModel().getDataEntity().getLong("org.id"), ar);
        if (!needTax) {
            return;
        }
        if (wholeEntry) {
            this.setDetailEntryTax();
            return;
        }
        this.setSpecifiedDetailEntryTaxAmt();
    }

    private void taxCodeCheck(int index) {
        DynamicObject entity = (DynamicObject)this.getModel().getValue("e_taxcode", index);
        Date bizdate = (Date)this.getModel().getValue("bizdate");
        if (entity != null) {
            DynamicObject taxcode = BusinessDataServiceHelper.loadSingleFromCache((Object)entity.getPkValue(), (String)"bastax_taxcode");
            DynamicObjectCollection taxTable = taxcode.getDynamicObjectCollection("entryentity");
            for (DynamicObject tax : taxTable) {
                DynamicObject taxrate = tax.getDynamicObject("taxrate");
                Date startdate = taxrate.getDate("activedate");
                Date enddate = taxrate.getDate("expdate");
                if (enddate == null) {
                    if (startdate.compareTo(bizdate) >= 0) continue;
                    this.getModel().setValue("taxrateid", tax.get("taxrate"), index);
                } else {
                    if (startdate.compareTo(bizdate) >= 0 || enddate.compareTo(bizdate) <= 0) continue;
                    this.getModel().setValue("taxrateid", tax.get("taxrate"), index);
                }
                break;
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u65e0\u7b26\u5408\u6761\u4ef6\u7684\u7a0e\u7801\u3002", (String)"TaxCodeEditPlugin_0", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
    }

    protected void setDetailEntryTax() {
        this.setAllDetailEntryTax();
        this.setAllDetailEntryTaxAmt();
        String entityName = this.getModel().getDataEntityType().getName();
        if ("ar_finarbill".equals(entityName) || "ap_finapbill".equals(entityName)) {
            this.setDetailEntryAdjustAmt();
        }
    }

    private void setAllDetailEntryTax() {
        List<TaxMaterialLineVo> materialLineList = TaxHelper.listTaxCode(this.getModel().getDataEntity());
        if (EmptyUtils.isEmpty(materialLineList)) {
            return;
        }
        for (int i = 0; i < materialLineList.size(); ++i) {
            TaxMaterialLineVo materialLine = materialLineList.get(i);
            if (EmptyUtils.isEmpty(materialLine)) continue;
            this.getModel().setEntryCurrentRowIndex(TaxHelper.getBillDetailEntryName(this.getModel().getDataEntityType().getName()), i);
            this.setTaxCode(i, materialLine.getTaxLineVos());
            this.setTaxDetailEntry(materialLine.getTaxLineVos());
        }
    }

    private void setAllDetailEntryTaxAmt() {
        List<TaxAmountMaterialLineVo> taxLineList = TaxHelper.listAllTaxLine(this.getModel().getDataEntity());
        for (int i = 0; i < taxLineList.size(); ++i) {
            TaxAmountMaterialLineVo taxLine = taxLineList.get(i);
            if (EmptyUtils.isEmpty(taxLine)) continue;
            this.getModel().setEntryCurrentRowIndex(TaxHelper.getBillDetailEntryName(this.getModel().getDataEntityType().getName()), i);
            this.setTaxDetailEntryAmt(taxLine.getTaxAmountLineVo());
        }
    }

    private void setSpecifiedDetailEntryTaxAmt() {
        String entryName = TaxHelper.getBillDetailEntryName(this.getModel().getDataEntityType().getName());
        int detailEntryRowIndex = this.getModel().getEntryCurrentRowIndex(entryName);
        DynamicObject detailEntryRow = this.getModel().getEntryRowEntity(entryName, detailEntryRowIndex);
        DynamicObjectCollection taxDetailEntryCollection = this.getModel().getEntryEntity("subentryentity");
        List<TaxAmountLineVo> taxLineList = TaxHelper.listTaxLine(this.getModel().getDataEntity(), detailEntryRow);
        for (int i = 0; i < Math.min(taxDetailEntryCollection.size(), taxLineList.size()); ++i) {
            if (EmptyUtils.isEmpty(taxLineList.get(i))) continue;
            this.getModel().setValue("s_tax", (Object)taxLineList.get(i).getTaxAmount(), i);
        }
        String entityName = this.getModel().getDataEntityType().getName();
        if ("ar_finarbill".equals(entityName) || "ap_finapbill".equals(entityName)) {
            this.setSpecifiedDetailEntryAdjustAmt(detailEntryRowIndex);
        }
    }

    private void setDetailEntryAdjustAmt() {
        IDataModel m = this.getModel();
        DynamicObjectCollection detailEntryCollection = m.getEntryEntity(TaxHelper.getBillDetailEntryName(this.getModel().getDataEntityType().getName()));
        BigDecimal exchangeRate = (BigDecimal)m.getValue("exchangerate");
        String quotation = "0";
        if (m.getProperty("quotation") != null) {
            quotation = (String)m.getValue("quotation");
        }
        DynamicObject baseCurrency = (DynamicObject)m.getValue("basecurrency");
        int localPrecision = baseCurrency.getInt("amtprecision");
        for (int i = 0; i < detailEntryCollection.size(); ++i) {
            m.setEntryCurrentRowIndex(TaxHelper.getBillDetailEntryName(this.getModel().getDataEntityType().getName()), i);
            BigDecimal detailTaxEntryOffsetAmt = this.getDetailTaxEntryOffsetTotalAmt();
            BigDecimal adjustamount = detailTaxEntryOffsetAmt.negate();
            m.setValue("e_adjustamount", (Object)adjustamount, i);
            BigDecimal adjustlocalamt = null;
            adjustlocalamt = "0".equals(quotation) ? adjustamount.multiply(exchangeRate).setScale(localPrecision, RoundingMode.HALF_UP) : adjustamount.divide(exchangeRate, localPrecision, RoundingMode.HALF_UP);
            m.setValue("e_adjustlocalamt", (Object)adjustlocalamt, i);
        }
    }

    private void setSpecifiedDetailEntryAdjustAmt(int rowIndex) {
        IDataModel m = this.getModel();
        BigDecimal exchangeRate = (BigDecimal)m.getValue("exchangerate");
        String quotation = "0";
        if (m.getProperty("quotation") != null) {
            quotation = (String)m.getValue("quotation");
        }
        DynamicObject baseCurrency = (DynamicObject)m.getValue("basecurrency");
        int localPrecision = baseCurrency.getInt("amtprecision");
        BigDecimal detailTaxEntryOffsetAmt = this.getDetailTaxEntryOffsetTotalAmt();
        BigDecimal adjustamount = detailTaxEntryOffsetAmt.negate();
        m.setValue("e_adjustamount", (Object)adjustamount, rowIndex);
        BigDecimal adjustlocalamt = null;
        adjustlocalamt = "0".equals(quotation) ? adjustamount.multiply(exchangeRate).setScale(localPrecision, RoundingMode.HALF_UP) : adjustamount.divide(exchangeRate, localPrecision, RoundingMode.HALF_UP);
        m.setValue("e_adjustlocalamt", (Object)adjustlocalamt, rowIndex);
    }

    private void setTaxDetailEntry(List<TaxLineVo> taxLineList) {
        if (EmptyUtils.isEmpty(taxLineList)) {
            return;
        }
        this.getModel().deleteEntryData("subentryentity");
        this.propertyChanged = false;
        for (int i = 0; i < taxLineList.size(); ++i) {
            TaxLineVo taxLine = taxLineList.get(i);
            this.getModel().createNewEntryRow("subentryentity");
            if (EmptyUtils.isEmpty(taxLine)) continue;
            this.getModel().setValue("s_taxcode", (Object)taxLine.getTaxCode(), i);
            this.getModel().setValue("s_taxcategory", (Object)taxLine.getTaxType(), i);
            this.getModel().setValue("s_taxrateid", (Object)taxLine.getTaxRate(), i);
            this.getModel().setValue("s_taxrate", (Object)taxLine.getTaxRatePercent(), i);
            this.getModel().setValue("s_isoffset", (Object)Boolean.valueOf(taxLine.getOffsetLogo()), i);
            this.getModel().setValue("s_priority", (Object)taxLine.getOrder(), i);
        }
        this.propertyChanged = true;
    }

    private void setTaxDetailEntryAmt(List<TaxAmountLineVo> taxLineList) {
        if (EmptyUtils.isEmpty(taxLineList)) {
            return;
        }
        for (int i = 0; i < taxLineList.size(); ++i) {
            TaxAmountLineVo taxLine = taxLineList.get(i);
            if (EmptyUtils.isEmpty(taxLine)) continue;
            this.getModel().setValue("s_tax", (Object)taxLine.getTaxAmount(), i);
        }
    }

    private BigDecimal getDetailTaxEntryOffsetTotalAmt() {
        List detailTaxEntryCollection = this.getModel().getEntryEntity("subentryentity").stream().filter(entity -> entity.getBoolean("s_isoffset")).collect(Collectors.toList());
        return detailTaxEntryCollection.stream().map(entity -> entity.getBigDecimal("s_tax")).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private void setTaxCode(int detailEntryIndex, List<TaxLineVo> taxLineList) {
        if (EmptyUtils.isEmpty(taxLineList)) {
            return;
        }
        Optional<TaxLineVo> taxLine = taxLineList.stream().filter(line -> line.getDefaultTaxCode().compareTo(1) == 0).findAny();
        if (!taxLine.isPresent()) {
            return;
        }
        this.getModel().setValue("e_taxcode", (Object)taxLine.get().getTaxCode(), detailEntryIndex);
        this.getModel().setValue("taxrateid", (Object)taxLine.get().getTaxRate(), detailEntryIndex);
        String taxRateName = "ap_finapbill".equals(this.getModel().getDataEntityType().getName()) ? "taxrate" : "e_taxrate";
        this.getModel().setValue(taxRateName, (Object)taxLine.get().getTaxRatePercent(), detailEntryIndex);
    }
}

