/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.form;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.arapcommon.consts.DBRouteConst;
import kd.fi.arapcommon.helper.BaseDataHelper;
import kd.fi.arapcommon.helper.SettingMapperHelper;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.vo.adjexch.AdjExchTransferObject;
import org.apache.commons.lang.StringUtils;

public class TerminalAdjustExchEdit
extends AbstractBillPlugIn {
    protected static final Log logger = LogFactory.getLog(TerminalAdjustExchEdit.class);

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        OperationStatus status = formShowParameter.getStatus();
        if (OperationStatus.VIEW.equals((Object)status)) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            this.getModel().setValue("multyorg", (Object)new Object[]{org.getPkValue()});
        } else {
            List multyorg = (List)formShowParameter.getCustomParam("multyorg");
            if (ObjectUtils.isEmpty((Object)multyorg)) {
                return;
            }
            Object period = formShowParameter.getCustomParam("period");
            String periodName = ResManager.loadKDString((String)"\u671f\u521d", (String)"TerminalAdjustExchEdit_0", (String)"fi-arapcommon", (Object[])new Object[0]);
            if (EmptyUtils.isNotEmpty(period)) {
                periodName = (String)formShowParameter.getCustomParam("periodname");
            }
            Object basecurrency = formShowParameter.getCustomParam("basecurrency");
            Object exratetable = formShowParameter.getCustomParam("exratetable");
            Boolean isPeriod = (Boolean)formShowParameter.getCustomParam("isperiod");
            this.getModel().setValue("multyorg", (Object)multyorg.toArray());
            this.getModel().setValue("period", period);
            this.getModel().setValue("listperiod", (Object)periodName);
            this.getModel().setValue("isperiod", (Object)isPeriod);
            this.getModel().setValue("exratetable", exratetable);
            this.getModel().setValue("basecurrency", basecurrency);
            this.getModel().setValue("adjexchdate", (Object)this.getPeriodEndDate());
            Date exchRateDate = (Date)this.getModel().getValue("adjexchdate");
            Set<Object> currencyIdSet = new HashSet<Object>(16);
            String Scheme = SettingMapperHelper.getValueFromCache("adjustexchange", "handleCurrencyIdSetScheme");
            boolean isUseSchemeOne = "1".equals(Scheme);
            if (isUseSchemeOne) {
                this.handleCurrencyIdSetSchemeOne(currencyIdSet);
            } else {
                this.handleCurrencyIdSetSchemeTwo(currencyIdSet, isPeriod, exchRateDate);
            }
            currencyIdSet = currencyIdSet.stream().filter(currencyId -> !currencyId.toString().equals(basecurrency.toString())).collect(Collectors.toSet());
            if (currencyIdSet.size() < 1) {
                return;
            }
            TableValueSetter tableValueSetter = new TableValueSetter(new String[0]);
            tableValueSetter.addField("e_fromcurr", new Object[0]);
            tableValueSetter.addField("e_tocurr", new Object[0]);
            tableValueSetter.addField("e_exratetable", new Object[0]);
            tableValueSetter.addField("e_exratedate", new Object[0]);
            tableValueSetter.addField("e_exrate", new Object[0]);
            tableValueSetter.addField("e_quotation", new Object[0]);
            for (Object currencyId2 : currencyIdSet) {
                if (currencyId2.toString().equals(basecurrency.toString())) continue;
                Map<String, Object> exchangeRateMap = this.getExchangeRateAndQuotation(this.objectToLong(currencyId2), exchRateDate, !isUseSchemeOne);
                Object[] rowData = new Object[]{this.objectToLong(currencyId2), this.objectToLong(basecurrency), this.objectToLong(exratetable), exchRateDate, 0, "0"};
                boolean isNull = true;
                if (exchangeRateMap != null && exchangeRateMap.get("exchangeRate") != null && exchangeRateMap.get("quoteType") != null) {
                    rowData = new Object[]{this.objectToLong(currencyId2), this.objectToLong(basecurrency), this.objectToLong(exratetable), exchRateDate, exchangeRateMap.get("exchangeRate"), (Boolean)exchangeRateMap.get("quoteType") != false ? "1" : "0"};
                    tableValueSetter.addRow(rowData);
                    isNull = false;
                }
                if (isUseSchemeOne || !isNull) continue;
                tableValueSetter.addRow(rowData);
            }
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.batchCreateNewEntryRow("entry", tableValueSetter);
            this.getView().updateView("entry");
        }
    }

    private Date getPeriodEndDate() {
        DynamicObject period = (DynamicObject)this.getModel().getValue("period");
        if (EmptyUtils.isNotEmpty(period)) {
            return period.getDate("enddate");
        }
        return new Date();
    }

    private Long objectToLong(Object o) {
        return Long.parseLong(String.valueOf(o));
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"adjexch"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Button source = (Button)evt.getSource();
        if ("adjexch".equals(source.getKey())) {
            HashMap<String, BigDecimal> rateMap = new HashMap<String, BigDecimal>(8);
            HashMap<String, String> quotationMap = new HashMap<String, String>(8);
            int rowCount = this.getModel().getEntryRowCount("entry");
            for (int i = 0; i < rowCount; ++i) {
                DynamicObject currency = (DynamicObject)this.getModel().getValue("e_fromcurr", i);
                StringBuilder exchangeRateMapKey = new StringBuilder();
                exchangeRateMapKey.append(currency.getLong("id"));
                BigDecimal exrate = (BigDecimal)this.getModel().getValue("e_exrate", i);
                String quotation = (String)this.getModel().getValue("e_quotation", i);
                if (EmptyUtils.isEmpty(exrate) || EmptyUtils.isEmpty(quotation)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6c47\u7387\u6216\u6362\u7b97\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u7ef4\u62a4\u3002", (String)"TerminalAdjustExchEdit_1", (String)"fi-arapcommon", (Object[])new Object[0]));
                }
                rateMap.put(exchangeRateMapKey.toString(), exrate);
                quotationMap.put(exchangeRateMapKey.toString(), quotation);
            }
            Set<Long> orgIds = this.getOrgIds();
            DynamicObject curPeriod = (DynamicObject)this.getModel().getValue("period");
            AdjExchTransferObject adjExchTransferObject = new AdjExchTransferObject();
            adjExchTransferObject.setAdjExchMode((String)this.getModel().getValue("adjexchmode"));
            adjExchTransferObject.setOrgIds(orgIds);
            adjExchTransferObject.setBizSystem(this.getParam());
            adjExchTransferObject.setFirstPeriod((Boolean)this.getModel().getValue("isperiod"));
            if (EmptyUtils.isNotEmpty(curPeriod)) {
                adjExchTransferObject.setCurPeriodId((Long)curPeriod.getPkValue());
            }
            adjExchTransferObject.setRateMap(rateMap);
            adjExchTransferObject.setQuotationMap(quotationMap);
            Long periodId = EmptyUtils.isNotEmpty(curPeriod) ? curPeriod.getLong("id") : 0L;
            DynamicObject[] adjExchRecords = this.reBuildAdjExchRecord(orgIds, periodId);
            OperationServiceHelper.executeOperate((String)"save", (String)("ar".equalsIgnoreCase(this.getParam()) ? "ar_adjustexch" : "ap_adjustexch"), (DynamicObject[])adjExchRecords, (OperateOption)OperateOption.create());
            this.dispose(adjExchTransferObject);
        }
    }

    private void dispose(AdjExchTransferObject adjExchTransferObject) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setAppId(this.getView().getFormShowParameter().getAppId());
        jobInfo.setJobType(JobType.BIZ);
        jobInfo.setName(ResManager.loadKDString((String)"\u8c03\u6c47", (String)"TerminalAdjustExchEdit_2", (String)"fi-arapcommon", (Object[])new Object[0]));
        jobInfo.setTaskClassname("kd.fi.arapcommon.service.adjustexch.AdjExchBatchAsynchronousTask");
        jobInfo.setId(UUID.randomUUID().toString());
        HashMap<String, String> parameterMap = new HashMap<String, String>(16);
        parameterMap.put("adjExchTransferObject", SerializationUtils.toJsonString((Object)adjExchTransferObject));
        jobInfo.setParams(parameterMap);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "taskcloseback");
        JobFormInfo formInfo = new JobFormInfo(jobInfo);
        formInfo.setCloseCallBack(closeCallBack);
        formInfo.setCanBackground(true);
        formInfo.setCanStop(true);
        formInfo.setTimeout(7200);
        JobForm.dispatch((JobFormInfo)formInfo, (IFormView)this.getView());
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("taskcloseback".equals(actionId)) {
            Map taskReturnData = (Map)closedCallBackEvent.getReturnData();
            if (EmptyUtils.isEmpty(taskReturnData)) {
                return;
            }
            String taskInfos = (String)taskReturnData.get("taskinfo");
            JSONObject taskInfo = JSON.parseObject((String)taskInfos);
            if (EmptyUtils.isEmpty(taskInfo)) {
                return;
            }
            String dataOfTaskInfo = (String)taskInfo.get("data");
            JSONObject resultMap = JSON.parseObject((String)dataOfTaskInfo);
            if (EmptyUtils.isEmpty(resultMap)) {
                return;
            }
            HashMap returnData = new HashMap(resultMap.size());
            ArrayList<Long> returnOrgIds = new ArrayList<Long>(resultMap.size());
            ArrayList<Long> returnPeriodIds = new ArrayList<Long>(resultMap.size());
            StringBuilder errorMessage = new StringBuilder();
            for (Map.Entry resultData : resultMap.entrySet()) {
                Long orgId = Long.parseLong((String)resultData.getKey());
                Map adjExchResultMap = (Map)resultData.getValue();
                if ("true".equals(adjExchResultMap.get("success").toString())) {
                    returnOrgIds.add(orgId);
                    Long periodId = 0L;
                    if (adjExchResultMap.get("periodId") != null) {
                        String tempVariable = adjExchResultMap.get("periodId").toString();
                        periodId = Long.parseLong(tempVariable);
                    }
                    returnPeriodIds.add(periodId);
                    continue;
                }
                errorMessage.append(adjExchResultMap.get("errorMsg"));
                logger.info(String.format("TerminalAdjustExchEdit-closedCallBack:orgId:%s,errorMsg:%s", orgId, errorMessage));
            }
            if (EmptyUtils.isNotEmpty(errorMessage.toString())) {
                this.getView().showErrorNotification(errorMessage.toString());
                return;
            }
            if (EmptyUtils.isNotEmpty(returnOrgIds) && EmptyUtils.isNotEmpty(returnPeriodIds)) {
                this.getView().invokeOperation("refresh");
                returnData.put("org", returnOrgIds);
                returnData.put("period", returnPeriodIds);
                this.getView().returnDataToParent(returnData);
            }
            this.getView().close();
        }
    }

    private DynamicObject[] reBuildAdjExchRecord(Set<Long> orgIds, Long periodId) {
        DynamicObject[] adjExchRecords;
        QFilter orgFilter = new QFilter("org", "in", orgIds);
        QFilter periodFilter = new QFilter("period", "=", (Object)periodId);
        QFilter bizSystemFilter = new QFilter("bizsystem", "=", (Object)this.getParam());
        for (DynamicObject adjExchRecord : adjExchRecords = BusinessDataServiceHelper.load((String)("ar".equalsIgnoreCase(this.getParam()) ? "ar_adjustexch" : "ap_adjustexch"), (String)TerminalAdjustExchEdit.getAdjExchRecordSelector(), (QFilter[])new QFilter[]{orgFilter, periodFilter, bizSystemFilter})) {
            adjExchRecord.set("adjexchdate", this.getModel().getValue("adjexchdate"));
            adjExchRecord.set("adjexchmode", this.getModel().getValue("adjexchmode"));
            DynamicObjectCollection entries = this.getModel().getEntryEntity("entry");
            DynamicObjectType dt = (DynamicObjectType)adjExchRecord.getDataEntityType();
            DynamicObjectType entrydt = ((EntryProp)dt.getProperty("entry")).getDynamicCollectionItemPropertyType();
            DynamicObjectCollection adjExchEntries = adjExchRecord.getDynamicObjectCollection("entry");
            if (EmptyUtils.isNotEmpty(adjExchEntries)) {
                adjExchEntries.clear();
            }
            for (DynamicObject entry : entries) {
                DynamicObject adjustexchEntry = new DynamicObject(entrydt);
                adjustexchEntry.set("e_fromcurr", entry.get("e_fromcurr"));
                adjustexchEntry.set("e_tocurr", entry.get("e_tocurr"));
                adjustexchEntry.set("e_exratetable", entry.get("e_exratetable"));
                adjustexchEntry.set("e_exratedate", entry.get("e_exratedate"));
                adjustexchEntry.set("e_exrate", entry.get("e_exrate"));
                adjustexchEntry.set("e_quotation", entry.get("e_quotation"));
                adjExchEntries.add((Object)adjustexchEntry);
            }
        }
        return adjExchRecords;
    }

    public static String getAdjExchRecordSelector() {
        ArrayList<String> selectors = new ArrayList<String>(16);
        selectors.add("id");
        selectors.add("org");
        selectors.add("isadjexch");
        selectors.add("gainloss");
        selectors.add("adjexchmode");
        selectors.add("adjexchdate");
        selectors.add("e_fromcurr");
        selectors.add("e_tocurr");
        selectors.add("e_exratetable");
        selectors.add("e_exratedate");
        selectors.add("e_exrate");
        selectors.add("e_quotation");
        return String.join((CharSequence)",", selectors);
    }

    private Set<Long> getOrgIds() {
        DynamicObjectCollection multyOrg = (DynamicObjectCollection)this.getModel().getValue("multyorg");
        HashSet<Long> orgIds = new HashSet<Long>(8);
        for (DynamicObject org : multyOrg) {
            orgIds.add((Long)org.getDynamicObject("fbasedataid").getPkValue());
        }
        return orgIds;
    }

    protected String getParam() {
        return (String)this.getView().getFormShowParameter().getCustomParam("bizSystem");
    }

    private void handleCurrencyIdSetSchemeOne(Set<Object> currencyIdSet) {
        DataSet ds = QueryServiceHelper.queryDataSet((String)"TerminalAdjustExchEdit", (String)"bd_currency", (String)"id", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1")}, (String)"id");
        for (Row row : ds) {
            currencyIdSet.add(row.get("id"));
        }
    }

    private void handleCurrencyIdSetSchemeTwo(Set<Object> currencyIdSet, Boolean isPeriod, Date exchRateDate) {
        DynamicObjectCollection multyOrg = (DynamicObjectCollection)this.getModel().getValue("multyorg");
        ArrayList<Long> orgIds = new ArrayList<Long>(8);
        for (DynamicObject org : multyOrg) {
            orgIds.add((Long)org.getDynamicObject("fbasedataid").getPkValue());
        }
        String key = "AP".equals(this.getParam()) ? "t_ap_newbalance" : "t_ar_balance";
        String sqlParam = StringUtils.join((Object[])orgIds.toArray(), (String)",");
        String dateFilter = "";
        DateFormat standardFormat = DateFormat.getDateTimeInstance();
        dateFilter = isPeriod != false ? (String)this.getView().getFormShowParameter().getCustomParam("adjexchdate") : standardFormat.format(exchRateDate);
        String sql = "select distinct(FCurrencyID) from " + key + " where forgid in (" + sqlParam + ") and fstopdate <= '" + dateFilter + "';";
        DataSet ds = DB.queryDataSet((String)TerminalAdjustExchEdit.class.getName(), (DBRoute)this.getDBRoute(), (String)sql);
        for (Row row : ds) {
            currencyIdSet.add(row.get("FCurrencyID"));
        }
        ds.close();
        key = "AP".equals(this.getParam()) ? "t_ap_journal" : "t_ar_journal";
        Date minMonthDate = DateUtils.getMinMonthDate(exchRateDate);
        String minDateFilter = standardFormat.format(minMonthDate);
        sql = "select distinct(FCurrencyID) from " + key + " where forgid in (" + sqlParam + ") and fbizdate between '" + minDateFilter + "' and '" + dateFilter + "';";
        DataSet dsSecond = DB.queryDataSet((String)TerminalAdjustExchEdit.class.getName(), (DBRoute)this.getDBRoute(), (String)sql);
        for (Row row : dsSecond) {
            currencyIdSet.add(row.get("FCurrencyID"));
        }
        dsSecond.close();
        DataSet existDs = QueryServiceHelper.queryDataSet((String)"TerminalAdjustExchEdit", (String)"bd_currency", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", currencyIdSet)}, (String)"id");
        currencyIdSet.clear();
        if (existDs.isEmpty()) {
            return;
        }
        for (Row existD : existDs) {
            currencyIdSet.add(existD.getLong("id"));
        }
    }

    private void addEntityKey(List<String> entityKey) {
        if ("AR".equals(this.getParam())) {
            entityKey.add("ar_finarbill");
            entityKey.add("ar_busbill");
            entityKey.add("ar_receivedbill");
            entityKey.add("cas_recbill");
        } else {
            entityKey.add("ap_finapbill");
            entityKey.add("ap_busbill");
            entityKey.add("ap_paidbill");
            entityKey.add("cas_paybill");
        }
    }

    private DBRoute getDBRoute() {
        if ("AP".equals(this.getParam())) {
            return DBRouteConst.AP;
        }
        return DBRouteConst.AR;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        OperationStatus status = formShowParameter.getStatus();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null) {
            this.getModel().setValue("multyorg", (Object)new Object[]{org.getPkValue()});
        }
        if (OperationStatus.VIEW.equals((Object)status)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"adjexch"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        switch (key) {
            case "adjexchmode": {
                if ("realtime".equals(newValue)) {
                    this.getModel().setValue("adjexchdate", (Object)this.getPeriodEndDate());
                    this.reCalculateExchangeRage();
                }
                if (!"assigndate".equals(newValue)) break;
                this.getModel().setValue("adjexchdate", (Object)this.getPeriodEndDate());
                this.reCalculateExchangeRage();
                break;
            }
            case "adjexchdate": {
                this.reCalculateExchangeRage();
            }
        }
    }

    private void reCalculateExchangeRage() {
        int rows = this.getModel().getEntryRowCount("entry");
        Date adjExchDate = (Date)this.getModel().getValue("adjexchdate");
        for (int i = 0; i < rows; ++i) {
            DynamicObject currencyId = (DynamicObject)this.getModel().getValue("e_fromcurr", i);
            Map<String, Object> exchangeRateMap = this.getExchangeRateAndQuotation(currencyId.getLong("masterid"), adjExchDate, true);
            boolean temp = true;
            if (exchangeRateMap != null && (exchangeRateMap.get("exchangeRate") != null || exchangeRateMap.get("quoteType") != null)) {
                temp = false;
            }
            if (temp) {
                this.getModel().setValue("e_exrate", (Object)0, i);
                this.getModel().setValue("e_quotation", (Object)"0", i);
                continue;
            }
            this.getModel().setValue("e_exrate", exchangeRateMap.get("exchangeRate"), i);
            this.getModel().setValue("e_quotation", (Object)((Boolean)exchangeRateMap.get("quoteType") != false ? "1" : "0"), i);
            this.getModel().setValue("e_exratedate", (Object)adjExchDate, i);
        }
    }

    private Map<String, Object> getExchangeRateAndQuotation(Long currencyId, Date adjExchDate, boolean isNotify) {
        DynamicObject currency;
        DynamicObject exrateTable = (DynamicObject)this.getModel().getValue("exratetable");
        DynamicObject baseCurrency = (DynamicObject)this.getModel().getValue("basecurrency");
        Map<String, Object> exchangeRateMap = BaseDataHelper.getExchangeRateMap(exrateTable.getLong("masterid"), currencyId, baseCurrency.getLong("masterid"), adjExchDate);
        boolean temp = true;
        if (exchangeRateMap == null) {
            temp = false;
        } else if (exchangeRateMap.get("exchangeRate") == null || exchangeRateMap.get("quoteType") == null) {
            temp = false;
        }
        if (isNotify && !temp && (currency = BusinessDataServiceHelper.loadSingleFromCache((Object)currencyId, (String)"bd_currency")) != null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7ed3\u7b97\u5e01\uff1a%s\uff0c\u6c47\u7387\u6216\u6362\u7b97\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u7ef4\u62a4\u3002", (String)"TerminalAdjustExchEdit_3", (String)"fi-arapcommon", (Object[])new Object[]{currency.getString("name")}));
        }
        return exchangeRateMap;
    }
}

