/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.form;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.fi.arapcommon.util.EmptyUtils;

public class TotalDiscountFormPlugin
extends AbstractFormPlugin {
    private static final String BTNOK = "btnok";

    public void afterCreateNewData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object currencyId = formShowParameter.getCustomParam("currency");
        this.getModel().setValue("pricetaxtotal", formShowParameter.getCustomParam("priceTaxTotal"));
        this.getModel().setValue("currency", currencyId);
        Object entityName = formShowParameter.getCustomParam("entityname");
        String fieldName = "ar_finarbill".equals(entityName) || "ar_busbill".equals(entityName) ? ResManager.loadKDString((String)"\u5e94\u6536\u91d1\u989d", (String)"TotalDiscountFormPlugin_5", (String)"fi-arapcommon", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5e94\u4ed8\u91d1\u989d", (String)"TotalDiscountFormPlugin_6", (String)"fi-arapcommon", (Object[])new Object[0]);
        this.getModel().setValue("textareafield", (Object)String.format(ResManager.loadKDString((String)"\u6ce8\u610f\uff1a\u201c\u786e\u5b9a\u201d\u540e\u5c06\u6e05\u9664\u660e\u7ec6\u884c\u5df2\u6709\u201c\u6298\u6263\u65b9\u5f0f\u201d\u3001\u201c\u5355\u4f4d\u6298\u6263(\u7387)\u201d\u3001\u201c\u6298\u6263\u989d\u201d\uff0c\u5e76\u6309%1$s\u7684\u6bd4\u4f8b\u5bf9\u603b\u6298\u6263\u989d\u8fdb\u884c\u5206\u644a\u3002", (String)"TotalDiscountFormPlugin_7", (String)"fi-arapcommon", (Object[])new Object[0]), fieldName));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (BTNOK.equals(operateKey) && this.isCheckAmtRules()) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            resultMap.put("discountamount", this.getModel().getValue("discountamount"));
            this.getView().returnDataToParent(resultMap);
            this.getView().close();
        }
    }

    public boolean isCheckAmtRules() {
        BigDecimal discountAmt = (BigDecimal)this.getModel().getValue("discountamount");
        if (EmptyUtils.isEmpty(discountAmt) || discountAmt.compareTo(BigDecimal.ZERO) == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u201c\u603b\u6298\u6263\u989d\u201d\u3002", (String)"TotalDiscountFormPlugin_0", (String)"fi-arapcommon", (Object[])new Object[0]));
            return false;
        }
        BigDecimal priceTaxTotal = (BigDecimal)this.getModel().getValue("pricetaxtotal");
        if (priceTaxTotal.signum() != discountAmt.signum() || discountAmt.abs().compareTo(priceTaxTotal.abs()) > 0) {
            String appId = this.getView().getFormShowParameter().getAppId();
            String appName = "";
            appName = "ar".equals(appId) ? ResManager.loadKDString((String)"\u5e94\u6536", (String)"TotalDiscountFormPlugin_1", (String)"fi-arapcommon", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5e94\u4ed8", (String)"TotalDiscountFormPlugin_2", (String)"fi-arapcommon", (Object[])new Object[0]);
            if (priceTaxTotal.compareTo(BigDecimal.ZERO) >= 0) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u603b\u6298\u6263\u989d\u9700\u6ee1\u8db3\u4e0e\u6574\u5355%1$s\u91d1\u989d\u7684\u65b9\u5411\u4e00\u81f4\u5e76\u5c0f\u4e8e\u7b49\u4e8e\u6574\u5355%1$s\u91d1\u989d\u3002", (String)"TotalDiscountFormPlugin_3", (String)"fi-arapcommon", (Object[])new Object[0]), appName));
                return false;
            }
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u603b\u6298\u6263\u989d\u9700\u6ee1\u8db3\u4e0e\u6574\u5355%1$s\u91d1\u989d\u7684\u65b9\u5411\u4e00\u81f4\u5e76\u5927\u4e8e\u7b49\u4e8e\u6574\u5355%1$s\u91d1\u989d\u3002", (String)"TotalDiscountFormPlugin_4", (String)"fi-arapcommon", (Object[])new Object[0]), appName));
            return false;
        }
        return true;
    }
}

