/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.form;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.fi.arapcommon.enums.UpgradeExecuteStatusEnum;

public class UpgradeConfigEdit
extends AbstractBillPlugIn {
    public void afterLoadData(EventObject e) {
        int largeTimes = 0;
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject result : entryEntity) {
            int executeTimes = result.getInt("e_executetimes");
            largeTimes = Math.max(executeTimes, largeTimes);
            Date eTaskStartDate = result.getDate("e_taskstartdate");
            Date eTaskEndDate = result.getDate("e_taskenddate");
            if (eTaskStartDate == null || eTaskEndDate == null) continue;
            long intervalSecond = eTaskEndDate.getTime() - eTaskStartDate.getTime();
            result.set("e_costtime", (Object)BigDecimal.valueOf(intervalSecond).divide(BigDecimal.valueOf(1000L)));
        }
        this.getModel().setValue("executetimes", (Object)largeTimes);
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey().toLowerCase();
        if (!"bar_upgradeagain".equals(key)) {
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"UpgradeConfigEdit_0", (String)"fi-arapcommon", (Object[])new Object[0]));
            return;
        }
        if (!UpgradeExecuteStatusEnum.FAILED.getValue().equals(this.getModel().getValue("e_executestatus", selectRows[0]))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6267\u884c\u72b6\u6001\u4e3a\u3010\u6267\u884c\u5931\u8d25\u3011\u7684\u5206\u5f55\u884c\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"UpgradeConfigEdit_1", (String)"fi-arapcommon", (Object[])new Object[0]));
            return;
        }
        DynamicObject selectRow = this.getModel().getEntryRowEntity("entryentity", selectRows[0]);
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("mutex_writeback", "false");
        option.setVariableValue("upgradeentryid", String.valueOf(selectRow.getLong("id")));
        this.getView().invokeOperation("upgrade", option);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        if ("upgrade".equals(e.getOperateKey())) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setSkipNoField(true);
    }
}

