/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.form;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.api.param.SettleResult;
import kd.fi.arapcommon.api.verify.IVerifyService;
import kd.fi.arapcommon.enums.VerifyRelationEnum;
import kd.fi.arapcommon.factory.ArApServiceAPIFactory;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;

public class VerifyCheckPlugin
extends AbstractFormPlugin {
    private Set<Long> mainIds = new HashSet<Long>(8);
    private Set<Long> asstIds = new HashSet<Long>(8);
    private static final int BIZDIRECTION_IN = 0;
    private static final int BIZDIRECTION_OUT = 1;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap", "verify"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        List<String> items = this.check();
        this.getModel().deleteEntryData("entryentity");
        switch (evt.getItemKey()) {
            case "checkbar": {
                if (items.size() > 0) {
                    for (int i = 0; i < items.size(); ++i) {
                        this.getModel().createNewEntryRow("entryentity");
                        this.getModel().setValue("checkscope", (Object)items.get(i), i);
                    }
                    break;
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5339\u914d\u6210\u529f", (String)"VerifyCheckPlugin_0", (String)"fi-arapcommon", (Object[])new Object[0]));
                break;
            }
            case "verify": {
                if (items.size() > 0) {
                    for (int i = 0; i < items.size(); ++i) {
                        this.getModel().createNewEntryRow("entryentity");
                        this.getModel().setValue("checkscope", (Object)items.get(i), i);
                    }
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5339\u914d\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u672a\u901a\u8fc7\u68c0\u67e5\u9879", (String)"VerifyCheckPlugin_1", (String)"fi-arapcommon", (Object[])new Object[0]));
                    break;
                }
                this.verify();
            }
        }
    }

    private void verify() {
        String mainEntity = (String)this.getModel().getValue("mainbillentity");
        String verifyType = (String)this.getModel().getValue("verifytype");
        IVerifyService service = "im_purreceivebill".equals(mainEntity) ? ArApServiceAPIFactory.getVerifyService(VerifyRelationEnum.APPURRECED.getValue()) : this.getVerifyService();
        SettleResult result = "botp".equals(verifyType) ? service.verifyByBotp(this.mainIds, this.asstIds) : service.verifyByCore(this.mainIds, this.asstIds);
        if (result.getSettleRecordPKs().size() > 0) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6838\u9500\u6210\u529f", (String)"VerifyCheckPlugin_2", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
    }

    private IVerifyService getVerifyService() {
        String mainEntity = (String)this.getModel().getValue("mainbillentity");
        DynamicObject[] mains = BusinessDataServiceHelper.load((String)mainEntity, (String)"invscheme", (QFilter[])new QFilter[]{new QFilter("id", "in", this.mainIds)});
        DynamicObject main = mains[0];
        Long invschemeId = main.getLong("invscheme.id");
        DynamicObject invscheme = BusinessDataServiceHelper.loadSingleFromCache((Object)invschemeId, (String)"im_invscheme");
        int direction = invscheme.getDynamicObject("transceivertype").getInt("bizdirection");
        if ("im_purinbill".equals(mainEntity)) {
            if (0 == direction) {
                return ArApServiceAPIFactory.getVerifyService(VerifyRelationEnum.APPURIN.getValue());
            }
            return ArApServiceAPIFactory.getVerifyService(VerifyRelationEnum.APPURRETURN.getValue());
        }
        if ("im_mdc_ominbill".equals(mainEntity) || "im_mdc_omcmplinbill".equals(mainEntity)) {
            if (0 == direction) {
                return ArApServiceAPIFactory.getVerifyService(VerifyRelationEnum.APOMIN.getValue());
            }
            return ArApServiceAPIFactory.getVerifyService(VerifyRelationEnum.APOMINRETURN.getValue());
        }
        if (0 == direction) {
            return ArApServiceAPIFactory.getVerifyService(VerifyRelationEnum.ARSALOUT.getValue());
        }
        return ArApServiceAPIFactory.getVerifyService(VerifyRelationEnum.ARSALRETURN.getValue());
    }

    public List<String> check() {
        boolean asstIspresent;
        boolean mainIspresent;
        Long asstAsstId;
        Long mainAsstId;
        ArrayList<String> items = new ArrayList<String>(16);
        String verifytype = (String)this.getModel().getValue("verifytype");
        String mainEntity = (String)this.getModel().getValue("mainbillentity");
        String mainBillNo = (String)this.getModel().getValue("mainbillno");
        int mainRowNum = (Integer)this.getModel().getValue("mainrownum");
        String asstEntity = (String)this.getModel().getValue("asstbillentity");
        String asstBillNo = (String)this.getModel().getValue("asstbillno");
        int asstRowNum = (Integer)this.getModel().getValue("asstrownum");
        QFilter mainFilter = new QFilter("billno", "=", (Object)mainBillNo).and(new QFilter("billentry.seq", "=", (Object)mainRowNum));
        DynamicObjectCollection mains = this.getBills(mainEntity, mainFilter);
        if (mains.size() == 0) {
            String item = ResManager.loadKDString((String)"\u4e3b\u65b9\u5355\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5", (String)"VerifyCheckPlugin_3", (String)"fi-arapcommon", (Object[])new Object[0]);
            items.add(item);
            return items;
        }
        DynamicObject main = (DynamicObject)mains.get(0);
        this.mainIds.add(main.getLong("id"));
        BigDecimal mainUnVerifyQty = main.getBigDecimal("billentry.unverifyqty");
        if (mainUnVerifyQty.compareTo(BigDecimal.ZERO) == 0) {
            String item = ResManager.loadKDString((String)"\u4e3b\u65b9\u5355\u636e\u672a\u6838\u9500\u6570\u91cf\u4e3a0\uff0c\u8bf7\u68c0\u67e5", (String)"VerifyCheckPlugin_4", (String)"fi-arapcommon", (Object[])new Object[0]);
            items.add(item);
            return items;
        }
        boolean isLogistics = main.getBoolean("billentry.logisticsbill");
        if (isLogistics) {
            String item = ResManager.loadKDString((String)"\u4e3b\u65b9\u5355\u636e\u4e3a\u7269\u6d41\u5355\u636e\uff0c\u4e0d\u53c2\u4e0e\u6838\u9500", (String)"VerifyCheckPlugin_5", (String)"fi-arapcommon", (Object[])new Object[0]);
            items.add(item);
            return items;
        }
        String asstEntryField = "ap_finapbill".equals(asstEntity) ? "detailentry.seq" : "entry.seq";
        QFilter asstFilter = new QFilter("billno", "=", (Object)asstBillNo).and(new QFilter(asstEntryField, "=", (Object)asstRowNum));
        DynamicObjectCollection assts = this.getBills(asstEntity, asstFilter);
        if (assts.size() == 0) {
            String item = ResManager.loadKDString((String)"\u8f85\u65b9\u5355\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5", (String)"VerifyCheckPlugin_6", (String)"fi-arapcommon", (Object[])new Object[0]);
            items.add(item);
            return items;
        }
        DynamicObject asst = (DynamicObject)assts.get(0);
        this.asstIds.add(asst.getLong("id"));
        Map<Long, Long> asstactIdToMasterIdMap = VerifyCheckPlugin.buildMapForAsstactIdToMasterId(asstEntity, main, asst);
        Long mainOrg = main.getLong("billentry.entrysettleorg");
        Long asstOrg = asst.getLong("org");
        if (!mainOrg.equals(asstOrg)) {
            String item = ResManager.loadKDString((String)"\u4e3b\u8f85\u65b9\u7ed3\u7b97\u7ec4\u7ec7\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5", (String)"VerifyCheckPlugin_7", (String)"fi-arapcommon", (Object[])new Object[0]);
            items.add(item);
        }
        if (!(mainAsstId = Long.valueOf(main.getLong("asstact"))).equals(asstAsstId = Long.valueOf(asst.getLong("asstact"))) && !asstactIdToMasterIdMap.get(mainAsstId).equals(asstactIdToMasterIdMap.get(asstAsstId))) {
            String item = ResManager.loadKDString((String)"\u4e3b\u8f85\u65b9\u5f80\u6765\u6237\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5", (String)"VerifyCheckPlugin_8", (String)"fi-arapcommon", (Object[])new Object[0]);
            items.add(item);
        }
        BigDecimal asstQty = asst.getBigDecimal("quantity");
        if (mainUnVerifyQty.signum() != asstQty.signum()) {
            String item = ResManager.loadKDString((String)"\u4e3b\u8f85\u65b9\u5355\u636e\u6570\u91cf\u65b9\u5411\u76f8\u53cd\uff0c\u8bf7\u68c0\u67e5", (String)"VerifyCheckPlugin_9", (String)"fi-arapcommon", (Object[])new Object[0]);
            items.add(item);
        }
        if ((mainIspresent = main.getBoolean("ispresent")) != (asstIspresent = asst.getBoolean("ispresent"))) {
            String item = ResManager.loadKDString((String)"\u4e3b\u8f85\u65b9\u8d60\u54c1\u5c5e\u6027\u4e0d\u4e00\u81f4", (String)"VerifyCheckPlugin_10", (String)"fi-arapcommon", (Object[])new Object[0]);
            items.add(item);
        }
        if ("botp".equals(verifytype)) {
            List<String> botpCheckItems = this.botpVerifyCheck(mainEntity, asstEntity, main, asst);
            items.addAll(botpCheckItems);
        } else {
            List<String> coreCheckItems = this.coreVerifyCheck(main, asst);
            items.addAll(coreCheckItems);
        }
        return items;
    }

    private List<String> coreVerifyCheck(DynamicObject main, DynamicObject asst) {
        ArrayList<String> items = new ArrayList<String>(16);
        long orgId = asst.getLong("org");
        String asstEntity = (String)this.getModel().getValue("asstbillentity");
        boolean coreBillVerifyparam = "ap_finapbill".equals(asstEntity) ? ((Boolean)SystemParameterHelper.getAPAppParameter(orgId, "ap_020")).booleanValue() : ((Boolean)SystemParameterHelper.getARAppParameter(orgId, "ar_014")).booleanValue();
        Long mainVerison = main.getLong("version");
        Long asstVersion = asst.getLong("version");
        String mainAuxpty = main.getString("auxpty");
        String asstAuxpty = asst.getString("auxpty");
        Long mainConfiguredcode = main.getLong("configuredcode");
        Long asstConfiguredcode = asst.getLong("configuredcode");
        Long mainTracknumber = main.getLong("tracknumber");
        Long asstTracknumber = asst.getLong("tracknumber");
        String mainCoreBillNo = main.getString("corebillno");
        String asstCoreBillNo = asst.getString("corebillno");
        int mainCoreEntrySeq = main.getInt("corebillentryseq");
        int asstCoreEntrySeq = asst.getInt("corebillentryseq");
        if (!coreBillVerifyparam) {
            items.add(ResManager.loadKDString((String)"\u6309\u6838\u5fc3\u5355\u636e\u53f7\u6838\u9500\u53c2\u6570\u672a\u5f00\u542f", (String)"VerifyCheckPlugin_11", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        if (mainCoreBillNo == null || mainCoreEntrySeq == 0 || !mainCoreBillNo.equals(asstCoreBillNo) || mainCoreEntrySeq != asstCoreEntrySeq) {
            items.add(ResManager.loadKDString((String)"\u4e3b\u8f85\u65b9\u6838\u5fc3\u5355\u636e\u53f7\u6216\u6838\u5fc3\u5355\u636e\u884c\u53f7\u4e0d\u4e00\u81f4", (String)"VerifyCheckPlugin_12", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        if (!mainVerison.equals(asstVersion)) {
            items.add(ResManager.loadKDString((String)"\u4e3b\u8f85\u65b9\u7269\u6599\u7248\u672c\u53f7\u4e0d\u4e00\u81f4", (String)"VerifyCheckPlugin_13", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        if (!mainAuxpty.equals(asstAuxpty)) {
            items.add(ResManager.loadKDString((String)"\u4e3b\u8f85\u65b9\u7269\u6599\u8f85\u52a9\u5c5e\u6027\u4e0d\u4e00\u81f4", (String)"VerifyCheckPlugin_14", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        if (!mainConfiguredcode.equals(asstConfiguredcode)) {
            items.add(ResManager.loadKDString((String)"\u4e3b\u8f85\u65b9\u914d\u7f6e\u53f7\u4e0d\u4e00\u81f4", (String)"VerifyCheckPlugin_15", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        if (!mainTracknumber.equals(asstTracknumber)) {
            items.add(ResManager.loadKDString((String)"\u4e3b\u8f85\u65b9\u8ddf\u8e2a\u53f7\u4e0d\u4e00\u81f4", (String)"VerifyCheckPlugin_16", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        return items;
    }

    private List<String> botpVerifyCheck(String mainEntity, String asstEntity, DynamicObject main, DynamicObject asst) {
        ArrayList<String> items = new ArrayList<String>(16);
        String entryType = "ap_finapbill".equals(asstEntity) ? "detailentry" : "entry";
        String entryIDFields = "ap_finapbill".equals(asstEntity) ? "detailentry.id" : "entry.id";
        Map<Long, Long> entryRowBotpMap = BOTPHelper.loadSourceRowIdsMap(asstEntity, entryType, new Long[]{asst.getLong("id")}, new Long[]{asst.getLong(entryIDFields)}, mainEntity);
        if (entryRowBotpMap.get(asst.getLong(entryIDFields)) != null && !entryRowBotpMap.get(asst.getLong(entryIDFields)).equals(main.getLong("billentry.id"))) {
            String relationItem = ResManager.loadKDString((String)"\u4e3b\u8f85\u65b9\u5206\u5f55\u6ca1\u6709\u5173\u8054\u5173\u7cfb\uff0c\u8bf7\u68c0\u67e5", (String)"VerifyCheckPlugin_17", (String)"fi-arapcommon", (Object[])new Object[0]);
            items.add(relationItem);
            return items;
        }
        return items;
    }

    private DynamicObjectCollection getBills(String entity, QFilter filter) {
        if ("ap_finapbill".equals(entity)) {
            return QueryServiceHelper.query((String)entity, (String)"id,asstact,org,detailentry.id,detailentry.quantity quantity,detailentry.e_materialversion version,detailentry.e_assistantattr auxpty,detailentry.configuredcode configuredcode,detailentry.tracknumber tracknumber,detailentry.corebillno corebillno,detailentry.corebillentryseq corebillentryseq,detailentry.ispresent ispresent", (QFilter[])new QFilter[]{filter});
        }
        if ("ar_revcfmbill".equals(entity)) {
            return QueryServiceHelper.query((String)entity, (String)"id,asstact,org,entry.id,entry.e_quantity quantity,entry.e_materialversion version,entry.e_assistantattr auxpty,entry.configuredcode configuredcode,entry.tracknumber tracknumber,entry.e_corebillno corebillno,entry.e_corebillentryseq corebillentryseq,entry.e_ispresent ispresent", (QFilter[])new QFilter[]{filter});
        }
        if ("im_saloutbill".equals(entity)) {
            return QueryServiceHelper.query((String)entity, (String)"id,billentry.mversion version,billentry.auxpty auxpty,billentry.configuredcode configuredcode,billentry.tracknumber tracknumber,billentry.unverifyqty,billentry.id,billentry.mainbillnumber corebillno,billentry.mainbillentryseq corebillentryseq,billentry.logisticsbill,billentry.ispresent ispresent,billentry.settlecustomer asstact,billentry.entrysettleorg", (QFilter[])new QFilter[]{filter});
        }
        return QueryServiceHelper.query((String)entity, (String)"id,billentry.mversion version,billentry.auxpty auxpty,billentry.configuredcode configuredcode,billentry.tracknumber tracknumber,billentry.unverifyqty,billentry.id,billentry.mainbillnumber corebillno,billentry.mainbillentryseq corebillentryseq,billentry.logisticsbill,billentry.ispresent ispresent,billentry.invoicesupplier asstact,billentry.entrysettleorg", (QFilter[])new QFilter[]{filter});
    }

    private static Map<Long, Long> buildMapForAsstactIdToMasterId(String asstEntity, DynamicObject main, DynamicObject asst) {
        HashMap<Long, Long> asstactIdToMasterIdMap = new HashMap<Long, Long>(16);
        HashSet<Long> asstactIds = new HashSet<Long>(2);
        asstactIds.add(main.getLong("asstact"));
        asstactIds.add(asst.getLong("asstact"));
        String asstType = "ap_finapbill".equals(asstEntity) ? "bd_supplier" : "bd_customer";
        String selectField = "id,masterid";
        DynamicObjectCollection asstactCollection = QueryServiceHelper.query((String)asstType, (String)selectField, (QFilter[])new QFilter[]{new QFilter("id", "in", asstactIds)});
        asstactIdToMasterIdMap.putAll(asstactCollection.stream().collect(Collectors.toMap(e -> e.getLong("id"), e -> e.getLong("masterid"))));
        return asstactIdToMasterIdMap;
    }
}

