/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.helper;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.helper.DynamicObjectHelper;
import kd.fi.arapcommon.util.StringUtils;
import kd.fi.arapcommon.vo.ARAPSumParam;

public class ArApReportHelper {
    public static DataSet getSettleDS4Sum(ARAPSumParam param, Long orgId, Date startDate, Date stopDate, String appName) {
        String mainSelector = "org,mainasstacttype asstacttype,mainasstactid asstact,maincurrency currency,basecurrency,totalsettleamt settleamt,localtotalsettleamt localsettleamt";
        String asstSelector = "org,entry.asstacttype asstacttype,entry.asstactid asstact,entry.currency currency,basecurrency,entry.settleamt settleamt,entry.localsettleamt localsettleamt";
        return ArApReportHelper.getSettleDataSet(param, orgId, startDate, stopDate, appName, mainSelector, asstSelector);
    }

    private static DataSet getSettleDataSet(ARAPSumParam param, Long orgId, Date startDate, Date stopDate, String appName, String mainSelector, String asstSelector) {
        List<Long> orgIds = new ArrayList<Long>();
        if (orgId == null) {
            orgIds = ArApReportHelper.getIdList((List<DynamicObject>)param.getOrgs());
        } else {
            orgIds.add(orgId);
        }
        QFilter mainFilter = new QFilter("org", "in", orgIds);
        QFilter asstFilter = new QFilter("org", "in", orgIds);
        if (startDate != null) {
            mainFilter.and(new QFilter("settledate", ">=", (Object)startDate));
            asstFilter.and(new QFilter("settledate", ">=", (Object)startDate));
        }
        mainFilter.and(new QFilter("settledate", "<=", (Object)stopDate));
        asstFilter.and(new QFilter("settledate", "<=", (Object)stopDate));
        if (param != null) {
            DynamicObjectCollection currencyColl;
            DynamicObjectCollection asstColl;
            String asstactType = param.getAsstactType();
            if (StringUtils.isNotEmpty(asstactType)) {
                mainFilter.and(new QFilter("mainasstacttype", "=", (Object)asstactType));
                asstFilter.and(new QFilter("entry.asstacttype", "=", (Object)asstactType));
            }
            if ((asstColl = param.getAsstact()) != null) {
                List<Long> asstIds = ArApReportHelper.getIdList((List<DynamicObject>)asstColl);
                mainFilter.and(new QFilter("mainasstactid", "in", asstIds));
                asstFilter.and(new QFilter("entry.asstactid", "in", asstIds));
            }
            if ((currencyColl = param.getCurrencys()) != null && currencyColl.size() > 0) {
                List<Long> currencyIds = ArApReportHelper.getIdList((List<DynamicObject>)currencyColl);
                mainFilter.and(new QFilter("maincurrency", "in", currencyIds));
                asstFilter.and(new QFilter("entry.currency", "in", currencyIds));
            }
        }
        if ("ar".equals(appName)) {
            mainFilter.and(new QFilter("settlerelation", "in", (Object)new String[]{SettleRelationEnum.RECSETTLE.getValue(), SettleRelationEnum.ARAPSETTLE.getValue(), SettleRelationEnum.ARTRANSFER.getValue(), SettleRelationEnum.BADDEBTLOSS.getValue()}));
            asstFilter.and(new QFilter("settlerelation", "in", (Object)SettleRelationEnum.APARSETTLE.getValue()));
        } else {
            mainFilter.and(new QFilter("settlerelation", "in", (Object)new String[]{SettleRelationEnum.APPAYSETTLE.getValue(), SettleRelationEnum.APARSETTLE.getValue(), SettleRelationEnum.PAYTRANS.getValue(), SettleRelationEnum.APLIQUIDATIONSETTLE.getValue()}));
            asstFilter.and(new QFilter("settlerelation", "=", (Object)SettleRelationEnum.ARAPSETTLE.getValue()));
        }
        DataSet mainSettleDS = QueryServiceHelper.queryDataSet((String)"queryMainSettle", (String)"ap_settlerecord", (String)mainSelector, (QFilter[])new QFilter[]{mainFilter}, (String)"");
        DataSet asstSettleDS = QueryServiceHelper.queryDataSet((String)"queryAsstSettle", (String)"ap_settlerecord", (String)asstSelector, (QFilter[])new QFilter[]{asstFilter}, (String)"");
        DataSet settleDS = ArApReportHelper.union(mainSettleDS, asstSettleDS);
        return settleDS;
    }

    public static QFilter getBaseFilter(ARAPSumParam param, Long orgId) {
        DynamicObjectCollection currencyColl;
        List<Long> orgIds = new ArrayList<Long>();
        if (orgId == null) {
            orgIds = ArApReportHelper.getIdList((List<DynamicObject>)param.getOrgs());
        } else {
            orgIds.add(orgId);
        }
        QFilter filter = new QFilter("org", "in", orgIds);
        if (param == null) {
            return filter;
        }
        String asstactType = param.getAsstactType();
        if (StringUtils.isNotEmpty(asstactType)) {
            filter.and(new QFilter("asstacttype", "=", (Object)asstactType));
        }
        if (param.getAsstact() != null) {
            DynamicObjectCollection asstColl = param.getAsstact();
            List<Long> asstIds = ArApReportHelper.getIdList((List<DynamicObject>)asstColl);
            filter.and(new QFilter("asstact", "in", asstIds));
        }
        if ((currencyColl = param.getCurrencys()) != null && currencyColl.size() > 0) {
            List<Long> currencyIds = ArApReportHelper.getIdList((List<DynamicObject>)currencyColl);
            filter.and(new QFilter("currency", "in", currencyIds));
        }
        if (param.isIncludUnAudit()) {
            filter.and(new QFilter("billstatus", "in", (Object)new String[]{"B", "C"}));
        } else {
            filter.and(new QFilter("billstatus", "=", (Object)"C"));
        }
        return filter;
    }

    public static List<Long> getIdList(List<DynamicObject> orgList) {
        return DynamicObjectHelper.getLongIds(orgList);
    }

    public static DataSet union(DataSet d, DataSet ... ds) {
        DataSet left = null;
        if (d != null) {
            left = d;
        }
        for (int i = 0; i < ds.length; ++i) {
            if (left == null) {
                left = ds[i];
                continue;
            }
            if (ds[i] == null) continue;
            left = left.union(ds[i]);
        }
        return left;
    }
}

