/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.helper;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.consts.DBRouteConst;
import kd.fi.arapcommon.util.StringUtils;

public class ArApResetOrgIdEventHelper {
    private static final Log logger = LogFactory.getLog(ArApResetOrgIdEventHelper.class);

    public static Map<String, Set<String>> getBaseDataNameAndDBRoot(boolean isForEvent) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>(8);
        HashSet<String> fiData = new HashSet<String>(8);
        fiData.add("fcm_checkitem");
        fiData.add("ai_recdatarule");
        fiData.add("ap_payproperty");
        fiData.add("ap_healthcheck");
        fiData.add("ap_accrualaging");
        fiData.add("ar_payproperty");
        fiData.add("ar_accrualaging");
        fiData.add("ar_baddebtaccrualplan");
        fiData.add("ar_rpa_settlescheme");
        result.put("fi", fiData);
        HashSet<String> baseData = new HashSet<String>(8);
        baseData.add("bos_print_meta");
        baseData.add("sch_job");
        baseData.add("bos_assistantdatagroup");
        result.put("basedata", baseData);
        return result;
    }

    public static Map<Long, Set<String>> getBaseDataView(Set<String> entityIds) {
        HashMap<Long, Set<String>> result = new HashMap<Long, Set<String>>(8);
        if (entityIds == null || entityIds.isEmpty()) {
            return result;
        }
        Long fiDefaultViewId = 0L;
        HashSet<String> copyEntityIds = new HashSet<String>(entityIds);
        QFilter[] baseDataFilters = new QFilter[]{new QFilter("basedata", "in", entityIds)};
        Map baseDataViews = BusinessDataServiceHelper.loadFromCache((String)"bd_basedataview", (String)"ctrlview.treetype, basedata", (QFilter[])baseDataFilters);
        if (baseDataViews != null && !baseDataViews.isEmpty()) {
            for (Map.Entry baseData : baseDataViews.entrySet()) {
                DynamicObject baseDataDo;
                DynamicObject value = (DynamicObject)baseData.getValue();
                if (value == null || (baseDataDo = value.getDynamicObject("basedata")) == null) continue;
                String entityName = baseDataDo.getPkValue().toString();
                Long viewId = value.getLong("ctrlview.id");
                if (fiDefaultViewId == 0L && "ap_payproperty".equals(entityName)) {
                    fiDefaultViewId = viewId;
                }
                Set entities = result.getOrDefault(viewId, new HashSet(8));
                entities.add(entityName);
                result.put(viewId, entities);
                copyEntityIds.remove(entityName);
            }
        }
        if (copyEntityIds.isEmpty()) {
            return result;
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("basedataid", "in", copyEntityIds)};
        Map defaultCtrlStrategies = BusinessDataServiceHelper.loadFromCache((String)"bd_bddefctrlstrtgy", (String)"ctrlview.treetype, basedataid", (QFilter[])qFilters);
        if (defaultCtrlStrategies != null && !defaultCtrlStrategies.isEmpty()) {
            for (Map.Entry defaultCtrlStrategy : defaultCtrlStrategies.entrySet()) {
                DynamicObject baseDataDo;
                DynamicObject value = (DynamicObject)defaultCtrlStrategy.getValue();
                if (value == null || (baseDataDo = value.getDynamicObject("basedataid")) == null) continue;
                String entityName = baseDataDo.getPkValue().toString();
                Long viewId = value.getLong("ctrlview.id");
                if (fiDefaultViewId == 0L && "ap_payproperty".equals(entityName)) {
                    fiDefaultViewId = viewId;
                }
                Set entities = result.getOrDefault(viewId, new HashSet(8));
                entities.add(entityName);
                result.put(viewId, entities);
                copyEntityIds.remove(entityName);
            }
        }
        if (!copyEntityIds.isEmpty() && fiDefaultViewId != 0L) {
            ((Set)result.get(fiDefaultViewId)).addAll(copyEntityIds);
        }
        return result;
    }

    public static void excuteResetOrgId(String dbKey, Set<String> entities, Map<String, Long> entityAndRootId, boolean isForEvent) {
        try (TXHandle tx = TX.requiresNew((String)("ArApResetOrgIdEventHelper." + dbKey));){
            logger.info("ArApResetOrgIdEventHelper.excuteResetOrgId.entityAndRootId:" + entityAndRootId);
            try {
                switch (dbKey) {
                    case "fi": {
                        ArApResetOrgIdEventHelper.updateFi(entities, entityAndRootId, isForEvent);
                        break;
                    }
                    case "base": {
                        ArApResetOrgIdEventHelper.updateBase(entities, entityAndRootId, isForEvent);
                        break;
                    }
                    case "wf": {
                        ArApResetOrgIdEventHelper.updateWF(entities, entityAndRootId, isForEvent);
                    }
                }
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    private static void updateFi(Set<String> entities, Map<String, Long> entityAndRootId, boolean isForEvent) {
        String sql;
        Long rootOrgId;
        if (entities.contains("ar_payproperty")) {
            rootOrgId = entityAndRootId.get("ar_payproperty");
            sql = "update t_ar_payproperty set fcreateorgid = " + rootOrgId + ", forgid = " + rootOrgId + " where FID in (503272215320499200,503272964926511104,503273213631960064,503273589181552640,1855010514183143424)";
            ArApResetOrgIdEventHelper.filterAndExcuteSql(DBRouteConst.FI, rootOrgId, isForEvent, sql);
        }
        if (entities.contains("ar_accrualaging")) {
            rootOrgId = entityAndRootId.get("ar_accrualaging");
            sql = "update t_ar_accrualaging set fcreateorgid = " + rootOrgId + ", forgid = " + rootOrgId + " where FID in (1513190301324293120,1530657671860979712)";
            ArApResetOrgIdEventHelper.filterAndExcuteSql(DBRouteConst.FI, rootOrgId, isForEvent, sql);
        }
        if (entities.contains("ar_baddebtaccrualplan")) {
            rootOrgId = entityAndRootId.get("ar_baddebtaccrualplan");
            sql = "update t_ar_baddebtaccrualplan set fcreateorgid = " + rootOrgId + ", forgid = " + rootOrgId + " where FID = 1544107390520048640";
            ArApResetOrgIdEventHelper.filterAndExcuteSql(DBRouteConst.FI, rootOrgId, isForEvent, sql);
        }
        if (entities.contains("ar_rpa_settlescheme")) {
            rootOrgId = entityAndRootId.get("ar_rpa_settlescheme");
            sql = "update t_ar_rpaschemeorgentry set forgid = " + rootOrgId + " where FENTRYID = 1743569978138826754";
            ArApResetOrgIdEventHelper.filterAndExcuteSql(DBRouteConst.FI, rootOrgId, isForEvent, sql);
        }
        if (entities.contains("ai_recdatarule")) {
            rootOrgId = entityAndRootId.get("ai_recdatarule");
            sql = "update T_AI_RECDATARULE set FCREATEORGID = " + rootOrgId + ", FORGID = " + rootOrgId + ", FUSEORG = " + rootOrgId + " WHERE FID = 874515865658216448";
            ArApResetOrgIdEventHelper.filterAndExcuteSql(DBRouteConst.FI, rootOrgId, isForEvent, sql);
        }
        if (entities.contains("fcm_checkitem")) {
            rootOrgId = entityAndRootId.get("fcm_checkitem");
            sql = "update t_fcm_checkitem set FCREATEORGID = " + rootOrgId + ", FORGID = " + rootOrgId + " WHERE FID in (1072964685428456448,1072995342728853504,1072998682418247680,1072999881737533440,1073005516617186304,1073096384560789504,1073096737092040704,1073097127783070720,1073097499683617792)";
            ArApResetOrgIdEventHelper.filterAndExcuteSql(DBRouteConst.FI, rootOrgId, isForEvent, sql);
        }
        if (entities.contains("ap_payproperty")) {
            rootOrgId = entityAndRootId.get("ap_payproperty");
            sql = "update t_ap_payproperty set fcreateorgid = " + rootOrgId + ", forgid = " + rootOrgId + " where FID in (503318221366006784,503319431607260160,503319710780135424,503320404845171712,503321651635591168,503321910306706432,503322248392775680,503322667848340480,612769728418586624,503318643782752256,748989939932240896,754280801553625088,1783255780082862080)";
            ArApResetOrgIdEventHelper.filterAndExcuteSql(DBRouteConst.FI, rootOrgId, isForEvent, sql);
        }
        if (entities.contains("ai_recdatarule")) {
            rootOrgId = entityAndRootId.get("ai_recdatarule");
            sql = "update T_AI_RECDATARULE set FCREATEORGID = " + rootOrgId + ", FORGID = " + rootOrgId + ", FUSEORG = " + rootOrgId + " WHERE FID in (872230884571376640,1834114279414971392)";
            ArApResetOrgIdEventHelper.filterAndExcuteSql(DBRouteConst.FI, rootOrgId, isForEvent, sql);
        }
        if (entities.contains("ap_healthcheck")) {
            rootOrgId = entityAndRootId.get("ap_healthcheck");
            sql = "update t_ap_healthchecks set forgid = " + rootOrgId + " WHERE FID in (1212281587136225280,1212281364200579072,1212281160768446464,1212280956992380928,1212280745465241600,1212280520893816832,1212280247794294784,1212280018038710272,1212279832667250688,1212279641977413632,1212279448368340992,1212279256436989952,1212278847039365120,1212278596857520128,1212278317927915520,1212277828477804544,1212277500021858304,1212200383238135808,1212276733336642560,1212276344449164288,1212275907696288768,1212275496318952448,1212275209780880384,1212274909560988672)";
            ArApResetOrgIdEventHelper.filterAndExcuteSql(DBRouteConst.FI, rootOrgId, isForEvent, sql);
        }
        if (entities.contains("ap_accrualaging")) {
            rootOrgId = entityAndRootId.get("ap_accrualaging");
            sql = "update t_ap_accrualaging set FCREATEORGID = " + rootOrgId + ", FORGID = " + rootOrgId + " WHERE FID = 1513190836777530368";
            ArApResetOrgIdEventHelper.filterAndExcuteSql(DBRouteConst.FI, rootOrgId, isForEvent, sql);
        }
    }

    private static void updateBase(Set<String> entities, Map<String, Long> entityAndRootId, boolean isForEvent) {
        String sql;
        Long rootOrgId;
        if (entities.contains("bos_print_meta")) {
            rootOrgId = entityAndRootId.get("bos_print_meta");
            sql = "update t_svc_printmeta set FORGID = " + rootOrgId + " WHERE FID in ('2P53L48BGDJE','2P53L3LLYYMR','2P53L51PAVXM','2P53L5KAEH82','2P53L1Z6374C','2P53L6+3V1A/','2P53L2R4KG=4')";
            ArApResetOrgIdEventHelper.filterAndExcuteSql(DBRouteConst.BASEDATA, rootOrgId, isForEvent, sql);
        }
        if (entities.contains("bos_assistantdatagroup")) {
            rootOrgId = entityAndRootId.get("bos_assistantdatagroup");
            sql = "update t_bas_assistantdata set FCREATEORGID = " + rootOrgId + " WHERE FID = '829631011070476288'";
            ArApResetOrgIdEventHelper.filterAndExcuteSql(DBRouteConst.BASEDATA, rootOrgId, isForEvent, sql);
        }
        if (entities.contains("bos_print_meta")) {
            rootOrgId = entityAndRootId.get("bos_print_meta");
            sql = "update t_svc_printmeta set FORGID = " + rootOrgId + " WHERE FID in ('2P8HDTE8V8T3','2P8HDUB83YBK','2P8HDRXH6V1/','2P8HDVZ2ALK8','2P8HDV2B1XAB','2P8HDX+1I4DR','2P8HDXQXGE8C')";
            ArApResetOrgIdEventHelper.filterAndExcuteSql(DBRouteConst.BASEDATA, rootOrgId, isForEvent, sql);
        }
        if (entities.contains("sch_job")) {
            rootOrgId = entityAndRootId.get("sch_job");
            sql = "update T_SCH_JOB set FRUNBYORGID = " + rootOrgId + " WHERE FID in ('104CGO9KJNK5','1LVIUEXV8AB3','1LVQJL7FK1IR','0U4KE8V+ZOH+','18J+X1SVCM4S','0U4KE8V+ZOH+','1V/IOABE1G/E')";
            ArApResetOrgIdEventHelper.filterAndExcuteSql(DBRouteConst.BASEDATA, rootOrgId, isForEvent, sql);
        }
    }

    private static void updateWF(Set<String> entities, Map<String, Long> entityAndRootId, boolean isForEvent) {
        String sql;
        Long rootOrgId;
        if (entities.contains("wf_model")) {
            rootOrgId = entityAndRootId.get("wf_model");
            sql = "update t_wf_model set FORGUNITID = '" + rootOrgId + "' WHERE fid in ('1497787062223408128','1495714846451330048','1497840483228087296')";
            ArApResetOrgIdEventHelper.filterAndExcuteSql(DBRouteConst.WF, rootOrgId, isForEvent, sql);
        }
        if (entities.contains("wf_resource") && (rootOrgId = entityAndRootId.get("wf_resource")) != null && rootOrgId != 0L) {
            Map<String, String> wfResourceContent = ArApResetOrgIdEventHelper.getWFContent(rootOrgId);
            for (Map.Entry<String, String> entry : wfResourceContent.entrySet()) {
                String id = entry.getKey();
                String value = entry.getValue();
                sql = "update t_wf_gebytearray set FCONTENT = '" + value + "' WHERE fid = " + id;
                DB.execute((DBRoute)DBRouteConst.WF, (String)sql);
            }
        }
    }

    private static void filterAndExcuteSql(DBRoute key, Long rootOrgId, boolean isForEvent, String sql) {
        if (rootOrgId == null || rootOrgId == 0L || StringUtils.isEmpty(sql)) {
            return;
        }
        if (!isForEvent && rootOrgId == 100000L) {
            return;
        }
        DB.execute((DBRoute)key, (String)sql);
    }

    public static Map<String, String> getWFContent(Long rootOrgId) {
        HashMap<String, String> result = new HashMap<String, String>(8);
        DataSet getWFContent = DB.queryDataSet((String)"getWFContent", (DBRoute)DBRouteConst.WF, (String)"select fid,fcontent from t_wf_gebytearray where fid in (1497787063565584384,1495714846812163072,1497840483546977280)");
        for (Row row : getWFContent) {
            String id = row.getString("fid");
            String content = row.getString("fcontent");
            int orgUnitIdIndex = content.indexOf("orgUnitId");
            int valueIndex = content.indexOf(",", orgUnitIdIndex);
            if ("".equals(content) || orgUnitIdIndex == -1 || valueIndex == -1) continue;
            String updateValue = content.substring(0, orgUnitIdIndex) + "orgUnitId\":" + rootOrgId + content.substring(valueIndex);
            result.put(id, updateValue);
        }
        return result;
    }
}

