/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.Row;
import kd.bos.algo.input.OrmInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.JobSession;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.dataentity.ShardingHinter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.StringUtils;
import kd.fi.arapcommon.vo.DateSegmentQueryInfo;

public class ArApXDBHelper {
    private static final Log logger = LogFactory.getLog(ArApXDBHelper.class);

    public static boolean isSharding(String tableName) {
        return ShardingHinter.isSharding((String)tableName);
    }

    public static QFilter getVerifyRecordXDBFilter(String entityName, Object[] billIds, boolean isAr) {
        String tableName = isAr ? "t_ar_verifyrecord" : "t_ap_verifyrecord";
        Boolean isSharding = ArApXDBHelper.isSharding(tableName);
        if (isSharding.booleanValue()) {
            boolean isHead = !"im_purinbill".equals(entityName) && !"im_saloutbill".equals(entityName);
            List<String> selector = ArApXDBHelper.getSelector(isHead);
            DataSet bills = QueryServiceHelper.queryDataSet((String)"queryVR4Main", (String)entityName, (String)String.join((CharSequence)",", selector), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)billIds)}, (String)"createtime asc");
            Date createTime = null;
            HashSet<Long> orgIds = new HashSet<Long>(8);
            boolean isFirst = true;
            for (Row bill : bills) {
                if (isFirst) {
                    createTime = bill.getDate("createtime");
                    isFirst = false;
                }
                orgIds.add(bill.getLong("org"));
            }
            if (orgIds.size() > 0) {
                QFilter commonFilter = new QFilter("org", "in", orgIds);
                commonFilter.and(new QFilter("createtime", ">=", (Object)createTime));
                return commonFilter;
            }
        }
        return null;
    }

    private static List<String> getSelector(boolean isHead) {
        ArrayList<String> queryFields = new ArrayList<String>();
        if (isHead) {
            queryFields.add("org");
            queryFields.add("createtime");
        } else {
            queryFields.add("billentry.entrysettleorg org");
            queryFields.add("createtime");
        }
        return queryFields;
    }

    public static QFilter getSalOutBillXDBFilter(Map<String, Set<String>> coreBillTypeMap) {
        boolean isSharding = ArApXDBHelper.isSharding("t_im_saloutbill");
        if (isSharding && coreBillTypeMap.size() > 0) {
            HashSet saleOutBillIds = new HashSet(8);
            Set<Map.Entry<String, Set<String>>> entries = coreBillTypeMap.entrySet();
            for (Map.Entry<String, Set<String>> entry : entries) {
                String entityName = entry.getKey();
                HashSet<Long> coreBillIds = new HashSet<Long>(8);
                Set<String> billNoSet = coreBillTypeMap.get(entityName);
                DataSet saleOutBills = ArApXDBHelper.getBillsDataSet(entityName, billNoSet);
                for (Row saleOutBill : saleOutBills) {
                    coreBillIds.add(saleOutBill.getLong("id"));
                }
                Map<String, HashSet<Long>> targetBills = BOTPHelper.findTargetBills(entityName, coreBillIds.toArray(new Long[0]));
                Set im_saloutbill = targetBills.get("im_saloutbill");
                if (im_saloutbill == null) continue;
                saleOutBillIds.addAll(im_saloutbill);
            }
            QFilter filter = new QFilter("id", "in", saleOutBillIds);
            return filter;
        }
        return null;
    }

    public static QFilter getPurInBillXDBFilter(String entity, Map<String, Set<String>> coreBillTypeMap) {
        boolean isSharding = ArApXDBHelper.isSharding("t_im_purinbill");
        if (isSharding && "im_purinbill".equals(entity) && coreBillTypeMap.size() > 0) {
            HashSet saleOutBillIds = new HashSet(8);
            Set<Map.Entry<String, Set<String>>> entries = coreBillTypeMap.entrySet();
            for (Map.Entry<String, Set<String>> entry : entries) {
                String entityName = entry.getKey();
                HashSet<Long> coreBillIds = new HashSet<Long>(8);
                Set<String> billNoSet = coreBillTypeMap.get(entityName);
                DataSet saleOutBills = ArApXDBHelper.getBillsDataSet(entityName, billNoSet);
                for (Row saleOutBill : saleOutBills) {
                    coreBillIds.add(saleOutBill.getLong("id"));
                }
                Map<String, HashSet<Long>> targetBills = BOTPHelper.findTargetBills(entityName, coreBillIds.toArray(new Long[0]));
                Set im_saloutbill = targetBills.get(entity);
                if (im_saloutbill == null) continue;
                saleOutBillIds.addAll(im_saloutbill);
            }
            QFilter filter = new QFilter("id", "in", saleOutBillIds);
            return filter;
        }
        return null;
    }

    private static DataSet getBillsDataSet(String entityName, Set<String> billNoSet) {
        DataSet saleOutBills = QueryServiceHelper.queryDataSet((String)"getSalOutBillXDBFilter", (String)entityName, (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "in", billNoSet)}, null);
        return saleOutBills;
    }

    public static DataSet queryDataSet(String entity, String selector, QFilter filter, String orderBy, String scene) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(1);
        filters.add(filter);
        return ArApXDBHelper.queryDataSet(entity, selector, filters, orderBy, scene);
    }

    public static DataSet queryDataSet(String entity, String selector, List<QFilter> filters, String orderBy, String scene) {
        QFilter filter = new QFilter("bizobj", "=", (Object)entity);
        filter.and(new QFilter("scene", "=", (Object)scene));
        filter.and(new QFilter("enable", "=", (Object)Boolean.TRUE));
        DynamicObject dateSegmentedQueryCfg = BusinessDataServiceHelper.loadSingleFromCache((String)"ap_datesegmentquerycfg", (String)"bizobj,datefield,splitdays,startdate,scene,islessmindate", (QFilter[])new QFilter[]{filter});
        if (dateSegmentedQueryCfg == null) {
            logger.info("dateSegmentedQueryCfg is null");
            return ArApXDBHelper.queryDataSet(entity, selector, filters, orderBy);
        }
        DateSegmentQueryInfo queryInfo = ArApXDBHelper.getDateSegmentedQueryInfo(dateSegmentedQueryCfg, filters);
        return ArApXDBHelper.dateSegmentQueryDataSet(entity, selector, filters, orderBy, queryInfo);
    }

    public static DataSet dateSegmentQueryDataSet(String entity, String selector, List<QFilter> filters, String orderBy, DateSegmentQueryInfo queryInfo) {
        if (queryInfo == null || !queryInfo.isCanDateSegmentQuery() || queryInfo.getMinDate() == null || queryInfo.getSplitDays() == 0 || queryInfo.getMaxDate() != null && (!queryInfo.getMaxDate().after(queryInfo.getMinDate()) || DateUtils.getDiffDays(queryInfo.getMinDate(), queryInfo.getMaxDate()) <= queryInfo.getSplitDays())) {
            logger.info("ArApXDB.queryDataSet-DateSegmentedQueryInfo is\uff1a" + queryInfo);
            return ArApXDBHelper.queryDataSet(entity, selector, filters, orderBy);
        }
        List<QFilter> splitDateFilters = ArApXDBHelper.getSplitDateFilters(queryInfo);
        List<OrmInput> ormInputList = ArApXDBHelper.createOrmInputList(entity, selector, filters, splitDateFilters);
        DataSet dataSet = ArApXDBHelper.queryDataSetByAlgoX((Input[])ormInputList.toArray(new OrmInput[0]), 30);
        if (StringUtils.isNotEmpty(orderBy)) {
            dataSet = dataSet.orderBy(orderBy.split(","));
        }
        return dataSet;
    }

    public static List<QFilter> getSplitDateFilters(DateSegmentQueryInfo info) {
        ArrayList<QFilter> splitDateFilters = new ArrayList<QFilter>(64);
        if (info.getMaxDate() == null) {
            Date currentDate = new Date();
            info.setMaxDate(currentDate);
            info.setMaxDateCp("<");
            QFilter dateFilter = new QFilter(info.getDateField(), ">=", (Object)currentDate);
            splitDateFilters.add(dateFilter);
        }
        Date maxDate = info.getMaxDate();
        Date minDate = info.getMinDate();
        while (maxDate.after(minDate)) {
            Date tempDate = DateUtils.getLastDay(maxDate, info.getSplitDays());
            QFilter dateFilter = new QFilter(info.getDateField(), info.getMaxDateCp(), (Object)maxDate);
            if (tempDate.before(minDate)) {
                tempDate = minDate;
                dateFilter.and(info.getDateField(), info.getMinDateCp(), (Object)minDate);
            } else {
                dateFilter.and(info.getDateField(), ">=", (Object)tempDate);
            }
            maxDate = tempDate;
            splitDateFilters.add(dateFilter);
        }
        if (info.isQueryLessMinDate()) {
            splitDateFilters.add(new QFilter(info.getDateField(), "<", (Object)info.getMinDate()));
        }
        return splitDateFilters;
    }

    private static List<OrmInput> createOrmInputList(String entity, String selector, List<QFilter> filters, List<QFilter> splitDateFilters) {
        ArrayList<OrmInput> inputList = new ArrayList<OrmInput>(10);
        ArrayList<QFilter> batchFilterList = new ArrayList<QFilter>(filters);
        if (splitDateFilters.isEmpty()) {
            OrmInput ormInput = new OrmInput("createOrmInputList", entity, selector, batchFilterList.toArray(new QFilter[0]));
            logger.info("----OrmInput.filter:" + batchFilterList);
            inputList.add(ormInput);
        } else {
            for (QFilter splitDateFilter : splitDateFilters) {
                batchFilterList = new ArrayList<QFilter>(filters);
                batchFilterList.add(splitDateFilter);
                OrmInput ormInput = new OrmInput("createOrmInputList", entity, selector, batchFilterList.toArray(new QFilter[0]));
                logger.info("----OrmInput.filter:" + batchFilterList);
                inputList.add(ormInput);
            }
        }
        return inputList;
    }

    public static DateSegmentQueryInfo getDateSegmentedQueryInfo(DynamicObject dateSegmentedQueryCfg, List<QFilter> filters) {
        DateSegmentQueryInfo info = new DateSegmentQueryInfo();
        int splitDays = dateSegmentedQueryCfg.getInt("splitdays");
        info.setSplitDays(splitDays);
        String dateField = dateSegmentedQueryCfg.getString("datefield");
        info.setDateField(dateField);
        boolean isQueryLessMinDate = dateSegmentedQueryCfg.getBoolean("islessmindate");
        info.setQueryLessMinDate(isQueryLessMinDate);
        Date startDate = dateSegmentedQueryCfg.getDate("startdate");
        Date maxDate = info.getMaxDate();
        Date minDate = info.getMinDate();
        for (QFilter filter : filters) {
            List nestQfilters;
            boolean hasDateField = false;
            boolean hasOrOp = false;
            String property = filter.getProperty();
            String cp = filter.getCP();
            Object value = filter.getValue();
            if (dateField.equals(property)) {
                Date tempValue = (Date)value;
                if (("<".equals(cp) || "<=".equals(cp)) && (maxDate == null || tempValue.before(maxDate))) {
                    info.setMaxDate(tempValue);
                    info.setMaxDateCp(cp);
                } else if ((">".equals(cp) || ">=".equals(cp)) && (minDate == null || tempValue.after(minDate))) {
                    info.setMinDate(tempValue);
                    info.setMinDateCp(cp);
                }
            }
            if (!CollectionUtils.isEmpty((Collection)(nestQfilters = filter.getNests(true)))) {
                for (QFilter.QFilterNest qFilterNest : nestQfilters) {
                    String op = qFilterNest.getOp();
                    if ("or".equalsIgnoreCase(op)) {
                        hasOrOp = true;
                    }
                    QFilter nestfilter = qFilterNest.getFilter();
                    String nProperty = nestfilter.getProperty();
                    String nCp = nestfilter.getCP();
                    Object nValue = nestfilter.getValue();
                    if (!dateField.equals(nProperty)) continue;
                    hasDateField = true;
                    Date tempValue = (Date)nValue;
                    if (("<".equals(nCp) || "<=".equals(nCp)) && (maxDate == null || tempValue.before(maxDate))) {
                        info.setMaxDate(tempValue);
                        info.setMaxDateCp(nCp);
                        continue;
                    }
                    if (!">".equals(nCp) && !">=".equals(nCp) || minDate != null && !tempValue.after(minDate)) continue;
                    info.setMinDate(tempValue);
                    info.setMinDateCp(nCp);
                }
            }
            if (hasDateField && hasOrOp) {
                info.setCanDateSegmentQuery(false);
                break;
            }
            if (info.getMinDate() != null) continue;
            info.setMinDate(startDate);
            info.setMinDateCp(">=");
        }
        return info;
    }

    private static DataSet queryDataSet(String entity, String selector, List<QFilter> filters, String orderBy) {
        long begin = System.currentTimeMillis();
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)(entity + "query"), (String)entity, (String)selector, (QFilter[])filters.toArray(new QFilter[0]), (String)orderBy);
        long end = System.currentTimeMillis();
        logger.info("---queryDataSet:" + (end - begin));
        return dataSet;
    }

    private static DataSet queryDataSetByAlgoX(Input[] inputs, int timeout) {
        long begin = System.currentTimeMillis();
        JobSession session = AlgoX.createSession((String)"queryDataSetByAlgoX");
        DataSetX dataSetX = session.fromInput(inputs);
        DataSetOutput out = new DataSetOutput(dataSetX.getRowMeta());
        String id = out.getId();
        dataSetX.output((Output)out);
        session.commit(timeout, TimeUnit.MINUTES);
        DataSet dataSet = session.readDataSet(id);
        long end = System.currentTimeMillis();
        logger.info("----queryDataSetByAlgoX:" + (end - begin));
        return dataSet;
    }
}

