/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.LinkSetElement;
import kd.bos.entity.LinkSetItemElement;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;

public class BillRelationBuilder {
    private TableDefine sourceTableDefine;
    private TableDefine targetTableDefine;
    private String targetBillType;
    private DBRoute targetDbRoute;

    public BillRelationBuilder(String sourceBillType, String targetBillType) {
        this.sourceTableDefine = ConvertMetaServiceHelper.loadTableDefine((String)sourceBillType, (String)sourceBillType);
        this.targetTableDefine = ConvertMetaServiceHelper.loadTableDefine((String)targetBillType, (String)targetBillType);
        MainEntityType targetEntityType = MetadataServiceHelper.getDataEntityType((String)targetBillType);
        String dbRouteKey = targetEntityType.getDBRouteKey();
        this.targetDbRoute = new DBRoute(dbRouteKey);
        this.targetBillType = targetBillType;
    }

    public void saveRelation(DynamicObject sourceBill, DynamicObject targetBill) {
        Long sourcePk = (Long)sourceBill.getPkValue();
        Long targetPk = (Long)targetBill.getPkValue();
        this.saveRelation(sourcePk, Collections.singletonList(targetPk));
    }

    public void saveRelation(Collection<DynamicObject> sourceBills, DynamicObject targetBill) {
        ArrayList<Long> sourcePks = new ArrayList<Long>(sourceBills.size());
        for (DynamicObject sourceBill : sourceBills) {
            sourcePks.add((Long)sourceBill.getPkValue());
        }
        this.saveRelation(sourcePks, (Long)targetBill.getPkValue());
    }

    public void saveRelation(Collection<Long> sourcePks, Long targetPk) {
        Long sourceTableId = this.sourceTableDefine.getTableId();
        Long targetTableId = this.targetTableDefine.getTableId();
        ArrayList<RelationRow> rows = new ArrayList<RelationRow>(sourcePks.size());
        for (Long sourcePk : sourcePks) {
            long pk = DBServiceHelper.genGlobalLongId();
            RelationRow row = new RelationRow(pk, sourcePk, sourceTableId, targetTableId, targetPk);
            rows.add(row);
        }
        this.saveRelation(rows);
    }

    public void saveRelation(Long sourcePk, Collection<Long> targetPks) {
        Long sourceTableId = this.sourceTableDefine.getTableId();
        Long targetTableId = this.targetTableDefine.getTableId();
        ArrayList<RelationRow> rows = new ArrayList<RelationRow>(targetPks.size());
        for (Long targetPk : targetPks) {
            long pk = DBServiceHelper.genGlobalLongId();
            RelationRow row = new RelationRow(pk, sourcePk, sourceTableId, targetTableId, targetPk);
            rows.add(row);
        }
        this.saveRelation(rows);
    }

    private void saveRelation(List<RelationRow> rows) {
        LinkSetElement loadLinkSet = ConvertMetaServiceHelper.loadLinkSet((String)this.targetBillType);
        this.saveBizRelation(rows, loadLinkSet.getTrackerTable(), ((LinkSetItemElement)loadLinkSet.getItems().get(0)).getTableName());
        try (TXHandle h = TX.requiresNew();){
            this.saveSysRelation(rows);
        }
    }

    private void saveSysRelation(List<RelationRow> rows) {
        ArrayList<SqlParameter[]> batchParameters = new ArrayList<SqlParameter[]>(rows.size());
        for (RelationRow row : rows) {
            ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
            params.add(new SqlParameter(":FID", -5, (Object)row.Id));
            params.add(new SqlParameter(":FSTABLEID", -5, (Object)row.sTableId));
            params.add(new SqlParameter(":FSBILLID", -5, (Object)row.sBillid));
            params.add(new SqlParameter(":FTTABLEID", -5, (Object)row.tTableId));
            params.add(new SqlParameter(":FTBILLID", -5, (Object)row.tbillId));
            params.add(new SqlParameter(":FCREATETIME", 91, (Object)new Date()));
            batchParameters.add(params.toArray(new SqlParameter[params.size()]));
        }
        String sBuilder = "INSERT INTO T_BOTP_BillTracker (FID, FSTABLEID, FSBILLID, FTTABLEID, FTBILLID, FCREATETIME) VALUES (?, ?, ?, ?, ?, ?)";
        DB.executeBatch((DBRoute)DBRoute.basedata, (String)sBuilder, batchParameters);
    }

    private void saveBizRelation(List<RelationRow> rows, String tc, String lk) {
        ArrayList<SqlParameter[]> tcBatchParameters = new ArrayList<SqlParameter[]>(64);
        ArrayList<SqlParameter[]> lkBatchParameters = new ArrayList<SqlParameter[]>(64);
        ArrayList<SqlParameter[]> deleteBatchParameters = new ArrayList<SqlParameter[]>(64);
        for (RelationRow row : rows) {
            Long id_tc = DBServiceHelper.genGlobalLongId();
            ArrayList<SqlParameter> params_tc = new ArrayList<SqlParameter>(64);
            params_tc.add(new SqlParameter(":FID", -5, (Object)id_tc));
            params_tc.add(new SqlParameter(":FTBillId", -5, (Object)row.tbillId));
            params_tc.add(new SqlParameter(":FTTableId", -5, (Object)row.tTableId));
            params_tc.add(new SqlParameter(":FTId", -5, (Object)row.tbillId));
            params_tc.add(new SqlParameter(":FSBillId", -5, (Object)row.sBillid));
            params_tc.add(new SqlParameter(":FSTableId", -5, (Object)row.sTableId));
            params_tc.add(new SqlParameter(":FSId", -5, (Object)row.sBillid));
            tcBatchParameters.add(params_tc.toArray(new SqlParameter[params_tc.size()]));
            Long id_lk = DBServiceHelper.genGlobalLongId();
            ArrayList<SqlParameter> params_lk = new ArrayList<SqlParameter>(64);
            params_lk.add(new SqlParameter(":FId", -5, (Object)row.tbillId));
            params_lk.add(new SqlParameter(":FPKId", -5, (Object)id_lk));
            params_lk.add(new SqlParameter(":FSeq", 4, (Object)1));
            params_lk.add(new SqlParameter(":FSTableId", -5, (Object)row.sTableId));
            params_lk.add(new SqlParameter(":FSBillId", -5, (Object)row.sBillid));
            params_lk.add(new SqlParameter(":FSId", -5, (Object)row.sBillid));
            lkBatchParameters.add(params_lk.toArray(new SqlParameter[params_lk.size()]));
            deleteBatchParameters.add(new SqlParameter[]{new SqlParameter(":FPKId", -5, (Object)id_lk)});
        }
        String sBuilder_tc = "INSERT INTO " + tc + " (FID, FTBillId, FTTableId,FTId,FSBillId,FSTableId,FSId) VALUES (?, ?,?,?, ?,?,?)";
        DB.executeBatch((DBRoute)this.targetDbRoute, (String)sBuilder_tc, tcBatchParameters);
        String delete_lk = "delete from  " + lk + " where  FPKId= ?";
        DB.executeBatch((DBRoute)this.targetDbRoute, (String)delete_lk, deleteBatchParameters);
        String sBuilder_lk = "INSERT INTO " + lk + " (FId, FPKId, FSeq,FSTableId,FSBillId,FSId) VALUES (?, ?,?,?, ?,?)";
        DB.executeBatch((DBRoute)this.targetDbRoute, (String)sBuilder_lk, lkBatchParameters);
    }

    private static class RelationRow {
        private Long Id;
        private Long sBillid;
        private Long sTableId;
        private Long tTableId;
        private Long tbillId;

        public RelationRow(Long Id, Long sBillid, Long sTableId, Long tTableId, Long tbillId) {
            this.Id = Id;
            this.sBillid = sBillid;
            this.sTableId = sTableId;
            this.tTableId = tTableId;
            this.tbillId = tbillId;
        }
    }
}

