/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.helper;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.DateProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.field.DateEdit;
import kd.bos.mvc.bill.BillViewForWebApi;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.model.BillModel;
import kd.fi.arapcommon.model.BillModelFactory;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.EntityMetadataUtils;
import kd.fi.arapcommon.util.StringUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.tuple.MutablePair;

public class BookDateHelper {
    public static void setBookDate(DynamicObject[] bills, boolean isAr) {
        String entity = isAr ? "ar_closeaccount" : "ap_closeaccount";
        Set orgIds = Stream.of(bills).map(bill -> bill.getDynamicObject("org").getLong("id")).collect(Collectors.toSet());
        DynamicObjectCollection closeAccounts = QueryServiceHelper.query((String)entity, (String)"org,currentdate,startdate", (QFilter[])new QFilter[]{new QFilter("org", "in", orgIds)});
        HashMap<Long, Date> currentDateMap = new HashMap<Long, Date>(64);
        HashMap<Long, Date> startDateMap = new HashMap<Long, Date>(64);
        for (DynamicObject closeAccount : closeAccounts) {
            long orgId = closeAccount.getLong("org");
            if (currentDateMap.containsKey(orgId) || startDateMap.containsKey(orgId)) continue;
            Date currentDate = closeAccount.getDate("currentdate");
            if (currentDate == null) {
                startDateMap.put(orgId, closeAccount.getDate("startdate"));
                continue;
            }
            currentDateMap.put(orgId, currentDate);
        }
        for (DynamicObject bill2 : bills) {
            Date bizDate = bill2.getDate("bizDate");
            if (ObjectUtils.isEmpty((Object)bizDate)) {
                bizDate = new Date();
            }
            Date bookDate = bill2.getDate("bookdate");
            long orgId = bill2.getDynamicObject("org").getLong("id");
            Date currentDate = (Date)currentDateMap.get(orgId);
            if (currentDate == null) {
                if (EntityMetadataUtils.isExistProperty(bill2, "isperiod") && bill2.getBoolean("isperiod")) {
                    Date startDate = (Date)startDateMap.get(orgId);
                    if (startDate != null) {
                        Date date = bizDate = bizDate.after(startDate = DateUtils.getLastDay(startDate, 1)) ? startDate : bizDate;
                    }
                    bookDate = bookDate == null || startDate != null && startDate.before(bookDate) ? (startDate != null && startDate.before(bizDate) ? startDate : bizDate) : (bookDate.before(bizDate) ? bizDate : bookDate);
                } else {
                    bookDate = bookDate != null && bizDate.before(bookDate) ? bookDate : bizDate;
                }
            } else {
                bookDate = bookDate == null || bookDate.before(bizDate) ? (bizDate.before(currentDate) ? currentDate : bizDate) : (bookDate.before(currentDate) ? currentDate : bookDate);
            }
            bill2.set("bookdate", (Object)bookDate);
        }
    }

    public static void billSavesetBookDate(DynamicObject[] entitys, boolean isAr) {
        ArrayList<DynamicObject> bills = new ArrayList<DynamicObject>(16);
        for (DynamicObject entity : entitys) {
            if ("C".equals(entity.getString("billstatus"))) continue;
            bills.add(entity);
        }
        if (bills.size() > 0) {
            BookDateHelper.setBookDate(bills.toArray(new DynamicObject[0]), isAr);
        }
    }

    public static void setBookDate(IDataModel model, boolean isAr) {
        DynamicObject closeAccount;
        String entity = isAr ? "ar_closeaccount" : "ap_closeaccount";
        Object orgValue = model.getValue("org");
        if (ObjectUtils.isEmpty((Object)orgValue)) {
            return;
        }
        DynamicObject org = (DynamicObject)orgValue;
        Date bizDate = (Date)model.getValue("bizdate");
        if (ObjectUtils.isEmpty((Object)bizDate)) {
            bizDate = new Date();
        }
        if (!ObjectUtils.isEmpty((Object)(closeAccount = QueryServiceHelper.queryOne((String)entity, (String)"currentdate,startdate", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)org.getLong("id"))})))) {
            Date currentDate = closeAccount.getDate("currentdate");
            if (currentDate == null) {
                currentDate = closeAccount.getDate("startdate");
            }
            Date bookDate = currentDate != null && bizDate.before(currentDate) ? currentDate : bizDate;
            model.setValue("bookdate", (Object)bookDate);
        } else {
            model.setValue("bookdate", (Object)bizDate);
        }
    }

    public static void setBookDateAndRange(IFormView view, boolean isAr) {
        Tuple<Date, Date> tuple = BookDateHelper.setBookDateRange(view, isAr);
        if (tuple != null) {
            view.getModel().setValue("bookdate", tuple.item1);
        }
    }

    public static Tuple<Date, Date> setBookDateRange(IFormView view, boolean isAr) {
        Date ctlDateMin;
        if (view instanceof BillViewForWebApi) {
            return null;
        }
        IDataModel model = view.getModel();
        Object orgValue = model.getValue("org");
        if (ObjectUtils.isEmpty((Object)orgValue)) {
            return null;
        }
        DynamicObject org = (DynamicObject)orgValue;
        String closeAcctKey = isAr ? "ar_closeaccount" : "ap_closeaccount";
        String initKey = isAr ? "ar_init" : "ap_init";
        Date bizDate = (Date)model.getValue("bizdate");
        if (ObjectUtils.isEmpty((Object)bizDate)) {
            bizDate = new Date();
        }
        BillShowParameter parameter = (BillShowParameter)view.getFormShowParameter();
        Object isPeriodParam = parameter.getCustomParam("isPeriod");
        String name = model.getDataEntityType().getName();
        boolean isRevcfm = "ar_revcfmbill".equals(name);
        boolean isPeriod = isPeriodParam != null && (Boolean)isPeriodParam != false || !isRevcfm && (Boolean)model.getValue("isperiod") != false;
        String cacheDateStr = view.getPageCache().get("cacheDate");
        Date cacheDate = null;
        if (StringUtils.isNotEmpty(cacheDateStr)) {
            cacheDate = new Date(Long.parseLong(cacheDateStr));
        } else {
            DynamicObject closeAccount;
            if (!isPeriod && !ObjectUtils.isEmpty((Object)(closeAccount = QueryServiceHelper.queryOne((String)closeAcctKey, (String)"currentdate,startdate", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)org.getLong("id"))}))) && ObjectUtils.isEmpty((Object)(cacheDate = closeAccount.getDate("currentdate")))) {
                cacheDate = closeAccount.getDate("startdate");
            }
            Date srcLatestDate = BookDateHelper.getSrcLatestDate(model);
            cacheDate = cacheDate != null ? (srcLatestDate != null && cacheDate.before(srcLatestDate) ? srcLatestDate : cacheDate) : srcLatestDate;
        }
        Date date = ctlDateMin = cacheDate != null && bizDate.before(cacheDate) ? cacheDate : bizDate;
        if (cacheDate != null) {
            view.getPageCache().put("cacheDate", JSONObject.toJSONString((Object)cacheDate));
        }
        DateEdit bookDateCtl = (DateEdit)view.getControl("bookdate");
        if (isPeriod) {
            InitHelper initHelper = new InitHelper(org.getLong("id"), initKey);
            Date startDate = initHelper.getStartDate();
            if (startDate == null) {
                return null;
            }
            Date lastDay = DateUtils.getLastDay(startDate, 1);
            ctlDateMin = ctlDateMin.before(lastDay) ? ctlDateMin : lastDay;
            bookDateCtl.setMinDate(ctlDateMin);
            bookDateCtl.setMaxDate(lastDay);
            return Tuple.create((Object)ctlDateMin, (Object)lastDay);
        }
        bookDateCtl.setMinDate(ctlDateMin);
        return Tuple.create((Object)ctlDateMin, null);
    }

    public static void checkBookDate(IDataModel model, boolean isAr, Map<Long, Date> cacheDateMap, InitHelper initHelper) {
        String name;
        boolean isRevcfm;
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (ObjectUtils.isEmpty((Object)org)) {
            return;
        }
        String closeAcctKey = isAr ? "ar_closeaccount" : "ap_closeaccount";
        Date bizDate = (Date)model.getValue("bizdate");
        if (ObjectUtils.isEmpty((Object)bizDate)) {
            bizDate = new Date();
        }
        boolean isPeriod = !(isRevcfm = "ar_revcfmbill".equals(name = model.getDataEntityType().getName())) && (Boolean)model.getValue("isperiod") != false;
        Date srcLatestDate = BookDateHelper.getSrcLatestDate(model);
        Date ctlDateMin = srcLatestDate != null && bizDate.before(srcLatestDate) ? srcLatestDate : bizDate;
        Date bookDate = (Date)model.getValue("bookdate");
        if (isPeriod) {
            Date startDate = initHelper.getStartDate();
            if (ObjectUtils.isEmpty((Object)startDate)) {
                return;
            }
            Date lastDay = DateUtils.getLastDay(startDate, 1);
            Date date = ctlDateMin = ctlDateMin.before(lastDay) ? ctlDateMin : lastDay;
            if (bookDate == null) {
                model.setValue("bookdate", (Object)ctlDateMin);
            } else if (bookDate.before(ctlDateMin) || bookDate.after(lastDay)) {
                if (!ObjectUtils.isEmpty((Object)srcLatestDate)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bb0\u8d26\u65e5\u671f\u9700\u5927\u4e8e\u7b49\u4e8e\u5355\u636e\u65e5\u671f\u4e14\u5c0f\u4e8e\u521d\u59cb\u5316\u7684\u542f\u7528\u65e5\u671f\u4e14\u5927\u4e8e\u7b49\u4e8e\u4e0a\u6e38\u5355\u636e\u7684\u8bb0\u8d26\u65e5\u671f\u3002", (String)"BookDateHelper_0", (String)"fi-arapcommon", (Object[])new Object[0]));
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u8bb0\u8d26\u65e5\u671f\u9700\u5927\u4e8e\u7b49\u4e8e\u5355\u636e\u65e5\u671f\u4e14\u5c0f\u4e8e\u521d\u59cb\u5316\u7684\u542f\u7528\u65e5\u671f\u3002", (String)"BookDateHelper_1", (String)"fi-arapcommon", (Object[])new Object[0]));
            }
        } else {
            Date cacheDate = cacheDateMap.get(org.getLong("id"));
            if (ObjectUtils.isEmpty((Object)cacheDate)) {
                DynamicObject closeAccount = QueryServiceHelper.queryOne((String)closeAcctKey, (String)"currentdate,startdate", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)org.getLong("id"))});
                if (!ObjectUtils.isEmpty((Object)closeAccount) && ObjectUtils.isEmpty((Object)(cacheDate = closeAccount.getDate("currentdate")))) {
                    cacheDate = closeAccount.getDate("startdate");
                }
                cacheDateMap.put(org.getLong("id"), cacheDate);
                Date date = ctlDateMin = cacheDate != null && ctlDateMin.before(cacheDate) ? cacheDate : ctlDateMin;
            }
            if (bookDate == null) {
                model.setValue("bookdate", (Object)ctlDateMin);
            } else if (bookDate.before(ctlDateMin)) {
                if (!ObjectUtils.isEmpty((Object)srcLatestDate)) {
                    if (isRevcfm) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u8bb0\u8d26\u65e5\u671f\u9700\u5927\u4e8e\u7b49\u4e8e\u786e\u8ba4\u65e5\u671f\u4e14\u5927\u4e8e\u7b49\u4e8e\u521d\u59cb\u5316\u7684\u5f53\u524d\u65e5\u671f\u4e14\u5927\u4e8e\u7b49\u4e8e\u4e0a\u6e38\u5355\u636e\u7684\u8bb0\u8d26\u65e5\u671f\u3002", (String)"BookDateHelper_4", (String)"fi-arapcommon", (Object[])new Object[0]));
                    }
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bb0\u8d26\u65e5\u671f\u9700\u5927\u4e8e\u7b49\u4e8e\u5355\u636e\u65e5\u671f\u4e14\u5927\u4e8e\u7b49\u4e8e\u521d\u59cb\u5316\u7684\u5f53\u524d\u65e5\u671f\u4e14\u5927\u4e8e\u7b49\u4e8e\u4e0a\u6e38\u5355\u636e\u7684\u8bb0\u8d26\u65e5\u671f\u3002", (String)"BookDateHelper_2", (String)"fi-arapcommon", (Object[])new Object[0]));
                }
                if (isRevcfm) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bb0\u8d26\u65e5\u671f\u9700\u5927\u4e8e\u7b49\u4e8e\u786e\u8ba4\u65e5\u671f\u4e14\u5927\u4e8e\u7b49\u4e8e\u521d\u59cb\u5316\u7684\u5f53\u524d\u65e5\u671f\u3002", (String)"BookDateHelper_5", (String)"fi-arapcommon", (Object[])new Object[0]));
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u8bb0\u8d26\u65e5\u671f\u9700\u5927\u4e8e\u7b49\u4e8e\u5355\u636e\u65e5\u671f\u4e14\u5927\u4e8e\u7b49\u4e8e\u521d\u59cb\u5316\u7684\u5f53\u524d\u65e5\u671f\u3002", (String)"BookDateHelper_3", (String)"fi-arapcommon", (Object[])new Object[0]));
            }
        }
    }

    public static Date getSrcLatestDate(IDataModel model) {
        Date latestDate = null;
        String name = model.getDataEntityType().getName();
        BillModel billModel = BillModelFactory.getModel(name);
        String srcBillType = (String)model.getValue(billModel.HEAD_SOURCEBILLTYPE);
        if (ObjectUtils.isEmpty((Object)srcBillType)) {
            return latestDate;
        }
        HashSet<String> billTypeSet = new HashSet<String>(8);
        billTypeSet.add("ar_revcfmbill");
        billTypeSet.add("ap_finapbill");
        billTypeSet.add("ar_finarbill");
        billTypeSet.add("ap_busbill");
        billTypeSet.add("ar_busbill");
        if (!billTypeSet.contains(srcBillType)) {
            return latestDate;
        }
        HashSet<Object> srcIdSet = new HashSet<Object>(2);
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObjectCollection entryColl = dataEntity.getDynamicObjectCollection(billModel.ENTRY);
        for (DynamicObject entry : entryColl) {
            Object srcBillId = entry.get(billModel.E_SOURCEBILLID);
            if (ObjectUtils.isEmpty((Object)srcBillId)) continue;
            if (srcBillId instanceof String) {
                String srcBillIdStr = (String)srcBillId;
                if (StringUtils.isEmpty(srcBillIdStr)) continue;
                srcBillId = Long.parseLong(srcBillIdStr);
            }
            srcIdSet.add(srcBillId);
        }
        if (!srcIdSet.isEmpty()) {
            DynamicObjectCollection srcBillColl = QueryServiceHelper.query((String)srcBillType, (String)billModel.HEAD_BOOKDATE, (QFilter[])new QFilter[]{new QFilter("id", "in", srcIdSet)});
            for (DynamicObject srcBill : srcBillColl) {
                Date srcDate = srcBill.getDate(billModel.HEAD_BOOKDATE);
                if (latestDate != null) {
                    latestDate = srcDate != null && latestDate.before(srcDate) ? srcDate : latestDate;
                    continue;
                }
                latestDate = srcDate;
            }
        }
        return latestDate;
    }

    public static void setSettleDate(DynamicObject[] settleDatas) {
        Map<Long, Date> billBookDateMap = BookDateHelper.getBillBookDateMap(settleDatas, true);
        Date operationDate = new Date();
        String mainEntity = settleDatas[0].getString("billentity");
        boolean isAr = true;
        if ("ap_finapbill".equals(mainEntity) || "cas_paybill".equals(mainEntity) || "ap_paidbill".equals(mainEntity)) {
            isAr = false;
        }
        String billStatus = settleDatas[0].getString("billstatus");
        Map<Long, MutablePair<Date, Date>> dateScopeMap = BookDateHelper.getDateScopeMap(settleDatas, isAr);
        for (DynamicObject settleData : settleDatas) {
            Date settleDate = settleData.getDate("settledate");
            boolean iswrittenoff = settleData.getBoolean("iswrittenoff");
            if (!iswrittenoff && !ObjectUtils.isEmpty((Object)settleDate) && !"C".equals(billStatus)) continue;
            Date tempSettleDate = null;
            long orgId = settleData.getLong("org.id");
            Date mainBookDate = iswrittenoff ? settleDate : billBookDateMap.get(settleData.getLong("mainbillid"));
            Date asstMaxBookDate = iswrittenoff ? settleDate : BookDateHelper.getEntryMaxBookDate(settleData, true, billBookDateMap);
            Date mainAsstMaxBookDate = BookDateHelper.getMainAsstMaxBookDate(mainBookDate, asstMaxBookDate);
            MutablePair<Date, Date> dateScope = dateScopeMap.get(orgId);
            Date dateScopeLeft = null;
            Date dateScopeRight = null;
            if (dateScope != null) {
                dateScopeLeft = (Date)dateScope.getLeft();
                dateScopeRight = (Date)dateScope.getRight();
            }
            if (mainAsstMaxBookDate == null && dateScopeLeft == null) {
                tempSettleDate = operationDate;
            } else if (mainAsstMaxBookDate == null && dateScopeLeft != null) {
                tempSettleDate = dateScopeLeft;
            } else if (mainAsstMaxBookDate != null && dateScopeLeft == null) {
                tempSettleDate = mainAsstMaxBookDate;
            } else if (dateScopeLeft != null && dateScopeRight != null) {
                tempSettleDate = dateScopeLeft.before(operationDate) && operationDate.before(dateScopeRight) ? operationDate : dateScopeLeft;
                Date date = tempSettleDate = tempSettleDate.before(mainAsstMaxBookDate) ? mainAsstMaxBookDate : tempSettleDate;
            }
            if (ObjectUtils.isEmpty((Object)tempSettleDate)) {
                tempSettleDate = operationDate;
            }
            settleData.set("settledate", (Object)tempSettleDate);
        }
    }

    public static void setVerifyDate(DynamicObject[] verifyDatas) {
        Date operationDate = new Date();
        Map<Long, Date> billBookDateMap = BookDateHelper.getBillBookDateMap(verifyDatas, false);
        String mainEntity = verifyDatas[0].getString("billtype");
        boolean isAr = false;
        if ("im_saloutbill".equals(mainEntity) || "ar_revcfmbill".equals(mainEntity)) {
            isAr = true;
        }
        Map<Long, MutablePair<Date, Date>> dateScopeMap = BookDateHelper.getDateScopeMap(verifyDatas, isAr);
        for (DynamicObject verifyData : verifyDatas) {
            Date tempVerifyDate = null;
            long orgId = verifyData.getLong("org.id");
            MutablePair<Date, Date> dateScope = dateScopeMap.get(orgId);
            Date mainBookDate = billBookDateMap.get(verifyData.getLong("billid"));
            Date asstMaxBookDate = BookDateHelper.getEntryMaxBookDate(verifyData, false, billBookDateMap);
            Date mainAsstMaxBookDate = BookDateHelper.getMainAsstMaxBookDate(mainBookDate, asstMaxBookDate);
            Date dateScopeLeft = null;
            Date dateScopeRight = null;
            if (dateScope != null) {
                dateScopeLeft = (Date)dateScope.getLeft();
                dateScopeRight = (Date)dateScope.getRight();
            }
            if (mainAsstMaxBookDate == null && dateScopeLeft == null) {
                tempVerifyDate = operationDate;
            } else if (mainAsstMaxBookDate == null && dateScopeLeft != null) {
                tempVerifyDate = dateScopeLeft;
            } else if (mainAsstMaxBookDate != null && dateScopeLeft == null) {
                tempVerifyDate = mainAsstMaxBookDate;
            } else if (dateScopeLeft != null && dateScopeRight != null) {
                tempVerifyDate = dateScopeLeft.before(operationDate) && operationDate.before(dateScopeRight) ? operationDate : dateScopeLeft;
                Date date = tempVerifyDate = tempVerifyDate.before(mainAsstMaxBookDate) ? mainAsstMaxBookDate : tempVerifyDate;
            }
            if (ObjectUtils.isEmpty((Object)tempVerifyDate)) {
                tempVerifyDate = operationDate;
            }
            verifyData.set("verifydate", (Object)tempVerifyDate);
        }
    }

    public static void setVerifyDate(List<DynamicObject> verifyRecords, boolean isAr) {
        Date operationDate = new Date();
        Map<Long, MutablePair<Date, Date>> dateScopeMap = BookDateHelper.getDateScopeMap(verifyRecords.toArray(new DynamicObject[0]), isAr);
        for (DynamicObject verifyRecord : verifyRecords) {
            DynamicObjectCollection entrys = verifyRecord.getDynamicObjectCollection("entry");
            Date maxBookDate = BookDateHelper.getMaxBookDate(entrys);
            Date tempVerifyDate = null;
            long orgId = verifyRecord.getLong("org.id");
            MutablePair<Date, Date> dateScope = dateScopeMap.get(orgId);
            Date dateScopeLeft = null;
            Date dateScopeRight = null;
            if (dateScope != null) {
                dateScopeLeft = (Date)dateScope.getLeft();
                dateScopeRight = (Date)dateScope.getRight();
            }
            if (maxBookDate == null && dateScopeLeft == null) {
                tempVerifyDate = operationDate;
            } else if (maxBookDate == null && dateScopeLeft != null) {
                tempVerifyDate = dateScopeLeft;
            } else if (maxBookDate != null && dateScopeLeft == null) {
                tempVerifyDate = maxBookDate;
            } else if (dateScopeLeft != null && dateScopeRight != null) {
                tempVerifyDate = dateScopeLeft.before(operationDate) && operationDate.before(dateScopeRight) ? operationDate : dateScopeLeft;
                Date date = tempVerifyDate = tempVerifyDate.before(maxBookDate) ? maxBookDate : tempVerifyDate;
            }
            if (ObjectUtils.isEmpty((Object)tempVerifyDate)) {
                tempVerifyDate = operationDate;
            }
            verifyRecord.set("createtime", (Object)tempVerifyDate);
        }
    }

    private static Date getMaxBookDate(DynamicObjectCollection entrys) {
        Date maxBookDate = null;
        for (DynamicObject entry : entrys) {
            Date asstBookDate;
            Date tempDate;
            Date mainBookDate = entry.getDate("bookdate");
            Date date = tempDate = mainBookDate.after(asstBookDate = entry.getDate("assbookdate")) ? mainBookDate : asstBookDate;
            if (maxBookDate == null) {
                maxBookDate = tempDate;
                continue;
            }
            maxBookDate = maxBookDate.after(tempDate) ? maxBookDate : tempDate;
        }
        return maxBookDate;
    }

    private static Map<Long, MutablePair<Date, Date>> getDateScopeMap(DynamicObject[] datas, boolean isAr) {
        String closeAccountEntity = isAr ? "ar_closeaccount" : "ap_closeaccount";
        String initEntity = isAr ? "ar_init" : "ap_init";
        HashMap<Long, MutablePair<Date, Date>> openAccountDateScope = new HashMap<Long, MutablePair<Date, Date>>(64);
        Set orgIds = Stream.of(datas).map(data -> data.getDynamicObject("org").getLong("id")).collect(Collectors.toSet());
        DynamicObjectCollection closeAccounts = QueryServiceHelper.query((String)closeAccountEntity, (String)"org.id,currentdate", (QFilter[])new QFilter[]{new QFilter("org", "in", orgIds)});
        closeAccounts.stream().forEach(closeAccount -> openAccountDateScope.put(closeAccount.getLong("org.id"), new MutablePair((Object)closeAccount.getDate("currentdate"), null)));
        DynamicObject[] inits = BusinessDataServiceHelper.load((String)initEntity, (String)"org,periodtype", (QFilter[])new QFilter[]{new QFilter("org", "in", orgIds)});
        HashMap<Long, DynamicObject> periodCacheMap = new HashMap<Long, DynamicObject>(8);
        for (DynamicObject init : inits) {
            Date beginDate;
            DynamicObject period;
            DynamicObject periodtype;
            DynamicObject periodCache = (DynamicObject)periodCacheMap.get(init.getLong("org.id"));
            if (periodCache != null || ObjectUtils.isEmpty((Object)(periodtype = init.getDynamicObject("periodtype")))) continue;
            long periodTypeId = periodtype.getLong("id");
            MutablePair dateScope = (MutablePair)openAccountDateScope.get(init.getLong("org.id"));
            if (ObjectUtils.isEmpty((Object)dateScope) || (period = QueryServiceHelper.queryOne((String)"bd_period", (String)"enddate", (QFilter[])new QFilter[]{new QFilter("begindate", "<=", (Object)(beginDate = (Date)dateScope.getLeft())), new QFilter("enddate", ">=", (Object)beginDate), new QFilter("periodtype", "=", (Object)periodTypeId)})) == null) continue;
            dateScope.setRight((Object)period.getDate("enddate"));
            periodCacheMap.put(init.getLong("org.id"), period);
        }
        return openAccountDateScope;
    }

    private static Date getEntryMaxBookDate(DynamicObject datas, boolean isSettle, Map<Long, Date> billBookDateMap) {
        DynamicObjectCollection entryColl = datas.getDynamicObjectCollection("entry");
        String asstBillIdEntity = isSettle ? "billid" : "e_billid";
        Date maxBookDate = null;
        for (DynamicObject entry : entryColl) {
            Date finBookDate = billBookDateMap.get(entry.getLong(asstBillIdEntity));
            if (maxBookDate != null && (maxBookDate == null || finBookDate == null || !maxBookDate.before(finBookDate))) continue;
            maxBookDate = finBookDate;
        }
        return maxBookDate;
    }

    private static Map<Long, Date> getBillBookDateMap(DynamicObject[] datas, boolean isSettle) {
        HashMap<Long, Date> billBookDateMap = new HashMap<Long, Date>(64);
        String mainEntity = isSettle ? "billentity" : "billtype";
        String mainBillIdEntity = isSettle ? "mainbillid" : "billid";
        String asstEntity = isSettle ? "e_billentity" : "e_billtype";
        String asstBillIdEntity = isSettle ? "billid" : "e_billid";
        String mainBillEntity = datas[0].getString(mainEntity);
        String asstBillEntity = ((DynamicObject)datas[0].getDynamicObjectCollection("entry").get(0)).getString(asstEntity);
        ArrayList<Long> mainBillIds = new ArrayList<Long>(64);
        ArrayList<Long> asstBillIds = new ArrayList<Long>(64);
        ArrayList<Long> casRecBillIds = new ArrayList<Long>(64);
        ArrayList<Long> casPayBillIds = new ArrayList<Long>(64);
        ArrayList<Long> paidBillIds = new ArrayList<Long>(64);
        ArrayList<Long> receiveBillIds = new ArrayList<Long>(64);
        for (DynamicObject data : datas) {
            if ("cas_recbill".equals(mainBillEntity)) {
                casRecBillIds.add(data.getLong(mainBillIdEntity));
            } else if ("cas_paybill".equals(mainBillEntity)) {
                casPayBillIds.add(data.getLong(mainBillIdEntity));
            } else if ("ap_paidbill".equals(mainBillEntity)) {
                paidBillIds.add(data.getLong(mainBillIdEntity));
            } else if ("ar_receivedbill".equals(mainBillEntity)) {
                receiveBillIds.add(data.getLong(mainBillIdEntity));
            } else {
                mainBillIds.add(data.getLong(mainBillIdEntity));
            }
            DynamicObjectCollection entry = data.getDynamicObjectCollection("entry");
            for (DynamicObject row : entry) {
                if ("cas_recbill".equals(asstBillEntity)) {
                    casRecBillIds.add(row.getLong(asstBillIdEntity));
                    continue;
                }
                if ("cas_paybill".equals(asstBillEntity)) {
                    casPayBillIds.add(row.getLong(asstBillIdEntity));
                    continue;
                }
                if ("ap_paidbill".equals(asstBillEntity)) {
                    paidBillIds.add(row.getLong(asstBillIdEntity));
                    continue;
                }
                if ("ar_receivedbill".equals(asstBillEntity)) {
                    receiveBillIds.add(row.getLong(asstBillIdEntity));
                    continue;
                }
                asstBillIds.add(row.getLong(asstBillIdEntity));
            }
        }
        billBookDateMap.putAll(BookDateHelper.getBillBookDateMap(mainBillIds, mainBillEntity));
        billBookDateMap.putAll(BookDateHelper.getBillBookDateMap(asstBillIds, asstBillEntity));
        long orgPk = datas[0].getLong("org.id");
        String casParam = (String)SystemParameterHelper.getCasParam(orgPk, "cs104");
        if (!ObjectUtils.isEmpty(casRecBillIds)) {
            DynamicObjectCollection recBills = QueryServiceHelper.query((String)"cas_recbill", (String)"id,payeedate,bizdate", (QFilter[])new QFilter[]{new QFilter("id", "in", casRecBillIds)});
            for (DynamicObject recBill : recBills) {
                if ("2".equals(casParam)) {
                    billBookDateMap.put(recBill.getLong("id"), recBill.getDate("payeedate"));
                    continue;
                }
                billBookDateMap.put(recBill.getLong("id"), recBill.getDate("bizdate"));
            }
        }
        if (!ObjectUtils.isEmpty(casPayBillIds)) {
            DynamicObjectCollection payBills = QueryServiceHelper.query((String)"cas_paybill", (String)"id,paydate,bizdate", (QFilter[])new QFilter[]{new QFilter("id", "in", casPayBillIds)});
            for (DynamicObject payBill : payBills) {
                if ("2".equals(casParam)) {
                    billBookDateMap.put(payBill.getLong("id"), payBill.getDate("paydate"));
                    continue;
                }
                billBookDateMap.put(payBill.getLong("id"), payBill.getDate("bizdate"));
            }
        }
        if (!ObjectUtils.isEmpty(paidBillIds)) {
            DynamicObjectCollection paidBills = QueryServiceHelper.query((String)"ap_paidbill", (String)"id,bizdate", (QFilter[])new QFilter[]{new QFilter("id", "in", paidBillIds)});
            paidBills.stream().forEach(bill -> billBookDateMap.put(bill.getLong("id"), bill.getDate("bizdate")));
        }
        if (!ObjectUtils.isEmpty(receiveBillIds)) {
            DynamicObjectCollection receiveBills = QueryServiceHelper.query((String)"ar_receivedbill", (String)"id,bizdate", (QFilter[])new QFilter[]{new QFilter("id", "in", receiveBillIds)});
            receiveBills.stream().forEach(bill -> billBookDateMap.put(bill.getLong("id"), bill.getDate("bizdate")));
        }
        return billBookDateMap;
    }

    private static Map<Long, Date> getBillBookDateMap(List<Long> billIds, String billEntity) {
        HashMap<Long, Date> billBookDateMap = new HashMap<Long, Date>(64);
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)billEntity);
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        boolean isQuery = false;
        for (IDataEntityProperty property : properties) {
            if (!(property instanceof DateProp) || !"bookdate".equals(property.getName())) continue;
            isQuery = true;
        }
        if (isQuery) {
            DynamicObjectCollection bills = QueryServiceHelper.query((String)billEntity, (String)"id,bookdate", (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)});
            bills.stream().forEach(bill -> billBookDateMap.put(bill.getLong("id"), bill.getDate("bookdate")));
        }
        return billBookDateMap;
    }

    private static Date getMainAsstMaxBookDate(Date mainBookDate, Date asstMaxBookDate) {
        Date mainAsstMaxDate = null;
        if (mainBookDate != null && asstMaxBookDate != null) {
            mainAsstMaxDate = mainBookDate.before(asstMaxBookDate) ? asstMaxBookDate : mainBookDate;
        } else if (mainBookDate != null || asstMaxBookDate != null) {
            mainAsstMaxDate = mainBookDate == null ? asstMaxBookDate : mainBookDate;
        }
        return mainAsstMaxDate;
    }

    @Deprecated
    public static void setBookDate(DynamicObject[] bills, String initEntity) {
        Set orgIds = Stream.of(bills).map(b -> b.getDynamicObject("org").getLong("id")).collect(Collectors.toSet());
        DynamicObjectCollection initInfos = QueryServiceHelper.query((String)initEntity, (String)"org,currentdate", (QFilter[])new QFilter[]{new QFilter("org", "in", orgIds)});
        HashMap<Long, Date> currentDateMap = new HashMap<Long, Date>(64);
        for (DynamicObject initInfo : initInfos) {
            long orgId = initInfo.getLong("org");
            Date currentDate = initInfo.getDate("currentdate");
            if (currentDateMap.containsKey(orgId)) continue;
            currentDateMap.put(orgId, currentDate);
        }
        for (DynamicObject bill : bills) {
            Date bizDate = bill.getDate("bizDate");
            long orgId = bill.getDynamicObject("org").getLong("id");
            Date currentDate = (Date)currentDateMap.get(orgId);
            Date bookDate = currentDate != null && bizDate.before(currentDate) ? currentDate : bizDate;
            bill.set("bookdate", (Object)bookDate);
        }
    }

    @Deprecated
    public static void clearBookDate(DynamicObject[] bills) {
        for (DynamicObject bill : bills) {
            bill.set("bookdate", null);
        }
    }
}

