/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.property.EntryProp;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.enums.BillStatusEnum;
import kd.fi.arapcommon.helper.ClosePeriodHelper;
import kd.fi.arapcommon.helper.FilterColumnHelper;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.StringUtils;
import kd.fi.arapcommon.vo.CheckItemDetailInfo;
import kd.fi.arapcommon.vo.FilterColumnSetting;

public class CloseAccountHelper {
    public static final String other = "OTHER";

    public static List<Map<String, Object>> getAllValidateInfos_old(boolean isAr, long orgId, Date closeDate) {
        ArrayList<Map<String, Object>> failedInfos = new ArrayList<Map<String, Object>>();
        failedInfos.addAll(CloseAccountHelper.getFinBillValidateInfos(isAr, orgId, closeDate));
        failedInfos.addAll(CloseAccountHelper.getBusBillValidateInfos(isAr, orgId, closeDate));
        boolean isCheck = true;
        if (isAr) {
            Object ar012 = SystemParameterHelper.getARAppParameter(orgId, "ar_012");
            boolean bl = isCheck = ar012 == null ? true : (Boolean)ar012;
        }
        if (isCheck) {
            failedInfos.addAll(CloseAccountHelper.getInvoiceValidateInfos(isAr, orgId, closeDate));
        }
        failedInfos.addAll(CloseAccountHelper.getLiquidationValidateInfos(isAr, orgId, closeDate));
        if (isAr) {
            failedInfos.addAll(CloseAccountHelper.getRevCfmBillValidateInfos(orgId, closeDate));
        }
        return failedInfos;
    }

    public static List<Map<String, Object>> getFinBillValidateInfos(boolean isAr, long orgId, Date closeDate) {
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("bizdate", "<=", (Object)DateUtils.getDataFormat(closeDate, false)), new QFilter("billstatus", "in", (Object)new String[]{BillStatusEnum.SAVE.getValue(), BillStatusEnum.SUBMIT.getValue()}).or(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and(isAr ? "paymode" : "purmode", "=", (Object)"CASH").and("settlestatus", "!=", (Object)"settled"))};
        List<Map<String, Object>> failedInfos = null;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"arapcommon.CloseAccount.QueryFinBill", (String)CloseAccountHelper.getEntity(isAr, "FinBill"), (String)"id,billstatus", (QFilter[])filters, null);){
            failedInfos = CloseAccountHelper.getFailedInfos(dataSet, isAr, "FinBill", closeDate);
        }
        return failedInfos;
    }

    public static List<Map<String, Object>> getBusBillValidateInfos(boolean isAr, long orgId, Date closeDate) {
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("bizdate", "<=", (Object)DateUtils.getDataFormat(closeDate, false)), new QFilter("billstatus", "in", (Object)new String[]{BillStatusEnum.SAVE.getValue(), BillStatusEnum.SUBMIT.getValue()})};
        List<Map<String, Object>> failedInfos = null;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"arapcommon.CloseAccount.QueryBusBill", (String)CloseAccountHelper.getEntity(isAr, "BusBill"), (String)"billstatus", (QFilter[])filters, null);){
            failedInfos = CloseAccountHelper.getFailedInfos(dataSet, isAr, "BusBill", closeDate);
        }
        return failedInfos;
    }

    public static List<Map<String, Object>> getRevCfmBillValidateInfos(long orgId, Date closeDate) {
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("bizdate", "<=", (Object)DateUtils.getDataFormat(closeDate, false)), new QFilter("billstatus", "in", (Object)new String[]{BillStatusEnum.SAVE.getValue(), BillStatusEnum.SUBMIT.getValue()})};
        List<Map<String, Object>> failedInfos = null;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"arapcommon.CloseAccount.QueryRevCfmBill", (String)"ar_revcfmbill", (String)"billstatus", (QFilter[])filters, null);){
            failedInfos = CloseAccountHelper.getFailedInfos(dataSet, true, "RevCfmBill", closeDate);
        }
        return failedInfos;
    }

    public static List<Map<String, Object>> getInvoiceValidateInfos(boolean isAr, long orgId, Date closeDate) {
        return CloseAccountHelper.getInvoiceValidateInfos(isAr, orgId, closeDate, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Map<String, Object>> getInvoiceValidateInfos(boolean isAr, long orgId, Date closeDate, Date currentDate) {
        DynamicObject info;
        String propName;
        if (isAr) {
            propName = "bizdate";
            if (ObjectUtils.isEmpty((Object)currentDate)) {
                info = QueryServiceHelper.queryOne((String)"ar_closeaccount", (String)"currentdate", (QFilter[])new QFilter[]{new QFilter("org.id", "=", (Object)orgId)});
                currentDate = info.getDate("currentdate");
            }
        } else {
            propName = "issuedate";
            if (ObjectUtils.isEmpty((Object)currentDate)) {
                info = QueryServiceHelper.queryOne((String)"ap_closeaccount", (String)"currentdate", (QFilter[])new QFilter[]{new QFilter("org.id", "=", (Object)orgId)});
                currentDate = info.getDate("currentdate");
            }
        }
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter(propName, "<=", (Object)DateUtils.getDataFormat(closeDate, false)), new QFilter(propName, ">=", (Object)DateUtils.getDataFormat(currentDate, true)), new QFilter("billstatus", "in", (Object)new String[]{BillStatusEnum.SAVE.getValue(), BillStatusEnum.SUBMIT.getValue()})};
        ArrayList<Map<String, Object>> failedInfos = new ArrayList<Map<String, Object>>();
        try (DataSet dataSet = null;){
            dataSet = QueryServiceHelper.queryDataSet((String)"arapcommon.CloseAccount.QueryInvoice", (String)CloseAccountHelper.getEntity(isAr, "Invoice"), (String)"billstatus,invoicetype", (QFilter[])filters, null);
            dataSet = dataSet.groupBy(new String[]{"billstatus", "invoicetype"}).count("count").finish();
            HashMap countMap = new HashMap();
            dataSet.forEach(row -> {
                Integer count;
                String key = row.getString("billstatus");
                if (other.equals(row.getString("invoicetype"))) {
                    key = key + "-OTHER";
                }
                count = (count = (Integer)countMap.get(key)) == null ? row.getInteger("count") : count + row.getInteger("count");
                countMap.put(key, count);
            });
            String entity = CloseAccountHelper.getEntity(isAr, "Invoice");
            for (Map.Entry entry : countMap.entrySet()) {
                String key = (String)entry.getKey();
                String entityKey = entity;
                if (key.contains(other)) {
                    entityKey = entityKey + "-OTHER";
                }
                failedInfos.add(CloseAccountHelper.genDetailInfo(entityKey, closeDate, key.split("-")[0], (Integer)entry.getValue(), isAr));
            }
        }
        return failedInfos;
    }

    public static List<Map<String, Object>> getLiquidationValidateInfos(boolean isAr, long orgId, Date closeDate) {
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("liquidationdate", "<=", (Object)DateUtils.getDataFormat(closeDate, false)), new QFilter("billstatus", "in", (Object)new String[]{BillStatusEnum.SAVE.getValue(), BillStatusEnum.SUBMIT.getValue()})};
        List<Map<String, Object>> failedInfos = null;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"arapcommon.CloseAccount.QueryLiquidation", (String)CloseAccountHelper.getEntity(isAr, "liquidation"), (String)"id,billstatus", (QFilter[])filters, null);){
            failedInfos = CloseAccountHelper.getFailedInfos(dataSet, isAr, "liquidation", closeDate);
        }
        return failedInfos;
    }

    private static String getEntity(boolean isAr, String bill) {
        switch (bill) {
            case "Init": {
                return isAr ? "ar_init" : "ap_init";
            }
            case "FinBill": {
                return isAr ? "ar_finarbill" : "ap_finapbill";
            }
            case "BusBill": {
                return isAr ? "ar_busbill" : "ap_busbill";
            }
            case "Invoice": {
                return isAr ? "ar_invoice" : "ap_invoice";
            }
            case "liquidation": {
                return isAr ? "ar_liquidation" : "ap_liquidation";
            }
            case "RevCfmBill": {
                return "ar_revcfmbill";
            }
        }
        return null;
    }

    private static List<Map<String, Object>> getFailedInfos_old(DataSet dataSet, boolean isAr, String bill, Date closeDate) {
        dataSet = dataSet.groupBy(new String[]{"billstatus"}).count("count").finish();
        ArrayList<Map<String, Object>> failedInfos = new ArrayList<Map<String, Object>>();
        dataSet.forEach(row -> failedInfos.add(CloseAccountHelper.genDetailInfo(CloseAccountHelper.getEntity(isAr, bill), closeDate, row.getString("billstatus"), row.getInteger("count"), isAr)));
        return failedInfos;
    }

    private static Map<String, Object> genDetailInfo(String entityKey, Date closeDate, String billStatus, int count, boolean isAr) {
        String failedBillDescription = null;
        if (BillStatusEnum.SAVE.getValue().equals(billStatus)) {
            failedBillDescription = ResManager.loadKDString((String)"\u6682\u5b58\u672a\u63d0\u4ea4", (String)"CloseAccountHelper_0", (String)"fi-arapcommon", (Object[])new Object[0]);
        } else if (BillStatusEnum.SUBMIT.getValue().equals(billStatus)) {
            failedBillDescription = ResManager.loadKDString((String)"\u63d0\u4ea4\u5f85\u5ba1\u6838", (String)"CloseAccountHelper_1", (String)"fi-arapcommon", (Object[])new Object[0]);
        } else if (BillStatusEnum.AUDIT.getValue().equals(billStatus) && ("ap_finapbill".equals(entityKey) || "ar_finarbill".equals(entityKey))) {
            failedBillDescription = isAr ? ResManager.loadKDString((String)"\u73b0\u9500\u4f46\u672a\u7ed3\u7b97", (String)"CloseAccountHelper_2", (String)"fi-arapcommon", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u73b0\u8d2d\u4f46\u672a\u7ed3\u7b97", (String)"CloseAccountHelper_3", (String)"fi-arapcommon", (Object[])new Object[0]);
        }
        String closeDateDisplayName = DateUtils.formatString(closeDate, "yyyy-MM-dd");
        String entityLocaleName = null;
        entityLocaleName = entityKey.contains(other) ? ResManager.loadKDString((String)"\u5176\u5b83\u53d1\u7968", (String)"CloseAccountHelper_4", (String)"fi-arapcommon", (Object[])new Object[0]) : MetadataServiceHelper.getDataEntityType((String)entityKey).getDisplayName().getLocaleValue();
        String failedMessage = String.format(ResManager.loadKDString((String)"\u622a\u6b62%1$s\uff0c%2$s\u6709%3$s\u5f20\u662f%4$s\u7684\u5355\u636e\u3002", (String)"CloseAccountHelper_5", (String)"fi-arapcommon", (Object[])new Object[0]), closeDateDisplayName, entityLocaleName, count, failedBillDescription);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("message", failedMessage);
        result.put("entityKey", entityKey);
        result.put("billCount", count);
        result.put("closeDate", closeDate);
        result.put("billStatus", billStatus);
        return result;
    }

    public static void bindFailedInfoToEntityEntry(DynamicObject info, List<Map<String, Object>> failedInfos) {
        DynamicObjectCollection entry = info.getDynamicObjectCollection("entryentity");
        entry.clear();
        EntryProp prop = (EntryProp)info.getDataEntityType().getProperties().get((Object)"entryentity");
        DynamicObjectType dt = prop.getDynamicCollectionItemPropertyType();
        for (Map<String, Object> failedInfo : failedInfos) {
            DynamicObject entryObject = new DynamicObject(dt);
            entryObject.set("failedmessage", failedInfo.get("message"));
            entryObject.set("billtype", failedInfo.get("entityKey"));
            entryObject.set("count", failedInfo.get("billCount"));
            entryObject.set("duedate", failedInfo.get("closeDate"));
            entryObject.set("status", failedInfo.get("billStatus"));
            entry.add((Object)entryObject);
        }
    }

    @Deprecated
    public static ListShowParameter getListShowParameter(boolean isAr, String entityKey, long orgId, String billStatus, Date duedate) {
        return CloseAccountHelper.getListShowParameter(isAr, entityKey, orgId, billStatus, duedate, null);
    }

    public static ListShowParameter getListShowParameter(boolean isAr, String entityKey, long orgId, String billStatus, Date duedate, Date currentdate) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId(entityKey.split("-")[0]);
        ListFilterParameter lfp = new ListFilterParameter();
        List<Object> filters = CloseAccountHelper.getListShowFilters(isAr, entityKey, orgId, duedate, billStatus, currentdate);
        if ("ap_invoice".equals(entityKey) || "ar_invoice".equals(entityKey)) {
            DynamicObjectCollection invoices = QueryServiceHelper.query((String)entityKey, (String)"invoicetype", (QFilter[])filters.toArray(new QFilter[0]));
            List invoiceTypes = invoices.stream().map(inv -> inv.getString("invoicetype")).distinct().collect(Collectors.toList());
            filters = filters.stream().filter(f -> !"invoicetype".equals(f.getProperty())).collect(Collectors.toList());
            filters.add(new QFilter("invoicetype", "in", invoiceTypes));
        }
        lfp.setQFilters(filters);
        listShowParameter.setListFilterParameter(lfp);
        HashMap<String, Object> customParams = new HashMap<String, Object>(8);
        customParams.put("commonfiltercolumns", FilterColumnHelper.toMap(CloseAccountHelper.getCommonFilterSetting(isAr, filters, entityKey.split("-")[0], orgId, duedate)));
        customParams.put("isopenbyhyperlink", Boolean.TRUE);
        if (entityKey.contains(other)) {
            customParams.put("invoiceType", other);
            listShowParameter.setCaption(ResManager.loadKDString((String)"\u5176\u4ed6\u53d1\u7968", (String)"CloseAccountHelper_6", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        listShowParameter.setCustomParams(customParams);
        return listShowParameter;
    }

    private static List<QFilter> getListShowFilters(boolean isAr, String entityKey, long orgId, Date duedate, String billStatus, Date currentdate) {
        DynamicObject checkingBill;
        String entityName;
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("org", "=", (Object)orgId));
        filters.add(new QFilter("billstatus", "=", (Object)billStatus));
        if (BillStatusEnum.AUDIT.getValue().equals(billStatus)) {
            filters.add(new QFilter(isAr ? "paymode" : "purmode", "=", (Object)"CASH"));
            if ("ap_finapbill".equals(entityKey) || "ar_finarbill".equals(entityKey)) {
                filters.add(new QFilter("settlestatus", "!=", (Object)"settled"));
            }
        }
        String dateFieldName = "bizdate";
        if (entityKey.contains("invoice") && !ObjectUtils.isEmpty((Object)(entityName = CloseAccountHelper.getEntity(isAr, "Invoice")))) {
            String string = dateFieldName = isAr ? "bizdate" : "issuedate";
            if (entityKey.contains(other)) {
                filters.add(new QFilter("invoicetype", "=", (Object)other));
            } else {
                filters.add(new QFilter("invoicetype", "!=", (Object)other));
            }
        }
        if (entityKey.contains("liquidation")) {
            dateFieldName = "liquidationdate";
        }
        if ((checkingBill = BusinessDataServiceHelper.loadSingleFromCache((String)"fcm_checkingbill", (QFilter[])new QFilter[]{new QFilter("checkingbill", "=", (Object)entityKey)})) != null) {
            dateFieldName = checkingBill.getString("periodpropvalue");
        }
        filters.add(new QFilter(dateFieldName, "<=", (Object)DateUtils.getDataFormat(duedate, false)));
        filters.add(new QFilter(dateFieldName, ">=", (Object)currentdate));
        return filters;
    }

    private static List<FilterColumnSetting> getCommonFilterSetting(boolean isAr, List<QFilter> filters, String entityKey, long orgId, Date duedate) {
        String bizDateFieldName = "bizdate";
        if (!isAr && "ap_invoice".equals(entityKey)) {
            bizDateFieldName = "issuedate";
        }
        if (entityKey.contains("liquidation")) {
            bizDateFieldName = "liquidationdate";
        }
        if ("sim_original_bill".equals(entityKey)) {
            bizDateFieldName = "issuetime";
        }
        LinkedList<FilterColumnSetting> settings = new LinkedList<FilterColumnSetting>();
        for (QFilter filter : filters) {
            FilterColumnSetting filterInfo;
            String property = filter.getProperty();
            if (bizDateFieldName.equals(property) || (filterInfo = FilterColumnHelper.createCommonFilterSetting(filter, entityKey)) == null) continue;
            if ("org".equals(property)) {
                filterInfo.setCaption(ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"CloseAccountHelper_7", (String)"fi-arapcommon", (Object[])new Object[0]));
            }
            if ("ap_invoice".equals(entityKey) || "ar_invoice".equals(entityKey)) {
                if ("org".equals(property)) {
                    filterInfo.setCaption(ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7", (String)"CloseAccountHelper_10", (String)"fi-arapcommon", (Object[])new Object[0]));
                }
                if ("billstatus".equals(property)) {
                    filterInfo.setCaption(ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001", (String)"CloseAccountHelper_11", (String)"fi-arapcommon", (Object[])new Object[0]));
                }
            }
            settings.add(filterInfo);
        }
        FilterColumnSetting dateFilterInfo = "ap_invoice".equals(entityKey) || "ar_invoice".equals(entityKey) ? new FilterColumnSetting(FilterColumnSetting.FilterType.DateFilterColumn, bizDateFieldName, ResManager.loadKDString((String)"\u5f00\u7968\u65e5\u671f", (String)"CloseAccountHelper_9", (String)"fi-arapcommon", (Object[])new Object[0])) : new FilterColumnSetting(FilterColumnSetting.FilterType.DateFilterColumn, bizDateFieldName, ResManager.loadKDString((String)"\u4e1a\u52a1\u65e5\u671f", (String)"CloseAccountHelper_8", (String)"fi-arapcommon", (Object[])new Object[0]));
        InitHelper initHelper = new InitHelper(orgId, CloseAccountHelper.getEntity(isAr, "Init"));
        ArrayList<Object> defaultDates = new ArrayList<Object>();
        defaultDates.add(DateUtils.formatString(initHelper.getCurrentDate(), "yyyy-MM-dd"));
        defaultDates.add(DateUtils.formatString(duedate, "yyyy-MM-dd"));
        dateFilterInfo.setDefaultValues(defaultDates);
        settings.add(dateFilterInfo);
        return settings;
    }

    public static List<Map<String, Object>> getAllValidateInfos(boolean isAr, long orgId, Date closeDate) {
        return CloseAccountHelper.getAllValidateInfos(isAr, orgId, closeDate, null);
    }

    public static List<Map<String, Object>> getAllValidateInfos(boolean isAr, long orgId, Date closeDate, Date currentDate) {
        List<Object> failedInfos = new ArrayList();
        List<CheckItemDetailInfo> checkItemList = CloseAccountHelper.queryCheckItemList(isAr, orgId);
        failedInfos = CloseAccountHelper.getValidateInfos(orgId, checkItemList, closeDate, currentDate, isAr);
        boolean isExist = failedInfos.stream().anyMatch(row -> row.get("entityKey").equals("ar_invoice"));
        if (!isExist) {
            boolean isCheck = true;
            if (isAr) {
                Object ar012 = SystemParameterHelper.getARAppParameter(orgId, "ar_012");
                boolean bl = isCheck = ar012 == null ? true : (Boolean)ar012;
                if (isCheck) {
                    failedInfos.addAll(CloseAccountHelper.getInvoiceValidateInfos(isAr, orgId, closeDate, currentDate));
                }
            }
        }
        return failedInfos;
    }

    public static List<CheckItemDetailInfo> queryCheckItemList(boolean isAr, long orgId) {
        return ClosePeriodHelper.getCheckItemList(isAr, orgId);
    }

    public static List<Map<String, Object>> getValidateInfos(long orgId, List<CheckItemDetailInfo> checkItemList, Date closeDate, boolean isAr) {
        return CloseAccountHelper.getValidateInfos(orgId, checkItemList, closeDate, null, isAr);
    }

    public static List<Map<String, Object>> getValidateInfos(long orgId, List<CheckItemDetailInfo> checkItemList, Date closeDate, Date currentDate, boolean isAr) {
        ArrayList<Map<String, Object>> failedInfos = new ArrayList<Map<String, Object>>();
        if (ObjectUtils.isEmpty((Object)currentDate)) {
            DynamicObject info;
            if (isAr) {
                info = QueryServiceHelper.queryOne((String)"ar_closeaccount", (String)"currentdate", (QFilter[])new QFilter[]{new QFilter("org.id", "=", (Object)orgId)});
                currentDate = info.getDate("currentdate");
            } else {
                info = QueryServiceHelper.queryOne((String)"ap_closeaccount", (String)"currentdate", (QFilter[])new QFilter[]{new QFilter("org.id", "=", (Object)orgId)});
                currentDate = info.getDate("currentdate");
            }
        }
        for (CheckItemDetailInfo checkItemDetail : checkItemList) {
            String checkCondition;
            String entityNum = checkItemDetail.getCheckBillId();
            Set<String> adjExchEntityName = CloseAccountHelper.getAdjExchEntityName();
            if (adjExchEntityName.contains(entityNum)) continue;
            String number = checkItemDetail.getNumber();
            if ("AR009".equals(number)) {
                CloseAccountHelper.checkOriginalBillOnPass(failedInfos, orgId, closeDate, currentDate);
            }
            if (StringUtils.isEmpty(checkCondition = checkItemDetail.getCheckCondition())) continue;
            QFilter qFilter = QFilter.fromSerializedString((String)checkCondition);
            String periodPropName = checkItemDetail.getPeriodPropName();
            QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter(periodPropName, "<=", (Object)DateUtils.getDataFormat(closeDate, false)), new QFilter(periodPropName, ">=", (Object)DateUtils.getDataFormat(currentDate, true)), qFilter};
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)("arapcommon.CloseAccount.Query" + entityNum), (String)entityNum, (String)"billstatus", (QFilter[])filters, null);
            Throwable throwable = null;
            try {
                failedInfos.addAll(CloseAccountHelper.getFailedInfos(dataSet, isAr, entityNum, closeDate));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dataSet == null) continue;
                if (throwable != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                dataSet.close();
            }
        }
        return failedInfos;
    }

    private static void checkOriginalBillOnPass(List<Map<String, Object>> failedInfos, long orgId, Date closeDate, Date currentDate) {
        QFilter filter = new QFilter("orgid", "=", (Object)orgId);
        filter.and(new QFilter("issuetime", ">=", (Object)currentDate));
        filter.and(new QFilter("issuetime", "<=", (Object)closeDate));
        filter.and(new QFilter("validstate", "=", (Object)"2"));
        filter.and(new QFilter("billsourcetype", "=", (Object)"A"));
        filter.and(new QFilter("unpushamount", "!=", (Object)BigDecimal.ZERO));
        DynamicObjectCollection simBill = QueryServiceHelper.query((String)"sim_original_bill", (String)"id", (QFilter[])new QFilter[]{filter});
        if (simBill != null && !simBill.isEmpty()) {
            int count = simBill.size();
            String closeDateDisplayName = DateUtils.formatString(closeDate, "yyyy-MM-dd");
            String entityLocaleName = MetadataServiceHelper.getDataEntityType((String)"sim_original_bill").getDisplayName().getLocaleValue();
            String failedMessage = String.format(ResManager.loadKDString((String)"\u622a\u6b62%1$s\uff0c%2$s\u6709%3$s\u5f20\u5df2\u5f00\u7968\u672a\u786e\u8ba4\u5e94\u6536\u7684\u5355\u636e\u3002", (String)"CloseAccountHelper_12", (String)"fi-arapcommon", (Object[])new Object[0]), closeDateDisplayName, entityLocaleName, count);
            HashMap<String, Object> result = new HashMap<String, Object>(8);
            result.put("message", failedMessage);
            result.put("entityKey", "sim_original_bill");
            result.put("billCount", count);
            result.put("closeDate", closeDate);
            result.put("billStatus", "2");
            failedInfos.add(result);
        }
    }

    private static Set<String> getAdjExchEntityName() {
        HashSet<String> entityName = new HashSet<String>(8);
        entityName.add("ap_adjexchbill");
        entityName.add("ar_adjustexchbill");
        entityName.add("ap_adjustexch");
        entityName.add("ar_adjustexch");
        return entityName;
    }

    private static List<Map<String, Object>> getFailedInfos(DataSet dataSet, boolean isAr, String bill, Date closeDate) {
        dataSet = dataSet.groupBy(new String[]{"billstatus"}).count("count").finish();
        ArrayList<Map<String, Object>> failedInfos = new ArrayList<Map<String, Object>>();
        dataSet.forEach(row -> failedInfos.add(CloseAccountHelper.genDetailInfo(bill, closeDate, row.getString("billstatus"), row.getInteger("count"), isAr)));
        return failedInfos;
    }
}

