/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.IFormPlugin;
import kd.fi.arapcommon.model.BillModel;
import kd.fi.arapcommon.service.DiscountRateService;
import kd.fi.arapcommon.vo.ProRateDisPram;

public class DiscountAmtHelper {
    public void setEntryDiscountAmt(BillModel dataModel, IDataModel m, Map<String, Object> discountMap) {
        DynamicObject finBill = m.getDataEntity();
        DynamicObjectCollection entrys = m.getEntryEntity(dataModel.ENTRY);
        ProRateDisPram disParam = new ProRateDisPram();
        disParam.setAmtScale(finBill.getInt("currency.amtprecision"));
        disParam.setBillTotalAmt((BigDecimal)m.getValue(dataModel.HEAD_PRICETAXTOTAL));
        disParam.setEntryTotalAmtFiled(dataModel.E_PRICETAXTOTAL);
        disParam.setDiscountTotalAmt(new BigDecimal(String.valueOf(discountMap.get("discountamount"))));
        disParam.setEntrys(entrys);
        DiscountRateService disCountService = new DiscountRateService();
        Map<Integer, BigDecimal> diacountMap = disCountService.apportAmtByRatio(disParam);
        Boolean includeTax = (Boolean)m.getValue(dataModel.HEAD_ISINCLUDETAX);
        m.beginInit();
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject entry = (DynamicObject)entrys.get(i);
            Integer seq = entry.getInt("seq");
            BigDecimal entryDiscountAmt = diacountMap.get(seq);
            if (entryDiscountAmt == null) continue;
            m.setValue(dataModel.E_DISCOUNTAMOUNT, (Object)entryDiscountAmt, i);
            BigDecimal qty = entry.getBigDecimal(dataModel.E_QUANTITY);
            BigDecimal taxRate = (BigDecimal)m.getValue(dataModel.E_TAXRATE, i);
            taxRate = taxRate.divide(BigDecimal.valueOf(100L));
            BigDecimal discountRate = includeTax != false ? entryDiscountAmt.divide(qty, 10, RoundingMode.DOWN) : entryDiscountAmt.divide(qty, 10, RoundingMode.DOWN).divide(BigDecimal.ONE.add(taxRate), 10, RoundingMode.DOWN);
            m.setValue(dataModel.E_DISCOUNTRATE, (Object)discountRate, i);
        }
        m.endInit();
    }

    public void discountShowForm(IFormView view, AbstractBillPlugIn billPlugIn, BillModel dataModel) {
        FormShowParameter formShowParameter = new FormShowParameter();
        DynamicObject finBiLL = view.getModel().getDataEntity(true);
        BigDecimal priceTaxTotal = finBiLL.getBigDecimal(dataModel.HEAD_PRICETAXTOTAL);
        DynamicObjectCollection entrys = finBiLL.getDynamicObjectCollection(dataModel.ENTRY);
        for (DynamicObject entry : entrys) {
            boolean isPresent = entry.getBoolean(dataModel.E_ISPRESENT);
            if (isPresent) continue;
            priceTaxTotal = priceTaxTotal.add(entry.getBigDecimal(dataModel.E_DISCOUNTAMOUNT));
        }
        formShowParameter.setFormId("ap_totaldiscount");
        HashMap<String, Object> customParams = new HashMap<String, Object>(8);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        DynamicObject currency = (DynamicObject)view.getModel().getValue("currency");
        if (ObjectUtils.isEmpty((Object)currency)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u7ed3\u7b97\u5e01\u522b\u3002", (String)"BusArBillEdit_14", (String)"fi-ar-formplugin", (Object[])new Object[0]));
            return;
        }
        customParams.put("currency", currency.getPkValue());
        customParams.put("priceTaxTotal", priceTaxTotal);
        customParams.put("entityname", view.getModel().getDataEntity().getDynamicObjectType().getName());
        formShowParameter.setCustomParams(customParams);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)billPlugIn, "ap_totaldiscount"));
        view.showForm(formShowParameter);
    }

    public void setRowDiscountRate(int index, IDataModel m, String changeKey, BillModel dataModel) {
        DynamicObject currency = (DynamicObject)m.getValue("currency");
        if (currency != null) {
            int amtPrecision = currency.getInt("amtprecision");
            String discountMode = (String)m.getValue(dataModel.E_DISCOUNTMODE, index);
            Boolean includeTax = (Boolean)m.getValue("isincludetax");
            BigDecimal taxRate = (BigDecimal)m.getValue(dataModel.E_TAXRATE, index);
            taxRate = taxRate.divide(BigDecimal.valueOf(100L));
            if ("TOTAL".equals(discountMode)) {
                BigDecimal qty = (BigDecimal)m.getValue(dataModel.E_QUANTITY, index);
                BigDecimal entryDisAmt = (BigDecimal)m.getValue(dataModel.E_DISCOUNTAMOUNT, index);
                BigDecimal rate = (BigDecimal)m.getValue(dataModel.E_DISCOUNTRATE, index);
                if (dataModel.E_QUANTITY.equals(changeKey) || dataModel.E_TAXRATE.equals(changeKey)) {
                    m.beginInit();
                    if (includeTax.booleanValue()) {
                        m.setValue(dataModel.E_DISCOUNTAMOUNT, (Object)rate.multiply(qty).setScale(amtPrecision, RoundingMode.HALF_UP), index);
                    } else {
                        m.setValue(dataModel.E_DISCOUNTAMOUNT, (Object)rate.multiply(qty).multiply(BigDecimal.ONE.add(taxRate)).setScale(amtPrecision, RoundingMode.HALF_UP), index);
                    }
                    m.endInit();
                } else if (dataModel.E_DISCOUNTAMOUNT.equals(changeKey)) {
                    BigDecimal discountRate = includeTax != false ? entryDisAmt.divide(qty, 10, RoundingMode.HALF_UP) : entryDisAmt.divide(qty, 10, RoundingMode.HALF_UP).divide(BigDecimal.ONE.add(taxRate), 10, RoundingMode.HALF_UP);
                    m.setValue(dataModel.E_DISCOUNTRATE, (Object)discountRate, index);
                }
            }
        }
    }
}

