/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.fi.arapcommon.util.EmptyUtils;

public class DynamicObjectHelper {
    public static List<Object> getMasterIds(Collection<DynamicObject> objs) {
        if (objs == null) {
            return new ArrayList<Object>();
        }
        ArrayList<Object> pks = new ArrayList<Object>(objs.size());
        for (DynamicObject obj : objs) {
            pks.add(obj.get("masterid"));
        }
        return pks;
    }

    public static List<Long> getLongIds(Collection<DynamicObject> objs) {
        if (objs == null) {
            return new ArrayList<Long>();
        }
        ArrayList<Long> pks = new ArrayList<Long>(objs.size());
        for (DynamicObject obj : objs) {
            pks.add(obj.getLong("id"));
        }
        return pks;
    }

    public static List<Object> getIdList(DynamicObject[] infos) {
        ArrayList<Object> idList = new ArrayList<Object>(infos.length);
        for (DynamicObject info : infos) {
            idList.add(info.get("id"));
        }
        return idList;
    }

    public static List<Object> getIdList(Collection<DynamicObject> objs) {
        if (objs == null) {
            return new ArrayList<Object>();
        }
        ArrayList<Object> pks = new ArrayList<Object>(objs.size());
        for (DynamicObject obj : objs) {
            pks.add(obj.get("id"));
        }
        return pks;
    }

    public static List<Object> getIdList4MultiBase(DynamicObjectCollection objs) {
        if (objs == null) {
            return new ArrayList<Object>();
        }
        ArrayList<Object> pks = new ArrayList<Object>(objs.size());
        for (DynamicObject obj : objs) {
            pks.add(obj.getDynamicObject("fbasedataid").getPkValue());
        }
        return pks;
    }

    public static void setValue(DynamicObject obj, String prop, Object value) {
        if (value instanceof DynamicObject) {
            obj.set(prop, ((DynamicObject)value).getPkValue());
        } else {
            obj.set(prop, value);
        }
    }

    public static Long getPk(DynamicObject obj, String prop) {
        Object value = obj.get(prop);
        if (value instanceof DynamicObject) {
            return (Long)((DynamicObject)value).getPkValue();
        }
        return (Long)value;
    }

    public static void setValueIfAbsent(DynamicObject obj, String prop, Object value) {
        if (EmptyUtils.isEmpty(obj.get(prop))) {
            DynamicObjectHelper.setValue(obj, prop, value);
        }
    }

    public static boolean isEmpty(DynamicObject obj, String prop) {
        return EmptyUtils.isEmpty(obj.get(prop));
    }

    public static String getLocalStringValue(DynamicObject obj, String prop) {
        ILocaleString localeString = obj.getLocaleString(prop);
        if (localeString == null) {
            return obj.getString(prop);
        }
        return localeString.getLocaleValue();
    }
}

