/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.arapcommon.vo.FilterColumnSetting;

public class FilterColumnHelper {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FilterColumnSetting createCommonFilterSetting(QFilter filter, String entityName) {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityName);
        String cp = filter.getCP();
        DynamicProperty property = dataEntityType.getProperty(filter.getProperty());
        FilterColumnSetting filterInfo = null;
        filterInfo = property instanceof DateProp ? new FilterColumnSetting(FilterColumnSetting.FilterType.DateFilterColumn, property.getName(), property.getDisplayName().getLocaleValue()) : new FilterColumnSetting(FilterColumnSetting.FilterType.CommonFilterColumn, property.getName(), property.getDisplayName().getLocaleValue());
        if ("=".equals(cp)) {
            ArrayList<Object> values = new ArrayList<Object>();
            values.add(filter.getValue().toString());
            filterInfo.setDefaultValues(values);
            FilterColumnHelper.createComboItem(property, values, filterInfo);
            return filterInfo;
        } else if ("in".equals(cp)) {
            List values = (List)filter.getValue();
            filterInfo.setDefaultValues(values);
            FilterColumnHelper.createComboItem(property, values, filterInfo);
            return filterInfo;
        } else {
            if (!"!=".equals(cp)) return null;
            if (!(property instanceof ComboProp)) return null;
            ArrayList<Object> seletedValues = new ArrayList<Object>();
            List comboItems = ((ComboProp)property).getComboItems();
            for (ValueMapItem item : comboItems) {
                if (item.getValue().equals(filter.getValue())) continue;
                seletedValues.add(item.getValue());
            }
            filterInfo.setDefaultValues(seletedValues);
            FilterColumnHelper.createComboItem(property, seletedValues, filterInfo);
        }
        return filterInfo;
    }

    private static void createComboItem(DynamicProperty property, List<Object> values, FilterColumnSetting filterInfo) {
        if (property instanceof BasedataProp) {
            if (property instanceof ItemClassProp) {
                return;
            }
            String baseEntityId = ((BasedataProp)property).getBaseEntityId();
            Map baseDatas = BusinessDataServiceHelper.loadFromCache((Object[])values.toArray(new Object[values.size()]), (String)baseEntityId);
            baseDatas.forEach((k, v) -> {
                String displayProp = ((BasedataProp)property).getDisplayProp();
                String displayName = v.getLocaleString(displayProp).getLocaleValue();
                filterInfo.addComboItem(displayName, k.toString());
            });
        } else if (property instanceof ComboProp) {
            List comboItems = ((ComboProp)property).getComboItems();
            block0: for (Object value : values) {
                for (ValueMapItem item : comboItems) {
                    if (!item.getValue().equals(value)) continue;
                    filterInfo.addComboItem(item.getName().getLocaleValue(), value.toString());
                    continue block0;
                }
            }
        } else if (property instanceof DateProp) {
            filterInfo.setDefaultValues(values);
        } else if (property instanceof BooleanProp) {
            if (values.get(0).equals("1")) {
                filterInfo.addComboItem(ResManager.loadKDString((String)"\u662f", (String)"FilterColumnHelper_0", (String)"fi-arapcommon", (Object[])new Object[0]), "1");
            } else {
                filterInfo.addComboItem(ResManager.loadKDString((String)"\u5426", (String)"FilterColumnHelper_1", (String)"fi-arapcommon", (Object[])new Object[0]), "0");
            }
        }
    }

    public static List<Map<String, Object>> toMap(List<FilterColumnSetting> infos) {
        LinkedList<Map<String, Object>> list = new LinkedList<Map<String, Object>>();
        for (FilterColumnSetting info : infos) {
            list.add(FilterColumnHelper.toMap(info));
        }
        return list;
    }

    public static Map<String, Object> toMap(FilterColumnSetting info) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("filterType", (Object)info.getFilterType());
        map.put("fieldName", info.getFieldName());
        map.put("caption", info.getCaption());
        map.put("comboItemNames", info.getComboItemNames());
        map.put("comboItemValus", info.getComboItemValus());
        map.put("defaultValues", info.getDefaultValues());
        map.put("isAppend", info.isAppend());
        return map;
    }

    public static List<FilterColumnSetting> fromMap(List<Map<String, Object>> map) {
        LinkedList<FilterColumnSetting> result = new LinkedList<FilterColumnSetting>();
        for (Map<String, Object> each : map) {
            result.add(FilterColumnHelper.fromMap(each));
        }
        return result;
    }

    public static FilterColumnSetting fromMap(Map<String, Object> map) {
        FilterColumnSetting.FilterType filterType = FilterColumnSetting.FilterType.valueOf((String)map.get("filterType"));
        String fieldName = (String)map.get("fieldName");
        String caption = (String)map.get("caption");
        boolean isAppend = (Boolean)map.get("isAppend");
        List comboItemNames = (List)map.get("comboItemNames");
        List comboItemValus = (List)map.get("comboItemValus");
        List defaultValues = (List)map.get("defaultValues");
        FilterColumnSetting info = new FilterColumnSetting(filterType, fieldName, caption);
        info.setComboItemNames(comboItemNames);
        info.setComboItemValus(comboItemValus);
        info.setDefaultValues(defaultValues);
        info.setAppend(isAppend);
        return info;
    }
}

