/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.MessageChannels;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.fi.arapcommon.enums.BillStatusEnum;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.service.concurrency.BillConcuControlParam;
import kd.fi.arapcommon.service.concurrency.LightLockCtrlNoDBStrategy;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.StdConfig;

public class InitHelper {
    private DynamicObject init;
    private static final Log logger = LogFactory.getLog(InitHelper.class);

    public InitHelper(long orgId, String entity) {
        QFilter qFilter = new QFilter("org", "=", (Object)orgId);
        if ("ar_init".equals(entity)) {
            Map initMap = BusinessDataServiceHelper.loadFromCache((String)entity, (String)(this.getSelectors() + ", policytype.type"), (QFilter[])new QFilter[]{qFilter});
            if (!ObjectUtils.isEmpty((Object)initMap)) {
                Collection inits = initMap.values();
                if (inits.size() == 1) {
                    this.init = (DynamicObject)inits.iterator().next();
                } else {
                    for (DynamicObject obj : inits) {
                        DynamicObject policytype = obj.getDynamicObject("policytype");
                        if (policytype == null || !"master".equals(policytype.getString("type"))) continue;
                        this.init = obj;
                    }
                    if (this.init == null && !inits.isEmpty()) {
                        this.init = (DynamicObject)inits.iterator().next();
                    }
                }
            }
        } else {
            this.init = BusinessDataServiceHelper.loadSingleFromCache((String)entity, (String)this.getSelectors(), (QFilter[])new QFilter[]{qFilter});
        }
    }

    private String getSelectors() {
        ArrayList<String> selectors = new ArrayList<String>();
        selectors.add("id");
        selectors.add("org");
        selectors.add("standardcurrency");
        selectors.add("exratetable");
        selectors.add("isfinishinit");
        selectors.add("periodtype");
        selectors.add("startperiod");
        selectors.add("curperiod");
        selectors.add("startdate");
        selectors.add("currentdate");
        return String.join((CharSequence)",", selectors);
    }

    public Object getInitId() {
        if (this.init == null) {
            return null;
        }
        return this.init.getPkValue();
    }

    public DynamicObject getStandardCurrency() {
        if (this.init == null) {
            return null;
        }
        return this.init.getDynamicObject("standardcurrency");
    }

    public DynamicObject getExrateTable() {
        if (this.init == null) {
            return null;
        }
        return this.init.getDynamicObject("exratetable");
    }

    public boolean isFinishInit() {
        if (this.init == null) {
            return false;
        }
        return this.init.getBoolean("isfinishinit");
    }

    public Date getStartDate() {
        if (this.init == null) {
            return null;
        }
        Date startDate = this.init.getDate("startdate");
        return startDate == null ? null : DateUtils.getDataFormat(startDate, true);
    }

    public Date getCurrentDate() {
        if (this.init == null) {
            return null;
        }
        Date currentDate = this.init.getDate("currentdate");
        return currentDate == null ? null : DateUtils.getDataFormat(currentDate, true);
    }

    public boolean isFinishSetting() {
        return this.getStartDate() != null;
    }

    public Object getCurperiodId() {
        if (this.init == null) {
            return null;
        }
        DynamicObject curperiod = this.init.getDynamicObject("curperiod");
        return curperiod == null ? null : curperiod.getPkValue();
    }

    public DynamicObject getPeriodType() {
        if (this.init == null) {
            return null;
        }
        return this.init.getDynamicObject("periodtype");
    }

    public DynamicObject getStartPeriod() {
        if (this.init == null) {
            return null;
        }
        return this.init.getDynamicObject("startperiod");
    }

    public DynamicObject getInit() {
        return this.init;
    }

    public static Map<String, Object> checkDataVolume(boolean isAr, boolean isCloseInit, List<Long> orgIds) {
        long count;
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        if (orgIds == null || orgIds.isEmpty()) {
            return result;
        }
        String dataSize = StdConfig.get("initDataSize");
        long threshold = EmptyUtils.isNotEmpty(dataSize) ? Long.parseLong(dataSize) : 20000L;
        QFilter orgFilter = new QFilter("org", "in", orgIds);
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)(isCloseInit ? BillStatusEnum.SUBMIT.getValue() : BillStatusEnum.AUDIT.getValue()));
        QFilter periodFilter = new QFilter("isperiod", "=", (Object)Boolean.TRUE);
        QFilter[] filter = new QFilter[]{orgFilter, statusFilter, periodFilter};
        QFilter[] filterForRecAndPay = new QFilter[]{orgFilter, statusFilter};
        if (isAr) {
            DataSet billDataSet = QueryServiceHelper.queryDataSet((String)"initDataCheck", (String)"ar_finarbill", (String)"count(1)", (QFilter[])filter, null);
            int finSize = billDataSet.next().getInteger("count(1)");
            count = finSize;
            result.put("ar_finarbill", finSize);
            billDataSet = QueryServiceHelper.queryDataSet((String)"initDataCheck", (String)"ar_busbill", (String)"count(1)", (QFilter[])filter, null);
            int busSize = billDataSet.next().getInteger("count(1)");
            count += (long)busSize;
            result.put("ar_busbill", busSize);
            billDataSet = QueryServiceHelper.queryDataSet((String)"initDataCheck", (String)"ar_receivedbill", (String)"count(1)", (QFilter[])filterForRecAndPay, null);
            int recSize = billDataSet.next().getInteger("count(1)");
            count += (long)recSize;
            result.put("ar_receivedbill", recSize);
        } else {
            DataSet billDataSet = QueryServiceHelper.queryDataSet((String)"initDataCheck", (String)"ap_finapbill", (String)"count(1)", (QFilter[])filter, null);
            int finSize = billDataSet.next().getInteger("count(1)");
            count = finSize;
            result.put("ap_finapbill", finSize);
            billDataSet = QueryServiceHelper.queryDataSet((String)"initDataCheck", (String)"ap_busbill", (String)"count(1)", (QFilter[])filter, null);
            int busSize = billDataSet.next().getInteger("count(1)");
            count += (long)busSize;
            result.put("ap_busbill", busSize);
            billDataSet = QueryServiceHelper.queryDataSet((String)"initDataCheck", (String)"ap_paidbill", (String)"count(1)", (QFilter[])filterForRecAndPay, null);
            int paySize = billDataSet.next().getInteger("count(1)");
            count += (long)paySize;
            result.put("ap_paidbill", paySize);
        }
        result.put("isOver", count > threshold);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invokeInitializeOp(Set<Long> ids, String billEntity, String biz, String opKey, boolean isFinishInit, IFormView view, boolean isSendMessage) {
        if (ids == null || ids.isEmpty()) {
            return;
        }
        boolean isAr = "ar_init".equals(billEntity);
        BillConcuControlParam param = new BillConcuControlParam(billEntity, biz, ids);
        param.setNeedWait(false);
        LightLockCtrlNoDBStrategy lock = new LightLockCtrlNoDBStrategy(param);
        lock.addCtrl();
        try {
            QFilter idFilter = new QFilter("id", "in", ids);
            DynamicObjectCollection inits = QueryServiceHelper.query((String)billEntity, (String)"id, org.name, isfinishinit", (QFilter[])idFilter.toArray());
            HashMap<Long, String> orgNameMap = new HashMap<Long, String>(8);
            for (DynamicObject init : inits) {
                Long id = init.getLong("id");
                String orgName = init.getString("org.name");
                orgNameMap.put(id, orgName);
            }
            OperationResult operationResult = view.invokeOperation(opKey);
            List successPkIds = operationResult.getSuccessPkIds();
            if (successPkIds != null && !successPkIds.isEmpty() && isSendMessage) {
                HashSet orgNames = new HashSet(8);
                for (Object successPkId : successPkIds) {
                    Long id = Long.parseLong(successPkId.toString());
                    orgNames.add(orgNameMap.get(id));
                }
                String orgNameMsg = String.join((CharSequence)"\u3001", orgNames);
                String resultMessage = isFinishInit ? ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7\u201c%s\u201d\uff1a\u7ed3\u675f\u521d\u59cb\u5316", (String)"InitHelper_2", (String)"fi-arapcommon", (Object[])new Object[]{orgNameMsg}) : ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7\u201c%s\u201d\uff1a\u53cd\u521d\u59cb\u5316", (String)"InitHelper_3", (String)"fi-arapcommon", (Object[])new Object[]{orgNameMsg});
                String successMsg = ResManager.loadKDString((String)"\u6210\u529f", (String)"InitHelper_4", (String)"fi-arapcommon", (Object[])new Object[0]);
                InitHelper.sendMessage(resultMessage + successMsg, isAr);
            }
            OperationHelper.assertResult(operationResult);
        }
        catch (Exception e) {
            if (isSendMessage) {
                InitHelper.sendMessage(e.getMessage(), isAr);
            }
        }
        finally {
            lock.releaseCtrl();
        }
    }

    public static void sendMessage(String resultMessage, boolean isAr) {
        List msgIdList;
        Map dataMap;
        Object successMsgIds;
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setType("message");
        messageInfo.setTitle(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u901a\u77e5\uff0c\u8bf7\u67e5\u9605\u3002", (String)"InitHelper_6", (String)"fi-arapcommon", (Object[])new Object[0]));
        messageInfo.setContent(resultMessage);
        String senderName = isAr ? ResManager.loadKDString((String)"\u5e94\u6536\u521d\u59cb\u5316", (String)"InitHelper_7", (String)"fi-arapcommon", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5e94\u4ed8\u521d\u59cb\u5316", (String)"InitHelper_9", (String)"fi-arapcommon", (Object[])new Object[0]);
        messageInfo.setSenderName(senderName);
        long currUserId = RequestContext.get().getCurrUserId();
        messageInfo.setUserIds(Collections.singletonList(currUserId));
        messageInfo.setTag(ResManager.loadKDString((String)"\u5fc5\u8bfb", (String)"InitHelper_8", (String)"fi-arapcommon", (Object[])new Object[0]));
        messageInfo.setNotifyType(MessageChannels.MC.getNumber());
        String source = isAr ? "ar" : "ap";
        messageInfo.setSource(source);
        ArrayList<MessageInfo> infos = new ArrayList<MessageInfo>(2);
        infos.add(messageInfo);
        Map result = MessageCenterServiceHelper.batchSendMessages(infos);
        Object data = result.get("data");
        if (data != null && (successMsgIds = (dataMap = (Map)data).get("successMsgIds")) != null && !(msgIdList = (List)successMsgIds).isEmpty()) {
            logger.info("\u521d\u59cb\u5316\u540e\u53d1\u9001\u5230\u6d88\u606f\u4e2d\u5fc3\u7684\u6d88\u606fID:" + msgIdList.get(0));
        }
    }

    public void checkInit() {
        StringBuilder errMsg = new StringBuilder();
        if (ObjectUtils.isEmpty((Object)this.getStandardCurrency())) {
            errMsg.append(ResManager.loadKDString((String)"\u4e1a\u52a1\u4e3b\u5e01\u79cd", (String)"InitHelper_10", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        if (ObjectUtils.isEmpty((Object)this.getExrateTable())) {
            if (errMsg.length() > 0) {
                errMsg.append("\u3001");
            }
            errMsg.append(ResManager.loadKDString((String)"\u6c47\u7387\u8868", (String)"InitHelper_11", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        if (ObjectUtils.isEmpty((Object)this.getPeriodType())) {
            if (errMsg.length() > 0) {
                errMsg.append("\u3001");
            }
            errMsg.append(ResManager.loadKDString((String)"\u671f\u95f4\u7c7b\u578b", (String)"InitHelper_12", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        if (errMsg.length() > 0) {
            String initEntity = this.init.getDataEntityType().getName();
            String appName = "ar_init".equals(initEntity) ? ResManager.loadKDString((String)"\u5e94\u6536", (String)"InitHelper_13", (String)"fi-arapcommon", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5e94\u4ed8", (String)"InitHelper_14", (String)"fi-arapcommon", (Object[])new Object[0]);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\uff1a%1$s\u521d\u59cb\u5316\u8bbe\u7f6e\u5b57\u6bb5%2$s\u9519\u8bef\uff0c\u8bf7\u5230%3$s\u5e94\u7528\u4e0b\u68c0\u67e5\u521d\u59cb\u5316\u8bbe\u7f6e\u3002", (String)"InitHelper_0", (String)"fi-arapcommon", (Object[])new Object[0]), this.init.getString("org.name"), errMsg.toString(), appName));
        }
    }
}

