/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.exception.KDBizException;
import kd.fi.arapcommon.invoice.vo.AmtInfo;
import kd.fi.arapcommon.invoice.vo.BaseInfo;
import kd.fi.arapcommon.invoice.vo.Invoice;
import kd.fi.arapcommon.invoice.vo.RecEntry;
import kd.fi.arapcommon.util.StringUtils;

public class InvoiceCloudLocalHelper {
    public List<Map<String, Object>> simpleInvoiceSplit(Invoice invoice) {
        ArrayList<Map<String, Object>> params = new ArrayList<Map<String, Object>>(2);
        HashMap<String, Object> param = new HashMap<String, Object>(16);
        String splitOrMergeFlag = invoice.getSplitOrMergeFlag();
        param.put("splitOrMergeFlag", splitOrMergeFlag);
        param.put("invoiceStatus", "0");
        String invoiceType = invoice.getBaseInfo().getInvoiceType();
        if (!this.isAllEleType(invoiceType)) {
            param.put("invoiceCode", this.getCode());
        }
        param.put("invoiceNo", this.getNo(invoiceType));
        BaseInfo baseInfo = invoice.getBaseInfo();
        param.put("billNo", baseInfo.getBillNo());
        param.put("invoiceDate", System.currentTimeMillis());
        AmtInfo amtInfo = invoice.getAmtInfo();
        List<RecEntry> recentrys = amtInfo.getRecentrys();
        ArrayList<Map<String, Object>> itemParams = new ArrayList<Map<String, Object>>(2);
        if (recentrys.size() > 1) {
            Map<String, Object> copyParam;
            if ("2".equals(splitOrMergeFlag)) {
                copyParam = this.multiEntryMergeBuild(param, itemParams, recentrys);
                if (!copyParam.isEmpty()) {
                    params.add(copyParam);
                }
            } else {
                copyParam = this.multiEntrySplitBuild(param, itemParams, recentrys);
                if (!copyParam.isEmpty()) {
                    params.add(copyParam);
                }
            }
        } else if (recentrys.size() == 1) {
            this.oneEntryBuild(param, itemParams, recentrys);
        } else {
            throw new KDBizException("No Entry Error.");
        }
        String no = param.get("invoiceNo").toString();
        long invoiceNo = Long.parseLong(no.substring(no.length() - 8)) + 1L;
        param.put("invoiceNo", no.substring(0, no.length() - 8) + invoiceNo);
        params.add(param);
        return params;
    }

    private Map<String, Object> multiEntryMergeBuild(Map<String, Object> param, List<Map<String, Object>> itemParams, List<RecEntry> recentrys) {
        param.put("splitOrMergeFlag", "3");
        HashMap<String, RecEntry> mergeMap = new HashMap<String, RecEntry>(16);
        for (int i = 0; i < recentrys.size(); ++i) {
            RecEntry recEntry = recentrys.get(i);
            String goodsname = StringUtils.isEmpty(recEntry.getMaterial()) ? recEntry.getExpenseItem() : recEntry.getMaterial();
            String goodsCode = recEntry.getGoodsCode();
            String specModel = recEntry.getSpecModel();
            String key = goodsname + goodsCode + specModel;
            RecEntry mergeEntry = (RecEntry)mergeMap.get(key);
            if (mergeEntry != null) {
                mergeEntry.setTaxAmount(recEntry.getTaxAmount().add(mergeEntry.getTaxAmount()));
                mergeEntry.setDetailAmount(recEntry.getDetailAmount().add(mergeEntry.getDetailAmount()));
                mergeEntry.setNum(recEntry.getNum().add(mergeEntry.getNum()));
                continue;
            }
            mergeMap.put(key, recEntry);
        }
        HashMap<String, Object> copyParam = new HashMap<String, Object>(16);
        BigDecimal tax = BigDecimal.ZERO;
        BigDecimal amt = BigDecimal.ZERO;
        int i = -1;
        for (Map.Entry entry : mergeMap.entrySet()) {
            RecEntry recEntry = (RecEntry)entry.getValue();
            Map<String, Object> itemParam = this.baseEntryBuild(recEntry);
            if (++i == 0) {
                copyParam.putAll(param);
                copyParam.put("totalAmount", recEntry.getDetailAmount().add(recEntry.getTaxAmount()));
                copyParam.put("totalTaxAmount", recEntry.getTaxAmount());
                copyParam.put("invoiceAmount", recEntry.getDetailAmount());
                ArrayList<Map<String, Object>> itemParams4First = new ArrayList<Map<String, Object>>(2);
                itemParams4First.add(itemParam);
                copyParam.put("items", itemParams4First);
                continue;
            }
            tax = tax.add(recEntry.getTaxAmount());
            amt = amt.add(recEntry.getDetailAmount());
            itemParams.add(itemParam);
        }
        param.put("totalAmount", amt.add(tax));
        param.put("totalTaxAmount", tax);
        param.put("invoiceAmount", amt);
        param.put("items", itemParams);
        return copyParam;
    }

    private Map<String, Object> multiEntrySplitBuild(Map<String, Object> param, List<Map<String, Object>> itemParams, List<RecEntry> recentrys) {
        param.put("splitOrMergeFlag", "1");
        HashMap<String, Object> copyParam = new HashMap<String, Object>(16);
        BigDecimal tax = BigDecimal.ZERO;
        BigDecimal amt = BigDecimal.ZERO;
        for (int i = 0; i < recentrys.size(); ++i) {
            RecEntry recEntry = recentrys.get(i);
            Map<String, Object> itemParam = this.baseEntryBuild(recEntry);
            if (i == 0) {
                copyParam.putAll(param);
                copyParam.put("totalAmount", recEntry.getDetailAmount().add(recEntry.getTaxAmount()));
                copyParam.put("totalTaxAmount", recEntry.getTaxAmount());
                copyParam.put("invoiceAmount", recEntry.getDetailAmount());
                ArrayList<Map<String, Object>> itemParams4First = new ArrayList<Map<String, Object>>(2);
                itemParams4First.add(itemParam);
                copyParam.put("items", itemParams4First);
                continue;
            }
            tax = tax.add(recEntry.getTaxAmount());
            amt = amt.add(recEntry.getDetailAmount());
            itemParams.add(itemParam);
        }
        param.put("totalAmount", amt.add(tax));
        param.put("totalTaxAmount", tax);
        param.put("invoiceAmount", amt);
        param.put("items", itemParams);
        return copyParam;
    }

    private void oneEntryBuild(Map<String, Object> param, List<Map<String, Object>> itemParams, List<RecEntry> recentrys) {
        RecEntry recEntry = recentrys.get(0);
        Map<String, Object> itemParam = this.baseEntryBuild(recEntry);
        itemParams.add(itemParam);
        param.put("totalAmount", recEntry.getDetailAmount().add(recEntry.getTaxAmount()));
        param.put("totalTaxAmount", recEntry.getTaxAmount());
        param.put("invoiceAmount", recEntry.getDetailAmount());
        param.put("items", itemParams);
    }

    private Map<String, Object> baseEntryBuild(RecEntry recEntry) {
        HashMap<String, Object> itemParam = new HashMap<String, Object>(16);
        itemParam.put("itemID", recEntry.getItemID());
        itemParam.put("taxAmount", recEntry.getTaxAmount());
        itemParam.put("detailAmount", recEntry.getDetailAmount());
        itemParam.put("num", recEntry.getNum());
        itemParam.put("unitPrice", recEntry.getUnitPrice());
        itemParam.put("taxRate", recEntry.getTaxRate());
        itemParam.put("goodsCode", recEntry.getGoodsCode());
        itemParam.put("goodsName", StringUtils.isEmpty(recEntry.getMaterial()) ? recEntry.getExpenseItem() : recEntry.getMaterial());
        itemParam.put("specModel", recEntry.getSpecModel());
        return itemParam;
    }

    private String getCode() {
        String millisStr = this.getMillisStr();
        return millisStr.substring(millisStr.length() - 11);
    }

    private String getNo(String invoiceType) {
        String millisStr = this.getMillisStr();
        if (this.isAllEleType(invoiceType)) {
            return "6124333" + millisStr;
        }
        return millisStr.substring(millisStr.length() - 8);
    }

    private boolean isAllEleType(String invoiceType) {
        return "26".equals(invoiceType) || "27".equals(invoiceType);
    }

    private String getMillisStr() {
        return String.valueOf(System.currentTimeMillis());
    }

    public static String invoiceDebugJson() {
        return null;
    }
}

