/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;

public class LineTypeHelper {
    public static List<Long> getAllBizTypeIds(long billTypeId) {
        LinkedList<Long> bizTypeIds = new LinkedList<Long>();
        Map<Long, JSONObject> result = LineTypeHelper.getBizTypebyBillType(billTypeId);
        if (result != null) {
            Collection<JSONObject> values = result.values();
            for (JSONObject value : values) {
                String bizTypeStr = value.getString("biztypeids");
                if (bizTypeStr == null) continue;
                bizTypeIds.addAll((Collection)JSON.parseObject((String)bizTypeStr, List.class));
            }
        }
        return bizTypeIds;
    }

    public static long getDefaultBizTypeId(long billTypeId) {
        Long defaultBizTypeId = 0L;
        Map<Long, JSONObject> result = LineTypeHelper.getBizTypebyBillType(billTypeId);
        if (result != null) {
            Collection<JSONObject> values = result.values();
            for (JSONObject value : values) {
                String defaultBizTypeStr = value.getString("defaultbiztypeid");
                if (defaultBizTypeStr != null) {
                    defaultBizTypeId = Long.parseLong(defaultBizTypeStr);
                    break;
                }
                String bizTypeStr = value.getString("biztypeids");
                if (bizTypeStr == null) break;
                List bizTypeIds = (List)JSON.parseObject((String)bizTypeStr, List.class);
                defaultBizTypeId = (Long)bizTypeIds.get(0);
            }
        }
        return defaultBizTypeId;
    }

    public static DynamicObject getDefaultBizType(long billTypeId) {
        long bizTypeId = LineTypeHelper.getDefaultBizTypeId(billTypeId);
        DynamicObject bizTypeObj = BusinessDataServiceHelper.loadSingleFromCache((Object)bizTypeId, (String)"bd_biztype");
        return bizTypeObj;
    }

    public static DynamicObject getBizTypebyId(long bizTypeId) {
        DynamicObject lineTypeObj = BusinessDataServiceHelper.loadSingleFromCache((Object)bizTypeId, (String)"bd_biztype");
        return lineTypeObj;
    }

    public static Map<Long, JSONObject> getBizTypebyBillType(long billTypeId) {
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"BillTypeMaterialService", (String)"getBizTypeByBillTypeparameterId", (Object[])new Object[]{billTypeId});
        return result;
    }

    public static Set<Long> getAllLineTypeIds(Long bizTypeId) {
        JSONObject lineTypeParam;
        ArrayList<Long> bizTypeIds = new ArrayList<Long>(1);
        bizTypeIds.add(bizTypeId);
        Map<Long, JSONObject> result = LineTypeHelper.getLineTypeByBizTypes(bizTypeIds);
        if (result != null && (lineTypeParam = result.get(bizTypeId)) != null) {
            String lineTypeIdStr = lineTypeParam.getString("lineTypeIds");
            Set lineTypeIdSet = (Set)JSON.parseObject((String)lineTypeIdStr, Set.class);
            return lineTypeIdSet;
        }
        return new HashSet<Long>();
    }

    public static long getDefaultLineTypeId(Long bizTypeId) {
        JSONObject lineTypeParam;
        long defaultLineTypeId = 0L;
        LinkedList<Long> bizTypeIds = new LinkedList<Long>();
        bizTypeIds.add(bizTypeId);
        Map<Long, JSONObject> result = LineTypeHelper.getLineTypeByBizTypes(bizTypeIds);
        if (result != null && (lineTypeParam = result.get(bizTypeId)) != null) {
            String defalutLineTypeStr = lineTypeParam.getString("deafaultLineType");
            String isEableStr = lineTypeParam.getString("isDeafaultEnable");
            if (Boolean.parseBoolean(isEableStr)) {
                defaultLineTypeId = Long.parseLong(defalutLineTypeStr);
            }
        }
        return defaultLineTypeId;
    }

    public static Map<Long, JSONObject> getLineTypeByBizTypes(List<Long> bizTypeIds) {
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"BillTypeMaterialService", (String)"getLineTypeByBillType", (Object[])new Object[]{bizTypeIds});
        return result;
    }

    public static QFilter[] getMaterialFilterByLineType(Long billTypeId, Long bizTypeId, Long lineTypeId) {
        QFilter[] materialFilters = (QFilter[])DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"BillTypeMaterialService", (String)"getQFilterByLineType", (Object[])new Object[]{billTypeId, bizTypeId, lineTypeId, Boolean.FALSE});
        return materialFilters;
    }

    public static boolean checkBizTypeinBillType(Long bizTypeId, Long billTypeId) {
        if (ObjectUtils.isEmpty((Object)bizTypeId) || ObjectUtils.isEmpty((Object)billTypeId)) {
            return false;
        }
        List<Long> BizTypeIdList = LineTypeHelper.getAllBizTypeIds(billTypeId);
        if (ObjectUtils.isEmpty(BizTypeIdList)) {
            return false;
        }
        return BizTypeIdList.contains(bizTypeId);
    }

    public static boolean checkLineTypeinBizType(Long lineTypeId, Long bizTypeId) {
        if (ObjectUtils.isEmpty((Object)lineTypeId) || ObjectUtils.isEmpty((Object)bizTypeId)) {
            return false;
        }
        Set<Long> lineTypeIdList = LineTypeHelper.getAllLineTypeIds(bizTypeId);
        if (ObjectUtils.isEmpty(lineTypeIdList)) {
            return false;
        }
        return lineTypeIdList.contains(lineTypeId);
    }

    public static DynamicObject getDefaultLineType(Long bizTypeId) {
        long lineTypeId = LineTypeHelper.getDefaultLineTypeId(bizTypeId);
        DynamicObject lineTypeObj = BusinessDataServiceHelper.loadSingleFromCache((Object)lineTypeId, (String)"bd_linetype");
        return lineTypeObj;
    }

    public static DynamicObject getLineTypebyId(Long lineTypeId) {
        DynamicObject lineTypeObj = BusinessDataServiceHelper.loadSingleFromCache((Object)lineTypeId, (String)"bd_linetype");
        return lineTypeObj;
    }

    public static Boolean getParam(long orgId, boolean isAr) {
        String paramKey = "ap_025";
        if (isAr) {
            paramKey = "ar_025";
            return SystemParameterHelper.getARBooleanParam(orgId, paramKey);
        }
        return SystemParameterHelper.getAPBooleanParam(orgId, paramKey);
    }

    public static Map<Long, Object> batchGetParam(List<Long> orgIds, boolean isAr) {
        String paramKey = "ap_025";
        if (isAr) {
            paramKey = "ar_025";
        }
        return SystemParameterHelper.batchGetAppParameter(isAr, orgIds, paramKey);
    }
}

