/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.helper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.RuntimeMetaType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;

public class MutexLockHelper {
    private static final Log logger = LogFactory.getLog(MutexLockHelper.class);
    private static final String DATA_OBJ_ID = "dataObjId";
    private static final String GROUP_ID = "groupId";
    private static final String ENTITY_KEY = "entityKey";
    private static final String OPERATION_KEY = "operationKey";
    private static final String IS_STRICT = "isStrict";

    public static void requireMutex(String entityKey, Set<Long> billIds, String operationKey, String errorInfo) {
        boolean isStrict = true;
        String netGroupId = RuntimeMetaType.NetCtrlOperate + "." + entityKey + "." + operationKey;
        if (netGroupId.length() > 36) {
            netGroupId = netGroupId.substring(netGroupId.length() - 36);
        }
        ArrayList mutexRequireList = new ArrayList(billIds.size());
        for (Long billId : billIds) {
            HashMap<String, Object> requireParam = new HashMap<String, Object>(8);
            requireParam.put(DATA_OBJ_ID, billId.toString());
            requireParam.put(GROUP_ID, netGroupId);
            requireParam.put(ENTITY_KEY, entityKey);
            requireParam.put(OPERATION_KEY, operationKey);
            requireParam.put(IS_STRICT, isStrict);
            mutexRequireList.add(requireParam);
        }
        try (DataMutex dataMutex = DataMutex.create();){
            Map mutexResult = dataMutex.batchrequire(mutexRequireList);
            for (Map.Entry mutexItem : mutexResult.entrySet()) {
                String objId = (String)mutexItem.getKey();
                Boolean required = (Boolean)mutexItem.getValue();
                if (required.booleanValue()) continue;
                throw new KDBizException(errorInfo);
            }
        }
        catch (IOException exception) {
            ErrorCode ec = new ErrorCode("MUTEX_REQUIRE_ERROR", String.format(ResManager.loadKDString((String)"\u7533\u8bf7\u4e92\u65a5\u9501\u51fa\u9519\uff1a%s\u3002", (String)"MutexLockHelper_4", (String)"fi-arapcommon", (Object[])new Object[0]), exception.getMessage()));
            throw new KDException((Throwable)exception, ec, new Object[0]);
        }
    }

    public static void batchRelease(String entityNumber, Set<Long> lockIDs, String operationKey) {
        String netGroupId = RuntimeMetaType.NetCtrlOperate + "." + entityNumber + "." + operationKey;
        if (netGroupId.length() > 36) {
            netGroupId = netGroupId.substring(netGroupId.length() - 36);
        }
        if (!lockIDs.isEmpty()) {
            ArrayList mutexRequireList = new ArrayList(lockIDs.size());
            for (Long lockID : lockIDs) {
                HashMap<String, String> requireParam = new HashMap<String, String>(8);
                requireParam.put(DATA_OBJ_ID, lockID.toString());
                requireParam.put(GROUP_ID, netGroupId);
                requireParam.put(ENTITY_KEY, entityNumber);
                requireParam.put(OPERATION_KEY, operationKey);
                mutexRequireList.add(requireParam);
            }
            try (DataMutex dataMutex = DataMutex.create();){
                Map releaseResult = dataMutex.batchRelease(mutexRequireList);
                for (Map.Entry releaseItem : releaseResult.entrySet()) {
                    boolean releaseRet = (Boolean)releaseItem.getValue();
                    String objId = (String)releaseItem.getKey();
                    if (releaseRet) continue;
                    logger.info("\u91ca\u653e\u6570\u636e\u5bf9\u8c61[" + objId + "]\u4e92\u65a5\u9501\u5931\u8d25.");
                }
            }
            catch (IOException exception) {
                throw new KDException((Throwable)exception, new ErrorCode("MUTEX_RELEASE_ERROR", String.format(ResManager.loadKDString((String)"\u91ca\u653e\u6570\u636e\u5bf9\u8c61\u4e92\u65a5\u9501\u51fa\u9519\uff0c\u9519\u8bef\u539f\u56e0\uff1a%s", (String)"MutexLockHelper_5", (String)"fi-arapcommon", (Object[])new Object[0]), exception.getMessage())), new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean requireMutex(String entityName, String key, String operationKey) {
        DataMutex dataMutex = null;
        try {
            dataMutex = DataMutex.create();
            boolean bl = dataMutex.require(key, RuntimeMetaType.NetCtrlOperate + "." + entityName, entityName, operationKey);
            return bl;
        }
        catch (Exception e) {
            logger.info("require mutex lock error :" + e);
        }
        finally {
            if (dataMutex != null) {
                try {
                    dataMutex.close();
                }
                catch (IOException e) {
                    logger.info("mutex lock close error :" + e);
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean releaseMutex(String entityName, String key, String operationKey) {
        DataMutex dataMutex = null;
        try {
            dataMutex = DataMutex.create();
            boolean bl = dataMutex.release(key, entityName, operationKey);
            return bl;
        }
        catch (Exception e) {
            logger.info("require mutex release error :" + e);
        }
        finally {
            if (dataMutex != null) {
                try {
                    dataMutex.close();
                }
                catch (IOException e) {
                    logger.info("mutex release lock close error :" + e);
                }
            }
        }
        return false;
    }
}

