/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.helper;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.enums.InvoiceBizTypeEnum;

public class PushApSetSupplierFiledHelper {
    private static final String bizId = "83bfebc8000002ac";

    public static void setInvoiceType(DynamicObject[] bills, boolean isFinAp) {
        Set asstactPks = Arrays.stream(bills).map(t -> t.getLong("asstact.id")).collect(Collectors.toSet());
        Map asstacts = BusinessDataServiceHelper.loadFromCache((String)"bd_supplier", (String)"paymentcurrency, entry_bank.bankaccount, entry_bank.bank, entry_bank.isdefault_bank,invoicecategory", (QFilter[])new QFilter[]{new QFilter("id", "in", asstactPks)});
        Set invoiceCategoryIdSet = asstacts.values().stream().map(t -> t.getLong("invoicecategory.id")).collect(Collectors.toSet());
        Map invoiceBizTypeMap = BusinessDataServiceHelper.loadFromCache((String)"bd_invoicebiztype", (String)"number,id,mulinvoicetype", (QFilter[])new QFilter[]{new QFilter("mulinvoicetype.fbasedataid", "in", invoiceCategoryIdSet).and("mulbiz.fbasedataid", "=", (Object)bizId)});
        HashMap<Object, DynamicObject> invoiceTypeMap = new HashMap<Object, DynamicObject>(8);
        Map specInvoiceTypeMap = BusinessDataServiceHelper.loadFromCache((String)"bd_invoicebiztype", (String)"number,id,mulinvoicetype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)InvoiceBizTypeEnum.SP00002_S.getValue()).and("mulbiz.fbasedataid", "=", (Object)bizId)});
        for (Map.Entry asstactEntry : asstacts.entrySet()) {
            DynamicObject asst = (DynamicObject)asstactEntry.getValue();
            Long invoiceTypeId = asst.getLong("invoicecategory.id");
            if (invoiceTypeId == null || invoiceTypeId == 0L) continue;
            for (Map.Entry bizTypeIdEntry : invoiceBizTypeMap.entrySet()) {
                DynamicObject invoiceBizType = (DynamicObject)bizTypeIdEntry.getValue();
                DynamicObjectCollection mulInvoiceTypes = invoiceBizType.getDynamicObjectCollection("mulinvoicetype");
                Set invoiceTypeIds = mulInvoiceTypes.stream().map(t -> t.get("FBasedataId.id")).collect(Collectors.toSet());
                if (!invoiceTypeIds.contains(invoiceTypeId)) continue;
                invoiceTypeMap.put(asst.get("id"), invoiceBizType);
            }
        }
        for (DynamicObject finApBill : bills) {
            DynamicObject invoiceBizType = finApBill.getDynamicObject("invoicebiztype");
            if (invoiceBizType != null) continue;
            DynamicObject asstact = finApBill.getDynamicObject("asstact");
            String asstactType = asstact.getDataEntityType().getName();
            Object asstactPk = asstact.getPkValue();
            if ("bd_supplier".equals(asstactType)) {
                Object invoiceBizTypeId = invoiceTypeMap.get(asstactPk);
                if (invoiceBizTypeId == null) {
                    finApBill.set("invoicebiztype", specInvoiceTypeMap.get(InvoiceBizTypeEnum.SP00002_S.getValue()));
                } else {
                    finApBill.set("invoicebiztype", invoiceBizTypeId);
                }
            }
            if (!isFinAp) continue;
            String taxPayerType = finApBill.getString("org.taxpayertype");
            long invoiceBizTypeId = finApBill.getLong("invoicebiztype.id");
            if (StringUtils.isEmpty((CharSequence)taxPayerType)) {
                if (invoiceBizTypeId == 0L || InvoiceBizTypeEnum.SP00002_S.getValue() == invoiceBizTypeId) {
                    finApBill.set("istaxdeduction", (Object)Boolean.TRUE);
                    continue;
                }
                finApBill.set("istaxdeduction", (Object)Boolean.FALSE);
                continue;
            }
            if ("1".equals(taxPayerType) && (InvoiceBizTypeEnum.SP00002_S.getValue() == invoiceBizTypeId || invoiceBizTypeId == 0L)) {
                finApBill.set("istaxdeduction", (Object)Boolean.TRUE);
                continue;
            }
            finApBill.set("istaxdeduction", (Object)Boolean.FALSE);
        }
    }
}

