/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;

public class RPASettleSchemeDefaultValueHelper {
    public static final String WEEK = "10";
    public static final String MONTH = "63";
    public static final String YEAR = "66";
    public static final String EQUALS = "105";
    public static final String AMT_EQUALS = "67";
    public static final String AMT_NOT_EQUALS = "83";
    public static final String LARGE_THAN = "21";
    public static final String LESS_THAN = "36";
    public static final String IN = "17";

    public static FilterCondition getDefaultFilterCondition(String settleRelation, String entityKey, String dateKey, boolean isMain, int settleModel) {
        FilterCondition condition = RPASettleSchemeDefaultValueHelper.getDefaultFilterCondition(settleRelation, entityKey, dateKey, isMain);
        if (settleModel == 2 && ("ap_finapbill".equals(entityKey) || "ar_finarbill".equals(entityKey))) {
            List filterRow = condition.getFilterRow();
            ((SimpleFilterRow)filterRow.get(2)).setFieldName("unplanlockamt");
        }
        return condition;
    }

    public static FilterCondition getDefaultFilterCondition(String settleRelation, String entityKey, String dateKey, boolean isMain) {
        FilterCondition filterCondition = new FilterCondition();
        switch (settleRelation) {
            case "appaysettle": 
            case "recsettle": 
            case "aparsettle": 
            case "arapsettle": 
            case "payrecsettle": 
            case "recpaysettle": {
                List<SimpleFilterRow> rows;
                if ("ap_finapbill".equals(entityKey)) {
                    filterCondition.setFilterRow(RPASettleSchemeDefaultValueHelper.getFinapFilter(AMT_NOT_EQUALS, dateKey));
                }
                if ("ar_finarbill".equals(entityKey)) {
                    filterCondition.setFilterRow(RPASettleSchemeDefaultValueHelper.getFinarFilter(AMT_NOT_EQUALS, dateKey));
                }
                if ("cas_paybill".equals(entityKey)) {
                    filterCondition.setFilterRow(RPASettleSchemeDefaultValueHelper.getPayFilter(AMT_NOT_EQUALS, dateKey));
                }
                if ("ap_paidbill".equals(entityKey)) {
                    rows = RPASettleSchemeDefaultValueHelper.getPayFilter(AMT_NOT_EQUALS, dateKey);
                    SimpleFilterRow row = rows.get(0);
                    row.setCompareType(EQUALS);
                    row.setValue(RPASettleSchemeDefaultValueHelper.getFilterValues("C"));
                    rows.get(2).setFieldName("paymenttype.ispartpayment");
                    filterCondition.setFilterRow(rows);
                }
                if ("cas_recbill".equals(entityKey)) {
                    filterCondition.setFilterRow(RPASettleSchemeDefaultValueHelper.geRecFilter(AMT_NOT_EQUALS, dateKey));
                }
                if (!"ar_receivedbill".equals(entityKey)) break;
                rows = RPASettleSchemeDefaultValueHelper.geRecFilter(AMT_NOT_EQUALS, dateKey);
                rows.get(0).setValue(RPASettleSchemeDefaultValueHelper.getFilterValues("C"));
                rows.get(2).setFieldName("rectype.ispartreceivable");
                filterCondition.setFilterRow(rows);
                break;
            }
            case "recclearing": 
            case "payclearing": {
                List<SimpleFilterRow> rows;
                if ("cas_paybill".equals(entityKey)) {
                    filterCondition.setFilterRow(RPASettleSchemeDefaultValueHelper.getPayFilter(LARGE_THAN, dateKey));
                }
                if ("ap_paidbill".equals(entityKey)) {
                    rows = RPASettleSchemeDefaultValueHelper.getPayFilter(LARGE_THAN, dateKey);
                    SimpleFilterRow row = rows.get(0);
                    row.setCompareType(EQUALS);
                    row.setValue(RPASettleSchemeDefaultValueHelper.getFilterValues("C"));
                    rows.get(2).setFieldName("paymenttype.ispartpayment");
                    filterCondition.setFilterRow(rows);
                }
                if ("cas_recbill".equals(entityKey)) {
                    filterCondition.setFilterRow(RPASettleSchemeDefaultValueHelper.geRecFilter(LARGE_THAN, dateKey));
                }
                if (!"ar_receivedbill".equals(entityKey)) break;
                rows = RPASettleSchemeDefaultValueHelper.geRecFilter(LARGE_THAN, dateKey);
                rows.get(0).setValue(RPASettleSchemeDefaultValueHelper.getFilterValues("C"));
                rows.get(2).setFieldName("rectype.ispartreceivable");
                filterCondition.setFilterRow(rows);
                break;
            }
            case "apself": 
            case "liqsettle": {
                if (isMain) {
                    filterCondition.setFilterRow(RPASettleSchemeDefaultValueHelper.getFinapFilter(LARGE_THAN, dateKey));
                    break;
                }
                filterCondition.setFilterRow(RPASettleSchemeDefaultValueHelper.getFinapFilter(LESS_THAN, dateKey));
                break;
            }
            case "apreceivesettle": {
                if (isMain) {
                    filterCondition.setFilterRow(RPASettleSchemeDefaultValueHelper.getFinapFilter(LESS_THAN, dateKey));
                    break;
                }
                filterCondition.setFilterRow(RPASettleSchemeDefaultValueHelper.geRecFilter(LARGE_THAN, dateKey));
                break;
            }
            case "arself": 
            case "arliqsettle": {
                if (isMain) {
                    filterCondition.setFilterRow(RPASettleSchemeDefaultValueHelper.getFinarFilter(LARGE_THAN, dateKey));
                    break;
                }
                filterCondition.setFilterRow(RPASettleSchemeDefaultValueHelper.getFinarFilter(LESS_THAN, dateKey));
                break;
            }
            case "arpaymentsettle": {
                if (isMain) {
                    filterCondition.setFilterRow(RPASettleSchemeDefaultValueHelper.getFinarFilter(LESS_THAN, dateKey));
                    break;
                }
                filterCondition.setFilterRow(RPASettleSchemeDefaultValueHelper.getPayFilter(LARGE_THAN, dateKey));
                break;
            }
            case "payself": {
                if (isMain) {
                    if ("cas_paybill".equals(entityKey)) {
                        filterCondition.setFilterRow(RPASettleSchemeDefaultValueHelper.getPayFilter(LARGE_THAN, dateKey));
                    }
                    if (!"ap_paidbill".equals(entityKey)) break;
                    List<SimpleFilterRow> rows = RPASettleSchemeDefaultValueHelper.getPayFilter(LARGE_THAN, dateKey);
                    SimpleFilterRow row = rows.get(0);
                    row.setCompareType(EQUALS);
                    row.setValue(RPASettleSchemeDefaultValueHelper.getFilterValues("C"));
                    rows.get(2).setFieldName("paymenttype.ispartpayment");
                    filterCondition.setFilterRow(rows);
                    break;
                }
                if ("cas_paybill".equals(entityKey)) {
                    filterCondition.setFilterRow(RPASettleSchemeDefaultValueHelper.getPayFilter(LESS_THAN, dateKey));
                }
                if (!"ap_paidbill".equals(entityKey)) break;
                List<SimpleFilterRow> rows = RPASettleSchemeDefaultValueHelper.getPayFilter(LESS_THAN, dateKey);
                SimpleFilterRow row = rows.get(0);
                row.setCompareType(EQUALS);
                row.setValue(RPASettleSchemeDefaultValueHelper.getFilterValues("C"));
                rows.get(2).setFieldName("paymenttype.ispartpayment");
                filterCondition.setFilterRow(rows);
                break;
            }
            case "recself": {
                if (isMain) {
                    if ("cas_recbill".equals(entityKey)) {
                        filterCondition.setFilterRow(RPASettleSchemeDefaultValueHelper.geRecFilter(LARGE_THAN, dateKey));
                    }
                    if (!"ar_receivedbill".equals(entityKey)) break;
                    List<SimpleFilterRow> rows = RPASettleSchemeDefaultValueHelper.geRecFilter(LARGE_THAN, dateKey);
                    rows.get(0).setValue(RPASettleSchemeDefaultValueHelper.getFilterValues("C"));
                    rows.get(2).setFieldName("rectype.ispartreceivable");
                    filterCondition.setFilterRow(rows);
                    break;
                }
                if ("cas_recbill".equals(entityKey)) {
                    filterCondition.setFilterRow(RPASettleSchemeDefaultValueHelper.geRecFilter(LESS_THAN, dateKey));
                }
                if (!"ar_receivedbill".equals(entityKey)) break;
                List<SimpleFilterRow> rows = RPASettleSchemeDefaultValueHelper.geRecFilter(LESS_THAN, dateKey);
                rows.get(0).setValue(RPASettleSchemeDefaultValueHelper.getFilterValues("C"));
                rows.get(2).setFieldName("rectype.ispartreceivable");
                filterCondition.setFilterRow(rows);
            }
        }
        return filterCondition;
    }

    public static List<SimpleFilterRow> getPayFilter(String type, String dateKey) {
        ArrayList<SimpleFilterRow> rows = new ArrayList<SimpleFilterRow>(4);
        SimpleFilterRow statusRow = new SimpleFilterRow();
        statusRow.setFieldName("billstatus");
        statusRow.setCompareType(IN);
        statusRow.setLogic("0");
        statusRow.setValue(RPASettleSchemeDefaultValueHelper.getFilterValues("D", "F", "I"));
        rows.add(statusRow);
        SimpleFilterRow unsettleRow = new SimpleFilterRow();
        unsettleRow.setCompareType(type);
        unsettleRow.setFieldName("e_unsettledamt");
        unsettleRow.setLogic("0");
        unsettleRow.setValue(RPASettleSchemeDefaultValueHelper.getFilterValues("0"));
        rows.add(unsettleRow);
        SimpleFilterRow unlockRow = new SimpleFilterRow();
        unlockRow.setCompareType(EQUALS);
        unlockRow.setFieldName("e_paymenttype.ispartpayment");
        unlockRow.setLogic("0");
        unlockRow.setValue(RPASettleSchemeDefaultValueHelper.getFilterValues("1"));
        rows.add(unlockRow);
        SimpleFilterRow dateRow = new SimpleFilterRow();
        dateRow.setCompareType(WEEK);
        dateRow.setFieldName(dateKey);
        dateRow.setLogic("0");
        dateRow.setValue(RPASettleSchemeDefaultValueHelper.getFilterValues(""));
        rows.add(dateRow);
        return rows;
    }

    public static List<SimpleFilterRow> geRecFilter(String type, String dateKey) {
        ArrayList<SimpleFilterRow> rows = new ArrayList<SimpleFilterRow>(4);
        SimpleFilterRow statusRow = new SimpleFilterRow();
        statusRow.setFieldName("billstatus");
        statusRow.setCompareType(EQUALS);
        statusRow.setLogic("0");
        statusRow.setValue(RPASettleSchemeDefaultValueHelper.getFilterValues("D"));
        rows.add(statusRow);
        SimpleFilterRow unsettleRow = new SimpleFilterRow();
        unsettleRow.setCompareType(type);
        unsettleRow.setFieldName("e_unsettledamt");
        unsettleRow.setLogic("0");
        unsettleRow.setValue(RPASettleSchemeDefaultValueHelper.getFilterValues("0"));
        rows.add(unsettleRow);
        SimpleFilterRow unlockRow = new SimpleFilterRow();
        unlockRow.setCompareType(EQUALS);
        unlockRow.setFieldName("e_receivingtype.ispartreceivable");
        unlockRow.setLogic("0");
        unlockRow.setValue(RPASettleSchemeDefaultValueHelper.getFilterValues("1"));
        rows.add(unlockRow);
        SimpleFilterRow dateRow = new SimpleFilterRow();
        dateRow.setCompareType(WEEK);
        dateRow.setFieldName(dateKey);
        dateRow.setLogic("0");
        dateRow.setValue(RPASettleSchemeDefaultValueHelper.getFilterValues(""));
        rows.add(dateRow);
        return rows;
    }

    public static List<SimpleFilterRow> getFinapFilter(String type, String dateKey) {
        ArrayList<SimpleFilterRow> rows = new ArrayList<SimpleFilterRow>(4);
        SimpleFilterRow statusRow = new SimpleFilterRow();
        statusRow.setFieldName("billstatus");
        statusRow.setCompareType(EQUALS);
        statusRow.setLogic("0");
        statusRow.setValue(RPASettleSchemeDefaultValueHelper.getFilterValues("C"));
        rows.add(statusRow);
        SimpleFilterRow unsettleRow = new SimpleFilterRow();
        unsettleRow.setCompareType(type);
        unsettleRow.setFieldName("unsettleamount");
        unsettleRow.setLogic("0");
        unsettleRow.setValue(RPASettleSchemeDefaultValueHelper.getFilterValues("0"));
        rows.add(unsettleRow);
        SimpleFilterRow unlockRow = new SimpleFilterRow();
        unlockRow.setCompareType(type);
        unlockRow.setFieldName("unlockamt");
        unlockRow.setLogic("0");
        unlockRow.setValue(RPASettleSchemeDefaultValueHelper.getFilterValues("0"));
        rows.add(unlockRow);
        SimpleFilterRow dateRow = new SimpleFilterRow();
        dateRow.setCompareType(WEEK);
        dateRow.setFieldName(dateKey);
        dateRow.setLogic("0");
        dateRow.setValue(RPASettleSchemeDefaultValueHelper.getFilterValues(""));
        rows.add(dateRow);
        return rows;
    }

    public static List<SimpleFilterRow> getFinarFilter(String type, String dateKey) {
        ArrayList<SimpleFilterRow> rows = new ArrayList<SimpleFilterRow>(4);
        SimpleFilterRow statusRow = new SimpleFilterRow();
        statusRow.setFieldName("billstatus");
        statusRow.setCompareType(EQUALS);
        statusRow.setLogic("0");
        statusRow.setValue(RPASettleSchemeDefaultValueHelper.getFilterValues("C"));
        rows.add(statusRow);
        SimpleFilterRow unsettleRow = new SimpleFilterRow();
        unsettleRow.setCompareType(type);
        unsettleRow.setFieldName("unsettleamount");
        unsettleRow.setLogic("0");
        unsettleRow.setValue(RPASettleSchemeDefaultValueHelper.getFilterValues("0"));
        rows.add(unsettleRow);
        SimpleFilterRow unlockRow = new SimpleFilterRow();
        unlockRow.setCompareType(type);
        unlockRow.setFieldName("e_unlockamt");
        unlockRow.setLogic("0");
        unlockRow.setValue(RPASettleSchemeDefaultValueHelper.getFilterValues("0"));
        rows.add(unlockRow);
        SimpleFilterRow dateRow = new SimpleFilterRow();
        dateRow.setCompareType(WEEK);
        dateRow.setFieldName(dateKey);
        dateRow.setLogic("0");
        dateRow.setValue(RPASettleSchemeDefaultValueHelper.getFilterValues(""));
        rows.add(dateRow);
        return rows;
    }

    public static List<FilterValue> getFilterValues(Object ... values) {
        ArrayList<FilterValue> filterValues = new ArrayList<FilterValue>(1);
        for (Object value : values) {
            filterValues.add(RPASettleSchemeDefaultValueHelper.getFilterValue(value));
        }
        return filterValues;
    }

    public static FilterValue getFilterValue(Object v) {
        FilterValue value = new FilterValue();
        value.setValue(v);
        return value;
    }

    @Deprecated
    public static List<Map<String, Object>> getDefaultEntryMap(String settleRelation, String asstEntityKey) {
        ArrayList<Map<String, Object>> entryMapList = new ArrayList<Map<String, Object>>(4);
        switch (settleRelation) {
            case "appaysettle": {
                if ("cas_paybill".equals(asstEntityKey)) {
                    entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("org.number", "entry.settleorg.number"));
                    entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("currency.number"));
                    entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("asstacttype", "itempayeetype"));
                    entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("asstact.number", "itempayee.number"));
                }
                if (!"ap_paidbill".equals(asstEntityKey)) break;
                entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("org.number"));
                entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("currency.number"));
                entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("asstacttype", "payeetype"));
                entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("asstact.number", "payee.number"));
                break;
            }
            case "recsettle": {
                if ("cas_recbill".equals(asstEntityKey)) {
                    entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("org.number", "entry.e_settleorg.number"));
                    entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("currency.number"));
                    entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("asstacttype", "itempayertype"));
                    entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("asstact.number", "itempayer.number"));
                }
                if (!"ar_receivedbill".equals(asstEntityKey)) break;
                entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("org.number"));
                entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("currency.number"));
                entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("asstacttype"));
                entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("asstact.number"));
                break;
            }
            case "payrecsettle": {
                entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("entry.settleorg.number", "entry.e_settleorg.number"));
                entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("currency.number"));
                entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("itempayeetype", "itempayertype"));
                entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("itempayee.number", "itempayer.number"));
                break;
            }
            case "recpaysettle": {
                entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("entry.e_settleorg.number", "entry.settleorg.number"));
                entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("currency.number"));
                entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("itempayertype", "itempayeetype"));
                entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("itempayer.number", "itempayee.number"));
                break;
            }
            case "apself": 
            case "arself": 
            case "aparsettle": 
            case "arapsettle": {
                entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("org.number"));
                entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("currency.number"));
                entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("asstacttype"));
                entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("asstact.number"));
                break;
            }
            case "payself": {
                entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("entry.settleorg.number"));
                entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("currency.number"));
                entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("itempayeetype"));
                entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("itempayee.number"));
                break;
            }
            case "recself": {
                entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("entry.e_settleorg.number"));
                entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("currency.number"));
                entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("itempayertype"));
                entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("itempayer.number"));
                break;
            }
            case "apreceivesettle": {
                entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("org.number", "entry.e_settleorg.number"));
                entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("currency.number"));
                entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("asstacttype", "itempayertype"));
                entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("asstact.number", "itempayer.number"));
                break;
            }
            case "arpaymentsettle": {
                entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("org.number", "entry.settleorg.number"));
                entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("currency.number"));
                entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("asstacttype", "itempayeetype"));
                entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("asstact.number", "itempayee.number"));
            }
        }
        entryMapList.remove(3);
        entryMapList.remove(2);
        return entryMapList;
    }

    public static List<Map<String, Object>> getDefaultEntryMap(String settleRelation, String mainEntityKey, String asstEntityKey) {
        ArrayList<Map<String, Object>> entryMapList = new ArrayList<Map<String, Object>>(4);
        switch (settleRelation) {
            case "appaysettle": {
                if ("cas_paybill".equals(asstEntityKey)) {
                    entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("org.number", "entry.settleorg.number"));
                    entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("currency.number"));
                }
                if (!"ap_paidbill".equals(asstEntityKey)) break;
                entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("org.number"));
                entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("currency.number"));
                break;
            }
            case "recsettle": {
                if ("cas_recbill".equals(asstEntityKey)) {
                    entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("org.number", "entry.e_settleorg.number"));
                    entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("currency.number"));
                }
                if (!"ar_receivedbill".equals(asstEntityKey)) break;
                entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("org.number"));
                entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("currency.number"));
                break;
            }
            case "payrecsettle": {
                if ("cas_paybill".equals(mainEntityKey) && "cas_recbill".equals(asstEntityKey)) {
                    entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("entry.settleorg.number", "entry.e_settleorg.number"));
                }
                if ("ap_paidbill".equals(mainEntityKey) && "cas_recbill".equals(asstEntityKey)) {
                    entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("org.number", "entry.e_settleorg.number"));
                }
                if ("cas_paybill".equals(mainEntityKey) && "ar_receivedbill".equals(asstEntityKey)) {
                    entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("entry.settleorg.number", "org.number"));
                }
                if ("ap_paidbill".equals(mainEntityKey) && "ar_receivedbill".equals(asstEntityKey)) {
                    entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("org.number", "org.number"));
                }
                entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("currency.number"));
                break;
            }
            case "recpaysettle": {
                if ("cas_recbill".equals(mainEntityKey) && "cas_paybill".equals(asstEntityKey)) {
                    entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("entry.e_settleorg.number", "entry.settleorg.number"));
                }
                if ("ar_receivedbill".equals(mainEntityKey) && "cas_paybill".equals(asstEntityKey)) {
                    entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("org.number", "entry.settleorg.number"));
                }
                if ("cas_recbill".equals(mainEntityKey) && "ap_paidbill".equals(asstEntityKey)) {
                    entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("entry.e_settleorg.number", "org.number"));
                }
                if ("ar_receivedbill".equals(mainEntityKey) && "ap_paidbill".equals(asstEntityKey)) {
                    entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("org.number", "org.number"));
                }
                entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("currency.number"));
                break;
            }
            case "apself": 
            case "arself": 
            case "aparsettle": 
            case "arapsettle": {
                entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("org.number"));
                entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("currency.number"));
                break;
            }
            case "payself": {
                if ("cas_paybill".equals(mainEntityKey) && "cas_paybill".equals(asstEntityKey)) {
                    entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("entry.settleorg.number", "entry.settleorg.number"));
                }
                if ("ap_paidbill".equals(mainEntityKey) && "cas_paybill".equals(asstEntityKey)) {
                    entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("org.number", "entry.settleorg.number"));
                }
                if ("cas_paybill".equals(mainEntityKey) && "ap_paidbill".equals(asstEntityKey)) {
                    entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("entry.settleorg.number", "org.number"));
                }
                if ("ap_paidbill".equals(mainEntityKey) && "ap_paidbill".equals(asstEntityKey)) {
                    entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("org.number", "org.number"));
                }
                entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("currency.number"));
                break;
            }
            case "recself": {
                if ("cas_recbill".equals(mainEntityKey) && "cas_recbill".equals(asstEntityKey)) {
                    entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("entry.e_settleorg.number", "entry.e_settleorg.number"));
                }
                if ("ar_receivedbill".equals(mainEntityKey) && "cas_recbill".equals(asstEntityKey)) {
                    entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("org.number", "entry.e_settleorg.number"));
                }
                if ("cas_recbill".equals(mainEntityKey) && "ar_receivedbill".equals(asstEntityKey)) {
                    entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("entry.e_settleorg.number", "org.number"));
                }
                if ("ar_receivedbill".equals(mainEntityKey) && "ar_receivedbill".equals(asstEntityKey)) {
                    entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("org.number", "org.number"));
                }
                entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("currency.number"));
                break;
            }
            case "apreceivesettle": {
                entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("org.number", "entry.e_settleorg.number"));
                entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("currency.number"));
                break;
            }
            case "arpaymentsettle": {
                entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("org.number", "entry.settleorg.number"));
                entryMapList.add(RPASettleSchemeDefaultValueHelper.getInitEntryMap("currency.number"));
            }
        }
        return entryMapList;
    }

    public static Map<String, Object> getInitEntryMap(String mainfield) {
        return RPASettleSchemeDefaultValueHelper.getInitEntryMap(mainfield, mainfield);
    }

    public static Map<String, Object> getInitEntryMap(String mainfield, String asstfield) {
        HashMap<String, Object> entryMap = new HashMap<String, Object>(4);
        entryMap.put("mainfield", mainfield);
        entryMap.put("asstfield", asstfield);
        entryMap.put("matchrelation", "0");
        entryMap.put("isnullmatch", Boolean.FALSE);
        entryMap.put("preference", Boolean.TRUE);
        return entryMap;
    }
}

