/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.ext.consumer.ECServiceSwitch;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.kdtx.ec.ECServiceHelper;
import kd.fi.arapcommon.service.settle.callscmc.CallOrderConServiceFactory;
import kd.fi.arapcommon.service.settle.callscmc.ICallOrderConInvoker;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.vo.CallSCMCParam;
import kd.fi.arapcommon.vo.SettleRecordVO;
import kd.fi.arapcommon.vo.SettleSchemeVO;

public class Settle4ScmcHelper {
    private static final Log logger = LogFactory.getLog(Settle4ScmcHelper.class);
    private static int BATCH_SIZE = 1000;

    public static void writeBackPmOrderBillEntry(List<Map<String, Object>> rowList, boolean settle) {
        if (EmptyUtils.isEmpty(rowList)) {
            return;
        }
        logger.info("writeBackPmOrderBillEntry.isSettleWbOrderAndConOpened() is :  " + ECServiceHelper.isSettleWbOrderAndConOpened());
        if (ECServiceHelper.isSettleWbOrderAndConOpened()) {
            long uniqueKey = DB.genGlobalLongId();
            for (Map<String, Object> param : rowList) {
                param.put("uniquekey", uniqueKey);
            }
            CommonParam param = new CommonParam();
            param.put((Object)"list", rowList);
            List<Object> arApBillIds = rowList.stream().filter(row -> row.get("ArApBillId") != null).map(row -> row.get("ArApBillId")).distinct().collect(Collectors.toList());
            logger.info("writeBackPmOrderBillEntry-maybe-lock-billid: " + arApBillIds);
            ECServiceHelper.beginAndRegisterWithBusInfo("ap_settle", "ap_settle_wborder", "scmc", "pm", "WbApQtyAndAmountService", (Param)param, "", arApBillIds);
        } else {
            try (TXHandle tx = TX.requiresNew((String)"writeBackPmOrderBillEntry");){
                try {
                    Map result = (Map)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"pm", (String)"PurFiService", (String)"WbApQtyAndAmount", (Object[])new Object[]{rowList});
                    if (result != null && !Boolean.TRUE.equals(result.get("success"))) {
                        throw new KDBizException(String.valueOf(result.get("message")));
                    }
                }
                catch (Exception e) {
                    tx.markRollback();
                    throw e;
                }
            }
        }
    }

    public static void writeBackPmOrderPayPlanAmt(List<Map<String, Object>> rowList) {
        if (EmptyUtils.isEmpty(rowList)) {
            return;
        }
        logger.info("writeBackPmOrderPayPlanAmt.isOpened() is :  " + ECServiceSwitch.isOpened());
        if (ECServiceSwitch.isOpened()) {
            long uniqueKey = DB.genGlobalLongId();
            for (Map<String, Object> param : rowList) {
                param.put("uniquekey", uniqueKey);
            }
            CommonParam param = new CommonParam();
            param.put((Object)"list", rowList);
            List<Object> arApBillIds = rowList.stream().filter(row -> row.get("ArApBillId") != null).map(row -> row.get("ArApBillId")).distinct().collect(Collectors.toList());
            logger.info("writeBackPmOrderOtherAmt-maybe-lock-billid: " + arApBillIds);
            ECServiceHelper.beginAndRegisterWithBusInfo("pay_wbpuramount", null, "scmc", "pm", "WbPayPlanPayAmountService", (Param)param, "", arApBillIds);
        }
    }

    public static void writeBackPmOrderOtherAmt(List<Map<String, Object>> rowList, boolean settle) {
        if (EmptyUtils.isEmpty(rowList)) {
            return;
        }
        logger.info("writeBackPmOrderOtherAmt.isSettleWbOrderAndConOpened() is :  " + ECServiceSwitch.isOpened());
        if (ECServiceSwitch.isOpened()) {
            long uniqueKey = DB.genGlobalLongId();
            for (Map<String, Object> param : rowList) {
                param.put("uniquekey", uniqueKey);
            }
            CommonParam param = new CommonParam();
            param.put((Object)"list", rowList);
            param.put((Object)"settleRelation", rowList.get(0).get("settleRelation"));
            List<Object> arApBillIds = rowList.stream().filter(row -> row.get("ArApBillId") != null).map(row -> row.get("ArApBillId")).distinct().collect(Collectors.toList());
            logger.info("writeBackPmOrderOtherAmt-maybe-lock-billid: " + arApBillIds);
            ECServiceHelper.beginAndRegisterWithBusInfo("ap_settle", "ap_settle_wborder", "scmc", "pm", "WbPayAmountService", (Param)param, "", arApBillIds);
        }
    }

    public static void writeBackScpoOrderBillEntry(List<Map<String, Object>> rowList, boolean settle) {
        if (EmptyUtils.isEmpty(rowList)) {
            return;
        }
        logger.info("writeBackScpoOrderBillEntry.isSettleWbOrderAndConOpened() is :  " + ECServiceSwitch.isOpened());
        if (ECServiceSwitch.isOpened()) {
            long uniqueKey = DB.genGlobalLongId();
            for (Map<String, Object> param : rowList) {
                param.put("uniquekey", uniqueKey);
            }
            CommonParam param = new CommonParam();
            param.put((Object)"list", rowList);
            List<Object> arApBillIds = rowList.stream().filter(row -> row.get("ArApBillId") != null).map(row -> row.get("ArApBillId")).distinct().collect(Collectors.toList());
            logger.info("writeBackScpoOrderBillEntry-maybe-lock-billid: " + arApBillIds);
            ECServiceHelper.beginAndRegisterWithBusInfo("ap_settle", "ap_settle_wbscpoorder", "scmc", "sctm", "WbApQtyAndAmount4SctmService", (Param)param, "", arApBillIds);
        }
    }

    public static void writeBackScpoOrderPayPlanAmt(List<Map<String, Object>> rowList) {
        if (EmptyUtils.isEmpty(rowList)) {
            return;
        }
        logger.info("writeBackScpoOrderPayPlanAmt.isOpened() is :  " + ECServiceSwitch.isOpened());
        if (ECServiceSwitch.isOpened()) {
            long uniqueKey = DB.genGlobalLongId();
            for (Map<String, Object> param : rowList) {
                param.put("uniquekey", uniqueKey);
            }
            CommonParam param = new CommonParam();
            param.put((Object)"list", rowList);
            List<Object> arApBillIds = rowList.stream().filter(row -> row.get("ArApBillId") != null).map(row -> row.get("ArApBillId")).distinct().collect(Collectors.toList());
            logger.info("writeBackScpoOrderPayPlanAmt-maybe-lock-billid: " + arApBillIds);
            ECServiceHelper.beginAndRegisterWithBusInfo("pay_wbplanamount", null, "scmc", "sctm", "WbPayPlanPayAmount4SctmService", (Param)param, "", arApBillIds);
        }
    }

    public static void writeBackScpoOrderOtherAmt(List<Map<String, Object>> rowList, boolean settle) {
        if (EmptyUtils.isEmpty(rowList)) {
            return;
        }
        logger.info("writeBackScpoOrderOtherAmt.isSettleWbOrderAndConOpened() is :  " + ECServiceSwitch.isOpened());
        if (ECServiceSwitch.isOpened()) {
            long uniqueKey = DB.genGlobalLongId();
            for (Map<String, Object> param : rowList) {
                param.put("uniquekey", uniqueKey);
            }
            CommonParam param = new CommonParam();
            param.put((Object)"list", rowList);
            param.put((Object)"settleRelation", rowList.get(0).get("settleRelation"));
            List<Object> arApBillIds = rowList.stream().filter(row -> row.get("ArApBillId") != null).map(row -> row.get("ArApBillId")).distinct().collect(Collectors.toList());
            logger.info("writeBackScpoOrderOtherAmt-maybe-lock-billid: " + arApBillIds);
            ECServiceHelper.beginAndRegisterWithBusInfo("ap_settle", "ap_settle_wbscpoorder", "scmc", "sctm", "WbPayAmount4SctmService", (Param)param, "", arApBillIds);
        }
    }

    public static void writeBackContractBillEntry(List<Map<String, Object>> rowList, boolean settle) {
        if (EmptyUtils.isEmpty(rowList)) {
            return;
        }
        logger.info("writeBackContractBillEntry.isSettleWbOrderAndConOpened() is :  " + ECServiceHelper.isSettleWbOrderAndConOpened());
        if (ECServiceHelper.isSettleWbOrderAndConOpened()) {
            long uniqueKey = DB.genGlobalLongId();
            for (Map<String, Object> param : rowList) {
                param.put("uniquekey", uniqueKey);
            }
            CommonParam param = new CommonParam();
            param.put((Object)"list", rowList);
            param.put((Object)"method", (Object)"wbPurContAp");
            List<Object> arApBillIds = rowList.stream().filter(row -> row.get("ArApBillId") != null).map(row -> row.get("ArApBillId")).distinct().collect(Collectors.toList());
            logger.info("writeBackContractBillEntry-maybe-lock-billid: " + arApBillIds);
            ECServiceHelper.beginAndRegisterWithBusInfo("ap_settle", "ap_settle_wbconm", "scmc", "conm", "PurConmService", (Param)param, "", arApBillIds);
        } else {
            try (TXHandle tx = TX.requiresNew((String)"writeBackContractBillEntry");){
                try {
                    DispatchServiceHelper.invokeBizService((String)"scmc", (String)"conm", (String)"PurConmService", (String)"wbPurContAp", (Object[])new Object[]{rowList});
                }
                catch (Exception e) {
                    logger.info("writeBackContractBillEntry use ordinary interface , " + e.getMessage());
                    tx.markRollback();
                    throw e;
                }
            }
        }
    }

    public static void writeBackContractOtherAmt(List<Map<String, Object>> rowList, boolean settle) {
        if (EmptyUtils.isEmpty(rowList)) {
            return;
        }
        logger.info("writeBackContractOtherAmt.isSettleWbOrderAndConOpened() is :  " + ECServiceSwitch.isOpened());
        if (ECServiceSwitch.isOpened()) {
            long uniqueKey = DB.genGlobalLongId();
            for (Map<String, Object> param : rowList) {
                param.put("uniquekey", uniqueKey);
            }
            CommonParam param = new CommonParam();
            param.put((Object)"list", rowList);
            param.put((Object)"method", (Object)"wbPurContAmount");
            param.put((Object)"settleRelation", rowList.get(0).get("settleRelation"));
            List<Object> arApBillIds = rowList.stream().filter(row -> row.get("ArApBillId") != null).map(row -> row.get("ArApBillId")).distinct().collect(Collectors.toList());
            logger.info("writeBackContractOtherAmt-maybe-lock-billid: " + arApBillIds);
            if ("pre_pay_writeback".equals(rowList.get(0).get("scene"))) {
                ECServiceHelper.beginAndRegisterWithBusInfo("pay_wbconamount", null, "scmc", "conm", "PurConmService", (Param)param, "", arApBillIds);
            } else {
                ECServiceHelper.beginAndRegisterWithBusInfo("ap_settle", "ap_settle_wbconm", "scmc", "conm", "PurConmService", (Param)param, "", arApBillIds);
            }
        }
    }

    public static void writeBackSalOrderRecAmt(List<Map<String, Object>> rowList, boolean settle) {
        if (EmptyUtils.isEmpty(rowList)) {
            return;
        }
        logger.info("writeBackSalOrderRecAmt.isSettleWbOrderAndConOpened() is :  " + ECServiceHelper.isSettleWbOrderAndConOpened());
        Map<Integer, List<Map<String, Object>>> groupListMap = Settle4ScmcHelper.groupListBySeq(rowList);
        for (Map.Entry<Integer, List<Map<String, Object>>> map : groupListMap.entrySet()) {
            Integer seq = map.getKey();
            List<Map<String, Object>> list = map.getValue();
            logger.info("writeBackSalOrderRecAmt - groupListMap.size is : " + groupListMap.size() + " current Seq is" + seq);
            if (ECServiceHelper.isSettleWbOrderAndConOpened()) {
                Settle4ScmcHelper.writeBackSalOrderRecAmtEC(list);
                continue;
            }
            Settle4ScmcHelper.writeBackSalOrderRecAmtTX(list);
        }
    }

    private static void writeBackSalOrderRecAmtEC(List<Map<String, Object>> list) {
        long uniqueKey = DB.genGlobalLongId();
        for (Map<String, Object> param : list) {
            param.put("uniquekey", uniqueKey);
        }
        CommonParam param = new CommonParam();
        param.put((Object)"list", list);
        param.put((Object)"method", (Object)"wbSOAmount");
        List<Object> arApBillIds = list.stream().filter(row -> row.get("ArApBillId") != null).map(row -> row.get("ArApBillId")).distinct().collect(Collectors.toList());
        logger.info("writeBackSalOrderRecAmt-maybe-lock-billid: " + arApBillIds);
        ECServiceHelper.beginAndRegisterWithBusInfo("ar_settle", "ar_settle_wborder", "scmc", "sm", "SalWbService", (Param)param, "", arApBillIds);
    }

    private static void writeBackSalOrderRecAmtTX(List<Map<String, Object>> list) {
        try (TXHandle tx = TX.requiresNew((String)"writeBackSalOrderRecAmt");){
            try {
                DispatchServiceHelper.invokeBizService((String)"scmc", (String)"sm", (String)"SalWbService", (String)"wbSOAmount", (Object[])new Object[]{list});
            }
            catch (Exception e) {
                logger.info("writeBackSalOrderRecAmt use ordinary interface , " + e.getMessage());
                tx.markRollback();
                throw e;
            }
        }
    }

    public static void writeBackSalConRecAmt(List<Map<String, Object>> rowList, boolean settle) {
        if (EmptyUtils.isEmpty(rowList)) {
            return;
        }
        logger.info("writeBackSalConRecAmt.isSettleWbOrderAndConOpened() is :  " + ECServiceHelper.isSettleWbOrderAndConOpened());
        if (ECServiceHelper.isSettleWbOrderAndConOpened()) {
            long uniqueKey = DB.genGlobalLongId();
            for (Map<String, Object> param : rowList) {
                param.put("uniquekey", uniqueKey);
            }
            CommonParam param = new CommonParam();
            param.put((Object)"list", rowList);
            param.put((Object)"method", (Object)"wbSalContAmount");
            List<Object> arApBillIds = rowList.stream().filter(row -> row.get("ArApBillId") != null).map(row -> row.get("ArApBillId")).distinct().collect(Collectors.toList());
            logger.info("writeBackSalConRecAmt-maybe-lock-billid: " + arApBillIds);
            ECServiceHelper.beginAndRegisterWithBusInfo("ar_settle", "ar_settle_wbconm", "scmc", "conm", "SalConmService", (Param)param, "", arApBillIds);
        } else {
            try (TXHandle tx = TX.requiresNew((String)"writeBackSalConRecAmt");){
                try {
                    DispatchServiceHelper.invokeBizService((String)"scmc", (String)"conm", (String)"SalConmService", (String)"wbSalContAmount", (Object[])new Object[]{rowList});
                }
                catch (Exception e) {
                    logger.info("writeBackSalConRecAmt use ordinary interface , " + e.getMessage());
                    tx.markRollback();
                    throw e;
                }
            }
        }
    }

    public static void writeBackSalOrderOrContract(List<Map<String, Object>> paramList, boolean settle) {
        logger.info("writeBackSalOrderOrContract in ");
        if (EmptyUtils.isEmpty(paramList)) {
            return;
        }
        try (TXHandle tx = TX.required((String)"writeBackSalOrderOrContract");){
            try {
                ArrayList<Map<String, Object>> salOrderSettleParamList = new ArrayList<Map<String, Object>>(64);
                ArrayList<Map<String, Object>> salConmSettleParamList = new ArrayList<Map<String, Object>>(64);
                String settleRelation = "";
                for (Map<String, Object> param : paramList) {
                    Object coreBillType = param.get("arMainBillEntity");
                    if (ObjectUtils.isEmpty((Object)coreBillType)) continue;
                    if ("sm_salorder".equals(coreBillType)) {
                        salOrderSettleParamList.add(param);
                        salConmSettleParamList.add(param);
                    }
                    if ("conm_salcontract".equals(coreBillType)) {
                        salConmSettleParamList.add(param);
                    }
                    settleRelation = String.valueOf(param.get("settleRelation"));
                }
                if (!salOrderSettleParamList.isEmpty()) {
                    if (SettleRelationEnum.ARSELF.getValue().equals(settleRelation)) {
                        Settle4ScmcHelper.disposeArToSalOrder(salOrderSettleParamList, settle);
                    } else {
                        Settle4ScmcHelper.writeBackSalOrderRecAmt(salOrderSettleParamList, settle);
                    }
                }
                if (!salConmSettleParamList.isEmpty()) {
                    if (SettleRelationEnum.ARSELF.getValue().equals(settleRelation)) {
                        Settle4ScmcHelper.disposeSaleCont(salConmSettleParamList, settle);
                    } else {
                        Settle4ScmcHelper.writeBackSalConRecAmt(salConmSettleParamList, settle);
                    }
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage());
                tx.markRollback();
                throw e;
            }
        }
    }

    public static void writeBackPurOrderOrContract(List<Map<String, Object>> paramList, boolean settle) {
        logger.info("writeBackPurOrderOrContract - in ");
        if (EmptyUtils.isEmpty(paramList)) {
            return;
        }
        try (TXHandle tx = TX.required((String)"writeBackPurOrderOrContract");){
            try {
                ArrayList<Map<String, Object>> purOrderSettleParamList = new ArrayList<Map<String, Object>>(64);
                ArrayList<Map<String, Object>> purOrderPrePayParamList = new ArrayList<Map<String, Object>>(64);
                ArrayList<Map<String, Object>> purConmSettleParamList = new ArrayList<Map<String, Object>>(64);
                ArrayList<Map<String, Object>> scpoOrderSettleParamList = new ArrayList<Map<String, Object>>(64);
                ArrayList<Map<String, Object>> scpoOrderPrePayParamList = new ArrayList<Map<String, Object>>(64);
                String settleRelation = "";
                for (Map<String, Object> param : paramList) {
                    Object coreBillType = EmptyUtils.isNotEmpty(param.get("mainBillEntity")) ? param.get("mainBillEntity") : param.get("mainbillentity");
                    coreBillType = EmptyUtils.isNotEmpty(coreBillType) ? coreBillType : param.get("apMainBillEntity");
                    coreBillType = EmptyUtils.isNotEmpty(coreBillType) ? coreBillType : param.get("apbill_mainbillentity");
                    Object object = coreBillType = EmptyUtils.isNotEmpty(coreBillType) ? coreBillType : param.get("paybill_mainbillentity");
                    if ("pre_pay_writeback".equals(param.get("scene"))) {
                        if ("pm_purorderbill".equals(coreBillType)) {
                            purOrderPrePayParamList.add(param);
                            purConmSettleParamList.add(param);
                        }
                        if ("conm_purcontract".equals(coreBillType)) {
                            purConmSettleParamList.add(param);
                        }
                        if (!"sctm_scpo".equals(coreBillType)) continue;
                        scpoOrderPrePayParamList.add(param);
                        continue;
                    }
                    if ("pm_purorderbill".equals(coreBillType)) {
                        purOrderSettleParamList.add(param);
                        purConmSettleParamList.add(param);
                    }
                    if ("conm_purcontract".equals(coreBillType)) {
                        purConmSettleParamList.add(param);
                    }
                    if ("sctm_scpo".equals(coreBillType)) {
                        scpoOrderSettleParamList.add(param);
                    }
                    settleRelation = String.valueOf(param.get("settleRelation"));
                }
                if (!purOrderPrePayParamList.isEmpty()) {
                    Settle4ScmcHelper.writeBackPmOrderPayPlanAmt(purOrderPrePayParamList);
                }
                if (!scpoOrderPrePayParamList.isEmpty()) {
                    Settle4ScmcHelper.writeBackScpoOrderPayPlanAmt(scpoOrderPrePayParamList);
                }
                if (!purOrderSettleParamList.isEmpty()) {
                    if (SettleRelationEnum.APSELF.getValue().equals(settleRelation)) {
                        Settle4ScmcHelper.writeBackPmOrderBillEntry(purOrderSettleParamList, settle);
                    } else {
                        Settle4ScmcHelper.writeBackPmOrderOtherAmt(purOrderSettleParamList, settle);
                    }
                }
                if (!scpoOrderSettleParamList.isEmpty()) {
                    if (SettleRelationEnum.APSELF.getValue().equals(settleRelation)) {
                        Settle4ScmcHelper.writeBackScpoOrderBillEntry(scpoOrderSettleParamList, settle);
                    } else {
                        Settle4ScmcHelper.writeBackScpoOrderOtherAmt(scpoOrderSettleParamList, settle);
                    }
                }
                if (!purConmSettleParamList.isEmpty()) {
                    if (SettleRelationEnum.APSELF.getValue().equals(settleRelation)) {
                        Settle4ScmcHelper.writeBackContractBillEntry(purConmSettleParamList, settle);
                    } else {
                        Settle4ScmcHelper.writeBackContractOtherAmt(purConmSettleParamList, settle);
                    }
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage());
                tx.markRollback();
                throw e;
            }
        }
    }

    public static void disposeArToSalOrder(List<Map<String, Object>> params, boolean settle) {
        if (params.size() > 0) {
            if (ECServiceHelper.isSettleWbOrderAndConOpened()) {
                long uniqueKey = DB.genGlobalLongId();
                for (Map<String, Object> dispose : params) {
                    dispose.put("uniquekey", uniqueKey);
                }
                logger.info("disposeArToSalOrder-consistency-true");
                CommonParam param = new CommonParam();
                param.put((Object)"list", params);
                param.put((Object)"method", (Object)"wbSOAr");
                List<Object> arApBillIds = params.stream().filter(row -> row.get("ArApBillId") != null).map(row -> row.get("ArApBillId")).distinct().collect(Collectors.toList());
                logger.info("disposeArToSalOrder-maybe-lock-billid: " + arApBillIds);
                ECServiceHelper.beginAndRegisterWithBusInfo("ar_settle", "ar_settle_wborder", "scmc", "sm", "SalWbService", (Param)param, "", arApBillIds);
            } else {
                try (TXHandle tx = TX.requiresNew((String)"settleinvokeScmc");){
                    try {
                        DispatchServiceHelper.invokeBizService((String)"scmc", (String)"sm", (String)"SalWbService", (String)"wbSOAr", (Object[])new Object[]{params});
                    }
                    catch (Exception e) {
                        tx.markRollback();
                        throw e;
                    }
                }
            }
        }
    }

    public static void disposeArRevcfmToSalOrder(List<Map<String, Object>> params) {
        if (params.size() > 0) {
            if (ECServiceHelper.isSettleWbOrderAndConOpened()) {
                long uniqueKey = DB.genGlobalLongId();
                for (Map<String, Object> dispose : params) {
                    dispose.put("uniquekey", uniqueKey);
                }
                logger.info("disposeArRevcfmToSalOrder-consistency-true");
                CommonParam param = new CommonParam();
                param.put((Object)"list", params);
                param.put((Object)"method", (Object)"wbSORevCfm");
                List<Object> arApBillIds = params.stream().filter(row -> row.get("ArApBillId") != null).map(row -> row.get("ArApBillId")).distinct().collect(Collectors.toList());
                logger.info("disposeArRevcfmToSalOrder-maybe-lock-billid: " + arApBillIds);
                ECServiceHelper.beginAndRegisterWithBusInfo("ar_settle", "ar_settle_wborder", "scmc", "sm", "SalWbService", (Param)param, "", arApBillIds);
            } else {
                try (TXHandle tx = TX.requiresNew((String)"settleinvokeScmc");){
                    try {
                        DispatchServiceHelper.invokeBizService((String)"scmc", (String)"sm", (String)"SalWbService", (String)"wbSORevCfm", (Object[])new Object[]{params});
                    }
                    catch (Exception e) {
                        tx.markRollback();
                        throw e;
                    }
                }
            }
        }
    }

    public static void disposeSaleCont(List<Map<String, Object>> params, boolean settle) {
        if (params.size() > 0) {
            if (ECServiceHelper.isSettleWbOrderAndConOpened()) {
                long uniqueKey = DB.genGlobalLongId();
                for (Map<String, Object> dispose : params) {
                    dispose.put("uniquekey", uniqueKey);
                }
                logger.info("disposeSaleCont-consistency-true");
                CommonParam param = new CommonParam();
                param.put((Object)"list", params);
                param.put((Object)"method", (Object)"wbSalContAr");
                List<Object> arApBillIds = params.stream().filter(row -> row.get("ArApBillId") != null).map(row -> row.get("ArApBillId")).distinct().collect(Collectors.toList());
                logger.info("disposeSaleCont-maybe-lock-billid: " + arApBillIds);
                ECServiceHelper.beginAndRegisterWithBusInfo("ar_settle", "ar_settle_wbconm", "scmc", "conm", "SalConmService", (Param)param, "", arApBillIds);
            } else {
                try (TXHandle tx = TX.requiresNew((String)"settleinvokeScmc");){
                    try {
                        DispatchServiceHelper.invokeBizService((String)"scmc", (String)"conm", (String)"SalConmService", (String)"wbSalContAr", (Object[])new Object[]{params});
                    }
                    catch (Exception e) {
                        tx.markRollback();
                        throw e;
                    }
                }
            }
        }
    }

    public static Map<Integer, List<Map<String, Object>>> groupListBySeq(List<Map<String, Object>> rowList) {
        Integer seq = 1;
        HashMap<Integer, List<Map<String, Object>>> groupMap = new HashMap<Integer, List<Map<String, Object>>>(8);
        ArrayList<Map<String, Object>> groupList = new ArrayList<Map<String, Object>>(BATCH_SIZE);
        for (Map<String, Object> map : rowList) {
            groupList.add(map);
            if (groupList.size() != BATCH_SIZE) continue;
            ArrayList<Map<String, Object>> newList = new ArrayList<Map<String, Object>>(BATCH_SIZE);
            newList.addAll(groupList);
            groupMap.put(seq, newList);
            groupList.clear();
            Integer n = seq;
            Integer n2 = seq = Integer.valueOf(seq + 1);
        }
        if (!groupList.isEmpty()) {
            ArrayList<Map<String, Object>> newList = new ArrayList<Map<String, Object>>(groupList.size());
            newList.addAll(groupList);
            groupMap.put(seq, newList);
        }
        return groupMap;
    }

    public static void newWriteBackPurAndCon(List<SettleRecordVO> voList, DynamicObject[] wbAfterBills, SettleSchemeVO scheme, DynamicObject[] wbBeforeBills) {
        String settleRelation = ObjectUtils.isEmpty((Object)scheme.getSettleRelation()) ? voList.get(0).getSettleRela() : scheme.getSettleRelation();
        ICallOrderConInvoker callOrderConService = CallOrderConServiceFactory.getCallOrderConService(settleRelation);
        if (callOrderConService != null) {
            if (ObjectUtils.isEmpty((Object)scheme.getSettleRelation())) {
                scheme.setSettleRelation(settleRelation);
            }
            CallSCMCParam scmcParam = new CallSCMCParam();
            scmcParam.setScheme(scheme);
            scmcParam.setMain(voList.get(0).isMainVo());
            callOrderConService.initParam(scmcParam);
            callOrderConService.invoke(voList, wbAfterBills, wbBeforeBills);
        }
    }
}

