/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.helper.ArApXDBHelper;
import kd.fi.arapcommon.util.StringUtils;

public class SettleRecordQueryHelper {
    public static boolean isExistsSettlesByMain(String settleRecordEntity, String entityKey, Object[] ids, QFilter otherFilter) {
        QFilter filter = new QFilter("mainbillid", "in", (Object)ids);
        filter.and(otherFilter);
        DynamicObject[] settleBills = SettleRecordQueryHelper.getSettleRecords(settleRecordEntity, "id", entityKey, ids, filter);
        return settleBills.length > 0;
    }

    public static boolean isExistsSettlesByAsst(String settleRecordEntity, String entityKey, Object[] ids, QFilter otherFilter) {
        QFilter filter = new QFilter("entry.billid", "in", (Object)ids);
        filter.and(otherFilter);
        DynamicObject[] settleBills = SettleRecordQueryHelper.getSettleRecords(settleRecordEntity, "id", entityKey, ids, filter);
        return settleBills.length > 0;
    }

    public static List<Long> getSettleIdsByMain(String settleRecordEntity, String entityKey, Object[] ids) {
        QFilter filter = new QFilter("mainbillid", "in", (Object)ids);
        DynamicObject[] settleBills = SettleRecordQueryHelper.getSettleRecords(settleRecordEntity, "id", entityKey, ids, filter);
        List<Long> mainSettleIds = Arrays.stream(settleBills).map(bill -> bill.getLong("id")).collect(Collectors.toList());
        return mainSettleIds;
    }

    public static List<Long> getSettleIdsByAsst(String settleRecordEntity, String entityKey, Object[] ids) {
        QFilter filter = new QFilter("entry.billid", "in", (Object)ids);
        DynamicObject[] settleBills = SettleRecordQueryHelper.getSettleRecords(settleRecordEntity, "id", entityKey, ids, filter);
        List<Long> asstSettleIds = Arrays.stream(settleBills).map(bill -> bill.getLong("id")).collect(Collectors.toList());
        return asstSettleIds;
    }

    public static List<Long> getBillIdsHadSettlesByMain(String settleRecordEntity, String entityKey, Object[] ids) {
        QFilter filter = new QFilter("mainbillid", "in", (Object)ids);
        DynamicObject[] settleBills = SettleRecordQueryHelper.getSettleRecords(settleRecordEntity, "id,mainbillid", entityKey, ids, filter);
        List<Long> billIds = Arrays.stream(settleBills).map(bill -> bill.getLong("mainbillid")).collect(Collectors.toList());
        return billIds;
    }

    public static List<Long> getBillIdsHadSettlesByAsst(String settleRecordEntity, String entityKey, Object[] ids) {
        DynamicObject[] settleBills;
        ArrayList<Long> billIds = new ArrayList<Long>(8);
        QFilter filter = new QFilter("entry.billid", "in", (Object)ids);
        for (DynamicObject settlInfo : settleBills = SettleRecordQueryHelper.getSettleRecords(settleRecordEntity, "id,entry.billid", entityKey, ids, filter)) {
            DynamicObjectCollection entryCol = settlInfo.getDynamicObjectCollection("entry");
            List entryBillIds = entryCol.stream().map(entry -> entry.getLong("billid")).collect(Collectors.toList());
            billIds.addAll(entryBillIds);
        }
        return billIds;
    }

    public static DynamicObject[] getSettleRecords(String settleRecordEntity, String selector, String entityKey, Object[] ids, QFilter filter) {
        boolean isSharding = ArApXDBHelper.isSharding("t_ap_settlerecord");
        if (isSharding && !StringUtils.isEmpty(entityKey)) {
            String selectFields = null;
            selectFields = "cas_recbill".equals(entityKey) ? "entry.e_settleorg orgId" : ("cas_paybill".equals(entityKey) ? "entry.settleorg orgId" : "org orgId");
            DataSet billDataSet = QueryServiceHelper.queryDataSet((String)"ArApXDBHelperGetSettlesOrg", (String)entityKey, (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids)}, null);
            HashSet<Long> orgIds = new HashSet<Long>(8);
            for (Row row : billDataSet) {
                orgIds.add(row.getLong("orgId"));
            }
            if (orgIds.size() > 0) {
                QFilter orgFilter = new QFilter("org", "in", orgIds);
                filter.and(orgFilter);
            }
        }
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)settleRecordEntity, (String)selector, (QFilter[])filter.toArray());
        return bills;
    }
}

