/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.helper;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.intertax.TaxService;

public class TaxentryImportHelper {
    public static JSONArray checkTaxentry(Map<String, Object> data, JSONObject row, int seq, String customerType) {
        JSONObject material = (JSONObject)row.get((Object)"e_material");
        JSONArray taxRowColls = null;
        BigDecimal taxrate = new BigDecimal(0);
        if (material == null) {
            material = (JSONObject)row.get((Object)"material");
        }
        if ((taxRowColls = (JSONArray)row.get((Object)"subentryentity")) != null && taxRowColls.size() > 0) {
            for (int subseq = 0; subseq < taxRowColls.size(); ++subseq) {
                JSONObject subrow = (JSONObject)taxRowColls.get(subseq);
                JSONObject tax = (JSONObject)subrow.get((Object)"s_taxrateid");
                if (tax == null) continue;
                String taxNum = tax.getString("number");
                String s_taxrate = subrow.getString("s_taxrate");
                try {
                    taxrate = new BigDecimal(s_taxrate).setScale(2, RoundingMode.HALF_DOWN);
                }
                catch (Exception e) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5355\u636e\u4f53\u4e2d\u7a0e\u7387\u4fe1\u606f\u586b\u5199\u9519\u8bef\u3002", (String)"TaxentryImportHelper_0", (String)"fi-arapcommon", (Object[])new Object[0]), seq + 1));
                }
                QFilter[] filter2 = new QFilter[]{new QFilter("number", "=", (Object)taxNum)};
                DynamicObject obj2 = BusinessDataServiceHelper.loadSingleFromCache((String)"gte_tax_rate", (String)"id,number,name", (QFilter[])filter2);
                long pkValue = (Long)obj2.getPkValue();
                List<Map<String, Object>> rate = TaxService.query("rate", pkValue);
                if (rate == null || rate.size() <= 0) continue;
                for (Map<String, Object> map : rate) {
                    BigDecimal gte_taxrate = (BigDecimal)map.get("taxrate");
                    if (gte_taxrate.setScale(2, RoundingMode.HALF_DOWN).compareTo(taxrate) == 0) continue;
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5355\u636e\u4f53\u4e2d\u7a0e\u7801\u7a0e\u7387\u4fe1\u606f\u586b\u5199\u9519\u8bef\u3002", (String)"TaxentryImportHelper_1", (String)"fi-arapcommon", (Object[])new Object[0]), seq + 1));
                }
            }
        }
        return taxRowColls;
    }

    public static BigDecimal computationTax(JSONArray taxRowColls, int priceprecision, JSONObject row, BigDecimal actunitprice, BigDecimal discountamount, int amtprecision) throws Exception {
        BigDecimal ONE_HUNDRED = new BigDecimal("100");
        BigDecimal one = new BigDecimal(1);
        BigDecimal includetax = new BigDecimal(0);
        BigDecimal noincludetax = new BigDecimal(0);
        BigDecimal s_taxbase = new BigDecimal(0);
        BigDecimal tax = new BigDecimal(0);
        BigDecimal unitprice = new BigDecimal(0);
        BigDecimal s_taxctrlamt = new BigDecimal(0);
        BigDecimal quantity = TaxentryImportHelper.getEntryBigDecimal(row, "e_quantity");
        int compare = quantity.compareTo(BigDecimal.ZERO);
        if (compare == 0 || compare < 0) {
            quantity = TaxentryImportHelper.getEntryBigDecimal(row, "quantity");
        }
        if (taxRowColls != null && taxRowColls.size() > 0) {
            for (int subseq = 0; subseq < taxRowColls.size(); ++subseq) {
                JSONObject subrow = (JSONObject)taxRowColls.get(subseq);
                JSONObject taxrateid = (JSONObject)subrow.get((Object)"s_taxrateid");
                if (taxrateid == null) continue;
                BigDecimal taxrate = subrow.getBigDecimal("s_taxrate");
                String taxNum = taxrateid.getString("number");
                BigDecimal taxr = taxrate.divide(ONE_HUNDRED).setScale(priceprecision, RoundingMode.HALF_DOWN);
                Boolean includediscountFlag = subrow.getBoolean("s_includediscount");
                if (includediscountFlag == null) {
                    includediscountFlag = Boolean.FALSE;
                }
                BigDecimal taxassessamt = subrow.getBigDecimal("s_taxassessamt");
                QFilter[] filter2 = new QFilter[]{new QFilter("number", "=", (Object)taxNum)};
                DynamicObject obj2 = BusinessDataServiceHelper.loadSingleFromCache((String)"gte_tax_rate", (String)"id,number,name", (QFilter[])filter2);
                long taxratePk = (Long)obj2.getPkValue();
                List<Map<String, Object>> rate = TaxService.query("rate", taxratePk);
                if (rate == null || rate.size() <= 0) continue;
                for (Map<String, Object> map : rate) {
                    String taxclassname = (String)map.get("taxclassname");
                    HashMap<String, String> taxcategoryMap = new HashMap<String, String>();
                    taxcategoryMap.put("importprop", "name");
                    taxcategoryMap.put("name", taxclassname);
                    subrow.put("s_taxcategory", (Object)new JSONObject(taxcategoryMap));
                    String dkssd = (String)map.get("dkssd");
                    subrow.put("s_taxtime", (Object)dkssd);
                    Boolean includingvat = (Boolean)map.get("includingvat");
                    subrow.put("s_includevat", (Object)includingvat);
                    Boolean includetaxFlag = (Boolean)map.get("includetax");
                    subrow.put("s_isinpricetax", (Object)includetaxFlag);
                    Boolean allowdeduct = (Boolean)map.get("allowdeduct");
                    subrow.put("s_candeductible", (Object)allowdeduct);
                    String taxbasetype = (String)map.get("taxbasetype");
                    subrow.put("s_taxbasetype", (Object)taxbasetype);
                    unitprice = TaxentryImportHelper.getEntryBigDecimal(row, "e_unitprice").setScale(priceprecision, RoundingMode.HALF_DOWN);
                    int compareTo = unitprice.compareTo(BigDecimal.ZERO);
                    if (compareTo == 0 || compareTo < 0) {
                        unitprice = TaxentryImportHelper.getEntryBigDecimal(row, "price").setScale(priceprecision, RoundingMode.HALF_DOWN);
                    }
                    BigDecimal taxTemp = one.add(taxr);
                    if (includetaxFlag.booleanValue()) {
                        noincludetax = unitprice.divide(taxTemp, 2, RoundingMode.HALF_DOWN);
                        includetax = unitprice;
                    } else {
                        includetax = taxrate.multiply(taxTemp).setScale(priceprecision, RoundingMode.HALF_DOWN);
                        noincludetax = unitprice;
                    }
                    s_taxbase = "1".equals(taxbasetype) ? quantity.multiply(includetax).setScale(priceprecision, RoundingMode.HALF_DOWN) : quantity.multiply(noincludetax).setScale(priceprecision, RoundingMode.HALF_DOWN);
                    if (includediscountFlag.booleanValue()) {
                        s_taxbase = s_taxbase.subtract(discountamount);
                    }
                    subrow.put("s_taxbase", (Object)s_taxbase);
                    if (null == taxassessamt) {
                        taxassessamt = s_taxbase;
                    }
                    BigDecimal taxrateSub = taxrate.divide(ONE_HUNDRED);
                    BigDecimal multiply = taxassessamt.multiply(taxrateSub).setScale(priceprecision, RoundingMode.HALF_DOWN);
                    BigDecimal s_tax = multiply.setScale(amtprecision, RoundingMode.HALF_DOWN);
                    String taxcalsstype = (String)map.get("taxcalsstype");
                    if ("2".equals(taxcalsstype)) {
                        s_tax = s_tax.negate();
                    }
                    subrow.put("s_tax", (Object)s_tax);
                    s_taxctrlamt = subrow.getBigDecimal("s_taxctrlamt");
                    if (s_taxctrlamt == null) {
                        s_taxctrlamt = s_tax;
                    }
                    subrow.put("s_taxctrlamt", (Object)s_taxctrlamt);
                    tax = tax.add(s_taxctrlamt);
                    BigDecimal deductrate = (BigDecimal)map.get("deductrate");
                    subrow.put("s_deductionrate", (Object)deductrate);
                    if (deductrate == null) continue;
                    BigDecimal deductrateHundred = deductrate.divide(ONE_HUNDRED);
                    BigDecimal deductible = s_taxctrlamt.multiply(deductrateHundred).setScale(priceprecision, RoundingMode.HALF_DOWN);
                    subrow.put("s_deductible", (Object)deductible);
                    BigDecimal nondeductible = s_taxctrlamt.subtract(deductible).setScale(priceprecision, RoundingMode.HALF_DOWN);
                    subrow.put("s_nondeductible", (Object)nondeductible);
                }
            }
        }
        return tax;
    }

    protected static BigDecimal getEntryBigDecimal(JSONObject row, String key) {
        Object value = row.get((Object)key);
        if (value == null) {
            return BigDecimal.ZERO;
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        return new BigDecimal(value.toString());
    }
}

