/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.impt;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.enums.BillSrcTypeEnum;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.impt.IBillImport;
import kd.fi.arapcommon.model.BillModel;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.StdConfig;

public abstract class AbstractBillImport
implements IBillImport {
    protected IFormView view;
    protected IDataModel model;
    protected IPageCache pageCache;
    protected BillModel billModel;
    protected boolean isExcel;
    protected InitHelper init;
    protected Map<Long, InitHelper> initMap = new HashMap<Long, InitHelper>(8);
    protected boolean isCanImport;
    protected Map<Long, Date> cacheDateMap = new HashMap<Long, Date>(8);
    protected Map<String, Map<String, DynamicObject>> cachedF7 = new HashMap<String, Map<String, DynamicObject>>();

    @Override
    public void initImportData(InitImportDataEventArgs e) {
        this.pageCache.put("isWebApi", "true");
        this.isCanImport = this.isCanImport();
        List dataList = e.getSourceDataList();
        for (Map list : dataList) {
            if (list.containsKey("billsrctype")) continue;
            list.put("billsrctype", BillSrcTypeEnum.IMPORT.getValue());
        }
    }

    @Override
    public void beforeImportData(BeforeImportDataEventArgs e) {
    }

    @Override
    public void afterImportData(ImportDataEventArgs e) {
    }

    protected void checkNull(String key, String title, Map data) {
        if (data.get(key) == null || data.get(key) == "") {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractBillImport_0", (String)"fi-arapcommon", (Object[])new Object[0]), title));
        }
    }

    protected void removeNoAssignField(Map data, String[] fields) {
        if (this.isCanImport) {
            return;
        }
        for (String field : fields) {
            data.remove(field);
        }
    }

    protected void removeNoAssignField(Map data, List<String> fields) {
        if (this.isCanImport) {
            return;
        }
        for (int i = 0; i < fields.size(); ++i) {
            if (!data.containsKey(fields.get(i))) continue;
            data.remove(fields.get(i));
        }
    }

    protected boolean checkExist(String entityName, JSONObject itemValue, String cacheKey) {
        QFilter[] filters;
        String number;
        String name = "bd_operator".equals(entityName) ? itemValue.getString("operatorname") : itemValue.getString("name");
        String string = number = "bd_operator".equals(entityName) ? itemValue.getString("operatornumber") : itemValue.getString("number");
        if (EmptyUtils.isEmpty(name) && EmptyUtils.isEmpty(number)) {
            return false;
        }
        Optional<DynamicObject> cacheResultOptional = this.getDynamicObjectFromCache(cacheKey, number);
        if (cacheResultOptional.isPresent()) {
            return true;
        }
        String properties = "bd_operator".equals(entityName) ? "id,operatornumber,operatorname" : "id,number,name";
        Optional<DynamicObject> dbResultOptional = this.getDynamicObjectFromDb(entityName, properties, filters = this.getQFilter(entityName, name, number));
        if (!dbResultOptional.isPresent()) {
            return false;
        }
        String numberKey = "bd_operator".equals(entityName) ? "operatornumber" : "number";
        itemValue.put("number", (Object)dbResultOptional.get().getString(numberKey));
        this.cacheObject(cacheKey, dbResultOptional.get().getString(numberKey), dbResultOptional.get());
        return true;
    }

    protected void checkF7(String entityName, String key, String title, boolean required, JSONObject data) {
        JSONObject value = null;
        if (data.get((Object)key) != null) {
            value = new JSONObject((Map)data.get((Object)key));
        }
        if (required && value == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractBillImport_0", (String)"fi-arapcommon", (Object[])new Object[0]), title));
        }
        if (value != null && !this.checkExist(entityName, value, key)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u4fe1\u606f\u672a\u627e\u5230\u3002", (String)"AbstractBillImport_1", (String)"fi-arapcommon", (Object[])new Object[0]), title));
        }
    }

    protected Optional<DynamicObject> getDynamicObjectFromCache(String cacheKey, String itemKey) {
        Map<String, DynamicObject> cacheResult = this.cachedF7.get(cacheKey);
        if (CollectionUtils.isEmpty(cacheResult)) {
            return Optional.empty();
        }
        DynamicObject result = cacheResult.get(itemKey);
        return Optional.ofNullable(result);
    }

    protected QFilter[] getQFilter(String entityName, String name, String number) {
        String numberName;
        QFilter filters = null;
        String string = numberName = "bd_operator".equals(entityName) ? "operatornumber" : "number";
        if (!EmptyUtils.isEmpty(number)) {
            filters = new QFilter(numberName, "=", (Object)number);
        }
        if (!EmptyUtils.isEmpty(name)) {
            QFilter nameFilter = new QFilter("name", "=", (Object)name);
            if (filters == null) {
                return nameFilter.toArray();
            }
        }
        if (filters == null) {
            return new QFilter[0];
        }
        return filters.toArray();
    }

    protected Optional<DynamicObject> getDynamicObjectFromDb(String entityName, String properties, QFilter[] filters) {
        if (filters.length == 0) {
            return Optional.empty();
        }
        DynamicObject result = BusinessDataServiceHelper.loadSingleFromCache((String)entityName, (String)properties, (QFilter[])filters);
        return Optional.ofNullable(result);
    }

    protected void cacheObject(String cacheKey, String itemKey, DynamicObject target) {
        Map<String, DynamicObject> cacheResult = this.cachedF7.get(cacheKey);
        if (cacheResult == null) {
            cacheResult = new HashMap<String, DynamicObject>();
        }
        cacheResult.put(itemKey, target);
        this.cachedF7.put(cacheKey, cacheResult);
    }

    protected static BigDecimal getEntryBigDecimal(Map row, String key) {
        Object value = row.get(key);
        if (value == null) {
            return BigDecimal.ZERO;
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        return new BigDecimal(value.toString());
    }

    private boolean isCanImport() {
        String isCanImportFlag = StdConfig.get("isCanImport");
        return "true".equals(isCanImportFlag);
    }
}

