/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.impt;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.enums.BillSrcTypeEnum;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.helper.OrgHelper;
import kd.fi.arapcommon.util.StringUtils;

public abstract class BillImportPlugin
extends BatchImportPlugin {
    private static Log log = LogFactory.getLog(BillImportPlugin.class);
    protected String entityKey;
    private boolean isAr = false;

    public BillImportPlugin(boolean isAr) {
        this.isAr = isAr;
    }

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        this.entityKey = this.getBillFormId();
        HashMap<String, Boolean> orgMap = new HashMap<String, Boolean>();
        String appId = this.ctx.getCheckRightAppId();
        log.info("---appId----" + appId);
        List<Long> permOrgs = OrgHelper.getAuthorizedBankOrgIds(RequestContext.get().getCurrUserId(), appId, this.entityKey, "47156aff000000ac", "fisaccounting");
        log.info("----permOrgs----" + permOrgs);
        String entityName = this.mainEntityType.getDisplayName().getLocaleValue();
        IDataEntityProperty billTypeProp = this.mainEntityType.findProperty(((BillEntityType)this.mainEntityType).getBillType());
        Object[] objs = null;
        if (billTypeProp != null) {
            QFilter qFilter = new QFilter("billformid", "=", (Object)this.entityKey);
            Map objMap = BusinessDataServiceHelper.loadFromCache((String)"bos_billtype", (String)"id, number, name", (QFilter[])new QFilter[]{qFilter});
            objs = objMap.values().toArray(new DynamicObject[0]);
        }
        Iterator<ImportBillData> iterator = rowdatas.iterator();
        while (iterator.hasNext()) {
            ImportBillData rowdata = iterator.next();
            JSONObject data = rowdata.getData();
            Map orgData = (Map)data.get((Object)"org");
            String message = null;
            String orgNum = null;
            String orgName = null;
            if (!ObjectUtils.isEmpty((Object)orgData)) {
                orgNum = (String)orgData.get("number");
                orgName = (String)orgData.get("name");
            }
            boolean isAuth = false;
            if (StringUtils.isEmpty(orgNum) && StringUtils.isEmpty(orgName)) {
                message = ResManager.loadKDString((String)"\u8bf7\u8865\u5145\u7ed3\u7b97\u7ec4\u7ec7\u3002", (String)"BillImportPlugin_0", (String)"fi-arapcommon", (Object[])new Object[0]);
            } else {
                DynamicObject org = null;
                if (StringUtils.isEmpty(orgNum)) {
                    QFilter qFilter = new QFilter("name", "=", (Object)orgName);
                    org = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id, number, name", (QFilter[])new QFilter[]{qFilter});
                    if (ObjectUtils.isEmpty((Object)org)) {
                        message = String.format(ResManager.loadKDString((String)"\u3010\u7ed3\u7b97\u7ec4\u7ec7\u3011\u6570\u636e\u4e0d\u5b58\u5728\uff1a\u540d\u79f0\u201c%s\u201d", (String)"BillImportPlugin_1", (String)"fi-arapcommon", (Object[])new Object[0]), orgName);
                    } else {
                        orgNum = org.getString("number");
                    }
                }
                if (message == null) {
                    if (!orgMap.containsKey(orgNum)) {
                        message = this.checkMainOrg(orgNum, permOrgs, entityName, org);
                        isAuth = message == null;
                        orgMap.put(orgNum, isAuth);
                    } else {
                        isAuth = (Boolean)orgMap.get(orgNum);
                    }
                }
            }
            if (message == null && !ObjectUtils.isEmpty((Object[])objs)) {
                message = this.checkBillType(data.get((Object)billTypeProp.getName()), billTypeProp.getDisplayName().getLocaleValue(), entityName, (DynamicObject[])objs);
            }
            if (message == null) {
                message = this.bizCheck(data);
            }
            if (isAuth && message == null) {
                if (data.containsKey((Object)"billsrctype")) continue;
                data.put("billsrctype", (Object)BillSrcTypeEnum.IMPORT.getValue());
                continue;
            }
            logger.log(Integer.valueOf(rowdata.getStartIndex()), message).fail();
            iterator.remove();
        }
        return super.save(rowdatas, logger);
    }

    protected String checkBillType(Object value, String name, String entityName, DynamicObject[] objs) {
        String message = null;
        if (ObjectUtils.isEmpty((Object)value)) {
            message = String.format(ResManager.loadKDString((String)"\u8bf7\u8865\u5145\u201c%s\u201d\u3002", (String)"BillImportPlugin_2", (String)"fi-arapcommon", (Object[])new Object[0]), name);
            return message;
        }
        JSONObject vData = (JSONObject)value;
        String importprop = vData.getString("importprop");
        String propValue = vData.getString(importprop);
        if (StringUtils.isEmpty(propValue)) {
            message = String.format(ResManager.loadKDString((String)"\u8bf7\u8865\u5145\u201c%s\u201d\u3002", (String)"BillImportPlugin_2", (String)"fi-arapcommon", (Object[])new Object[0]), name);
        } else {
            List billTypes = null;
            billTypes = "name".equals(importprop) ? Stream.of(objs).map(b -> b.getLocaleString(importprop).getLocaleValue()).collect(Collectors.toList()) : Stream.of(objs).map(b -> b.getString(importprop)).collect(Collectors.toList());
            if (!billTypes.contains(propValue)) {
                message = String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u4e0d\u5b58\u5728%2$s\u7684%3$s\u3002", (String)"BillImportPlugin_3", (String)"fi-arapcommon", (Object[])new Object[0]), entityName, propValue, name);
            }
        }
        return message;
    }

    protected String checkMainOrg(String orgNum, List<Long> permOrgs, String entityName, DynamicObject org) {
        String message = null;
        if (org == null) {
            org = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id, number, name", (QFilter[])new QFilter("number", "=", (Object)orgNum).toArray());
        }
        if (ObjectUtils.isEmpty((Object)org)) {
            message = String.format(ResManager.loadKDString((String)"\u201c\u7ed3\u7b97\u7ec4\u7ec7\u201d\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u9519\u8bef\u7f16\u7801\uff1a%s\u3002", (String)"BillImportPlugin_4", (String)"fi-arapcommon", (Object[])new Object[0]), orgNum);
        } else {
            long orgPk = org.getLong("id");
            String orgName = org.getLocaleString("name").getLocaleValue();
            if (!permOrgs.contains(orgPk)) {
                message = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%1$s(%2$s)\u201d\uff0c\u6ca1\u6709\u201c%3$s\u201d\u7684\u65b0\u589e\u6743\u9650\u3002", (String)"BillImportPlugin_5", (String)"fi-arapcommon", (Object[])new Object[0]), orgName, orgNum, entityName);
            } else {
                InitHelper init = new InitHelper(orgPk, this.isAr ? "ar_init" : "ap_init");
                if (ObjectUtils.isEmpty((Object)init.getInitId())) {
                    message = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%1$s(%2$s)\u201d\uff0c\u6ca1\u6709\u8fdb\u884c\u521d\u59cb\u5316\u8bbe\u7f6e\u3002", (String)"BillImportPlugin_6", (String)"fi-arapcommon", (Object[])new Object[0]), orgName, orgNum);
                }
            }
        }
        return message;
    }

    protected String bizCheck(JSONObject data) {
        return null;
    }

    protected void checkNull(Object value, String name) {
        if (!this.isNull(value, name)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u8865\u5145\u201c%s\u201d\u3002", (String)"BillImportPlugin_2", (String)"fi-arapcommon", (Object[])new Object[0]), name));
        }
    }

    protected void checkEntryNull(Object value, String name, int seq) {
        if (!this.isNull(value, name)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7b2c%1$s\u884c\uff1a\u8bf7\u8865\u5145\u201c%2$s\u201d\u3002", (String)"BillImportPlugin_7", (String)"fi-arapcommon", (Object[])new Object[0]), seq, name));
        }
    }

    private boolean isNull(Object value, String name) {
        boolean notNull = false;
        if (!ObjectUtils.isEmpty((Object)value)) {
            if (value instanceof Map) {
                Map vData = (Map)value;
                String importprop = (String)vData.get("importprop");
                if (StringUtils.isNotEmpty(importprop) && StringUtils.isNotEmpty((String)vData.get(importprop))) {
                    notNull = true;
                } else {
                    String vNum = (String)vData.get("number");
                    String vName = (String)vData.get("name");
                    if (!StringUtils.isEmpty(vNum) || !StringUtils.isEmpty(vName)) {
                        notNull = true;
                    }
                }
            }
            if (value instanceof String) {
                notNull = true;
            }
            if (value instanceof BigDecimal) {
                notNull = true;
            }
            if (value instanceof Double) {
                notNull = true;
            }
        }
        return notNull;
    }

    protected void checkIsFx(boolean isFx, boolean isFxPriceTaxTotal) {
        if (isFx && isFxPriceTaxTotal) {
            throw new KDBizException(this.isAr ? ResManager.loadKDString((String)"\u5fae\u8c03\u91d1\u989d\u4e0e\u5fae\u8c03\u5e94\u6536\u91d1\u989d\u5f00\u5173\u4e0d\u53ef\u540c\u65f6\u6253\u5f00\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u5bfc\u5165\u3002", (String)"BillImportPlugin_8", (String)"fi-arapcommon", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5fae\u8c03\u91d1\u989d\u4e0e\u5fae\u8c03\u5e94\u4ed8\u91d1\u989d\u5f00\u5173\u4e0d\u53ef\u540c\u65f6\u6253\u5f00\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u5bfc\u5165\u3002", (String)"BillImportPlugin_9", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
    }

    protected String checkOperatorAndgroup(JSONObject data, String operatorFiled, String groupFiled) {
        DynamicObject operBill;
        String tipName = this.isAr ? ResManager.loadKDString((String)"\u9500\u552e", (String)"BillImportPlugin_12", (String)"fi-arapcommon", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u91c7\u8d2d", (String)"BillImportPlugin_13", (String)"fi-arapcommon", (Object[])new Object[0]);
        Map operator = (Map)data.get((Object)operatorFiled);
        Map operatorGroup = (Map)data.get((Object)groupFiled);
        if (operatorGroup != null) {
            String groupNumber = (String)operatorGroup.get("number");
            String groupName = (String)operatorGroup.get("name");
            if (StringUtils.isNotEmpty(groupNumber) || StringUtils.isNotEmpty(groupName)) {
                if (operator != null && (StringUtils.isNotEmpty((String)operator.get("operatornumber")) || StringUtils.isNotEmpty((String)operator.get("operatorname")))) {
                    operBill = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_operator", (String)"operatorgrpid,opergrpnumber,opergrpname", (QFilter[])new QFilter[]{this.getOperatoeFilter(operator, operatorGroup)});
                    boolean isNotMatch = false;
                    if (operBill != null) {
                        String opNumber = operBill.getString("opergrpnumber");
                        String opName = operBill.getString("opergrpname");
                        boolean bl = StringUtils.isNotEmpty(groupNumber) ? !groupNumber.equals(opNumber) : (isNotMatch = !groupName.equals(opName));
                    }
                    if (operBill == null || isNotMatch) {
                        return String.format(ResManager.loadKDString((String)"%1$s\u7ec4\u672a\u5728%2$s\u5458\u7684\u5173\u8054\u8303\u56f4\u5185\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BillImportPlugin_10", (String)"fi-arapcommon", (Object[])new Object[0]), tipName, tipName);
                    }
                } else {
                    return String.format(ResManager.loadKDString((String)"%1$s\u7ec4\u672a\u5728%2$s\u5458\u7684\u5173\u8054\u8303\u56f4\u5185\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BillImportPlugin_10", (String)"fi-arapcommon", (Object[])new Object[0]), tipName, tipName);
                }
            }
        }
        if (operator != null) {
            String operatorNumber = (String)operator.get("operatornumber");
            String operatorName = (String)operator.get("operatorname");
            if (StringUtils.isNotEmpty(operatorNumber) || StringUtils.isNotEmpty(operatorName)) {
                operBill = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_operator", (String)"operatorgrpid,opergrpnumber", (QFilter[])new QFilter[]{this.getOperatoeFilter(operator, operatorGroup)});
                if (operBill == null) {
                    return ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684%s\u5458\u3002", (String)"BillImportPlugin_11", (String)"fi-arapcommon", (Object[])new Object[]{tipName, tipName});
                }
                String grpId = operBill.getString("operatorgrpid");
                operator.put("id", operBill.getString("id"));
                data.put(operatorFiled, (Object)operator);
                if (operatorGroup != null) {
                    operatorGroup.put("id", grpId);
                } else {
                    JSONObject groupObj = new JSONObject();
                    groupObj.put("id", (Object)grpId);
                    groupObj.put("number", (Object)operBill.getString("opergrpnumber"));
                    operatorGroup = groupObj;
                }
                data.put(groupFiled, (Object)operatorGroup);
            }
        }
        return null;
    }

    private QFilter getOperatoeFilter(Map<String, String> operator, Map<String, String> operatorGroup) {
        String operatorNumber = operator.get("operatornumber");
        String operatorName = operator.get("operatorname");
        QFilter operNum = new QFilter("id", "!=", (Object)0);
        if (StringUtils.isNotEmpty(operatorNumber)) {
            operNum.and("operatornumber", "=", (Object)operatorNumber);
        }
        if (StringUtils.isNotEmpty(operatorName)) {
            operNum.and("operatorname", "=", (Object)operatorName);
        }
        if ("ap_busbill".equals(this.entityKey) || "ap_finapbill".equals(this.entityKey)) {
            operNum.and("opergrptype", "=", (Object)"CGZ");
        } else {
            operNum.and("opergrptype", "=", (Object)"XSZ");
        }
        if (operatorGroup != null) {
            String groupNumber = operatorGroup.get("number");
            String groupName = operatorGroup.get("name");
            if (StringUtils.isNotEmpty(groupNumber)) {
                operNum.and("opergrpnumber", "=", (Object)groupNumber);
            }
            if (StringUtils.isNotEmpty(groupName)) {
                operNum.and("opergrpname", "=", (Object)groupName);
            }
        }
        return operNum;
    }
}

