/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.init;

import com.alibaba.fastjson.JSONArray;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.operate.webapi.AbstractOperateWebApi;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.enums.BillStatusEnum;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.init.GlImportFactory;
import kd.fi.arapcommon.init.ISchemeImport;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.GLUtils;
import kd.fi.arapcommon.vo.BalanceQueryParam;

public class GlImportService {
    private static final Log logger = LogFactory.getLog(GlImportService.class);
    private static final String AR_GLIMPORTBILL = "ar_glimportbill";
    private final Long orgPk;
    private final DynamicObject init;
    private final DynamicObject accountBook;

    public GlImportService(boolean isAr, Long orgPk) {
        this.orgPk = orgPk;
        InitHelper initHelper = new InitHelper(orgPk, isAr ? "ar_init" : "ap_init");
        this.init = initHelper.getInit();
        this.accountBook = GLUtils.getAccountBook4Master(orgPk);
    }

    public Map<Long, List<String>> deleteInitBill(Set<Long> accountPks) {
        QFilter qFilter = new QFilter("org", "=", (Object)this.orgPk);
        QFilter acFilter = new QFilter("account", "in", accountPks);
        DynamicObjectCollection glimports = QueryServiceHelper.query((String)AR_GLIMPORTBILL, (String)"account,entitykey,billid", (QFilter[])new QFilter[]{qFilter, acFilter});
        Map<Long, List<String>> errAcctMap = this.getErrorAccountMap(glimports);
        if (!errAcctMap.isEmpty()) {
            accountPks.removeAll(errAcctMap.keySet());
        }
        if (!accountPks.isEmpty()) {
            Map billMap = glimports.stream().filter(acct -> accountPks.contains(acct.getLong("account"))).collect(Collectors.groupingBy(gl -> gl.getString("entitykey"), Collectors.mapping(acct -> acct.getLong("billid"), Collectors.toList())));
            if (!ObjectUtils.isEmpty(billMap)) {
                for (Map.Entry entryBill : billMap.entrySet()) {
                    this.doOperation(entryBill.getKey(), entryBill.getValue());
                }
            }
            DeleteServiceHelper.delete((String)AR_GLIMPORTBILL, (QFilter[])new QFilter[]{qFilter, acFilter});
        }
        return errAcctMap;
    }

    private Map<Long, List<String>> getErrorAccountMap(DynamicObjectCollection glimports) {
        HashMap<Long, List<String>> errAcctMap = new HashMap<Long, List<String>>(0);
        Map entityMap = glimports.stream().collect(Collectors.groupingBy(gl -> gl.getString("entitykey"), Collectors.mapping(acct -> acct, Collectors.toList())));
        QFilter cFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        for (Map.Entry entry : entityMap.entrySet()) {
            String entityKey = entry.getKey();
            List acctBills = entry.getValue();
            List billPks = acctBills.stream().map(bill -> bill.getLong("billid")).collect(Collectors.toList());
            QFilter pkFilter = new QFilter("id", "in", billPks);
            DynamicObjectCollection bills = QueryServiceHelper.query((String)entityKey, (String)"id, billno", (QFilter[])new QFilter[]{cFilter, pkFilter});
            if (ObjectUtils.isEmpty((Object)bills)) continue;
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityKey);
            Map<Long, String> map = bills.stream().collect(Collectors.toMap(b -> b.getLong("id"), b -> b.getString("billno")));
            for (DynamicObject acctBill : acctBills) {
                String billno;
                Long accountPk = acctBill.getLong("account");
                ArrayList<String> msgList = (ArrayList<String>)errAcctMap.get(accountPk);
                if (msgList == null) {
                    msgList = new ArrayList<String>(0);
                }
                if ((billno = map.get(acctBill.getLong("billid"))) != null) {
                    String msg = String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\u3002\u76f8\u540c\u79d1\u76ee\u4e0b\u5b58\u5728\u5355\u636e\u7f16\u53f7%1$s\u7684\u671f\u521d%2$s\uff0c\u7531\u4e8e\u5df2\u5ba1\u6838\u800c\u65e0\u6cd5\u5220\u9664\u3002", (String)"GlImportService_3", (String)"fi-arapcommon", (Object[])new Object[0]), billno, mainType.getDisplayName().getLocaleValue());
                    msgList.add(msg);
                }
                errAcctMap.put(accountPk, msgList);
            }
        }
        return errAcctMap;
    }

    private void doOperation(String entityKey, List<Long> billPks) {
        DynamicObject[] bills;
        QFilter qFilter = new QFilter("id", "in", billPks);
        QFilter qFilter1 = new QFilter("billstatus", "=", (Object)BillStatusEnum.SUBMIT.getValue());
        for (DynamicObject bill : bills = BusinessDataServiceHelper.load((String)entityKey, (String)"id, billstatus", (QFilter[])new QFilter[]{qFilter, qFilter1})) {
            bill.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
        }
        SaveServiceHelper.update((DynamicObject[])bills);
        DynamicObject[] needDeleteBills = BusinessDataServiceHelper.load((String)entityKey, (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (needDeleteBills.length > 0) {
            Object[] needDeleteBillPks = Arrays.stream(needDeleteBills).map(e -> e.getLong("id")).toArray();
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", "true");
            option.setVariableValue("mutex_writeback", "false");
            option.setVariableValue("isStrict", "false");
            option.setVariableValue("ignoreValidation", "true");
            OperationResult deleteResult = OperationServiceHelper.executeOperate((String)"delete", (String)entityKey, (Object[])needDeleteBillPks, (OperateOption)option);
            OperationHelper.assertResult(deleteResult);
        }
    }

    public Map<String, Object> execute(DynamicObject entry) {
        List<Map<String, Object>> balances = this.invokeGLBalanceService(entry);
        String accountNum = entry.getString("e_account.number");
        List<Map<String, Object>> balanceList = this.balancesFilter(balances, entry.getString("e_balancetype"));
        if (balanceList.size() > 0) {
            int rowIndex = entry.getInt("seq");
            String entityKey = entry.getString("e_entityobject");
            ISchemeImport iScheme = GlImportFactory.getService(entityKey, this.orgPk, this.init);
            ArrayList<Map<String, Object>> billDatas = new ArrayList(balanceList.size());
            try {
                billDatas = iScheme.convert(balanceList, entry);
            }
            catch (Exception e) {
                String message = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u79d1\u76ee\u7f16\u7801\u201c%2$s\u201d\uff1a%3$s", (String)"GlImportService_4", (String)"fi-arapcommon", (Object[])new Object[0]), rowIndex, accountNum, e.getMessage());
                return this.buildResultMap(billDatas.size(), new ArrayList<Long>(0), message, false);
            }
            Map<String, Object> result = this.invokeSaveApi(entityKey, billDatas);
            boolean isSuccess = (Boolean)result.get("success");
            List apiDatas = (List)result.get("data");
            List<Long> successPks = apiDatas.stream().filter(m -> (Boolean)m.get("success")).map(m -> (Long)m.get("id")).collect(Collectors.toList());
            List errApiDatas = apiDatas.stream().filter(m -> (Boolean)m.get("success") == false).collect(Collectors.toList());
            HashSet<String> errorInfoSets = new HashSet<String>(8);
            for (Map errorInfos : errApiDatas) {
                Object data = errorInfos.get("data");
                Object convertResult = errorInfos.get("convertResult");
                if (EmptyUtils.isNotEmpty(data)) {
                    if (data instanceof Collection) {
                        List errlist = (List)errorInfos.get("data");
                        for (OperateErrorInfo err : errlist) {
                            errorInfoSets.add(err.getMessage());
                        }
                        continue;
                    }
                    errorInfoSets.add((String)errorInfos.get("message"));
                    continue;
                }
                if (EmptyUtils.isNotEmpty(convertResult) && convertResult instanceof HashMap) {
                    for (Object convertResultObj : ((HashMap)convertResult).values()) {
                        for (Object error : (JSONArray)convertResultObj) {
                            errorInfoSets.add((String)error);
                        }
                    }
                    continue;
                }
                errorInfoSets.add((String)errorInfos.get("message"));
            }
            StringBuilder errMessage = new StringBuilder();
            int seq = 1;
            for (String errorInfo : errorInfoSets) {
                errMessage.append(seq++).append('.').append(errorInfo);
            }
            String message = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u79d1\u76ee\u7f16\u7801\u201c%2$s\u201d\uff1a%3$s\u6570\u636e\u5bfc\u5165\u5171%4$s\u5f20\uff0c\u6210\u529f%5$s\u5f20\uff0c\u5931\u8d25%6$s\u5f20\u3002\u5931\u8d25\u539f\u56e0\uff1a%7$s", (String)"GlImportService_1", (String)"fi-arapcommon", (Object[])new Object[0]), rowIndex, accountNum, EntityMetadataCache.getDataEntityType((String)entityKey).getDisplayName().getLocaleValue(), billDatas.size(), successPks.size(), billDatas.size() - successPks.size(), errMessage);
            return this.buildResultMap(billDatas.size(), successPks, message, isSuccess);
        }
        return this.buildResultMap(0, new ArrayList<Long>(0), null, true);
    }

    private List<Map<String, Object>> balancesFilter(List<Map<String, Object>> balances, String balanceType) {
        ArrayList<Map<String, Object>> balanceList = new ArrayList<Map<String, Object>>(0);
        for (Map<String, Object> balance : balances) {
            BigDecimal beginfor = new BigDecimal(balance.get("beginfor").toString());
            if (!("1".equals(balanceType) && beginfor.compareTo(BigDecimal.ZERO) != 0 || "2".equals(balanceType) && beginfor.compareTo(BigDecimal.ZERO) > 0) && (!"3".equals(balanceType) || beginfor.compareTo(BigDecimal.ZERO) >= 0)) continue;
            balanceList.add(balance);
        }
        return balanceList;
    }

    private Map<String, Object> buildResultMap(int subtotal, List<Long> successPks, String message, boolean success) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
        resultMap.put("subtotal", subtotal);
        resultMap.put("successPks", successPks);
        resultMap.put("message", message);
        resultMap.put("success", success);
        return resultMap;
    }

    private List<Map<String, Object>> invokeGLBalanceService(DynamicObject entry) {
        String resultJson;
        BalanceQueryParam param = new BalanceQueryParam();
        param.setOrgId(this.orgPk);
        param.setBookTypeId(GLUtils.getMainAccountBookId());
        Long accountPk = entry.getLong("e_account.id");
        param.setAccountTableId(this.accountBook.getLong("accounttable.id"));
        param.setPeriodId(this.init.getLong("startperiod.id"));
        param.addSelector("beginfor");
        param.addSelector("beginlocal");
        param.addSelector("endfor");
        param.addSelector("endlocal");
        param.addSelector("creditfor");
        param.addSelector("creditlocal");
        param.addSelector("debitfor");
        param.addSelector("debitlocal");
        param.addGroupBy("account");
        param.addGroupBy("currency");
        Map<String, Long> flexField = this.getFlexField(entry);
        flexField.forEach((key, value) -> param.addGroupBy((String)key));
        ArrayList<Map<String, Long>> asstTypeValues = new ArrayList<Map<String, Long>>(8);
        asstTypeValues.add(flexField);
        param.setAccountAssgrp(accountPk, asstTypeValues);
        String paramJson = param.toString();
        logger.info("---gl.getBalance.param---" + paramJson);
        try {
            resultJson = (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)"gl", (String)"BalanceService", (String)"getBalance", (Object[])new Object[]{paramJson});
        }
        catch (Exception e) {
            logger.info("GlImoprtInvokeException:" + ArApHelper.getStackTraceMessage(e));
            throw e;
        }
        ArrayList<Map<String, Object>> balances = new ArrayList(8);
        if (resultJson != null && !"".equals(resultJson.trim())) {
            balances = (List)SerializationUtils.fromJsonString((String)resultJson, List.class);
        }
        logger.info("---gl.getBalance.size---" + balances.size());
        return balances;
    }

    private Map<String, Long> getFlexField(DynamicObject entry) {
        HashMap<String, Long> flexField = new HashMap<String, Long>(0);
        flexField.put(entry.getString("e_asstactitem.flexfield"), null);
        for (int i = 0; i < 6; ++i) {
            String e_mappingfield = entry.getString("e_mappingfield" + (i + 1));
            if (ObjectUtils.isEmpty((Object)e_mappingfield)) continue;
            DynamicObject m_asstactitem = entry.getDynamicObject("e_asstactitem" + (i + 1));
            flexField.put(m_asstactitem.getString("flexfield"), null);
        }
        return flexField;
    }

    private Map<String, Object> invokeSaveApi(String entityKey, List<Map<String, Object>> datas) {
        HashMap<String, List<Map<String, Object>>> dataMap = new HashMap<String, List<Map<String, Object>>>();
        dataMap.put("datas", datas);
        String entityTypeId = FormMetadataCache.getFormConfig((String)entityKey).getEntityTypeId();
        AbstractOperateWebApi webApi = FormMetadataCache.getFormOperationApi((String)entityTypeId, (String)"save");
        webApi.initialize(entityKey, dataMap);
        return ApiResult.toMap((ApiResult)webApi.execute());
    }
}

