/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.init;

import com.alibaba.fastjson.JSONObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.helper.SettingMapperHelper;
import kd.fi.arapcommon.vo.ReconciliationParam;

public class InitServiceHelper {
    private static final Log logger = LogFactory.getLog(InitServiceHelper.class);

    public static void reconciliation(boolean isAr, IFormView view, Object pk) {
        ReconciliationParam param = InitServiceHelper.getReconciliationParam(isAr, view, pk);
        boolean exception = false;
        String openParam = null;
        String code = null;
        String message = null;
        try {
            openParam = (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)"frm", (String)"ReconciliationService", (String)"execute", (Object[])new Object[]{JSONObject.toJSONString((Object)param)});
            logger.info("ai-execute param : " + JSONObject.toJSONString((Object)param));
            logger.info("ai-execute result : " + openParam);
            if (openParam == null) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u8c03\u7528\u5bf9\u8d26\u63a5\u53e3\u8fd4\u56de\u7a7a\u3002", (String)"InitServiceHelper_0", (String)"fi-arapcommon", (Object[])new Object[0]));
            }
        }
        catch (KDBizException e) {
            if (e.getArgs().length > 0) {
                openParam = e.getArgs()[0].toString();
            }
            ErrorCode ec = e.getErrorCode();
            code = ec.getCode();
            message = ec.getMessage();
            exception = true;
        }
        catch (Exception e) {
            logger.error("ai-execute error : " + e);
            message = e.getMessage();
            exception = true;
        }
        boolean isShow = false;
        if (exception) {
            if ("2".equals(code)) {
                isShow = true;
            } else {
                view.showErrorNotification(message);
            }
        } else {
            isShow = true;
        }
        if (isShow) {
            FormShowParameter parame = new FormShowParameter();
            parame.setFormId("frm_reconciliation_rst_fst");
            parame.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parame.setCustomParam("model", (Object)openParam);
            view.showForm(parame);
        }
    }

    private static ReconciliationParam getReconciliationParam(boolean isAr, IFormView view, Object pk) {
        ReconciliationParam param = new ReconciliationParam();
        if (view instanceof IListView) {
            QFilter qFilter = new QFilter("id", "=", pk);
            DynamicObject init = null;
            if (isAr) {
                init = QueryServiceHelper.queryOne((String)"ar_init", (String)"org, startperiod, policyid", (QFilter[])new QFilter[]{qFilter});
                param.setAppNumber("ar");
                param.setBizBookId(init.getLong("policyid"));
            } else {
                init = QueryServiceHelper.queryOne((String)"ap_init", (String)"org, startperiod", (QFilter[])new QFilter[]{qFilter});
                param.setAppNumber("ap");
            }
            param.setOrgId(init.getLong("org"));
            param.setPeriodId(init.getLong("startperiod"));
        } else {
            IDataModel m = view.getModel();
            long orgPk = (Long)((DynamicObject)m.getValue("org")).getPkValue();
            param.setOrgId(orgPk);
            param.setPeriodId(Long.valueOf(((DynamicObject)m.getValue("startperiod")).getPkValue().toString()));
            if (isAr) {
                param.setAppNumber("ar");
                param.setBizBookId(Long.valueOf(m.getValue("policyid").toString()));
            } else {
                param.setAppNumber("ap");
            }
        }
        param.setOriResult(true);
        param.setInit(true);
        return param;
    }

    public static int getInitBatchHandleCount() {
        int batchCount = 0;
        String batchCountStr = SettingMapperHelper.getOrCreateValueFromCache("init", "batchcount", "100000");
        try {
            batchCount = Integer.parseInt(batchCountStr);
        }
        catch (Exception e) {
            batchCount = 100000;
        }
        return batchCount;
    }
}

