/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.init.impl;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.arapcommon.init.AbstractSchemeImport;
import kd.fi.arapcommon.util.EmptyUtils;

public class FinArBillSchemeImpl
extends AbstractSchemeImport {
    public FinArBillSchemeImpl(String entityKey, Long orgPk, DynamicObject init) {
        super(entityKey, orgPk, init);
    }

    @Override
    protected void billProperty(Map<String, Object> dataMap, Map<String, Object> balance, DynamicObject entry) {
        dataMap.put("billtype", this.basedata(entry.getDynamicObject("e_billtype")));
        dataMap.put("biztype", this.basedata(entry.getDynamicObject("e_biztype")));
        Date bizDate = (Date)dataMap.get("bizdate");
        dataMap.put("duedate", bizDate);
        dataMap.put("bookdate", bizDate);
        dataMap.put("invoicedate", bizDate);
        String asstacttype = entry.getString("e_asstacttype");
        dataMap.put("asstacttype", asstacttype);
        Object asstactitem = balance.get(entry.getString("e_asstactitem.flexfield"));
        long asstactitemPk = this.getAsstactitemPk(asstacttype, Long.parseLong(asstactitem.toString()));
        dataMap.put("asstact", this.basedata(asstactitemPk));
        dataMap.put("recorg", this.basedata(this.getFisbankroll(this.orgPk)));
        dataMap.put("salesorg", this.basedata(this.orgPk));
        dataMap.put("paymode", "CREDIT");
        dataMap.put("payproperty", this.basedata(entry.getDynamicObject("e_arpayproperty")));
        dataMap.put("isfx", Boolean.FALSE);
        dataMap.put("isfxpricetaxtotal", Boolean.FALSE);
        dataMap.put("isincludetax", Boolean.TRUE);
        dataMap.put("ispricetotal", Boolean.TRUE);
        dataMap.put("isperiod", Boolean.TRUE);
    }

    @Override
    protected void billEntryProperty(Map<String, Object> entryMap, Map<String, Object> balance, DynamicObject entry) {
        entryMap.put("linetype", this.basedata(entry.getDynamicObject("e_linetype")));
        entryMap.put("e_ispresent", Boolean.FALSE);
        BigDecimal quantity = BigDecimal.ONE;
        BigDecimal unitprice = BigDecimal.ZERO;
        BigDecimal beginfor = new BigDecimal(balance.get("beginfor").toString());
        if (EmptyUtils.isNotEmpty(beginfor)) {
            if (beginfor.compareTo(BigDecimal.ZERO) < 0) {
                quantity = BigDecimal.ONE.negate();
            }
            unitprice = beginfor.abs();
        }
        if ("1".equals(entry.getString("e_balancedc"))) {
            quantity = quantity.negate();
        }
        entryMap.put("e_quantity", quantity);
        entryMap.put("e_unitprice", unitprice);
        entryMap.put("e_recamount", quantity.multiply(unitprice));
    }
}

