/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.intertax;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.arapcommon.intertax.InterTaxService;
import kd.fi.arapcommon.intertax.TaxService;

@Deprecated
public class InterTaxGTEHelper {
    private static Log logger = LogFactory.getLog(InterTaxGTEHelper.class);
    private IFormView formView;
    private IDataModel dataModel;
    private String entityId;
    private String entryKey;
    private boolean taxroundrule = false;
    private int scale = 2;
    private PropertyChangedArgs propertyChangedArgs;
    private String operateKey;

    public InterTaxGTEHelper(IFormView formView) {
        this.formView = formView;
        this.dataModel = formView.getModel();
        this.entityId = formView.getEntityId();
        this.entryKey = "entry";
        if ("ap_finapbill".equals(this.entityId) || this.entityId.endsWith("ap_finchange")) {
            this.entryKey = "detailentry";
        }
        this.taxroundrule = (Boolean)this.dataModel.getValue("taxroundrule");
        DynamicObject currency = (DynamicObject)this.dataModel.getValue("currency");
        if (!ObjectUtils.isEmpty((Object)currency)) {
            this.scale = currency.getInt("amtprecision");
        }
    }

    public InterTaxGTEHelper(IFormView formView, PropertyChangedArgs propertyChangedArgs) {
        this.formView = formView;
        this.dataModel = formView.getModel();
        this.entityId = formView.getEntityId();
        this.entryKey = "entry";
        if ("ap_finapbill".equals(this.entityId) || this.entityId.endsWith("ap_finchange")) {
            this.entryKey = "detailentry";
        }
        this.taxroundrule = (Boolean)this.dataModel.getValue("taxroundrule");
        DynamicObject currency = (DynamicObject)this.dataModel.getValue("currency");
        if (!ObjectUtils.isEmpty((Object)currency)) {
            this.scale = currency.getInt("amtprecision");
        }
        this.propertyChangedArgs = propertyChangedArgs;
    }

    public InterTaxGTEHelper(IFormView formView, String operateKey) {
        this.formView = formView;
        this.dataModel = formView.getModel();
        this.entityId = formView.getEntityId();
        this.entryKey = "entry";
        if ("ap_finapbill".equals(this.entityId) || this.entityId.endsWith("ap_finchange")) {
            this.entryKey = "detailentry";
        }
        this.taxroundrule = (Boolean)this.dataModel.getValue("taxroundrule");
        DynamicObject currency = (DynamicObject)this.dataModel.getValue("currency");
        if (!ObjectUtils.isEmpty((Object)currency)) {
            this.scale = currency.getInt("amtprecision");
        }
        this.operateKey = operateKey;
    }

    public static String getVersion() {
        return "2019-12-14";
    }

    public void isBotpNew() {
        boolean hasTaxgroup;
        MainEntityType mainType = this.dataModel.getDataEntityType();
        boolean bl = hasTaxgroup = mainType.findProperty("isgtetax") != null;
        if (!hasTaxgroup) {
            return;
        }
        boolean isintertax = (Boolean)this.dataModel.getValue("isgtetax");
        if (!isintertax) {
            return;
        }
        this.calculateAllTaxEntry();
    }

    public void propertyChanged_taxentry() {
        int index;
        boolean hasTaxgroup;
        logger.info("20191213 InterTaxGTEHelper.propertyChanged_taxentry start.");
        MainEntityType mainType = this.dataModel.getDataEntityType();
        boolean bl = hasTaxgroup = mainType.findProperty("isgtetax") != null;
        if (!hasTaxgroup) {
            return;
        }
        boolean isintertax = (Boolean)this.dataModel.getValue("isgtetax");
        if (!isintertax) {
            return;
        }
        String key = this.propertyChangedArgs.getProperty().getName();
        ChangeData[] changeData = this.propertyChangedArgs.getChangeSet();
        int entryIndex = index = changeData[0].getRowIndex();
        logger.info("20191213 InterTaxGTEHelper.propertyChanged_taxentry key: " + key);
        switch (key) {
            case "taxroundrule": {
                this.calculateAllTaxEntry();
                break;
            }
            case "e_rategroup": {
                DynamicObject rategroup = (DynamicObject)changeData[0].getNewValue();
                if (ObjectUtils.isEmpty((Object)rategroup)) {
                    this.dataModel.deleteEntryData("subentryentity");
                    DynamicObject detial = (DynamicObject)this.dataModel.getEntryEntity(this.entryKey).get(entryIndex);
                    this.calculateTaxEntry(detial, entryIndex, true, new ArrayList<DynamicObject>());
                    this.updateTaxSubEntry();
                    break;
                }
                List<Map<String, Object>> result = TaxService.query("rategroup", rategroup.getLong("id"));
                this.getSubAndCalculate(entryIndex, result);
                break;
            }
            case "e_quantity": 
            case "quantity": 
            case "e_unitprice": 
            case "price": 
            case "e_discountmode": 
            case "discountmode": 
            case "e_discountrate": 
            case "discountrate": 
            case "e_premiumrate": {
                this.calculateTaxEntry(entryIndex);
                break;
            }
            case "s_taxrateid": {
                DynamicObject taxrateid = (DynamicObject)changeData[0].getNewValue();
                if (ObjectUtils.isEmpty((Object)taxrateid)) break;
                List<Map<String, Object>> result = TaxService.query("rate", taxrateid.getLong("id"));
                this.updateSubEntryByEaxrateid(index, result);
                entryIndex = changeData[0].getParentRowIndex();
                DynamicObject detial = (DynamicObject)this.dataModel.getEntryEntity(this.entryKey).get(entryIndex);
                DynamicObjectCollection taxColls = detial.getDynamicObjectCollection("subentryentity");
                this.calculateTaxEntry(detial, entryIndex, true, (Collection<DynamicObject>)taxColls);
                this.updateTaxSubEntry();
                break;
            }
            case "s_taxassessamt": {
                BigDecimal oldTaxctrlamt;
                boolean hasTaxctrlamt;
                BigDecimal taxbase = (BigDecimal)changeData[0].getNewValue();
                BigDecimal taxrate = (BigDecimal)this.dataModel.getValue("s_taxrate", index);
                BigDecimal oldTax = (BigDecimal)this.dataModel.getValue("s_tax", index);
                BigDecimal newTax = taxbase.multiply(taxrate).divide(new BigDecimal(100));
                boolean bl2 = hasTaxctrlamt = mainType.findProperty("s_taxctrlamt") != null;
                if (hasTaxctrlamt && ((oldTaxctrlamt = (BigDecimal)this.dataModel.getValue("s_taxctrlamt", index)).compareTo(BigDecimal.ZERO) == 0 || oldTaxctrlamt.compareTo(oldTax) == 0)) {
                    this.dataModel.setValue("s_taxctrlamt", (Object)newTax, index);
                }
                this.dataModel.setValue("s_tax", (Object)newTax, index);
            }
            case "s_includetail": 
            case "s_includediscount": 
            case "s_taxctrlamt": {
                entryIndex = changeData[0].getParentRowIndex();
                this.calculateTaxEntry(entryIndex);
                break;
            }
            case "s_deductionrate": {
                BigDecimal tax = (BigDecimal)this.dataModel.getValue("s_tax", index);
                if (mainType.findProperty("s_taxctrlamt") != null) {
                    tax = (BigDecimal)this.dataModel.getValue("s_taxctrlamt", index);
                }
                BigDecimal deductionrate = (BigDecimal)this.dataModel.getValue("s_deductionrate", index);
                BigDecimal deductible = tax.multiply(deductionrate).divide(new BigDecimal(100));
                this.dataModel.setValue("s_deductible", (Object)deductible, index);
                this.dataModel.setValue("s_nondeductible", (Object)tax.subtract(deductible), index);
            }
        }
        this.calculateHeadAmt();
    }

    private void getSubAndCalculate(int entryIndex, List<Map<String, Object>> result) {
        this.dataModel.deleteEntryData("subentryentity");
        if (ObjectUtils.isEmpty(result)) {
            this.formView.showTipNotification(ResManager.loadKDString((String)"\u8c03\u7528\u7a0e\u52a1\u4e91\u63a5\u53e3\uff0c\u6ca1\u6709\u67e5\u8be2\u5230\u7a0e\u7ec4\u5bf9\u5e94\u7684\u7a0e\u7387\u4fe1\u606f\u3002", (String)"InterTaxGTEHelper_0", (String)"fi-arapcommon", (Object[])new Object[0]));
            return;
        }
        int taxrateSize = result.size();
        this.dataModel.batchCreateNewEntryRow("subentryentity", taxrateSize);
        int subIndex = 0;
        this.dataModel.beginInit();
        for (Map<String, Object> taxrateEntry : result) {
            this.fillTaxRow(taxrateEntry, subIndex++, false);
            if (!((Boolean)taxrateEntry.get("isdeducttax")).booleanValue()) continue;
            this.dataModel.createNewEntryRow("subentryentity");
            this.fillTaxRow(taxrateEntry, subIndex++, true);
        }
        this.dataModel.endInit();
        logger.info("20191213 InterTaxGTEHelper.getSubAndCalculate endInit.");
        DynamicObject detial = (DynamicObject)this.dataModel.getEntryEntity(this.entryKey).get(entryIndex);
        DynamicObjectCollection taxColls = detial.getDynamicObjectCollection("subentryentity");
        this.calculateTaxEntry(detial, entryIndex, true, (Collection<DynamicObject>)taxColls);
        this.updateTaxSubEntry();
    }

    private void updateSubEntryByEaxrateid(int index, List<Map<String, Object>> result) {
        if (ObjectUtils.isEmpty(result)) {
            this.formView.showTipNotification(ResManager.loadKDString((String)"\u8c03\u7528\u7a0e\u52a1\u4e91\u63a5\u53e3\uff0c\u6ca1\u6709\u67e5\u8be2\u5230\u8be5\u7a0e\u7387\u4fe1\u606f\u3002", (String)"InterTaxGTEHelper_1", (String)"fi-arapcommon", (Object[])new Object[0]));
            return;
        }
        this.dataModel.beginInit();
        Map<String, Object> taxrateEntry = result.get(0);
        this.fillTaxRow(taxrateEntry, index++, false);
        if (((Boolean)taxrateEntry.get("isdeducttax")).booleanValue()) {
            int insertIndex = this.dataModel.insertEntryRow("subentryentity", index);
            this.fillTaxRow(taxrateEntry, index++, true);
        }
        for (int i = 1; i < result.size(); ++i) {
            Map<String, Object> taxrateEntry1 = result.get(i);
            int insertIndex = this.dataModel.insertEntryRow("subentryentity", index);
            this.fillTaxRow(taxrateEntry1, index++, false);
            if (!((Boolean)taxrateEntry1.get("isdeducttax")).booleanValue()) continue;
            insertIndex = this.dataModel.insertEntryRow("subentryentity", index);
            this.fillTaxRow(taxrateEntry1, index++, true);
        }
        this.dataModel.endInit();
    }

    private void fillTaxRow(Map<String, Object> taxrateEntry, int subIndex, boolean isSplit) {
        this.dataModel.setValue("s_taxrateid", taxrateEntry.get("id"), subIndex);
        this.dataModel.setValue("s_taxcategory", taxrateEntry.get("taxclassid"), subIndex);
        this.dataModel.setValue("s_simplecode", taxrateEntry.get("taxcalsstype"), subIndex);
        this.dataModel.setValue("s_taxcalsstype", taxrateEntry.get("taxcalsstype"), subIndex);
        this.dataModel.setValue("s_isinpricetax", taxrateEntry.get("includetax"), subIndex);
        BigDecimal taxrate = (BigDecimal)taxrateEntry.get("taxrate");
        this.dataModel.setValue("s_taxrate", (Object)(isSplit ? taxrate.negate() : taxrate), subIndex);
        this.dataModel.setValue("s_taxtime", taxrateEntry.get("dkssd"), subIndex);
        this.dataModel.setValue("s_includevat", taxrateEntry.get("includingvat"), subIndex);
        this.dataModel.setValue("s_taxbasetype", taxrateEntry.get("taxbasetype"), subIndex);
        this.dataModel.setValue("s_candeductible", taxrateEntry.get("allowdeduct"), subIndex);
        this.dataModel.setValue("s_deduct", taxrateEntry.get("ductrattype"), subIndex);
        this.dataModel.setValue("s_deductionrate", taxrateEntry.get("deductrate"), subIndex);
    }

    public void calculateAllTaxEntry() {
        DynamicObjectCollection detialColls = this.dataModel.getEntryEntity(this.entryKey);
        for (int entryIndex = 0; entryIndex < detialColls.size(); ++entryIndex) {
            this.dataModel.setEntryCurrentRowIndex("subentryentity", entryIndex);
            DynamicObject detial = (DynamicObject)detialColls.get(entryIndex);
            DynamicObjectCollection taxColls = detial.getDynamicObjectCollection("subentryentity");
            this.calculateTaxEntry(detial, entryIndex, true, (Collection<DynamicObject>)taxColls);
        }
        this.updateTaxSubEntry();
        this.formView.updateView(this.entryKey);
    }

    private void calculateTaxEntry(DynamicObject detial, int entryIndex, boolean updateDetial, Collection<DynamicObject> taxRowColls) {
        BigDecimal quantity = BigDecimal.ZERO;
        BigDecimal price = BigDecimal.ZERO;
        BigDecimal premiumrate = BigDecimal.ZERO;
        String discountmodeKey = "e_discountmode";
        BigDecimal discountrate = BigDecimal.ZERO;
        if ("ap_finapbill".equals(this.entityId) || this.entityId.endsWith("ap_finchange")) {
            quantity = detial.getBigDecimal("quantity");
            price = detial.getBigDecimal("price");
            premiumrate = detial.getBigDecimal("e_premiumrate");
            discountmodeKey = "discountmode";
            discountrate = detial.getBigDecimal("discountrate");
        } else {
            quantity = detial.getBigDecimal("e_quantity");
            price = detial.getBigDecimal("e_unitprice");
            discountrate = detial.getBigDecimal("e_discountrate");
        }
        String discountmode = detial.getString(discountmodeKey);
        BigDecimal e_vattax = BigDecimal.ZERO;
        BigDecimal e_paytax = BigDecimal.ZERO;
        for (DynamicObject taxsub : taxRowColls) {
            if (!"1".equals(taxsub.getString("s_simplecode"))) continue;
            InterTaxService interTaxService = this.calculateTaxEntry(taxsub, quantity, price, premiumrate, discountmode, discountrate, BigDecimal.ZERO);
            BigDecimal s_tax = this.updateTaxEntry(taxsub, interTaxService);
            e_vattax = e_vattax.add(s_tax);
            if (!"2".equals(taxsub.getString("s_taxtime"))) continue;
            e_paytax = e_paytax.add(s_tax);
        }
        BigDecimal e_tax = e_vattax;
        for (DynamicObject taxsub : taxRowColls) {
            if ("1".equals(taxsub.getString("s_simplecode"))) continue;
            InterTaxService interTaxService = this.calculateTaxEntry(taxsub, quantity, price, premiumrate, discountmode, discountrate, e_vattax);
            BigDecimal s_tax = this.updateTaxEntry(taxsub, interTaxService);
            if ("2".equals(taxsub.getString("s_taxtime"))) {
                e_paytax = e_paytax.add(s_tax);
            }
            e_tax = e_tax.add(s_tax);
        }
        if (updateDetial) {
            this.dataModel.setValue("e_vattax", (Object)e_vattax.setScale(this.scale, RoundingMode.HALF_DOWN), entryIndex);
            this.dataModel.setValue("e_tax", (Object)e_tax.setScale(this.scale, RoundingMode.HALF_DOWN), entryIndex);
            if ("ar_busbill".equals(this.entityId) || "ar_finarbill".equals(this.entityId) || this.entityId.contains("ar_finarbill")) {
                this.dataModel.setValue("e_rectax", (Object)e_paytax.setScale(this.scale, RoundingMode.HALF_DOWN), entryIndex);
                this.dataModel.setValue("e_recamount", (Object)e_tax.add(detial.getBigDecimal("e_amount")), entryIndex);
            } else {
                detial.set("e_paytax", (Object)e_paytax.setScale(this.scale, RoundingMode.HALF_DOWN));
                this.dataModel.setValue("e_pricetaxtotal", (Object)e_tax.add(detial.getBigDecimal("e_amount")), entryIndex);
            }
        }
    }

    public InterTaxService calculateTaxEntry(DynamicObject taxsub, BigDecimal quantity, BigDecimal price, BigDecimal premiumrate, String discountmode, BigDecimal discountrate, BigDecimal vattax) {
        MainEntityType mainType;
        boolean hasTaxctrlamt;
        BigDecimal taxrate = taxsub.getBigDecimal("s_taxrate");
        InterTaxService interTaxService = new InterTaxService(quantity, price, taxrate);
        interTaxService.setIncludediscount(taxsub.getBoolean("s_includediscount"));
        interTaxService.calculateDiscountAmt(discountmode, discountrate);
        interTaxService.setIsnegate("2".equals(taxsub.getString("s_simplecode")));
        if (taxsub.getBoolean("s_includevat")) {
            interTaxService.setVatAmt(vattax);
        }
        BigDecimal deductionrate = taxsub.getBigDecimal("s_deductionrate");
        interTaxService.setDeductionrate(taxsub.getBigDecimal("s_deductionrate"));
        boolean includetail = taxsub.getBoolean("s_includetail");
        if (!includetail) {
            interTaxService.setTailRate(premiumrate);
        }
        interTaxService.setIsinpricetax(taxsub.getBoolean("s_isinpricetax"));
        interTaxService.setIstaxbaseAmt("1".equals(taxsub.getString("s_taxbasetype")));
        interTaxService.calculateTax();
        if ("2".equals(taxsub.getString("s_simplecode")) && "2".equals(taxsub.getString("s_taxtime"))) {
            interTaxService.setTax(BigDecimal.ZERO);
        }
        BigDecimal oldTaxbase = taxsub.getBigDecimal("s_taxbase");
        BigDecimal oldTaxassessamt = taxsub.getBigDecimal("s_taxassessamt");
        BigDecimal s_tax = interTaxService.getTax();
        if (oldTaxassessamt.compareTo(BigDecimal.ZERO) != 0 && oldTaxassessamt.compareTo(oldTaxbase) != 0) {
            s_tax = taxsub.getBigDecimal("s_tax");
        }
        boolean bl = hasTaxctrlamt = (mainType = this.dataModel.getDataEntityType()).findProperty("s_taxctrlamt") != null;
        if (hasTaxctrlamt) {
            BigDecimal oldTax = taxsub.getBigDecimal("s_tax");
            BigDecimal oldTaxctrlamt = taxsub.getBigDecimal("s_taxctrlamt");
            if (oldTaxctrlamt.compareTo(BigDecimal.ZERO) == 0 || oldTaxctrlamt.compareTo(oldTax) == 0) {
                oldTaxctrlamt = s_tax;
            }
            BigDecimal deductible = oldTaxctrlamt.multiply(deductionrate).divide(new BigDecimal(100));
            interTaxService.setDeductible(deductible);
            interTaxService.setNondeductible(oldTaxctrlamt.subtract(deductible));
        }
        return interTaxService;
    }

    private BigDecimal updateTaxEntry(DynamicObject taxsub, InterTaxService interTaxService) {
        boolean hasTaxctrlamt;
        BigDecimal oldTaxbase = taxsub.getBigDecimal("s_taxbase");
        BigDecimal oldTaxassessamt = taxsub.getBigDecimal("s_taxassessamt");
        BigDecimal oldTax = taxsub.getBigDecimal("s_tax");
        BigDecimal taxbase = interTaxService.getTaxbase();
        taxsub.set("s_taxbase", (Object)taxbase);
        taxsub.set("s_deductible", (Object)interTaxService.getDeductible());
        taxsub.set("s_nondeductible", (Object)interTaxService.getNondeductible());
        BigDecimal s_tax = interTaxService.getTax();
        if (oldTaxassessamt.compareTo(BigDecimal.ZERO) == 0 || oldTaxassessamt.compareTo(oldTaxbase) == 0) {
            taxsub.set("s_taxassessamt", (Object)taxbase);
            oldTaxassessamt = taxbase;
        } else {
            s_tax = taxsub.getBigDecimal("s_tax");
        }
        if (this.taxroundrule) {
            s_tax = s_tax.setScale(this.scale, RoundingMode.HALF_DOWN);
        }
        taxsub.set("s_tax", (Object)s_tax);
        MainEntityType mainType = this.dataModel.getDataEntityType();
        boolean bl = hasTaxctrlamt = mainType.findProperty("s_taxctrlamt") != null;
        if (!hasTaxctrlamt) {
            return s_tax;
        }
        BigDecimal oldTaxctrlamt = taxsub.getBigDecimal("s_taxctrlamt");
        if (oldTaxctrlamt.compareTo(BigDecimal.ZERO) == 0 || oldTaxctrlamt.compareTo(oldTax) == 0) {
            taxsub.set("s_taxctrlamt", (Object)s_tax);
            oldTaxctrlamt = s_tax;
        }
        return oldTaxctrlamt;
    }

    private void calculateHeadAmt() {
        logger.info("20191213 InterTaxGTEHelper.calculateHeadAmt start.");
        DynamicObjectCollection entrycolls = this.dataModel.getEntryEntity(this.entryKey);
        BigDecimal taxAmt = BigDecimal.ZERO;
        BigDecimal pricetaxtotal = BigDecimal.ZERO;
        switch (this.entityId) {
            case "ar_busbill": {
                break;
            }
            case "ap_busbill": {
                for (DynamicObject entry : entrycolls) {
                    taxAmt = taxAmt.add(entry.getBigDecimal("e_tax"));
                    pricetaxtotal = pricetaxtotal.add(entry.getBigDecimal("e_pricetaxtotal"));
                }
                this.dataModel.setValue("tax", (Object)taxAmt);
                this.dataModel.setValue("pricetaxtotal", (Object)pricetaxtotal);
            }
        }
        if ("ap_finapbill".equals(this.entityId) || this.entityId.endsWith("ap_finchange")) {
            BigDecimal paytax = BigDecimal.ZERO;
            for (DynamicObject entry : entrycolls) {
                paytax = paytax.add(entry.getBigDecimal("e_paytax"));
                taxAmt = taxAmt.add(entry.getBigDecimal("e_tax"));
                pricetaxtotal = pricetaxtotal.add(entry.getBigDecimal("e_pricetaxtotal"));
            }
            this.dataModel.setValue("paytax", (Object)paytax);
            this.dataModel.setValue("tax", (Object)taxAmt);
            this.dataModel.setValue("pricetaxtotal", (Object)pricetaxtotal);
        }
        if (this.entityId.contains("ar_finarbill")) {
            for (DynamicObject entry : entrycolls) {
                taxAmt = taxAmt.add(entry.getBigDecimal("e_tax"));
                pricetaxtotal = pricetaxtotal.add(entry.getBigDecimal("e_recamount"));
            }
            this.dataModel.setValue("tax", (Object)taxAmt);
            this.dataModel.setValue("recamount", (Object)pricetaxtotal);
        }
    }

    public void clearAllTaxEntry() {
        DynamicObjectCollection detialColls = this.dataModel.getEntryEntity(this.entryKey);
        for (DynamicObject detial : detialColls) {
            detial.set("subentryentity", null);
        }
        this.formView.updateView("subentryentity");
    }

    public void afterDoOperation() {
        if ("deletesubentry".equals(this.operateKey)) {
            int entryIndex = this.dataModel.getEntryCurrentRowIndex(this.entryKey);
            this.calculateTaxEntry(entryIndex);
        }
    }

    private void calculateTaxEntry(int entryIndex) {
        DynamicObject detial = (DynamicObject)this.dataModel.getEntryEntity(this.entryKey).get(entryIndex);
        DynamicObjectCollection taxColls = detial.getDynamicObjectCollection("subentryentity");
        this.calculateTaxEntry(detial, entryIndex, true, (Collection<DynamicObject>)taxColls);
        this.updateTaxSubEntry();
        this.formView.updateView(this.entryKey);
    }

    private void updateTaxSubEntry() {
        MainEntityType mainType = this.dataModel.getDataEntityType();
        boolean hasTaxctrlamt = mainType.findProperty("s_taxctrlamt") != null;
        DynamicObjectCollection detialColls = this.dataModel.getEntryEntity(this.entryKey);
        for (DynamicObject detial : detialColls) {
            DynamicObjectCollection taxColls = detial.getDynamicObjectCollection("subentryentity");
            for (DynamicObject taxsub : taxColls) {
                taxsub.set("s_taxbase", (Object)taxsub.getBigDecimal("s_taxbase").setScale(this.scale, RoundingMode.HALF_DOWN));
                taxsub.set("s_taxassessamt", (Object)taxsub.getBigDecimal("s_taxassessamt").setScale(this.scale, RoundingMode.HALF_DOWN));
                taxsub.set("s_tax", (Object)taxsub.getBigDecimal("s_tax").setScale(this.scale, RoundingMode.HALF_DOWN));
                if (hasTaxctrlamt) {
                    taxsub.set("s_taxctrlamt", (Object)taxsub.getBigDecimal("s_taxctrlamt").setScale(this.scale, RoundingMode.HALF_DOWN));
                }
                taxsub.set("s_deductible", (Object)taxsub.getBigDecimal("s_deductible").setScale(this.scale, RoundingMode.HALF_DOWN));
                taxsub.set("s_nondeductible", (Object)taxsub.getBigDecimal("s_nondeductible").setScale(this.scale, RoundingMode.HALF_DOWN));
            }
        }
        this.formView.updateView("subentryentity");
    }
}

