/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.intertaximport;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.consts.FinARBillModel;
import kd.fi.arapcommon.helper.ArapAbstractImport;
import kd.fi.arapcommon.helper.BaseDataHelper;
import kd.fi.arapcommon.helper.TaxentryImportHelper;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.StringUtils;

public class ArBusBillTaxentryImport
extends ArapAbstractImport {
    private LinkedHashSet<String> numberList = null;

    @Override
    public boolean beforeImportData(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        super.beforeImportData(data, option, importlogs);
        try {
            JSONObject row;
            QFilter[] filters;
            DynamicObject currency;
            boolean isPeriod = this.isPeriod(data);
            this.checkOrgNew("fisaccounting");
            if (this.numberList == null) {
                this.numberList = new LinkedHashSet();
            }
            this.checkText("billno", ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7", (String)"ArBusBillTaxentryImport_0", (String)"fi-arapcommon", (Object[])new Object[0]), true, 80, null);
            String number = (String)data.get("billno");
            this.checkNumberOnly(number);
            if (isPeriod) {
                String billtypenumber;
                JSONObject billtype = (JSONObject)data.get("billtype");
                if (billtype != null && "arfin_borrowar_BT_S".equals(billtypenumber = billtype.getString("number"))) {
                    throw new Exception(ResManager.loadKDString((String)"\u501f\u8d37\u9879\u8c03\u6574\uff0c\u4e0d\u80fd\u5bfc\u5165\u671f\u521d\u5355\u636e\u3002", (String)"ArBusBillTaxentryImport_1", (String)"fi-arapcommon", (Object[])new Object[0]));
                }
                if (this.init.isFinishInit()) {
                    throw new Exception(ResManager.loadKDString((String)"\u5df2\u7ed3\u675f\u521d\u59cb\u5316\u4e0d\u5141\u8bb8\u5bfc\u5165\u671f\u521d\u5355\u636e\u3002", (String)"ArBusBillTaxentryImport_2", (String)"fi-arapcommon", (Object[])new Object[0]));
                }
                this.checkDate("bizdate", ResManager.loadKDString((String)"\u5355\u636e\u65e5\u671f", (String)"ArBusBillTaxentryImport_3", (String)"fi-arapcommon", (Object[])new Object[0]), true, null, this.init.getStartDate(), null);
            } else {
                Date currentDate = this.init.getCurrentDate();
                if (ObjectUtils.isEmpty((Object)currentDate)) {
                    currentDate = this.init.getStartDate();
                }
                this.checkDate("bizdate", ResManager.loadKDString((String)"\u5355\u636e\u65e5\u671f", (String)"ArBusBillTaxentryImport_3", (String)"fi-arapcommon", (Object[])new Object[0]), true, currentDate, null, null);
            }
            this.checkDateCompare("duedate", ResManager.loadKDString((String)"\u5230\u671f\u65e5", (String)"ArBusBillTaxentryImport_4", (String)"fi-arapcommon", (Object[])new Object[0]));
            this.checkAsstact();
            this.checkF7("bd_reccondition", "paycond", ResManager.loadKDString((String)"\u6536\u6b3e\u6761\u4ef6", (String)"ArBusBillTaxentryImport_5", (String)"fi-arapcommon", (Object[])new Object[0]), false, null);
            this.checkF7("bd_settlementtype", "settlementtype", ResManager.loadKDString((String)"\u7ed3\u7b97\u65b9\u5f0f", (String)"ArBusBillTaxentryImport_6", (String)"fi-arapcommon", (Object[])new Object[0]), false, this.getDefaultSettleType());
            this.checkOrgF7("fisbankroll", "recorg", ResManager.loadKDString((String)"\u6536\u6b3e\u7ec4\u7ec7", (String)"ArBusBillTaxentryImport_7", (String)"fi-arapcommon", (Object[])new Object[0]), true, null);
            this.checkText("remark", ResManager.loadKDString((String)"\u5907\u6ce8", (String)"ArBusBillTaxentryImport_8", (String)"fi-arapcommon", (Object[])new Object[0]), false, 510, null);
            data.remove("billstatus");
            JSONObject currencyData = (JSONObject)data.get("currency");
            String currencyNumber = (String)currencyData.get((Object)"number");
            if (ObjectUtils.isEmpty((Object)currencyNumber)) {
                currencyNumber = "CNY";
            }
            if ((currency = BusinessDataServiceHelper.loadSingle((String)"bd_currency", (String)"id,number,name,amtprecision,priceprecision", (QFilter[])(filters = new QFilter[]{new QFilter("number", "=", (Object)currencyNumber)}))) == null) {
                throw new Exception(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u7ed3\u7b97\u5e01\u201d\u3002", (String)"ArBusBillTaxentryImport_9", (String)"fi-arapcommon", (Object[])new Object[0]));
            }
            int amtprecision = currency.getInt("amtprecision");
            int priceprecision = currency.getInt("priceprecision");
            this.checkExchangeRate();
            this.checkOrgF7("fissale", "salesorg", ResManager.loadKDString((String)"\u9500\u552e\u7ec4\u7ec7", (String)"ArBusBillTaxentryImport_10", (String)"fi-arapcommon", (Object[])new Object[0]), false, null);
            BigDecimal baddebtamt = this.getBigDecimal("baddebtamt");
            if (baddebtamt.compareTo(BigDecimal.ZERO) > 0) {
                data.put("isbaddebt", Boolean.TRUE);
            } else {
                data.put("isbaddebt", Boolean.FALSE);
            }
            JSONArray entryList = (JSONArray)data.get("entry");
            if (entryList != null) {
                for (int seq = 0; seq < entryList.size(); ++seq) {
                    row = (JSONObject)entryList.get(seq);
                    this.checkEntryNull(row, seq);
                    this.checkEntryEnum("e_discountmode", ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f", (String)"ArBusBillTaxentryImport_11", (String)"fi-arapcommon", (Object[])new Object[0]), row, seq, false, new String[]{"PERCENT", "PERUNIT", "NULL"}, "NULL");
                    this.checkEntryEnum("e_corebilltype", ResManager.loadKDString((String)"\u6838\u5fc3\u5355\u636e\u7c7b\u578b", (String)"ArBusBillTaxentryImport_12", (String)"fi-arapcommon", (Object[])new Object[0]), row, seq, false, new String[]{"sm_salorder", "conm_salcontract"}, "");
                    this.checkEntryText("e_corebillno", ResManager.loadKDString((String)"\u6838\u5fc3\u5355\u636e\u53f7", (String)"ArBusBillTaxentryImport_13", (String)"fi-arapcommon", (Object[])new Object[0]), row, seq, false, 80, null);
                    this.checkEntryText("e_remark", ResManager.loadKDString((String)"\u5907\u6ce8", (String)"ArBusBillTaxentryImport_8", (String)"fi-arapcommon", (Object[])new Object[0]), row, seq, false, 510, null);
                    JSONArray taxRowColls = TaxentryImportHelper.checkTaxentry(data, row, seq, "2");
                    this.sumEntryAmt(row, amtprecision, priceprecision, taxRowColls);
                }
                this.sumAmt(amtprecision);
                this.calculateLocalAmt();
                this.numberList.add(number);
            }
            JSONArray planEntryList = (JSONArray)data.get("planentity");
            if (entryList != null && planEntryList.size() > 0) {
                BigDecimal exchanegRate = this.getBigDecimal("exchangerate");
                BigDecimal sumpricetax = BigDecimal.ZERO;
                for (int seq = 0; seq < planEntryList.size(); ++seq) {
                    JSONObject row2 = (JSONObject)planEntryList.get(seq);
                    BigDecimal planRowAmt = this.getEntryBigDecimal(row2, "planpricetax");
                    sumpricetax = sumpricetax.add(planRowAmt);
                    row2.put("planpricetaxloc", (Object)planRowAmt.multiply(exchanegRate).setScale(this.baseCurrencyPrecision, RoundingMode.HALF_DOWN));
                    row2.put("planlockedamt", (Object)"0");
                    row2.put("unplanlockamt", (Object)planRowAmt);
                    row2.put("plansettledamt", (Object)"0");
                    row2.put("plansettledlocamt", (Object)"0");
                    row2.put("unplansettleamt", (Object)planRowAmt);
                    row2.put("unplansettlelocamt", (Object)planRowAmt.multiply(exchanegRate).setScale(this.baseCurrencyPrecision, RoundingMode.HALF_DOWN));
                }
                if (sumpricetax.compareTo(this.getBigDecimal("recamount")) != 0) {
                    throw new Exception(ResManager.loadKDString((String)"\u6536\u6b3e\u8ba1\u5212\u5e94\u6536\u91d1\u989d\u5408\u8ba1\u4e0e\u6574\u5355\u5e94\u6536\u91d1\u989d\u4e00\u81f4\u624d\u80fd\u4fdd\u5b58\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"ArBusBillTaxentryImport_14", (String)"fi-arapcommon", (Object[])new Object[0]));
                }
            } else {
                planEntryList = new JSONArray();
                row = new JSONObject();
                row.put("planduedate", data.get("duedate"));
                row.put("plansettletype", data.get("settlementtype"));
                row.put("planpricetax", data.get("recamount"));
                row.put("planpricetaxloc", data.get("reclocalamt"));
                row.put("planlockedamt", (Object)"0");
                row.put("unplanlockamt", data.get("recamount"));
                row.put("plansettledamt", (Object)"0");
                row.put("plansettledlocamt", (Object)"0");
                row.put("unplansettleamt", data.get("recamount"));
                row.put("unplansettlelocamt", data.get("reclocalamt"));
                planEntryList.add((Object)row);
                data.put("planentity", planEntryList);
            }
        }
        catch (Exception exc) {
            if (exc instanceof KDBizException) {
                importlogs.add(new ImportLogger.ImportLog(exc.getMessage()));
            } else {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                importlogs.add(new ImportLogger.ImportLog(sw.toString()));
                try {
                    pw.close();
                    sw.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return false;
        }
        return true;
    }

    private void checkNumberOnly(String number) throws Exception {
        switch (this.importtype) {
            case "override": {
                break;
            }
            case "new": {
                if (this.numberList.contains(number)) {
                    throw new Exception(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u5b58\u5728 - \u65e0\u6cd5\u65b0\u589e\u5bfc\u5165\u3002", (String)"ArBusBillTaxentryImport_15", (String)"fi-arapcommon", (Object[])new Object[0]));
                }
                DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)"ar_busbill", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)number)});
                if (obj == null) break;
                throw new Exception(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u5b58\u5728 - \u65e0\u6cd5\u65b0\u589e\u5bfc\u5165\u3002", (String)"ArBusBillTaxentryImport_15", (String)"fi-arapcommon", (Object[])new Object[0]));
            }
        }
    }

    private boolean isMaterial() {
        String billtypenumber;
        boolean isMaterial = true;
        JSONObject billtype = (JSONObject)this.data.get("billtype");
        if (billtype != null && ("ar_busbill_salefee_BT_S".equals(billtypenumber = billtype.getString("number")) || "ar_busbill_other_BT_S".equals(billtypenumber))) {
            isMaterial = false;
        }
        return isMaterial;
    }

    private void checkAsstact() throws Exception {
        JSONObject billType = (JSONObject)this.data.get("billtype");
        if (billType.get((Object)"name") != null && ResManager.loadKDString((String)"\u5176\u4ed6\u5e94\u6536", (String)"ArBusBillTaxentryImport_16", (String)"fi-arapcommon", (Object[])new Object[0]).equals(billType.get((Object)"name")) || billType.get((Object)"number") != null && "arfin_other_BT_S".equals(billType.get((Object)"number"))) {
            String value = (String)this.data.get("asstacttype");
            if (StringUtils.isEmpty(value)) {
                this.data.put("asstacttype", "bos_user");
                value = "bos_user";
            }
            this.checkF7(value, "asstact", ResManager.loadKDString((String)"\u5f80\u6765\u6237", (String)"ArBusBillTaxentryImport_17", (String)"fi-arapcommon", (Object[])new Object[0]), true, null);
        } else {
            this.data.put("asstacttype", "bd_customer");
            this.checkF7("bd_customer", "asstact", ResManager.loadKDString((String)"\u5f80\u6765\u6237", (String)"ArBusBillTaxentryImport_17", (String)"fi-arapcommon", (Object[])new Object[0]), true, null);
        }
    }

    private String getDefaultSettleType() {
        QFilter filter = new QFilter("isdefault", "=", (Object)"1");
        DynamicObject[] settleTypes = BusinessDataServiceHelper.load((String)"bd_settlementtype", (String)"number", (QFilter[])new QFilter[]{filter});
        if (settleTypes != null && settleTypes.length > 0) {
            return (String)settleTypes[0].get("number");
        }
        return null;
    }

    private void checkExchangeRate() throws Exception {
        JSONObject currency = (JSONObject)this.data.get("currency");
        if (currency.get((Object)"number").equals(this.baseCurrency.get("number"))) {
            this.data.put("exchangerate", "1");
            return;
        }
        Double rate = (Double)this.data.get("exchangerate");
        if (rate == null) {
            BigDecimal exchangeRate = BaseDataHelper.getExchangeRate(currency.getLong("id"), this.baseCurrency.getLong("id"), this.orgId, DateUtils.getLastDay((Date)this.cachedDate.get(this.orgId), 1));
            this.data.put("exchangerate", exchangeRate.toPlainString());
        }
    }

    private void checkEntryNull(JSONObject row, int seq) throws Exception {
        if (this.isMaterial()) {
            JSONObject material = (JSONObject)row.get((Object)"e_material");
            if (material == null) {
                throw new Exception(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\uff0c\u8bf7\u8865\u5145\u7269\u6599\u3002", (String)"ArBusBillTaxentryImport_18", (String)"fi-arapcommon", (Object[])new Object[0]), seq + 1));
            }
            QFilter filter = new QFilter("number", "=", (Object)material.getString("number"));
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)"bd_material", (String)"id,number,name,modelnum,baseunit.id,baseunit.number", (QFilter[])new QFilter[]{filter});
            if (obj == null) {
                throw new Exception(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\uff0c\u8bf7\u8865\u5145\u201c\u7269\u6599\u7f16\u7801\u201d\u3002", (String)"ArBusBillTaxentryImport_19", (String)"fi-arapcommon", (Object[])new Object[0]), seq + 1));
            }
            this.checkEntryText("e_spectype", ResManager.loadKDString((String)"\u89c4\u683c\u578b\u53f7", (String)"ArBusBillTaxentryImport_21", (String)"fi-arapcommon", (Object[])new Object[0]), row, seq, false, 50, obj.getString("modelnum"));
            String baseunitNumber = obj.getDynamicObject("baseunit").getString("number");
            this.checkEntryF7("bd_measureunits", "e_measureunit", ResManager.loadKDString((String)"\u8ba1\u4ef7\u5355\u4f4d", (String)"ArBusBillTaxentryImport_22", (String)"fi-arapcommon", (Object[])new Object[0]), row, seq, true, baseunitNumber);
            JSONObject value = new JSONObject();
            value.put("number", (Object)baseunitNumber);
            row.put("e_baseunit", (Object)value);
        } else {
            this.checkEntryF7("er_expenseitemedit", "e_expenseitem", ResManager.loadKDString((String)"\u8d39\u7528\u9879\u76ee", (String)"ArBusBillTaxentryImport_23", (String)"fi-arapcommon", (Object[])new Object[0]), row, seq, true, null);
        }
        Object value = row.get((Object)"e_quantity");
        if (value == null) {
            throw new Exception(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\uff0c\u8bf7\u8865\u5145\u6570\u91cf\u3002", (String)"ArBusBillTaxentryImport_24", (String)"fi-arapcommon", (Object[])new Object[0]), seq + 1));
        }
    }

    private void sumAmt(int amtprecision) {
        BigDecimal recamount = BigDecimal.ZERO;
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal tax = BigDecimal.ZERO;
        BigDecimal unverifyamount = BigDecimal.ZERO;
        BigDecimal unsettleamount = BigDecimal.ZERO;
        JSONArray entryList = (JSONArray)this.data.get("entry");
        for (int seq = 0; seq < entryList.size(); ++seq) {
            JSONObject row = (JSONObject)entryList.get(seq);
            BigDecimal erecamount = this.getEntryBigDecimal(row, "e_recamount");
            BigDecimal eamount = this.getEntryBigDecimal(row, "e_amount");
            BigDecimal etax = this.getEntryBigDecimal(row, "e_tax");
            BigDecimal eunverifyamount = this.getEntryBigDecimal(row, "e_unverifyamt");
            BigDecimal eunsettleamount = this.getEntryBigDecimal(row, "e_unsettleamt");
            recamount = recamount.add(erecamount);
            amount = amount.add(eamount);
            tax = tax.add(etax);
            unverifyamount = unverifyamount.add(eunverifyamount);
            unsettleamount = unsettleamount.add(eunsettleamount);
        }
        this.data.put("recamount", recamount.setScale(amtprecision, RoundingMode.HALF_DOWN));
        this.data.put("amount", amount.setScale(amtprecision, RoundingMode.HALF_DOWN));
        this.data.put("tax", tax.setScale(amtprecision, RoundingMode.HALF_DOWN));
        this.data.put("unverifyamount", unverifyamount.setScale(amtprecision, RoundingMode.HALF_DOWN));
        this.data.put("unsettleamount", unsettleamount.setScale(amtprecision, RoundingMode.HALF_DOWN));
    }

    protected void sumEntryAmt(JSONObject row, int amtprecision, int priceprecision, JSONArray taxRowColls) throws Exception {
        BigDecimal ONE_HUNDRED = new BigDecimal("100");
        BigDecimal quantity = this.getEntryBigDecimal(row, "e_quantity");
        row.put("e_unverifyqty", (Object)quantity.toPlainString());
        BigDecimal discountamount = new BigDecimal(0);
        BigDecimal actunitprice = new BigDecimal(0);
        if ("PERCENT".equals(row.get((Object)"e_discountmode"))) {
            BigDecimal discountrate = this.getEntryBigDecimal(row, "e_discountrate").divide(ONE_HUNDRED);
            discountamount = quantity.multiply(this.getEntryBigDecimal(row, "e_unitprice")).multiply(discountrate).setScale(amtprecision, RoundingMode.HALF_DOWN);
            row.put("e_discountamount", (Object)discountamount);
            actunitprice = this.getEntryBigDecimal(row, "e_unitprice").multiply(BigDecimal.ONE.subtract(discountrate)).setScale(priceprecision, RoundingMode.HALF_DOWN);
            row.put("e_actunitprice", (Object)actunitprice);
        } else if ("PERUNIT".equals(row.get((Object)"e_discountmode"))) {
            BigDecimal discountamt = this.getEntryBigDecimal(row, "e_discountrate");
            actunitprice = this.getEntryBigDecimal(row, "e_unitprice").subtract(discountamt).setScale(priceprecision, RoundingMode.HALF_DOWN);
            row.put("e_actunitprice", (Object)actunitprice);
            discountamount = quantity.multiply(discountamt).setScale(amtprecision, RoundingMode.HALF_DOWN);
            row.put("e_discountamount", (Object)discountamount);
        } else if ("NULL".equals(row.get((Object)"e_discountmode"))) {
            actunitprice = this.getEntryBigDecimal(row, "e_unitprice").setScale(priceprecision, RoundingMode.HALF_DOWN);
            row.put("e_actunitprice", (Object)actunitprice);
            row.put("e_acttaxunitprice", (Object)this.getEntryBigDecimal(row, "e_taxunitprice").setScale(priceprecision, RoundingMode.HALF_DOWN));
            row.put("e_discountrate", (Object)BigDecimal.ZERO);
            row.put("e_discountamount", (Object)BigDecimal.ZERO);
        }
        BigDecimal tax = TaxentryImportHelper.computationTax(taxRowColls, priceprecision, row, actunitprice, discountamount, amtprecision);
        BigDecimal e_amount = actunitprice.multiply(quantity).setScale(amtprecision, RoundingMode.HALF_DOWN);
        row.put("e_amount", (Object)e_amount);
        BigDecimal recamount = e_amount.add(tax).setScale(amtprecision, RoundingMode.HALF_DOWN);
        BigDecimal recamountScale = recamount.setScale(amtprecision, RoundingMode.HALF_DOWN);
        row.put("e_recamount", (Object)recamountScale);
        row.put("e_unverifyamt", (Object)recamountScale);
        row.put("e_unlockamt", (Object)recamountScale);
        row.put("e_unsettleamt", (Object)recamountScale);
        row.put("e_unconfirmamt", (Object)recamountScale);
        row.put("e_tax", (Object)tax.setScale(amtprecision, RoundingMode.HALF_DOWN));
    }

    protected void calculateLocalAmt() {
        BigDecimal rate = this.getBigDecimal("exchangerate");
        for (int i = 0; i < FinARBillModel.getAllHeadAmt().length; ++i) {
            BigDecimal amount = this.getBigDecimal(FinARBillModel.getAllHeadAmt()[i]);
            if (amount.compareTo(BigDecimal.ZERO) <= 0) continue;
            this.data.put(FinARBillModel.getAllHeadLocalAmt()[i], amount.multiply(rate).setScale(this.baseCurrencyPrecision, RoundingMode.HALF_DOWN));
        }
        JSONArray entryList = (JSONArray)this.data.get("entry");
        for (int seq = 0; seq < entryList.size(); ++seq) {
            for (int i = 0; i < FinARBillModel.getAllEntryAmt().length; ++i) {
                JSONObject row = (JSONObject)entryList.get(seq);
                BigDecimal amount = this.getEntryBigDecimal(row, FinARBillModel.getAllEntryAmt()[i]);
                if (amount.compareTo(BigDecimal.ZERO) <= 0) continue;
                row.put(FinARBillModel.getAllEntryLocalAmt()[i], (Object)amount.setScale(this.baseCurrencyPrecision, RoundingMode.HALF_DOWN));
            }
        }
    }

    protected boolean isPeriod(Map<String, Object> data) {
        if (data.get("isperiod") != null) {
            return (Boolean)data.get("isperiod");
        }
        return true;
    }
}

