/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.invcloud.call;

import com.alibaba.fastjson.JSON;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.arapcommon.business.piaozone.cv.JsonParseUtils;
import kd.fi.arapcommon.business.piaozone.exception.PZAuthException;
import kd.fi.arapcommon.business.piaozone.info.InvoiceCloudCfg;
import kd.fi.arapcommon.business.piaozone.info.InvoiceDetailRetrunVO;
import kd.fi.arapcommon.business.piaozone.info.InvoiceVO;
import kd.fi.arapcommon.business.piaozone.info.QueryInvoiceDetailInfo;
import kd.fi.arapcommon.business.piaozone.kingdee.APIHelper;
import kd.fi.arapcommon.business.piaozone.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.arapcommon.business.piaozone.kingdee.action.DeleteAction;
import kd.fi.arapcommon.business.piaozone.kingdee.action.GenVoucherAction;
import kd.fi.arapcommon.business.piaozone.kingdee.action.QueryBySerialNoAction;
import kd.fi.arapcommon.business.piaozone.kingdee.action.SaveAction;
import kd.fi.arapcommon.business.piaozone.kingdee.action.UpdateAction;
import kd.fi.arapcommon.invcloud.call.AbstractCallCloudService;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.JsonUtils;
import kd.fi.arapcommon.util.StringUtils;

public class CallOldCloudServiceImpl
extends AbstractCallCloudService {
    protected static final Log logger = LogFactory.getLog(CallOldCloudServiceImpl.class);

    @Override
    public Object updateInvoiceCloud(List<Long> invoiceIds) {
        logger.info("CallOldCloudServiceImpl updateInvoiceCloud begin.");
        Object[] invoices = this.queryInvoices(invoiceIds);
        if (ObjectUtils.isEmpty((Object[])invoices)) {
            return null;
        }
        logger.info("CallOldCloudServiceImpl updateInvoiceCloud invoices length is : " + invoices.length);
        HashMap<Long, InvoiceCloudCfg> cloudCfgMap = new HashMap<Long, InvoiceCloudCfg>(8);
        for (Object invoice : invoices) {
            String serialNo = invoice.getString("serialno");
            if (EmptyUtils.isEmpty(serialNo)) continue;
            long orgId = invoice.getLong("org.id");
            InvoiceCloudCfg config = cloudCfgMap.computeIfAbsent(orgId, v -> KingdeeInvoiceCloudConfig.getConfig(orgId));
            String[] serialNos = new String[]{invoice.getString("serialno")};
            SaveAction saveAction = new SaveAction(config, invoice.getPkValue(), invoice.getString("billno"), serialNos);
            this.callBackInvCloud(saveAction);
            UpdateAction updateAction = new UpdateAction(config, invoice.getPkValue(), invoice.getString("billno"));
            this.callBackInvCloud(updateAction);
        }
        return null;
    }

    @Override
    public Object releaseInvoice(List<Long> invoiceIds) {
        logger.info("CallOldCloudServiceImpl releaseInvoice begin.");
        Object[] invoices = this.queryInvoices(invoiceIds);
        if (ObjectUtils.isEmpty((Object[])invoices)) {
            return null;
        }
        logger.info("CallOldCloudServiceImpl releaseInvoice invoices length is : " + invoices.length);
        for (Object inv : invoices) {
            if (EmptyUtils.isEmpty(inv.getString("serialno"))) continue;
            DeleteAction deleteAction = new DeleteAction(inv.getDynamicObject("org"), inv.getPkValue(), inv.getString("billno"));
            this.callBackInvCloud(deleteAction);
        }
        return null;
    }

    @Override
    public List<InvoiceVO> queryCloudInvoice(Map<Long, String> orgForSerialMap) {
        logger.info("CallOldCloudServiceImpl queryCloudInvoice begin.");
        if (ObjectUtils.isEmpty(orgForSerialMap)) {
            return null;
        }
        Map<Long, QueryInvoiceDetailInfo> queryInvoiceDetailInfoMap = this.queryInvoiceDetailMap(orgForSerialMap);
        logger.info("CallXHCloudServiceImpl queryCloudInvoice orgForSerialMap is : " + queryInvoiceDetailInfoMap);
        if (queryInvoiceDetailInfoMap.isEmpty()) {
            return null;
        }
        ArrayList<InvoiceVO> queryResult = new ArrayList<InvoiceVO>(64);
        block0: for (Map.Entry<Long, QueryInvoiceDetailInfo> entrySet : queryInvoiceDetailInfoMap.entrySet()) {
            QueryInvoiceDetailInfo queryBO = entrySet.getValue();
            String serialNos = queryBO.getSerialNo();
            logger.info("\u67e5\u8be2\u53d1\u7968\u8be6\u7ec6, \u4f20\u9012\u8fdb\u6765\u7684\u5e8f\u5217\u53f7", (Object)serialNos);
            if (serialNos == null || serialNos.isEmpty()) {
                logger.info("\u67e5\u8be2\u53d1\u7968\u8be6\u7ec6, \u4f20\u9012\u8fdb\u6765\u7684\u5e8f\u5217\u53f7\u4e3a\u7a7a");
                continue;
            }
            String taxRegNum = queryBO.getTaxNo();
            QueryBySerialNoAction queryAction = new QueryBySerialNoAction(serialNos);
            queryAction.setTaxNo(queryBO.getTaxNo());
            queryAction.setCompanyName(queryBO.getCompanyName());
            queryAction.setBxdKey(queryBO.getBxdKey());
            Long orgId = queryBO.getOrgId();
            String token = "";
            logger.info("\u53d1\u7968\u5e8f\u5217\u53f7\u67e5\u8be2\uff0c\u83b7\u53d6token");
            if (orgId != null && KingdeeInvoiceCloudConfig.isGroupPattern()) {
                token = APIHelper.getToken4Ap(orgId);
                queryAction.setOrgId(orgId);
                logger.info("InvoiceConfigPattern:\u96c6\u56e2\u6a21\u5f0f\uff0c" + orgId);
            } else {
                token = APIHelper.getToken4Ap(taxRegNum);
                logger.info("InvoiceConfigPattern:\u7ec4\u7ec7\u6a21\u5f0f");
            }
            for (int i = 0; i < 5; ++i) {
                ErrorCode ec;
                queryAction.setToken(token);
                String apiReturnJson = queryAction.execute();
                InvoiceDetailRetrunVO invoiceDetailReturnVO = JsonParseUtils.parseInvoiceDetailReturnVO(apiReturnJson);
                String errcode = invoiceDetailReturnVO.getErrcode();
                if ("0000".equals(errcode)) {
                    List<InvoiceVO> returnVOData = invoiceDetailReturnVO.getData();
                    logger.info("APIHelper----\u8c03\u7528\u53d1\u7968\u4e91\u67e5\u8be2\u8be6\u7ec6\u4fe1\u606f\u6210\u529f" + JSON.toJSONString(returnVOData));
                    queryResult.addAll(returnVOData);
                    continue block0;
                }
                if ("1300".equals(errcode)) {
                    logger.info("token\u8fc7\u671f, \u91cd\u65b0\u83b7\u53d6tocken\u53d1\u9001\u8bf7\u6c42");
                    if (i != 4) continue;
                    ec = new ErrorCode("token_is_expired", ResManager.loadKDString((String)"Token\u4e00\u76f4\u8fc7\u671f\uff0c \u67e5\u8be2\u53d1\u7968\u8be6\u60c5\u5931\u8d25\u3002", (String)"APIHelper_9", (String)"fi-arapcommon", (Object[])new Object[0]));
                    throw new KDBizException(ec, new Object[0]);
                }
                logger.error("\u67e5\u8be2\u53d1\u7968\u8be6\u60c5\u8fd4\u56de\u6570\u636e\u5f02\u5e38:" + apiReturnJson);
                ec = new ErrorCode("query_other_exception", invoiceDetailReturnVO.getDescription());
                throw new PZAuthException(ec);
            }
        }
        logger.info("CallOldCloudServiceImpl queryCloudInvoice queryInvoiceVOS.size" + queryResult.size());
        return queryResult;
    }

    @Override
    public Object updateTaxDeduction(List<Long> invoiceIds) {
        logger.info("CallOldCloudServiceImpl updateTaxDeduction begin.");
        Object[] invoices = this.queryInvoices(invoiceIds);
        if (ObjectUtils.isEmpty((Object[])invoices)) {
            return null;
        }
        logger.info("CallOldCloudServiceImpl updateTaxDeduction invoices length is : " + invoices.length);
        HashMap<Long, InvoiceCloudCfg> cloudCfgMap = new HashMap<Long, InvoiceCloudCfg>(8);
        for (Object invoice : invoices) {
            String serialNo = invoice.getString("serialno");
            if (EmptyUtils.isEmpty(serialNo)) continue;
            long orgId = invoice.getLong("org.id");
            InvoiceCloudCfg config = cloudCfgMap.computeIfAbsent(orgId, v -> KingdeeInvoiceCloudConfig.getConfig(orgId));
            HashMap<String, Object> extendParam = new HashMap<String, Object>(8);
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("serialNo", serialNo);
            data.put("canBeDeduction", invoice.getBoolean("istaxdeduction") ? "1" : "0");
            extendParam.put("invoiceData", Collections.singletonList(data));
            UpdateAction updateAction = new UpdateAction(config, invoice.getPkValue(), invoice.getString("billno"), extendParam);
            this.callBackInvCloud(updateAction);
        }
        return null;
    }

    @Override
    public Map<String, Object> buildViewInvoiceParam(List<Long> billIds, String entityName, List<String> serialNos) {
        logger.info("CallOldCloudServiceImpl buildViewInvoiceParam begin.");
        Object[] bills = this.getViewInvoiceBill(billIds, entityName);
        if (ObjectUtils.isEmpty((Object[])bills)) {
            logger.info("CallOldCloudServiceImpl buildViewInvoiceParam bill is null .");
            return new HashMap<String, Object>(8);
        }
        if (ObjectUtils.isEmpty(serialNos)) {
            serialNos.addAll(this.getBillAllSerialNo((DynamicObject[])bills, entityName));
        }
        long orgId = bills[0].getLong("ap_payapply".equals(entityName) ? "settleorg.id" : "org.id");
        InvoiceCloudCfg config = KingdeeInvoiceCloudConfig.getConfig(orgId);
        String invId = this.getBillNoCachedInCloud(entityName, (DynamicObject)bills[0]);
        logger.info("\u8c03\u7528\u524d\u7aef\u67e5\u770b\u53d1\u7968\u5217\u8868\u754c\u9762>>> serialNosKey:" + invId + ", serialNos:" + serialNos);
        HashMap<String, Object> customParam = new HashMap<String, Object>(16);
        customParam.put("actionType", "viewInvoiceList");
        customParam.put("invoiceOrgId", orgId);
        customParam.put("onPC", Boolean.TRUE);
        customParam.put("billNumber", invId);
        customParam.put("serialNo", JsonUtils.objToJson(serialNos));
        HashMap<String, Object> showInvoiceParam = new HashMap<String, Object>();
        showInvoiceParam.put("billId", invId);
        showInvoiceParam.put("billNumber", bills[0].getString("billno"));
        showInvoiceParam.put("orgId", orgId);
        showInvoiceParam.put("serialNos", new ArrayList<String>(serialNos));
        String taxRegnums = config.getTaxRegnum();
        String taxRegNum = taxRegnums.split("=")[0];
        showInvoiceParam.put("taxRegNum", taxRegNum);
        if (!"ap_invoice".equals(entityName)) {
            ArrayList<String> relevanceExpenseIdList = new ArrayList<String>(16);
            for (Object bill : bills) {
                if ("ap_finapbill".equals(entityName) || "ap_payapply".equals(entityName)) {
                    DynamicObjectCollection invEntries = bill.getDynamicObjectCollection("inventry");
                    for (DynamicObject invEntry : invEntries) {
                        if (ObjectUtils.isEmpty((Object)invEntry.getString("i_serialno"))) continue;
                        String invBillId = invEntry.getString("invid");
                        relevanceExpenseIdList.add("ap_invoice_" + invBillId);
                    }
                    continue;
                }
                if (!"ap_replaceinvapply".equals(entityName)) continue;
                DynamicObjectCollection oldInvEntry = bill.getDynamicObjectCollection("oldinventry");
                for (DynamicObject oldInvRow : oldInvEntry) {
                    if (ObjectUtils.isEmpty((Object)oldInvRow.getString("o_serialno"))) continue;
                    relevanceExpenseIdList.add("ap_invoice_" + oldInvRow.getString("o_invid"));
                }
                DynamicObjectCollection newInvEntry = bill.getDynamicObjectCollection("newinventry");
                for (DynamicObject newInvRow : newInvEntry) {
                    if (ObjectUtils.isEmpty((Object)newInvRow.getString("n_serialno"))) continue;
                    relevanceExpenseIdList.add("ap_invoice_" + newInvRow.getString("n_invid"));
                }
            }
            String relevanceExpenseId = String.join((CharSequence)",", relevanceExpenseIdList);
            logger.info("\u67e5\u8be2\u53d1\u7968\u5173\u8054\u7684\u5355\u636eID" + relevanceExpenseId);
            showInvoiceParam.put("relevanceExpenseId", relevanceExpenseId);
        }
        customParam.put("showInvoiceUrlReqParam", JsonUtils.objToJson(showInvoiceParam));
        return customParam;
    }

    @Override
    public void showInvoiceAssistant(AbstractFormPlugin plugin) {
        logger.info("CallOldCloudServiceImpl showInvoiceAssistant begin.");
        IFormView view = plugin.getView();
        String entityName = view.getModel().getDataEntityType().getName();
        DynamicObject org = "ap_payapply".equals(entityName) ? (DynamicObject)view.getModel().getValue("settleorg") : (DynamicObject)view.getModel().getValue("org");
        long billId = DB.genLongId((String)"t_ap_invoice");
        String billIdStr = "ap_invoice_" + billId;
        String taxRegNum = this.getTaxNo(org);
        HashMap<String, Object> customParam = new HashMap<String, Object>(8);
        customParam.put("actionType", "selectInvoice");
        customParam.put("taxRegNum", taxRegNum);
        customParam.put("onPC", Boolean.TRUE);
        customParam.put("bxd_key", billIdStr);
        customParam.put("billNumber", billIdStr);
        HashMap<String, Object> param = new HashMap<String, Object>(8);
        param.put("billId", billIdStr);
        param.put("taxRegNum", taxRegNum);
        param.put("invoiceCompanyId", org.getPkValue());
        customParam.put("importInvoiceIframeUrlReqParam", JSON.toJSONString(param));
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("800");
        styleCss.setHeight("530");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)plugin, "selectInvoice_" + billId);
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("er_invoicecloudpage_pc");
        formShowParameter.getOpenStyle().setInlineStyleCss(styleCss);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.getCustomParams().putAll(customParam);
        formShowParameter.setShowTitle(false);
        formShowParameter.setCloseCallBack(closeCallBack);
        plugin.getView().showForm(formShowParameter);
    }

    @Override
    public Object updateCloudInvoicePool(List<Long> invoiceIds) {
        logger.info("CallOldCloudServiceImpl updateCloudInvoicePool begin.");
        if (ObjectUtils.isEmpty(invoiceIds)) {
            return null;
        }
        Map<Long, List<Long>> invoiceForVoucherMap = this.getInvoiceForVoucherMap(invoiceIds);
        logger.info("CallOldCloudServiceImpl updateCloudInvoicePool invoiceForVoucherMap is \uff1a" + invoiceForVoucherMap);
        if (invoiceForVoucherMap.isEmpty()) {
            return null;
        }
        DynamicObject[] invoices = this.queryInvoices(new ArrayList<Long>(invoiceForVoucherMap.keySet()));
        Map<Long, DynamicObject> voucherMap = this.getVoucherMap(invoiceForVoucherMap);
        HashMap<Long, InvoiceCloudCfg> invoiceCloudCfgMap = new HashMap<Long, InvoiceCloudCfg>(8);
        ArrayList<DynamicObject> needUpdateSynStatusInvs = new ArrayList<DynamicObject>(8);
        for (DynamicObject invoice : invoices) {
            List<Long> voucherIds = invoiceForVoucherMap.get(invoice.getLong("id"));
            ArrayList awsVoucherInfos = new ArrayList(8);
            if (!ObjectUtils.isEmpty(voucherIds)) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                for (Long voucherId : voucherIds) {
                    DynamicObject voucher = voucherMap.get(voucherId);
                    if (voucher == null) continue;
                    HashMap<String, Object> awsVoucherParamMap = new HashMap<String, Object>(8);
                    awsVoucherParamMap.put("vouchId", voucher.getLong("id"));
                    awsVoucherParamMap.put("vouchNo", voucher.getString("billno"));
                    DynamicObject period = voucher.getDynamicObject("period");
                    if (period != null) {
                        awsVoucherParamMap.put("period", period.get("number"));
                    }
                    awsVoucherParamMap.put("businessDate", sdf.format(voucher.getDate("bizdate")));
                    awsVoucherParamMap.put("accountDate", sdf.format(voucher.getDate("bookeddate")));
                    awsVoucherInfos.add(awsVoucherParamMap);
                }
            }
            HashMap<String, Object> awsParamMap = new HashMap<String, Object>(8);
            awsParamMap.put("voucherInfo", awsVoucherInfos);
            awsParamMap.put("expenseId", "ap_invoice_" + invoice.getLong("id"));
            HashMap<String, Object> awsInvoiceParamMap = new HashMap<String, Object>(2);
            awsInvoiceParamMap.put("serialNo", invoice.get("serialno"));
            awsInvoiceParamMap.put("deductionFlag", invoice.getBoolean("istaxdeduction") ? "1" : "0");
            awsParamMap.put("invoiceData", Collections.singletonList(awsInvoiceParamMap));
            boolean isSuccess = this.callAwsUpdateVoucher(invoiceCloudCfgMap, awsParamMap, invoice.getLong("org.id"));
            if (!isSuccess) continue;
            needUpdateSynStatusInvs.add(invoice);
        }
        this.updateInvoiceSynStatus(needUpdateSynStatusInvs);
        logger.info("CallOldCloudServiceImpl updateCloudInvoicePool end.");
        return null;
    }

    private boolean callAwsUpdateVoucher(Map<Long, InvoiceCloudCfg> invoiceCloudCfgMap, Map<String, Object> awsParamMap, long orgId) {
        InvoiceCloudCfg config = invoiceCloudCfgMap.get(orgId);
        if (config == null) {
            config = KingdeeInvoiceCloudConfig.getConfig(orgId);
            invoiceCloudCfgMap.put(orgId, config);
        }
        logger.info("CallOldCloudServiceImpl callAwsUpdateVoucher awsParamMap is " + awsParamMap);
        GenVoucherAction genVoucherAction = new GenVoucherAction(this.getTaxNo(orgId), awsParamMap);
        Map<?, ?> response = APIHelper.invokeAction(genVoucherAction);
        Object errCode = response.get("errcode");
        if ("0000".equals(errCode)) {
            logger.info("CallOldCloudServiceImpl : callAwsUpdateVoucher is success ! ");
            return true;
        }
        Object desc = response.get("description");
        logger.info("CallOldCloudServiceImpl : callAwsUpdateVoucher exist error ! error message is : " + desc + "(" + errCode + ")");
        return false;
    }

    private String getTaxNo(DynamicObject org) {
        InvoiceCloudCfg config;
        String taxRegNum = "";
        if (KingdeeInvoiceCloudConfig.isGroupPattern()) {
            config = KingdeeInvoiceCloudConfig.getConfig((Long)org.getPkValue());
            String taxRegnums = config.getTaxRegnum();
            taxRegNum = taxRegnums.split("=")[0];
        }
        if (StringUtils.isEmpty(taxRegNum)) {
            config = KingdeeInvoiceCloudConfig.getConfig(org);
            taxRegNum = config.getTaxRegnum();
        }
        return taxRegNum;
    }

    private String getTaxNo(Long orgId) {
        InvoiceCloudCfg config;
        String taxRegNum = "";
        if (KingdeeInvoiceCloudConfig.isGroupPattern()) {
            config = KingdeeInvoiceCloudConfig.getConfig(orgId);
            String taxRegnums = config.getTaxRegnum();
            taxRegNum = taxRegnums.split("=")[0];
        }
        if (StringUtils.isEmpty(taxRegNum)) {
            config = KingdeeInvoiceCloudConfig.getConfig(orgId);
            taxRegNum = config.getTaxRegnum();
        }
        logger.info("CallOldCloudServiceImpl getTaxNo orgid is " + orgId + ",taxRegNum is " + taxRegNum);
        return taxRegNum;
    }
}

