/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.journal;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.fi.arapcommon.util.EntityMetadataUtils;
import kd.fi.arapcommon.util.StringUtils;

public class BillJournalMapperEdit
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"apbillentity", "arbillentity", "billentity", "billfield", "journalfield"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String journalEntity = (String)this.getModel().getValue("journalentity");
        this.setComboFields(journalEntity, "journalfield");
    }

    public void afterBindData(EventObject e) {
        String journalentity;
        super.afterBindData(e);
        IDataModel model = this.getModel();
        String billentity = (String)model.getValue("billentity");
        boolean isAr = "ar".equals(model.getValue("app"));
        if (StringUtils.isNotEmpty(billentity)) {
            model.beginInit();
            model.setValue(isAr ? "arbillentity" : "apbillentity", (Object)billentity);
            model.endInit();
            this.getView().updateView(isAr ? "arbillentity" : "apbillentity");
            this.setComboFields(billentity, "billfield");
            model.setValue("billfield", model.getValue("billkey"));
        }
        if (StringUtils.isNotEmpty(journalentity = (String)model.getValue("journalentity"))) {
            this.setComboFields(journalentity, "journalfield");
            model.setValue("journalfield", model.getValue("journalkey"));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        IDataModel model = this.getModel();
        if ("app".equals(key)) {
            this.appChanged(model);
        } else if ("apbillentity".equals(key) || "arbillentity".equals(key)) {
            String billEntity = (String)this.getModel().getValue(key);
            this.billEntityChanged(model);
            model.setValue("billentity", (Object)billEntity);
            this.setComboFields(billEntity, "billfield");
        } else if ("billfield".equals(key)) {
            model.setValue("billkey", model.getValue("billfield"));
        } else if ("journalfield".equals(key)) {
            model.setValue("journalkey", model.getValue("journalfield"));
        } else if ("journalentity".equals(key)) {
            String journalEntity = (String)this.getModel().getValue(key);
            this.setComboFields(journalEntity, "journalfield");
        }
    }

    private void appChanged(IDataModel model) {
        model.setValue("apbillentity", null);
        model.setValue("arbillentity", null);
        model.setValue("billentity", null);
        model.setValue("billfield", null);
        model.setValue("billkey", null);
        model.setValue("journalfield", null);
        model.setValue("journalkey", null);
    }

    private void billEntityChanged(IDataModel model) {
        model.setValue("billentity", null);
        model.setValue("billfield", null);
        model.setValue("billkey", null);
    }

    private void setComboFields(String entityKey, String field) {
        if (StringUtils.isEmpty(entityKey)) {
            return;
        }
        List<IDataEntityProperty> properties = EntityMetadataUtils.getProperties(entityKey);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(properties.size());
        for (IDataEntityProperty prop : properties) {
            LocaleString displayName = prop.getDisplayName();
            if (displayName == null) continue;
            LocaleString dis = new LocaleString(displayName.getLocaleValue() + "(" + prop.getName() + ")");
            items.add(new ComboItem(dis, prop.getName()));
        }
        ComboEdit edit = (ComboEdit)this.getControl(field);
        edit.setComboItems(items);
    }
}

