/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.journal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.journal.JournalCheckResult;
import kd.fi.arapcommon.journal.convert.SrPushJournalSetting;
import kd.fi.arapcommon.journal.convert.SrPushJournalSettingFactory;
import kd.fi.arapcommon.util.DateUtils;

public class CheckJournalService {
    private Long[] orgIds;
    private Date startDate;
    private Date stopDate;
    private static String[] apSourceEntityKeys = new String[]{"ap_finapbill", "ap_busbill", "ap_paidbill", "cas_paybill"};
    private static String[] arSourceEntityKeys = new String[]{"ar_finarbill", "ar_busbill", "ar_receivedbill", "cas_recbill"};
    private List<JournalCheckResult> resultList = new ArrayList<JournalCheckResult>();
    private String journalEntityKey;
    private HashSet<Long> idSet = new HashSet();
    private Map<String, SrPushJournalSetting> relationSettingCache = new HashMap<String, SrPushJournalSetting>();

    public CheckJournalService(Long[] orgIds, Date startDate, Date stopDate, String app) {
        this.orgIds = orgIds;
        this.startDate = DateUtils.getDataFormat(startDate, true);
        this.stopDate = DateUtils.getDataFormat(stopDate, false);
        this.journalEntityKey = "ap".equals(app) ? "ap_journal" : "ar_journal";
    }

    public List<JournalCheckResult> check(String app) {
        if ("ap".equals(app)) {
            this.checkApBills();
            SettleRelationEnum[] apSettleRelations = SettleRelationEnum.getApSettleRelation();
            this.checkSettleRecord(apSettleRelations, "ap_settlerecord");
            return this.resultList;
        }
        this.checkArBills();
        SettleRelationEnum[] arSettleRelations = SettleRelationEnum.getArSettleRelation();
        this.checkSettleRecord(arSettleRelations, "ar_settlerecord");
        return this.resultList;
    }

    private void checkApBills() {
        for (String sourceEntityKey : apSourceEntityKeys) {
            this.checkBizBills(sourceEntityKey);
        }
    }

    private List<JournalCheckResult> checkArBills() {
        for (String sourceEntityKey : arSourceEntityKeys) {
            this.checkBizBills(sourceEntityKey);
        }
        return this.resultList;
    }

    private void checkBizBills(String sourceEntityKey) {
        QFilter billStatusFilter = null;
        billStatusFilter = "cas_paybill".equals(sourceEntityKey) || "cas_recbill".equals(sourceEntityKey) ? new QFilter("billstatus", "=", (Object)"D") : this.getBillStatusFilter(false);
        Object[] bizBills = BusinessDataServiceHelper.load((String)sourceEntityKey, (String)"id,billno", (QFilter[])new QFilter[]{this.getBillDateFilter("bizdate"), billStatusFilter, this.getOrgFilter()});
        if (ObjectUtils.isEmpty((Object[])bizBills)) {
            return;
        }
        Long[] billIds = this.getIds((DynamicObject[])bizBills, "id");
        QFilter billTypeFilter = new QFilter("sourcebilltype", "=", (Object)sourceEntityKey);
        DynamicObject[] journals = BusinessDataServiceHelper.load((String)"ar_journal", (String)"id,sourcebillid", (QFilter[])new QFilter[]{this.getOrgFilter(), this.getJournalDateFilter(), billTypeFilter});
        Long[] sourceBillIds = this.getIds(journals, "sourcebillid");
        this.repetitiveError(sourceEntityKey, (DynamicObject[])bizBills, journals, sourceBillIds);
        this.noJournalError(sourceEntityKey, (DynamicObject[])bizBills, billIds);
        this.noBizBillError(sourceEntityKey, billIds, journals, sourceBillIds);
    }

    private void checkSettleRecord(SettleRelationEnum[] settleRelations, String sourceEntityKey) {
        DynamicObject[] apJournals = BusinessDataServiceHelper.load((String)"ap_journal", (String)"id,sourcebillid,sourceentryid", (QFilter[])new QFilter[]{new QFilter("sourcebilltype", "=", (Object)sourceEntityKey), this.getJournalDateFilter(), this.getOrgFilter()});
        DynamicObject[] arJournals = BusinessDataServiceHelper.load((String)"ar_journal", (String)"id,sourcebillid,sourceentryid", (QFilter[])new QFilter[]{new QFilter("sourcebilltype", "=", (Object)sourceEntityKey), this.getJournalDateFilter(), this.getOrgFilter()});
        LinkedList<DynamicObject> journals = new LinkedList<DynamicObject>();
        journals.addAll(Arrays.asList(apJournals));
        journals.addAll(Arrays.asList(arJournals));
        ArrayList<DynamicObject> mainJournalList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> asstastJournalList = new ArrayList<DynamicObject>();
        for (DynamicObject journal : journals) {
            if (journal.getLong("sourceentryid") == 0L) {
                mainJournalList.add(journal);
                continue;
            }
            asstastJournalList.add(journal);
        }
        QFilter relationFilter = new QFilter("settlerelation", "in", (Object)settleRelations);
        DynamicObject[] settleRecords = BusinessDataServiceHelper.load((String)sourceEntityKey, (String)"id,settlerelation,billno,entry", (QFilter[])new QFilter[]{relationFilter, this.getOrgFilter(), this.getBillDateFilter("settledate")});
        LinkedList<DynamicObject> settleRecordsToCheck = new LinkedList<DynamicObject>();
        Long[] mainSettleRecordIds = this.getIds(settleRecords, "id");
        ArrayList<Object> asstastSettleRecordIdList = new ArrayList<Object>();
        for (DynamicObject settleRecord : settleRecords) {
            SrPushJournalSetting setting = this.getRelationSetting(settleRecord.getString("settlerelation"));
            if (setting.getMainJournalType() != null) {
                settleRecordsToCheck.add(settleRecord);
            }
            if (setting.getAsstJournalType() == null) continue;
            DynamicObjectCollection asstastSettleRecords = settleRecord.getDynamicObjectCollection("entry");
            for (DynamicObject asstastSettleRecord : asstastSettleRecords) {
                asstastSettleRecordIdList.add(asstastSettleRecord.getPkValue());
            }
        }
        DynamicObject[] mainJournals = mainJournalList.toArray(new DynamicObject[0]);
        Long[] mainSourceBillIds = this.getIds(mainJournals, "sourcebillid");
        this.repetitiveError(sourceEntityKey, settleRecords, mainJournals, mainSourceBillIds);
        this.noJournalError(sourceEntityKey, settleRecords, mainSettleRecordIds);
        this.noBizBillError(sourceEntityKey, mainSettleRecordIds, mainJournals, mainSourceBillIds);
        DynamicObject[] asstastJournals = asstastJournalList.toArray(new DynamicObject[0]);
        Long[] asstastSourceBillIds = this.getIds(asstastJournals, "sourceentryid");
        Long[] asstastSettleRecordIds = asstastSettleRecordIdList.toArray(new Long[0]);
        this.repetitiveError(sourceEntityKey, settleRecords, asstastJournals, asstastSourceBillIds);
        this.noJournalError(sourceEntityKey, settleRecords, asstastSettleRecordIds);
        this.noBizBillError(sourceEntityKey, asstastSettleRecordIds, asstastJournals, asstastSourceBillIds);
    }

    private SrPushJournalSetting getRelationSetting(String relation) {
        SettleRelationEnum[] values;
        SrPushJournalSetting srPushJournalSetting = this.relationSettingCache.get(relation);
        if (srPushJournalSetting != null) {
            return srPushJournalSetting;
        }
        for (SettleRelationEnum settleRelation : values = SettleRelationEnum.values()) {
            if (!settleRelation.getValue().equals(relation)) continue;
            srPushJournalSetting = SrPushJournalSettingFactory.getSetting(settleRelation);
            this.relationSettingCache.put(relation, srPushJournalSetting);
            return srPushJournalSetting;
        }
        throw new IllegalArgumentException("relation does not exist");
    }

    private void noBizBillError(String sourceEntityKey, Long[] billIds, DynamicObject[] journals, Long[] sourceBillIds) {
        String errorType = "NoSourceBill";
        List<Long> noBizBillIdSet = this.getNoBizBillIdSet(sourceBillIds, billIds);
        for (Long sourceBillId : noBizBillIdSet) {
            for (DynamicObject journal : journals) {
                if (sourceBillId.longValue() != journal.getLong("sourcebillid")) continue;
                String journalId = journal.getString("id");
                this.fillResultList(this.journalEntityKey, journalId, errorType, sourceEntityKey);
            }
        }
    }

    private void repetitiveError(String sourceEntityKey, DynamicObject[] bizBills, DynamicObject[] journals, Long[] sourceBillIds) {
        String errorType = "RepetitiveJournals";
        List<Long> errorSouBillIdSet = this.getSourceBillIdList(sourceBillIds);
        for (Long billId : errorSouBillIdSet) {
            ArrayList<String> journalIds = new ArrayList<String>();
            String billNo = null;
            for (DynamicObject journal : journals) {
                if (billId.longValue() != journal.getLong("sourcebillid")) continue;
                journalIds.add(journal.getString("id"));
                for (DynamicObject bizBill : bizBills) {
                    if (billId.longValue() != bizBill.getLong("id")) continue;
                    billNo = bizBill.getString("billno");
                }
            }
            this.fillResultList(sourceEntityKey, billNo, errorType, String.join((CharSequence)",", journalIds));
        }
    }

    private void noJournalError(String sourceEntityKey, DynamicObject[] bizBills, Long[] billIds) {
        String errorType = "NoJournal";
        List<Long> noJournalIdSet = this.getNoJournalIdSet(billIds);
        for (Long billId : noJournalIdSet) {
            for (DynamicObject bizBill : bizBills) {
                if (billId.longValue() != bizBill.getLong("id")) continue;
                String billNo = bizBill.getString("billno");
                this.fillResultList(sourceEntityKey, billNo, errorType, null);
            }
        }
    }

    private void fillResultList(String sourceEntityKey, String billNo, String errorType, String supplement) {
        JournalCheckResult result = new JournalCheckResult();
        result.setBillType(sourceEntityKey);
        result.setBillNo(billNo);
        result.setErrorType(errorType);
        result.setSupplement(supplement);
        this.resultList.add(result);
    }

    private List<Long> getSourceBillIdList(Long[] sourceBillIds) {
        ArrayList<Long> errorIdList = new ArrayList<Long>();
        for (Long sourceBillId : sourceBillIds) {
            if (this.idSet.add(sourceBillId)) continue;
            errorIdList.add(sourceBillId);
        }
        return errorIdList;
    }

    private List<Long> getNoJournalIdSet(Long[] billIds) {
        ArrayList<Long> errorIdList = new ArrayList<Long>();
        for (Long billId : billIds) {
            if (this.idSet.contains(billId)) continue;
            errorIdList.add(billId);
        }
        return errorIdList;
    }

    private List<Long> getNoBizBillIdSet(Long[] sourceBillIds, Long[] billIds) {
        ArrayList<Long> errorIdList = new ArrayList<Long>();
        for (Long sourceBillId : sourceBillIds) {
            if (Arrays.asList(billIds).contains(sourceBillId)) continue;
            errorIdList.add(sourceBillId);
        }
        return errorIdList;
    }

    private Long[] getIds(DynamicObject[] bills, String key) {
        if (bills == null) {
            return new Long[0];
        }
        Long[] pks = new Long[bills.length];
        for (int i = 0; i < bills.length; ++i) {
            pks[i] = bills[i].getLong(key);
        }
        return pks;
    }

    private QFilter getOrgFilter() {
        QFilter orgFilter = new QFilter("org", "in", (Object)this.orgIds);
        return orgFilter;
    }

    private QFilter getBillDateFilter(String dateName) {
        QFilter dateFilter = new QFilter(dateName, ">=", (Object)this.startDate);
        dateFilter.and(dateName, "<=", (Object)this.stopDate);
        return dateFilter;
    }

    private QFilter getJournalDateFilter() {
        QFilter dateFilter = new QFilter("bizdate", ">=", (Object)this.startDate);
        dateFilter.and("bizdate", "<=", (Object)this.stopDate);
        return dateFilter;
    }

    private QFilter getBillStatusFilter(boolean isSettleRecord) {
        if (isSettleRecord) {
            return null;
        }
        QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)"C");
        return billStatusFilter;
    }
}

