/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.journal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.helper.SettingMapperHelper;
import kd.fi.arapcommon.journal.JournalService;
import kd.fi.arapcommon.journal.convert.JournalConverter;
import kd.fi.arapcommon.journal.enums.BillCheckEnum;

public class JournalRebuildService {
    private List<Long> orgIds;
    private Date startDate;
    private Date stopDate;
    private static final int BATCHQUERYCOUNT = 5000;

    public JournalRebuildService(Date startDate, Date stopDate) {
        this.startDate = startDate;
        this.stopDate = stopDate;
    }

    public JournalRebuildService(List<Long> orgIds, Date startDate, Date stopDate) {
        this.orgIds = orgIds;
        this.startDate = startDate;
        this.stopDate = stopDate;
    }

    public void rebuild(String app) {
        if ("ap".equals(app)) {
            this.rebuildApBills(app, null);
        } else {
            this.rebuildArBills(app, null);
        }
    }

    public void rebuild(String app, String formId) {
        if ("ap".equals(app)) {
            this.rebuildApBills(app, formId);
        } else {
            this.rebuildArBills(app, formId);
        }
    }

    private void rebuildApBills(String app, String formId) {
        if (formId != null) {
            this.rebuildBillJournals(formId);
        } else {
            BillCheckEnum[] enums;
            for (BillCheckEnum checkEnum : enums = BillCheckEnum.values()) {
                if (checkEnum.isAr()) continue;
                this.rebuildBillJournals(checkEnum.getValue());
            }
        }
    }

    private void rebuildArBills(String app, String formId) {
        if (formId != null) {
            this.rebuildBillJournals(formId);
        } else {
            BillCheckEnum[] enums;
            for (BillCheckEnum checkEnum : enums = BillCheckEnum.values()) {
                if (!checkEnum.isAr()) continue;
                this.rebuildBillJournals(checkEnum.getValue());
            }
        }
    }

    private void deleteJournals(String app, String formId) {
        String journalKey = app + "_journal";
        List<QFilter> filters = this.getFilters(journalKey);
        if (formId != null) {
            filters.add(new QFilter("sourcebilltype", "=", (Object)formId));
        }
        DynamicObjectCollection journals = QueryServiceHelper.query((String)journalKey, (String)"id", (QFilter[])filters.toArray(new QFilter[0]));
        Object[] journalIds = this.getPks(journals);
        OperationResult executeOperate = OperationServiceHelper.executeOperate((String)"delete", (String)journalKey, (Object[])journalIds, (OperateOption)OperateOption.create());
        this.logErrPk(journalKey, executeOperate, (Long[])journalIds);
    }

    private void rebuildBillJournals(String sourceEntityKey) {
        List<QFilter> filters = this.getFilters(sourceEntityKey);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"JournalRebuildEdit-query", (String)sourceEntityKey, (String)"id", (QFilter[])filters.toArray(new QFilter[0]), (String)"id");
        ArrayList<Long> idList = new ArrayList<Long>(64);
        if (!dataSet.isEmpty()) {
            for (Row row : dataSet) {
                idList.add(row.getLong("id"));
                if (idList.size() != 5000) continue;
                this.delAndSaveJournals(idList, sourceEntityKey);
            }
            if (!idList.isEmpty()) {
                this.delAndSaveJournals(idList, sourceEntityKey);
            }
        }
    }

    private void delAndSaveJournals(List<Long> longIds, String sourceEntityKey) {
        try (TXHandle tx = TX.requiresNew();){
            JournalService journalService = new JournalService();
            JournalConverter journalConverter = journalService.getConverter(sourceEntityKey);
            DynamicObject[] bills = BusinessDataServiceHelper.load((Object[])longIds.toArray(new Long[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)sourceEntityKey));
            journalService.deleteJournals(sourceEntityKey, longIds.toArray(new Long[0]));
            try {
                List<DynamicObject> journals = journalConverter.convert(bills);
                this.save(journals);
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    private void save(Collection<DynamicObject> journals) {
        Map<String, List<DynamicObject>> groupByJournals = journals.stream().collect(Collectors.groupingBy(journal -> journal.getDataEntityType().getName()));
        for (List<DynamicObject> eachTypeJournals : groupByJournals.values()) {
            SaveServiceHelper.save((DynamicObject[])eachTypeJournals.toArray(new DynamicObject[0]));
        }
    }

    private void logErrPk(String entityKey, OperationResult executeOperate, Long[] pks) {
        List successPkIds = executeOperate.getSuccessPkIds();
        for (Long pk : pks) {
            if (successPkIds.contains(pk)) continue;
            this.logErrPk(entityKey, pk);
        }
    }

    private void logErrPk(String entityKey, Long pk) {
        SettingMapperHelper.saveOrUpdate("JournalRebuild.pk", pk.toString(), entityKey);
    }

    private Long[] getPks(DynamicObjectCollection journals) {
        if (journals == null) {
            return new Long[0];
        }
        Long[] pks = new Long[journals.size()];
        for (int i = 0; i < journals.size(); ++i) {
            pks[i] = ((DynamicObject)journals.get(i)).getLong("id");
        }
        return pks;
    }

    private List<QFilter> getFilters(String entityKey) {
        List settleRealtions;
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        if (this.orgIds != null && !this.orgIds.isEmpty()) {
            filters.add(new QFilter("org", "in", this.orgIds));
        }
        String dateFieldKey = "bizdate";
        if ("ap_settlerecord".equals(entityKey) || "ar_settlerecord".equals(entityKey)) {
            dateFieldKey = "settledate";
        }
        QFilter dateRangeFilter = new QFilter(dateFieldKey, ">=", (Object)this.startDate).and(dateFieldKey, "<=", (Object)this.stopDate);
        filters.add(dateRangeFilter);
        String billStatus = "C";
        if ("cas_paybill".equals(entityKey) || "cas_recbill".equals(entityKey)) {
            billStatus = "D";
        }
        QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)billStatus);
        if (!("ap_settlerecord".equals(entityKey) || "ar_settlerecord".equals(entityKey) || "ap_journal".equals(entityKey) || "ar_journal".equals(entityKey) || "cas_paybill".equals(entityKey))) {
            filters.add(billStatusFilter);
        }
        if ("cas_recbill".equals(entityKey)) {
            filters.add(new QFilter("receivingtype.ispartreceivable", "=", (Object)Boolean.TRUE));
        }
        if ("cas_paybill".equals(entityKey)) {
            filters.add(new QFilter("paymenttype.ispartpayment", "=", (Object)Boolean.TRUE));
            filters.add(new QFilter("billstatus", "in", (Object)new String[]{"D", "F", "I"}));
        }
        if ("ap_settlerecord".equals(entityKey)) {
            SettleRelationEnum[] apSettleRelation = SettleRelationEnum.getApSettleRelation();
            settleRealtions = Arrays.asList(apSettleRelation).stream().map(SettleRelationEnum::getValue).collect(Collectors.toList());
            filters.add(new QFilter("settlerelation", "in", settleRealtions));
        }
        if ("ar_settlerecord".equals(entityKey)) {
            SettleRelationEnum[] arSettleRelation = SettleRelationEnum.getArSettleRelation();
            settleRealtions = Arrays.asList(arSettleRelation).stream().map(SettleRelationEnum::getValue).collect(Collectors.toList());
            filters.add(new QFilter("settlerelation", "in", settleRealtions));
        }
        return filters;
    }
}

