/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.journal;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.DateEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.arapcommon.journal.JournalRebuildService;
import kd.fi.arapcommon.journal.enums.BillCheckEnum;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.StringUtils;

public class RebuildJournalEdit
extends AbstractFormPlugin {
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        IDataModel m = this.getModel();
        DynamicObject entity = m.getDataEntity();
        switch (key) {
            case "app": {
                String app = (String)this.getModel().getValue("app");
                if ("ap".equals(app)) {
                    this.clearEntryValue("entryentity");
                    this.setApBillsDefaultValue();
                }
                if ("ar".equals(app)) {
                    this.clearEntryValue("entryentity");
                    this.setArBillsDefaultValue();
                }
                m.setValue("formbill", null);
                this.setSourceBill();
                break;
            }
            case "curperiod": {
                m.setValue("org", null);
                m.setValue("startdate", null);
                m.setValue("stopdate", null);
                Date beginDate = entity.getDate("curperiod.begindate");
                Date endDate = entity.getDate("curperiod.enddate");
                DateEdit startEdit = (DateEdit)this.getControl("startdate");
                startEdit.setMinDate(beginDate);
                startEdit.setMaxDate(endDate);
                DateEdit stopEdit = (DateEdit)this.getControl("stopdate");
                stopEdit.setMinDate(beginDate);
                stopEdit.setMaxDate(endDate);
                break;
            }
        }
    }

    private void filterOrgSelect() {
        BasedataEdit orgF7 = (BasedataEdit)this.getControl("org");
        orgF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject entity = this.getModel().getDataEntity();
            String app = entity.getString("app");
            Long curperId = entity.getLong("curperiod.id");
            if (!ObjectUtils.isEmpty((Object)curperId)) {
                DynamicObjectCollection inits = QueryServiceHelper.query((String)(app + "_init"), (String)"org", (QFilter[])new QFilter[]{new QFilter("curperiod.id", "=", (Object)curperId).and("isfinishinit", "=", (Object)Boolean.TRUE)});
                Set curPerOrgIds = inits.stream().map(t -> t.getLong("org")).collect(Collectors.toSet());
                QFilter filter = new QFilter("id", "in", curPerOrgIds);
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
                listFilterParameter.setFilter(filter);
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setApBillsDefaultValue();
        this.setSourceBill();
    }

    private void setApBillsDefaultValue() {
        int row0 = this.getModel().createNewEntryRow("entryentity");
        this.getModel().setValue("sourcebill", (Object)"ap_finapbill", row0);
        int row1 = this.getModel().createNewEntryRow("entryentity");
        this.getModel().setValue("sourcebill", (Object)"ap_busbill", row1);
        int row2 = this.getModel().createNewEntryRow("entryentity");
        this.getModel().setValue("sourcebill", (Object)"ap_paidbill", row2);
        int row3 = this.getModel().createNewEntryRow("entryentity");
        this.getModel().setValue("sourcebill", (Object)"ap_settlerecord", row3);
    }

    private void setArBillsDefaultValue() {
        int row0 = this.getModel().createNewEntryRow("entryentity");
        this.getModel().setValue("sourcebill", (Object)"ar_finarbill", row0);
        int row1 = this.getModel().createNewEntryRow("entryentity");
        this.getModel().setValue("sourcebill", (Object)"ar_busbill", row1);
        int row2 = this.getModel().createNewEntryRow("entryentity");
        this.getModel().setValue("sourcebill", (Object)"ar_receivedbill", row2);
        int row3 = this.getModel().createNewEntryRow("entryentity");
        this.getModel().setValue("sourcebill", (Object)"ar_settlerecord", row3);
    }

    private void setSourceBill() {
        BillCheckEnum[] BillCheckEnumArry;
        IDataModel m = this.getModel();
        String app = (String)m.getValue("app");
        boolean isAr = "ar".equals(app);
        ComboEdit item = (ComboEdit)this.getControl("formbill");
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        for (BillCheckEnum billCheckEnum : BillCheckEnumArry = BillCheckEnum.values()) {
            if (billCheckEnum.isAr() != isAr) continue;
            items.add(new ComboItem(new LocaleString(billCheckEnum.getName()), billCheckEnum.getValue()));
        }
        item.setComboItems(items);
    }

    private void clearEntryValue(String entryEntity) {
        this.getModel().deleteEntryData(entryEntity);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"rebuild"});
        this.addClickListeners(new String[]{"refreshresult"});
        this.filterOrgSelect();
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        DynamicObject rebuildBill = this.getModel().getDataEntity();
        String app = rebuildBill.getString("app");
        Date startDate = rebuildBill.getDate("startdate");
        Date stopDate = rebuildBill.getDate("stopdate");
        String formBill = rebuildBill.getString("formbill");
        DynamicObjectCollection orgs = rebuildBill.getDynamicObjectCollection("org");
        ArrayList<Long> orgIds = new ArrayList<Long>(10);
        if (orgs != null && orgs.size() > 0 && startDate != null && stopDate != null && StringUtils.isNotEmpty(formBill)) {
            for (DynamicObject org : orgs) {
                DynamicObject orgBill = org.getDynamicObject("fbasedataid");
                Long orgId = orgBill.getLong("id");
                orgIds.add(orgId);
            }
            switch (key) {
                case "rebuild": {
                    Date standardStartDate = DateUtils.getDataFormat(startDate, true);
                    Date standardStopDate = DateUtils.getDataFormat(stopDate, false);
                    JournalRebuildService journalRebuildService = new JournalRebuildService(orgIds, standardStartDate, standardStopDate);
                    journalRebuildService.rebuild(app, rebuildBill.getString("formbill"));
                    this.clearEntryValue("failureentry");
                    this.setFailureEntry(app);
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u91cd\u5efa\u6d41\u6c34\u6210\u529f\u3002", (String)"RebuildJournalEdit_0", (String)"fi-arapcommon", (Object[])new Object[0]));
                    break;
                }
                case "refreshresult": {
                    this.queryJournal(app);
                    this.clearEntryValue("failureentry");
                    this.setFailureEntry(app);
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5237\u65b0\u7ed3\u679c\u6210\u529f\u3002", (String)"RebuildJournalEdit_1", (String)"fi-arapcommon", (Object[])new Object[0]));
                    break;
                }
            }
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5b58\u5728\u5fc5\u5f55\u5b57\u6bb5\u65e0\u503c\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"RebuildJournalEdit_2", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        if ("openjournalcheck".equals(key)) {
            this.showJournalChek();
        }
    }

    private void showJournalChek() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("ap_journal_check");
        this.getView().showForm(parameter);
    }

    private void setFailureEntry(String app) {
        DynamicObject[] failures;
        for (DynamicObject failure : failures = BusinessDataServiceHelper.load((String)"ap_settingmapper", (String)"key,value", (QFilter[])new QFilter[]{new QFilter("type", "=", (Object)"JournalRebuild.pk"), new QFilter("value", "like", (Object)("%" + app + "%"))})) {
            int row = this.getModel().createNewEntryRow("failureentry");
            this.getModel().setValue("key", failure.get("key"), row);
            this.getModel().setValue("value", failure.get("value"), row);
        }
    }

    private void queryJournal(String app) {
        DynamicObject[] failures = BusinessDataServiceHelper.load((String)"ap_settingmapper", (String)"key", (QFilter[])new QFilter[]{new QFilter("type", "=", (Object)"JournalRebuild.pk")});
        ArrayList<Long> keys = new ArrayList<Long>(64);
        for (DynamicObject failure : failures) {
            keys.add(failure.getLong("key"));
        }
        DynamicObject[] journals = BusinessDataServiceHelper.load((String)(app + "_journal"), (String)"sourcebillid", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", keys)});
        ArrayList<Long> ids = new ArrayList<Long>(64);
        for (DynamicObject journal : journals) {
            ids.add(journal.getLong("sourcebillid"));
        }
        DeleteServiceHelper.delete((String)"ap_settingmapper", (QFilter[])new QFilter[]{new QFilter("key", "in", ids)});
    }
}

