/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.journal.convert;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.arapcommon.helper.BaseDataHelper;
import kd.fi.arapcommon.helper.DynamicObjectHelper;
import kd.fi.arapcommon.journal.convert.JournalConverter;
import kd.fi.arapcommon.util.EntityMetadataUtils;

public abstract class JournalAutoConverter
implements JournalConverter {
    protected String sourceEntityKey;
    protected String journalKey;
    protected String entryKey;
    protected Map<String, IDataEntityProperty> mapper;
    private Map<String, IDataEntityProperty> journalFields;

    @Override
    public List<DynamicObject> convert(DynamicObject[] sourceBills) {
        this.sourceEntityKey = null;
        this.journalKey = null;
        this.entryKey = null;
        this.mapper = null;
        this.journalFields = null;
        if (sourceBills.length == 0) {
            return new ArrayList<DynamicObject>();
        }
        this.sourceEntityKey = sourceBills[0].getDataEntityType().getName();
        this.journalKey = this.getJournalType(this.sourceEntityKey);
        this.buildRelation(this.sourceEntityKey, this.journalKey);
        if (this.mapper != null) {
            for (IDataEntityProperty prop : this.mapper.values()) {
                IDataEntityType parent;
                if (prop == null || !((parent = prop.getParent()) instanceof EntryType)) continue;
                this.entryKey = parent.getName();
            }
        }
        Set<String> sourceBillRefKeys = this.getSourceBillSelectors();
        List<String> properties = EntityMetadataUtils.getProperties(sourceBills[0]);
        if (!properties.containsAll(sourceBillRefKeys)) {
            List<Long> sourcePks = DynamicObjectHelper.getLongIds(Arrays.asList(sourceBills));
            sourceBills = BusinessDataServiceHelper.load((Object[])sourcePks.toArray(), (DynamicObjectType)JournalAutoConverter.getSubEntityType(this.sourceEntityKey, sourceBillRefKeys));
        }
        ArrayList<DynamicObject> journals = new ArrayList<DynamicObject>();
        for (DynamicObject sourceBill : sourceBills) {
            journals.addAll(this.convert(sourceBill));
        }
        return journals;
    }

    protected String getJournalType(String sourceEntityKey) {
        return this.sourceEntityKey.startsWith("ap") ? "ap_journal" : "ar_journal";
    }

    protected abstract Set<String> getSourceBillSelectors();

    protected Set<String> getSourceBillDefaultSelectors() {
        return this.mapper.values().stream().filter(p -> p != null).map(IMetadata::getName).collect(Collectors.toSet());
    }

    private static DynamicObjectType getSubEntityType(String entityName, Iterable<? extends String> selectors) {
        HashSet<String> select = new HashSet<String>();
        for (String string : selectors) {
            select.add(string.trim());
        }
        return EntityMetadataCache.getSubDataEntityType((String)entityName, select);
    }

    protected List<DynamicObject> convert(DynamicObject sourceBill) {
        ArrayList<DynamicObject> journals = new ArrayList<DynamicObject>();
        if (this.entryKey == null) {
            DynamicObject journal = BusinessDataServiceHelper.newDynamicObject((String)this.journalKey);
            this.mapper.forEach((jouProp, sourceProp) -> {
                DynamicProperty masterIdProperty;
                long masterId;
                Object value = this.getValue((String)jouProp, sourceBill, null);
                if (value instanceof DynamicObject && (masterId = ((DynamicObject)value).getLong((masterIdProperty = ((DynamicObject)value).getDynamicObjectType().getProperty("masterid")) == null ? "id" : "masterid")) != 0L) {
                    value = masterId;
                }
                journal.set(jouProp, value);
            });
            journals.add(journal);
        } else {
            DynamicObjectCollection sourceEntry = sourceBill.getDynamicObjectCollection(this.entryKey);
            sourceEntry.forEach(row -> {
                DynamicObject journal = BusinessDataServiceHelper.newDynamicObject((String)this.journalKey);
                this.mapper.forEach((jouProp, sourceProp) -> {
                    DynamicProperty masterIdProperty;
                    long masterId;
                    Object value = this.getValue((String)jouProp, sourceBill, (DynamicObject)row);
                    if (value instanceof DynamicObject && (masterId = ((DynamicObject)value).getLong((masterIdProperty = ((DynamicObject)value).getDynamicObjectType().getProperty("masterid")) == null ? "id" : "masterid")) != 0L) {
                        value = masterId;
                    }
                    journal.set(jouProp, value);
                });
                journals.add(journal);
            });
        }
        return journals;
    }

    protected Object getValue(String journalField, DynamicObject sourceBill, DynamicObject row) {
        if ("sourcebilltype".equals(journalField)) {
            return this.sourceEntityKey;
        }
        if ("sourcebillid".equals(journalField)) {
            return sourceBill.getLong("id");
        }
        if ("sourceentryid".equals(journalField)) {
            return row == null ? 0L : row.getLong("id");
        }
        if ("billno".equals(journalField)) {
            return sourceBill.getString("billno");
        }
        IDataEntityProperty sourceProp = this.mapper.get(journalField);
        if (sourceProp != null) {
            IDataEntityType parent = sourceProp.getParent();
            if (parent instanceof EntryType) {
                return row.get(sourceProp.getName());
            }
            return sourceBill.get(sourceProp.getName());
        }
        IDataEntityProperty property = this.journalFields.get(journalField);
        if (property instanceof AmountProp) {
            return BigDecimal.ZERO;
        }
        return null;
    }

    private void buildRelation(String sourceEntityKey, String journalKey) {
        this.mapper = new HashMap<String, IDataEntityProperty>();
        this.journalFields = new HashMap<String, IDataEntityProperty>();
        List<IDataEntityProperty> journalProps = this.getProperties(journalKey);
        journalProps.forEach(jp -> this.journalFields.put(jp.getName(), (IDataEntityProperty)jp));
        List<IDataEntityProperty> sourceBillProps = this.getProperties(sourceEntityKey);
        Map<String, String> propertyMap = BaseDataHelper.getMapperProperties(sourceEntityKey);
        for (IDataEntityProperty jouProp : journalProps) {
            String jouFieldName = jouProp.getName();
            if ("id".equals(jouFieldName) || "seq".equals(jouFieldName) || jouFieldName.contains("_lk") || jouFieldName.endsWith("_id") || jouFieldName.endsWith("_sid")) continue;
            if ("sourcebilltype".equals(jouFieldName) || "sourcebillid".equals(jouFieldName) || "sourceentryid".equals(jouFieldName)) {
                this.mapper.put(jouFieldName, null);
                continue;
            }
            this.mapper.put(jouFieldName, this.matchProp(jouProp, sourceBillProps, propertyMap));
        }
    }

    protected IDataEntityProperty matchProp(IDataEntityProperty prop, List<IDataEntityProperty> sourceBillProps, Map<String, String> propertyMap) {
        for (IDataEntityProperty sourceProp : sourceBillProps) {
            if (prop.getName().equals(sourceProp.getName())) {
                return sourceProp;
            }
            if (propertyMap.isEmpty()) continue;
            String propName = propertyMap.get(prop.getName());
            if (!sourceProp.getName().equals(propName)) continue;
            return sourceProp;
        }
        return null;
    }

    private List<IDataEntityProperty> getProperties(String entityKey) {
        MainEntityType journalEntityDataType = MetadataServiceHelper.getDataEntityType((String)entityKey);
        ArrayList<IDataEntityProperty> props = new ArrayList<IDataEntityProperty>();
        DataEntityPropertyCollection properties = journalEntityDataType.getProperties();
        for (IDataEntityProperty prop : properties) {
            if (prop instanceof EntryProp) {
                DataEntityPropertyCollection entryProperties = ((EntryProp)prop)._collectionItemPropertyType.getProperties();
                for (IDataEntityProperty eProp : entryProperties) {
                    props.add(eProp);
                }
                continue;
            }
            props.add(prop);
        }
        return props;
    }
}

