/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.journal.service;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.journal.service.CommonjournalSelectService;
import kd.fi.arapcommon.vo.ErrCheckVo;

public class SettleRecordSelectService
extends CommonjournalSelectService {
    public SettleRecordSelectService(boolean isAr) {
        super(isAr);
    }

    @Override
    public QFilter getFilter(Set<Long> orgIds, Date beginDate, Date endDate) {
        QFilter filter = new QFilter("org", "in", orgIds);
        filter.and("settledate", ">=", (Object)beginDate);
        filter.and("settledate", "<=", (Object)endDate);
        filter.and("settlerelation", "in", this.getRelationsByApp());
        return filter;
    }

    private List<String> getRelationsByApp() {
        List<String> settleRelations;
        if (this.isAr) {
            SettleRelationEnum[] arSettleRelation = SettleRelationEnum.getArSettleRelation();
            settleRelations = Arrays.asList(arSettleRelation).stream().map(SettleRelationEnum::getValue).collect(Collectors.toList());
        } else {
            SettleRelationEnum[] apSettleRelation = SettleRelationEnum.getApSettleRelation();
            settleRelations = Arrays.asList(apSettleRelation).stream().map(SettleRelationEnum::getValue).collect(Collectors.toList());
        }
        return settleRelations;
    }

    @Override
    public Set<ErrCheckVo> getNoJournalBills(List<Long> idList, String key) {
        DynamicObjectCollection recordBills = QueryServiceHelper.query((String)key, (String)"id,entry.id,billno,settlerelation,entry.billtype", (QFilter[])new QFilter[]{new QFilter("id", "in", idList)});
        Set<String> changeReleation = this.changeReleation();
        HashSet<Long> changeJourByRelationSet = new HashSet<Long>(16);
        HashSet<Long> finHeadIds = new HashSet<Long>(16);
        HashSet<Long> entryIds = new HashSet<Long>(16);
        for (DynamicObject recordBill : recordBills) {
            String relation = recordBill.getString("settlerelation");
            Long entryId = recordBill.getLong("entry.id");
            if (changeReleation.contains(relation)) {
                changeJourByRelationSet.add(entryId);
            }
            finHeadIds.add(recordBill.getLong("id"));
            String billType = recordBill.getString("entry.billtype");
            if ("liquidation".equals(billType) || "paytrans".equals(relation) || "artransfer".equals(relation) || "baddebtloss".equals(relation) || "transwar".equals(relation)) continue;
            entryIds.add(entryId);
        }
        DynamicObjectCollection Changejournals = this.isAr ? QueryServiceHelper.query((String)"ap_journal", (String)"id,billno,sourcebillid,sourceentryid", (QFilter[])new QFilter[]{new QFilter("sourceentryid", "in", changeJourByRelationSet)}) : QueryServiceHelper.query((String)"ar_journal", (String)"id,billno,sourcebillid,sourceentryid", (QFilter[])new QFilter[]{new QFilter("sourceentryid", "in", changeJourByRelationSet)});
        Set changeJournals = Changejournals.stream().map(t -> t.getLong("sourceentryid")).collect(Collectors.toSet());
        DynamicObjectCollection journals = QueryServiceHelper.query((String)this.journalEntity, (String)"id,billno,sourcebillid,sourceentryid,biztype", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", finHeadIds)});
        HashSet<Long> journalHeadIds = new HashSet<Long>(8);
        HashSet<Long> journalEntrySet = new HashSet<Long>(8);
        for (DynamicObject journal : journals) {
            Long journalEntryId = journal.getLong("sourceentryid");
            Long journalBillId = journal.getLong("sourcebillid");
            if (journalEntryId > 0L) {
                if ("baddebtrecovery".equals(journal.getString("biztype"))) {
                    finHeadIds.remove(journalBillId);
                }
                journalEntrySet.add(journalEntryId);
                continue;
            }
            journalHeadIds.add(journalBillId);
        }
        finHeadIds.removeAll(journalHeadIds);
        entryIds.removeAll(changeJournals);
        entryIds.removeAll(journalEntrySet);
        HashSet<ErrCheckVo> errCheckVoSet = new HashSet<ErrCheckVo>(16);
        HashSet<Long> recordErrSet = new HashSet<Long>(8);
        for (DynamicObject record : recordBills) {
            Long recordId = record.getLong("id");
            Long entryId = record.getLong("entry.id");
            if (!finHeadIds.contains(recordId) && !entryIds.contains(entryId) || !recordErrSet.add(recordId)) continue;
            errCheckVoSet.add(this.setErrVo(record, key));
        }
        return errCheckVoSet;
    }

    @Override
    public Set<ErrCheckVo> setNoBillJournal(DynamicObjectCollection journals, String journalEntity) {
        HashSet notExistIds = new HashSet(10);
        Map<String, List<DynamicObject>> recordEntryMap = journals.stream().collect(Collectors.groupingBy(bill -> bill.getString("sourcebilltype")));
        for (Map.Entry<String, List<DynamicObject>> groupBill : recordEntryMap.entrySet()) {
            String key = groupBill.getKey();
            List<DynamicObject> groupJournals = groupBill.getValue();
            Set srcBillIds = groupJournals.stream().map(t -> t.getLong("sourcebillid")).collect(Collectors.toSet());
            Set srcBillEntryIds = groupJournals.stream().filter(t -> t.getLong("sourceentryid") > 0L).map(t -> t.getLong("sourceentryid")).collect(Collectors.toSet());
            DynamicObjectCollection srcBillsByHead = QueryServiceHelper.query((String)key, (String)"id,entry.id", (QFilter[])new QFilter[]{new QFilter("id", "in", srcBillIds)});
            Set existIds = srcBillsByHead.stream().map(t -> t.getLong("id")).collect(Collectors.toSet());
            Set existEntryIds = srcBillsByHead.stream().map(t -> t.getLong("entry.id")).collect(Collectors.toSet());
            srcBillIds.removeAll(existIds);
            srcBillEntryIds.removeAll(existEntryIds);
            notExistIds.addAll(srcBillEntryIds);
            notExistIds.addAll(srcBillIds);
        }
        HashSet<ErrCheckVo> errCheckVoSet = new HashSet<ErrCheckVo>(16);
        for (DynamicObject journal : journals) {
            Long srcBillId = journal.getLong("sourcebillid");
            Long srcBillEnytyId = journal.getLong("sourceentryid");
            if (!notExistIds.contains(srcBillId) && !notExistIds.contains(srcBillEnytyId)) continue;
            errCheckVoSet.add(this.setErrByItem(journal, "notbilljournal"));
        }
        return errCheckVoSet;
    }

    private Set<String> changeReleation() {
        HashSet<String> relationSet = new HashSet<String>(8);
        relationSet.addAll(Arrays.asList("aparsettle", "payrecsettle", "aprecsettle", "arapsettle", "recpaysettle", "arpaysettle"));
        return relationSet;
    }
}

