/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.kdtx.ec;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DBRoute;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.check.TxCheckUtil;
import kd.bos.kdtx.sdk.constant.GlobalSessionType;
import kd.bos.kdtx.sdk.context.DtxContext;
import kd.bos.kdtx.sdk.ext.consumer.ECServiceSwitch;
import kd.bos.kdtx.sdk.session.ec.ECGlobalSession;
import kd.bos.kdtx.sdk.session.ec.ECSession;
import kd.fi.arapcommon.util.StdConfig;
import kd.fi.arapcommon.util.StringUtils;

public class ECServiceHelper {
    public static void begin(String scenesCode) {
        ECSession session = (ECSession)DtxContext.getDtxSession();
        if (session != null && scenesCode.equals(session.getScenesCode())) {
            ECGlobalSession.begin((String)scenesCode, (DBRoute)DBRoute.of((String)"fi"), (GlobalSessionType)GlobalSessionType.REENTRANT);
        } else {
            ECGlobalSession.begin((String)scenesCode, (DBRoute)DBRoute.of((String)"fi"), (GlobalSessionType)GlobalSessionType.COMBINATION);
        }
        ECGlobalSession.setAsync((boolean)true);
    }

    public static void beginAndRegister(String scenesCode, String branchScenesCode, String cloudId, String appId, String serviceName, Param param, String bizId) {
        ECServiceHelper.begin(scenesCode);
        ECGlobalSession.register((String)cloudId, (String)appId, (String)serviceName, (Param)param, (String)branchScenesCode, (String)bizId);
    }

    public static void beginAndRegisterWithBusInfo(String scenesCode, String branchScenesCode, String cloudId, String appId, String serviceName, Param param, String bizId, List<Object> businessPks) {
        ECServiceHelper.begin(scenesCode);
        ArrayList<String> businessInfo = new ArrayList<String>(10);
        if (businessPks != null && !businessPks.isEmpty()) {
            for (Object pk : businessPks) {
                businessInfo.add(pk.toString());
            }
        }
        ECGlobalSession.register((String)cloudId, (String)appId, (String)serviceName, (Param)param, (String)branchScenesCode, businessInfo);
        ECGlobalSession.setBusinessType((String)scenesCode);
        if (businessInfo.size() > 0) {
            ECGlobalSession.setBusinessInfo(businessInfo);
        }
    }

    public static List<String> loadUnfinishedTx(String businessType, List<String> businessIds) {
        if (StringUtils.isEmpty(businessType) || ObjectUtils.isEmpty(businessIds)) {
            return new ArrayList<String>(1);
        }
        List unFinishedIds = TxCheckUtil.loadUnfinishedTx((String)businessType, businessIds);
        return unFinishedIds;
    }

    public static List<String> loadUnfinishedTx(String businessType, Set<Long> businessIds) {
        if (StringUtils.isEmpty(businessType) || ObjectUtils.isEmpty(businessIds)) {
            return new ArrayList<String>(1);
        }
        ArrayList<String> businessIdList = new ArrayList<String>(businessIds.size());
        for (Long businessId : businessIds) {
            businessIdList.add(businessId.toString());
        }
        return ECServiceHelper.loadUnfinishedTx(businessType, businessIdList);
    }

    public static boolean isVerifyImOpened() {
        return ECServiceSwitch.isOpened() && !"false".equals(StdConfig.get("verifyim_ec_enable"));
    }

    public static boolean isVerifyCalOpened() {
        return ECServiceSwitch.isOpened() && !"false".equals(StdConfig.get("verifycal_ec_enable"));
    }

    public static boolean isSettleWbOrderOpened() {
        return ECServiceSwitch.isOpened() && "true".equals(StdConfig.get("settlewborder_ec_enable"));
    }

    public static boolean isSettleWbOrderAndConOpened() {
        return ECServiceSwitch.isOpened() && !"false".equals(StdConfig.get("settlewborderandcon_ec_enable"));
    }
}

