/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.mutex.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.SqlParameter;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.id.IDService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.fi.arapcommon.consts.DBRouteConst;
import kd.fi.arapcommon.mutex.Locker;
import org.apache.commons.collections4.ListUtils;

public class DataLocker
implements Locker {
    private static final Log logger = LogFactory.getLog(DataLocker.class);
    private static final String algoKey = DataLocker.class.getName();
    protected String batchId;
    protected String entityKey;
    protected String operationKey;
    private AtomicBoolean isPrepared = new AtomicBoolean(false);

    public DataLocker(String batchId, String entityKey, String operationKey) {
        this.batchId = batchId;
        this.entityKey = entityKey;
        this.operationKey = operationKey;
    }

    @Override
    public boolean lock(String pk) {
        ArrayList<String> idList = new ArrayList<String>();
        idList.add(pk);
        Map<String, Boolean> lockMap = this.batchLock(idList);
        return lockMap.get(pk);
    }

    @Override
    public void unlock(String pk) {
        ArrayList<String> idList = new ArrayList<String>();
        idList.add(pk);
        this.batchUnlock(idList);
    }

    @Override
    public Map<String, Boolean> batchLock(List<String> idList) {
        this.prepared();
        List<String> lockedPks = this.readLock(idList);
        HashMap<String, Boolean> lockMap = new HashMap<String, Boolean>(lockedPks.size());
        for (String lockPk : lockedPks) {
            lockMap.put(lockPk, Boolean.FALSE);
        }
        List unlockPks = ListUtils.subtract(idList, lockedPks);
        if (!unlockPks.isEmpty()) {
            this.writeLock(unlockPks);
            for (String pk : unlockPks) {
                lockMap.put(pk, Boolean.TRUE);
            }
        }
        return lockMap;
    }

    private List<String> readLock(List<String> idList) {
        ArrayList<String> lockedPks = new ArrayList<String>();
        QFilter[] filters = new QFilter[]{new QFilter("entityKey", "=", (Object)this.entityKey), new QFilter("operationKey", "=", (Object)this.operationKey), new QFilter("objectId", "in", idList)};
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)algoKey, (String)"bd_datalock", (String)"id, batchID, objectId", (QFilter[])filters, null);){
            Iterator rowIterator = ds.iterator();
            if (rowIterator != null) {
                while (rowIterator.hasNext()) {
                    Row data = (Row)rowIterator.next();
                    lockedPks.add(String.valueOf(data.getLong("objectId")));
                }
            }
        }
        return lockedPks;
    }

    private void writeLock(List<String> pks) {
        String insertSQL = "INSERT INTO T_BD_DataLock (FID, FEntityKey, FOperationKey, FBatchID, FObjectID, FCreatorID, FCreateTime)  VALUES (?, ?, ?, ?, ?, ?, ?); ";
        ArrayList<SqlParameter[]> paramsList = new ArrayList<SqlParameter[]>(pks.size());
        long userID = UserServiceHelper.getCurrentUserId();
        Date currentDate = new Date();
        for (int i = 0; i < pks.size(); ++i) {
            SqlParameter[] params = new SqlParameter[7];
            long id = IDService.get().genLongId();
            params[0] = new SqlParameter(":FID", -5, (Object)id);
            params[1] = new SqlParameter(":FEntityKey", 12, (Object)this.entityKey);
            params[2] = new SqlParameter(":FOperationKey", 12, (Object)this.operationKey);
            params[3] = new SqlParameter(":FBatchID", 12, (Object)this.batchId);
            params[4] = new SqlParameter(":FObjectID", 12, (Object)pks.get(i));
            params[5] = new SqlParameter(":FUserID", -5, (Object)userID);
            params[6] = new SqlParameter(":FCreateTime", 93, (Object)currentDate);
            paramsList.add(params);
        }
        try (TXHandle handle = TX.requiresNew();){
            DB.executeBatch((DBRoute)DBRouteConst.CAS, (String)insertSQL, paramsList);
        }
    }

    @Override
    public void batchUnlock(List<String> pks) {
        this.doRelease(pks);
        if (!pks.isEmpty() && pks.size() > 0) {
            logger.info("not release bizLock = " + pks);
            throw new KDBizException("not release bizLock = " + pks);
        }
    }

    public void doRelease(List<String> pks) {
        ArrayList<Long> idList = new ArrayList<Long>();
        String querySQL = "select FID, FBatchID, FObjectID from T_BD_DataLock where FEntityKey = ? and FOperationKey = ? and FBatchID = ? ";
        Object[] params = new Object[]{this.entityKey, this.operationKey, this.batchId};
        try (DataSet ds = DB.queryDataSet((String)algoKey, (DBRoute)DBRouteConst.CAS, (String)querySQL, (Object[])params);){
            Iterator rowIterator = ds.iterator();
            if (rowIterator != null) {
                while (rowIterator.hasNext()) {
                    Row data = (Row)rowIterator.next();
                    if (pks != null) {
                        pks.remove(data.getString("FObjectID"));
                    }
                    idList.add(data.getLong("FID"));
                }
            }
        }
        String deleteSql = "Delete From T_BD_DataLock Where FID = ? ;";
        ArrayList<SqlParameter[]> paramsList = new ArrayList<SqlParameter[]>(idList.size());
        for (int i = 0; i < idList.size(); ++i) {
            SqlParameter[] param = new SqlParameter[]{new SqlParameter(":FID", -5, idList.get(i))};
            paramsList.add(param);
        }
        try (TXHandle handle = TX.requiresNew();){
            DB.executeBatch((DBRoute)DBRouteConst.CAS, (String)deleteSql, paramsList);
        }
    }

    private void prepared() {
        if (!this.isPrepared.get()) {
            this.createBasePath();
            this.isPrepared.set(true);
        }
    }

    private void createBasePath() {
    }
}

