/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.openapi;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.operate.webapi.AbstractOperateWebApi;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.arapcommon.enums.BillSrcTypeEnum;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.helper.OrgHelper;
import kd.fi.arapcommon.openapi.info.SingleBillResult;
import kd.fi.arapcommon.util.StringUtils;

public abstract class BillSaveApi
implements IBillWebApiPlugin {
    private static final Log logger = LogFactory.getLog(BillSaveApi.class);
    private final Map<String, Object> materialCache = new HashMap<String, Object>();
    protected String entityKey;
    private boolean isAr = false;

    public BillSaveApi(boolean isAr) {
        this.isAr = isAr;
    }

    public ApiResult doCustomService(Map<String, Object> params) {
        ApiResult result = null;
        this.entityKey = (String)params.get("formid");
        if (StringUtils.isEmpty(this.entityKey)) {
            result = ApiResult.fail((String)ResManager.loadKDString((String)"formid\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"BillSaveApi_0", (String)"fi-arapcommon", (Object[])new Object[0]), (String)"1001");
        } else {
            logger.info("---param formid = " + this.entityKey);
            MainEntityType dt = MetadataServiceHelper.getDataEntityType((String)this.entityKey);
            String entityName = dt.getDisplayName().getLocaleValue();
            ArrayList datas = (ArrayList)params.get("datas");
            IDataEntityProperty billTypeProp = dt.findProperty(((BillEntityType)dt).getBillType());
            Object[] objs = null;
            if (billTypeProp != null) {
                QFilter qFilter = new QFilter("billformid", "=", (Object)this.entityKey);
                Map objMap = BusinessDataServiceHelper.loadFromCache((String)"bos_billtype", (String)"id, number, name", (QFilter[])new QFilter[]{qFilter});
                objs = objMap.values().toArray(new DynamicObject[0]);
            }
            HashMap<String, Boolean> orgMap = new HashMap<String, Boolean>();
            List<Long> permOrgs = OrgHelper.getAuthorizedBankOrgIds(this.isAr ? "ar" : "ap", this.entityKey, "47156aff000000ac");
            ArrayList<SingleBillResult> allResults = new ArrayList<SingleBillResult>(datas.size());
            ArrayList<Map<String, Object>> impDatas = new ArrayList<Map<String, Object>>();
            TreeMap<Integer, Integer> mapping = new TreeMap<Integer, Integer>();
            int dIndex = 0;
            for (int i = 0; i < datas.size(); ++i) {
                LinkedHashMap data = (LinkedHashMap)datas.get(i);
                LinkedHashMap orgData = (LinkedHashMap)data.get("org");
                String message = null;
                String orgNum = null;
                String orgName = null;
                if (!ObjectUtils.isEmpty((Object)orgData)) {
                    orgNum = (String)orgData.get("number");
                    orgName = (String)orgData.get("name");
                }
                boolean isAuth = false;
                if (StringUtils.isEmpty(orgNum) && StringUtils.isEmpty(orgName)) {
                    message = ResManager.loadKDString((String)"\u8bf7\u8865\u5145\u201c\u7ed3\u7b97\u7ec4\u7ec7\u201d\u3002", (String)"BillSaveApi_1", (String)"fi-arapcommon", (Object[])new Object[0]);
                } else {
                    DynamicObject org = null;
                    if (StringUtils.isEmpty(orgNum)) {
                        QFilter qFilter = new QFilter("name", "=", (Object)orgName);
                        org = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id, number, name", (QFilter[])new QFilter[]{qFilter});
                        if (ObjectUtils.isEmpty((Object)org)) {
                            message = String.format(ResManager.loadKDString((String)"\u201c\u7ed3\u7b97\u7ec4\u7ec7\u201d\u6570\u636e\u4e0d\u5b58\u5728\uff1a\u540d\u79f0\u201c%s\u201d\u3002", (String)"BillSaveApi_2", (String)"fi-arapcommon", (Object[])new Object[0]), orgName);
                        } else {
                            orgNum = org.getString("number");
                        }
                    }
                    if (message == null) {
                        if (!orgMap.containsKey(orgNum)) {
                            message = this.checkMainOrg(orgNum, permOrgs, entityName, org);
                            isAuth = message == null;
                            orgMap.put(orgNum, isAuth);
                        } else {
                            isAuth = (Boolean)orgMap.get(orgNum);
                        }
                    }
                }
                if (message == null && !ObjectUtils.isEmpty((Object[])objs)) {
                    message = this.checkBillType(data.get(billTypeProp.getName()), billTypeProp.getDisplayName().getLocaleValue(), entityName, (DynamicObject[])objs);
                }
                if (message == null) {
                    message = this.bizCheck(data);
                }
                SingleBillResult billResult = new SingleBillResult();
                billResult.setDIndex(i);
                billResult.setMessage(message);
                allResults.add(billResult);
                if (!isAuth || message != null) continue;
                if (!data.containsKey("billsrctype")) {
                    data.put("billsrctype", BillSrcTypeEnum.IMPORT.getValue());
                }
                impDatas.add(data);
                mapping.put(i, dIndex);
                ++dIndex;
            }
            if (!impDatas.isEmpty()) {
                ApiResult exeResult = this.doProcess(impDatas, "save");
                result = datas.size() == impDatas.size() ? exeResult : this.mergeResult(allResults, mapping, exeResult);
            } else {
                ArrayList<Map<String, Object>> sDatas = new ArrayList<Map<String, Object>>(allResults.size());
                for (int i = 0; i < allResults.size(); ++i) {
                    SingleBillResult billResult = (SingleBillResult)allResults.get(i);
                    sDatas.add(SingleBillResult.toMap(billResult));
                }
                result = new ApiResult();
                result.setData(sDatas);
                result.setSuccess(false);
                result.setMessage("");
                result.setErrorCode("");
            }
        }
        return result;
    }

    protected String checkMainOrg(String orgNum, List<Long> permOrgs, String entityName, DynamicObject org) {
        String message = null;
        if (org == null) {
            org = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id, number, name", (QFilter[])new QFilter("number", "=", (Object)orgNum).toArray());
        }
        if (ObjectUtils.isEmpty((Object)org)) {
            message = String.format(ResManager.loadKDString((String)"\u201c\u7ed3\u7b97\u7ec4\u7ec7\u201d\u6570\u636e\u4e0d\u5b58\u5728\uff1a\u7f16\u7801\u201c%s\u201d\u3002", (String)"BillSaveApi_3", (String)"fi-arapcommon", (Object[])new Object[0]), orgNum);
        } else {
            long orgPk = org.getLong("id");
            String orgName = org.getLocaleString("name").getLocaleValue();
            if (!permOrgs.contains(orgPk)) {
                message = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%1$s(%2$s)\u201d\u6ca1\u6709\u201c%3$s\u201d\u7684\u65b0\u589e\u6743\u9650\u3002", (String)"BillSaveApi_4", (String)"fi-arapcommon", (Object[])new Object[0]), orgName, orgNum, entityName);
            } else {
                InitHelper init = new InitHelper(orgPk, this.isAr ? "ar_init" : "ap_init");
                if (ObjectUtils.isEmpty((Object)init.getInitId())) {
                    message = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%1$s(%2$s)\u201d\uff0c\u6ca1\u6709\u8fdb\u884c\u521d\u59cb\u5316\u8bbe\u7f6e\u3002", (String)"BillSaveApi_5", (String)"fi-arapcommon", (Object[])new Object[0]), orgName, orgNum);
                }
            }
        }
        return message;
    }

    protected String checkBillType(Object value, String name, String entityName, DynamicObject[] objs) {
        String message = null;
        LinkedHashMap vData = (LinkedHashMap)value;
        String vNum = (String)vData.get("number");
        if (StringUtils.isEmpty(vNum)) {
            message = String.format(ResManager.loadKDString((String)"\u8bf7\u8865\u5145\u201c%s\u201d\u3002", (String)"BillSaveApi_6", (String)"fi-arapcommon", (Object[])new Object[0]), name);
        } else {
            List billTypes = Stream.of(objs).map(b -> b.getString("number")).collect(Collectors.toList());
            if (!billTypes.contains(vNum)) {
                message = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e0d\u5b58\u5728%2$s\u7684%3$s\u3002", (String)"BillSaveApi_10", (String)"fi-arapcommon", (Object[])new Object[0]), entityName, vNum, name);
            }
        }
        return message;
    }

    protected ApiResult doProcess(List<Map<String, Object>> impDatas, String opName) {
        HashMap<String, List<Map<String, Object>>> dataMap = new HashMap<String, List<Map<String, Object>>>();
        dataMap.put("datas", impDatas);
        String entityTypeId = FormMetadataCache.getFormConfig((String)this.entityKey).getEntityTypeId();
        AbstractOperateWebApi webApi = FormMetadataCache.getFormOperationApi((String)entityTypeId, (String)opName);
        webApi.initialize(this.entityKey, dataMap);
        return webApi.execute();
    }

    private ApiResult mergeResult(List<SingleBillResult> allResults, Map<Integer, Integer> mapping, ApiResult exeResult) {
        ArrayList exeDatas = (ArrayList)exeResult.getData();
        TreeMap<Integer, Map> mappingResult = new TreeMap<Integer, Map>();
        block0: for (int i = 0; i < exeDatas.size(); ++i) {
            HashMap saveData = (HashMap)exeDatas.get(i);
            for (Map.Entry<Integer, Integer> entry : mapping.entrySet()) {
                if (i != entry.getValue()) continue;
                int actIndex = entry.getKey();
                Map actRet = (Map)org.apache.commons.lang3.ObjectUtils.clone((Object)saveData);
                actRet.replace("dindex", actIndex);
                mappingResult.put(actIndex, actRet);
                continue block0;
            }
        }
        ArrayList<Map<String, Object>> datas = new ArrayList<Map<String, Object>>(allResults.size());
        for (int i = 0; i < allResults.size(); ++i) {
            SingleBillResult billResult = allResults.get(i);
            int actIndex = billResult.getDIndex();
            Map actRet = (Map)mappingResult.get(actIndex);
            if (actRet != null) {
                datas.add(actRet);
                continue;
            }
            datas.add(SingleBillResult.toMap(billResult));
        }
        ApiResult merge = new ApiResult();
        merge.setData(datas);
        merge.setSuccess(false);
        merge.setMessage("");
        merge.setErrorCode("");
        return merge;
    }

    protected String bizCheck(LinkedHashMap<String, Object> data) {
        return null;
    }

    protected void checkNull(Object value, String name) {
        if (!this.isNull(value, name)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u8865\u5145\u201c%s\u201d\u3002", (String)"BillSaveApi_6", (String)"fi-arapcommon", (Object[])new Object[0]), name));
        }
    }

    protected void checkEntryNull(Object value, String name, int seq) {
        if (!this.isNull(value, name)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c\u5355\u636e\u4f53\u201d\u7b2c%1$s\u884c\uff1a\u8bf7\u8865\u5145%2$s\u3002", (String)"BillSaveApi_7", (String)"fi-arapcommon", (Object[])new Object[0]), seq, name));
        }
    }

    private boolean isNull(Object value, String name) {
        boolean notNull = false;
        if (!ObjectUtils.isEmpty((Object)value)) {
            if (value instanceof Map) {
                LinkedHashMap vData = (LinkedHashMap)value;
                String vNum = (String)vData.get("number");
                String vName = (String)vData.get("name");
                if (!StringUtils.isEmpty(vNum) || !StringUtils.isEmpty(vName)) {
                    notNull = true;
                }
            }
            if (value instanceof String) {
                notNull = true;
            }
            if (value instanceof BigDecimal) {
                notNull = true;
            }
            if (value instanceof Integer) {
                notNull = true;
            }
            if (value instanceof Double) {
                notNull = true;
            }
        }
        return notNull;
    }

    protected boolean isMaterial(Object sData, String materialProp) {
        boolean isMaterial = false;
        LinkedHashMap btData = (LinkedHashMap)sData;
        String btNum = (String)btData.get("number");
        String btName = (String)btData.get("name");
        String searchKey = null;
        Object qFilter = null;
        searchKey = !StringUtils.isEmpty(btNum) ? "number" : "name";
        DynamicObject obj = this.getBillTypeObj(searchKey, btNum);
        if (obj != null) {
            DynamicObjectCollection fieldcontrolentry = obj.getDynamicObjectCollection("fieldcontrolentry");
            for (DynamicObject fieldcontrol : fieldcontrolentry) {
                if (!materialProp.equals(fieldcontrol.getString("fieldkey")) || !fieldcontrol.getBoolean("mustinput")) continue;
                isMaterial = true;
                break;
            }
        } else {
            String message = null;
            message = "number".equals(searchKey) ? String.format(ResManager.loadKDString((String)"\u201c\u5355\u636e\u7c7b\u578b\u201d\u6570\u636e\u4e0d\u5b58\u5728\uff1a\u7f16\u7801\u201c%s\u201d\u3002", (String)"BillSaveApi_8", (String)"fi-arapcommon", (Object[])new Object[0]), btNum) : String.format(ResManager.loadKDString((String)"\u201c\u5355\u636e\u7c7b\u578b\u201d\u6570\u636e\u4e0d\u5b58\u5728\uff1a\u540d\u79f0\u201c%s\u201d\u3002", (String)"BillSaveApi_9", (String)"fi-arapcommon", (Object[])new Object[0]), btName);
            throw new KDBizException(message);
        }
        return isMaterial;
    }

    private DynamicObject getBillTypeObj(String property, String btNum) {
        String key = property + "_" + btNum;
        Object billTypeObj = this.materialCache.get(key);
        if (billTypeObj == null) {
            QFilter qFilter = new QFilter(property, "=", (Object)btNum);
            billTypeObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_billtype", (String)"id,number,fieldcontrolentry.fieldkey,fieldcontrolentry.mustinput", (QFilter[])new QFilter[]{qFilter});
            this.materialCache.put(key, billTypeObj);
        }
        return (DynamicObject)billTypeObj;
    }
}

