/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.openapi;

import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.entity.api.ApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.tx.AsyncTx;
import kd.fi.arapcommon.tx.AsyncTxService;

public class QueryTaskStateApiPlugin
implements IBillWebApiPlugin {
    public ApiResult doCustomService(Map<String, Object> params) {
        ApiResult result = new ApiResult();
        String entityKey = (String)params.get("entitykey");
        if (entityKey == null) {
            result.setSuccess(false);
            result.setMessage("please input entitykey as query parameter");
            return result;
        }
        String billNo = (String)params.get("billno");
        if (billNo == null) {
            result.setSuccess(false);
            result.setMessage("please input billno as query parameter");
            return result;
        }
        QFilter billNoFilter = new QFilter("billno", "=", (Object)billNo);
        boolean exists = QueryServiceHelper.exists((String)entityKey, (QFilter[])new QFilter[]{billNoFilter});
        if (exists) {
            result.setData((Object)"data has been imported successfully.");
            result.setSuccess(true);
            return result;
        }
        AsyncTxService asyncTxService = new AsyncTxService();
        AsyncTx[] txs = asyncTxService.query(entityKey, new String[]{billNo});
        if (txs.length == 0) {
            String message = "task not found.";
            result.setData((Object)message);
            result.setErrorCode("TASK_NOT_FOUND");
            result.setMessage(message);
            result.setSuccess(false);
            return result;
        }
        String state = txs[0].getState();
        if ("running".equals(state)) {
            String message = "task is delivering";
            result.setData((Object)message);
            result.setMessage(message);
            result.setSuccess(true);
            return result;
        }
        if ("err".equals(state)) {
            result.setData((Object)"process error");
            result.setMessage("process error");
            result.setErrorCode("PROCESS_ERROR");
            result.setSuccess(false);
            return result;
        }
        if ("success".equals(state)) {
            String message = "The task has been processed successfully,but data hasn't been imported into system.";
            result.setData((Object)message);
            result.setMessage(message);
            result.setErrorCode("UNEXPEXTED_ERROR");
            result.setSuccess(false);
            return result;
        }
        result.setData((Object)("unknow message state:" + state));
        result.setSuccess(false);
        return result;
    }
}

