/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.opplugin;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.InitOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.arapcommon.enums.BillOperationEnum;
import kd.fi.arapcommon.excecontrol.AbstractExecControlValidator;
import kd.fi.arapcommon.excecontrol.ExecCtrlHelper;
import kd.fi.arapcommon.helper.BOTPConditionHelper;
import kd.fi.arapcommon.service.log.LogUtil;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.OperationUtils;
import kd.fi.arapcommon.util.StdConfig;
import kd.fi.arapcommon.validator.DecimalScopeValidator;
import kd.fi.arapcommon.validator.FromEasBillValidator;

public abstract class ArapBaseOp
extends AbstractOperationServicePlugIn {
    private List<AbstractExecControlValidator> execControlValidators = new ArrayList<AbstractExecControlValidator>(8);
    private final Set<String> selectors = new HashSet<String>(64);

    public void initialize(InitOperationArgs e) {
        if (this.operateMeta.get("key") == null) {
            return;
        }
        Object[] execControls = ExecCtrlHelper.getNormalExecControl(this.billEntityType.getName(), this.operateMeta.get("key").toString());
        if (ObjectUtils.isEmpty((Object[])execControls)) {
            return;
        }
        this.execControlValidators = ExecCtrlHelper.getExecControlValidator((DynamicObject[])execControls);
        this.getExecControlSelectors((DynamicObject[])execControls);
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        if (this.operateMeta != null && !this.selectors.isEmpty()) {
            fieldKeys.addAll(this.selectors);
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new FromEasBillValidator());
        if (this.operateMeta != null) {
            Object type = this.operateMeta.get("type");
            if ("save".equals(type) || "submit".equals(type)) {
                e.addValidator((AbstractValidator)new DecimalScopeValidator());
            }
            if (!this.execControlValidators.isEmpty()) {
                for (AbstractExecControlValidator controlValidator : this.execControlValidators) {
                    e.addValidator((AbstractValidator)controlValidator);
                }
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        String opKey = e.getOperationKey();
        LogUtil.endLog(opKey, e.getDataEntities());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        String opKey = e.getOperationKey();
        LogUtil.beginLog(opKey, e.getDataEntities()[0].getDynamicObjectType().getName());
        this.operationCheck(e);
    }

    protected void operationCheck(BeforeOperationArgs e) {
        OperateOption operation = this.getOption();
        if (operation == null) {
            return;
        }
        if (EmptyUtils.isEmpty(operation.getVariables())) {
            return;
        }
        String ignoreApplyPayCheck = StdConfig.get("ignoreapplypaycheck");
        if ("true".equalsIgnoreCase(ignoreApplyPayCheck) && "ap_payapply".equals(e.getDataEntities()[0].getDataEntityType().getName())) {
            return;
        }
        String appId = (String)operation.getVariables().get("appnumber");
        boolean operationPermission = OperationUtils.hasOperationPermission(appId, this.billEntityType.getName(), BillOperationEnum.valuesOf(e.getOperationKey()));
        if (!operationPermission) {
            e.setCancelMessage(ResManager.loadKDString((String)"\u62a5\u8d26\u5de5\u4f5c\u53f0\u4e0b\u7981\u6b62\u4f7f\u7528\u6b64\u529f\u80fd\u3002", (String)"ArapBaseOp_0", (String)"fi-arapcommon", (Object[])new Object[0]));
            e.setCancel(true);
        }
    }

    private void getExecControlSelectors(DynamicObject[] execControls) {
        for (AbstractExecControlValidator controlValidator : this.execControlValidators) {
            this.selectors.addAll(controlValidator.preparePropertys());
        }
        String entityName = this.billEntityType.getName();
        for (DynamicObject execControl : execControls) {
            String dataFilterJson = execControl.getString("datafilterjson_tag");
            Set<String> tempSelectors = BOTPConditionHelper.getFormulaFieldsName(entityName, dataFilterJson);
            this.selectors.addAll(tempSelectors);
        }
    }
}

