/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.opplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class BaseDataEnableValidator
extends AbstractValidator {
    public void validate() {
        String entityKey;
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        switch (entityKey = this.getEntityKey()) {
            case "ap_finapbill": 
            case "ap_busbill": 
            case "ap_invoice": 
            case "ap_liquidation": 
            case "ar_finarbill": 
            case "ar_busbill": 
            case "ar_invoice": 
            case "ar_revcfmbill": 
            case "ar_liquidation": 
            case "ar_baddebtlossbill": {
                Map<String, List<DynamicObject>> asstactTypeGroupMap = Arrays.stream(dataEntities).map(ExtendedDataEntity::getDataEntity).collect(Collectors.groupingBy(c -> c.getString("asstacttype")));
                Map<Object, String> asstactMap = this.isAsstactEnable(asstactTypeGroupMap);
                if (ObjectUtils.isEmpty(asstactMap)) {
                    return;
                }
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    DynamicObject bill = dataEntity.getDataEntity();
                    Object asstactId = bill.get("asstact.id");
                    if (!"0".equals(asstactMap.get(asstactId))) continue;
                    this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5f80\u6765\u6237\u201c%s\u201d\u5df2\u7ecf\u88ab\u7981\u7528\u3002", (String)"AsstactEnableValidator_0", (String)"fi-arapcommon", (Object[])new Object[0]), bill.get("asstact.name")));
                }
                break;
            }
            case "ap_payapply": 
            case "ap_payapplychange": {
                HashMap<String, List<DynamicObject>> entryAsstactTypeGroupMap = new HashMap<String, List<DynamicObject>>(dataEntities.length);
                ArrayList<DynamicObject> dataList = new ArrayList<DynamicObject>(16);
                Set billSet = Arrays.stream(dataEntities).map(ExtendedDataEntity::getDataEntity).collect(Collectors.toSet());
                for (DynamicObject bill : billSet) {
                    DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entry");
                    for (DynamicObject entry : entrys) {
                        String asstacttype = entry.getString("e_asstacttype");
                        dataList.add(entry);
                        entryAsstactTypeGroupMap.put(asstacttype, dataList);
                    }
                }
                Map<Object, String> entryAsstactMap = this.isAsstactEnable(entryAsstactTypeGroupMap);
                if (ObjectUtils.isEmpty(entryAsstactMap)) {
                    return;
                }
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    DynamicObject bill = dataEntity.getDataEntity();
                    DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entry");
                    for (int i = 0; i < entrys.size(); ++i) {
                        DynamicObject entry = (DynamicObject)entrys.get(i);
                        Object asstactId = entry.get("e_asstact.id");
                        if (!"0".equals(entryAsstactMap.get(asstactId))) continue;
                        this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u5f80\u6765\u6237\u201c%2$s\u201d\u5df2\u7ecf\u88ab\u7981\u7528\u3002", (String)"AsstactEnableValidator_1", (String)"fi-arapcommon", (Object[])new Object[0]), i + 1, entry.get("e_asstact.name")));
                    }
                }
                break;
            }
        }
    }

    private Map<Object, String> isAsstactEnable(Map<String, List<DynamicObject>> asstactTypeGroupMap) {
        HashMap<Object, String> returnMap = new HashMap<Object, String>(16);
        HashMap<Object, DynamicObject> asstactMap = new HashMap<Object, DynamicObject>(16);
        for (Map.Entry<String, List<DynamicObject>> entry : asstactTypeGroupMap.entrySet()) {
            String asstactType = entry.getKey();
            List<DynamicObject> asstactListEntryValue = entry.getValue();
            Map<Object, DynamicObject> selectAsstactMap = this.selectAsstact(asstactListEntryValue, asstactType);
            if (ObjectUtils.isEmpty(selectAsstactMap)) continue;
            asstactMap.putAll(selectAsstactMap);
        }
        if (!ObjectUtils.isEmpty(asstactMap)) {
            for (Map.Entry<String, List<Object>> entry : asstactMap.entrySet()) {
                returnMap.put(entry.getKey(), ((DynamicObject)entry.getValue()).getString("enable"));
            }
        }
        return returnMap;
    }

    private Map<Object, DynamicObject> selectAsstact(List<DynamicObject> dataEntityList, String entityName) {
        Map dataMap;
        HashMap<Object, DynamicObject> asstactMap = new HashMap<Object, DynamicObject>(16);
        if (ObjectUtils.isEmpty(dataEntityList) || ObjectUtils.isEmpty((Object)entityName)) {
            return asstactMap;
        }
        HashSet<Object> asstactIdSet = new HashSet<Object>(8);
        if ("ap_payapply".equals(this.entityKey) || "ap_payapplychange".equals(this.entityKey)) {
            for (DynamicObject bill : dataEntityList) {
                Object asstactId = bill.get("e_asstact.id");
                if (asstactId == null) continue;
                asstactIdSet.add(asstactId);
            }
        } else {
            for (DynamicObject bill : dataEntityList) {
                Object asstactId = bill.get("asstact.id");
                if (asstactId == null) continue;
                asstactIdSet.add(asstactId);
            }
        }
        if (!ObjectUtils.isEmpty((Object)(dataMap = BusinessDataServiceHelper.loadFromCache((String)entityName, (String)"enable", (QFilter[])new QFilter[]{new QFilter("id", "in", asstactIdSet).and(new QFilter("enable", "=", (Object)"0"))})))) {
            asstactMap.putAll(dataMap);
        }
        return asstactMap;
    }
}

