/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.opplugin;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.arapcommon.helper.DynamicObjectHelper;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.util.DateUtils;

public class BillAppStatusValidator
extends AbstractValidator {
    private Map<Long, InitHelper> initHelperCache = new HashMap<Long, InitHelper>();

    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            Date startDate;
            DynamicObject bill = dataEntity.getDataEntity();
            DynamicObject org = bill.getDynamicObject("org");
            if (org == null) continue;
            Object orgId = org.getPkValue();
            InitHelper initHelper = this.getInitHelper((Long)orgId);
            if (!initHelper.isFinishSetting()) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u6ca1\u6709\u8fdb\u884c\u521d\u59cb\u5316\u8bbe\u7f6e\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58\u5355\u636e\u3002", (String)"BillAppStatusValidator_0", (String)"fi-arapcommon", (Object[])new Object[0]), DynamicObjectHelper.getLocalStringValue(org, "name")));
                continue;
            }
            Date bizDate = this.getBizDate(bill);
            if (bizDate == null) continue;
            if (this.isPeriodBill(bill)) {
                startDate = initHelper.getStartDate();
                if (startDate == null || DateUtils.compareTo(bizDate, startDate) < 0) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u4fdd\u5b58\u542f\u7528\u65e5\u671f\u4e4b\u540e\u7684\u671f\u521d\u5355\u636e\u3002", (String)"BillAppStatusValidator_1", (String)"fi-arapcommon", (Object[])new Object[0]));
                continue;
            }
            startDate = initHelper.getStartDate();
            if (startDate == null || bizDate.compareTo(startDate) >= 0 || "ap_finapbill".equals(this.entityKey)) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u4fdd\u5b58\u542f\u7528\u65e5\u671f\u4e4b\u524d\u7684\u4e1a\u52a1\u5355\u636e\u3002", (String)"BillAppStatusValidator_3", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
    }

    private InitHelper getInitHelper(Long orgId) {
        if (this.initHelperCache.get(orgId) != null) {
            return this.initHelperCache.get(orgId);
        }
        InitHelper initHelper = new InitHelper(orgId, this.entityKey.contains("ap_") ? "ap_init" : "ar_init");
        this.initHelperCache.put(orgId, initHelper);
        return initHelper;
    }

    private boolean isPeriodBill(DynamicObject bill) {
        String entityKey = bill.getDataEntityType().getName();
        if ("ap_invoice".equals(entityKey) || "ar_invoice".equals(entityKey)) {
            return false;
        }
        return bill.getBoolean("isperiod");
    }

    private Date getBizDate(DynamicObject bill) {
        String entityKey = bill.getDataEntityType().getName();
        if ("ap_invoice".equals(entityKey)) {
            return bill.getDate("issuedate");
        }
        return bill.getDate("bizdate");
    }
}

