/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.opplugin;

import java.util.LinkedList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.arapcommon.helper.LineTypeHelper;
import kd.fi.arapcommon.validator.BillSubmit4LineTypeValidator;
import kd.fi.arapcommon.validator.LineTypeValidator;
import kd.fi.arapcommon.vo.LineTypeInfo;

public class BillSubmit4LineTypeOp
extends AbstractOperationServicePlugIn {
    private List<LineTypeInfo> lineTypeInfos = new LinkedList<LineTypeInfo>();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("org");
        fieldKeys.add("biztype");
        fieldKeys.add("linetype");
        fieldKeys.add("ap_finapbill".equals(this.billEntityType.getName()) ? "billtypeid" : "billtype");
        fieldKeys.add("payproperty");
        fieldKeys.add("ap_finapbill".equals(this.billEntityType.getName()) ? "expenseitem" : "e_expenseitem");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new BillSubmit4LineTypeValidator(this.lineTypeInfos));
        e.addValidator((AbstractValidator)new LineTypeValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        for (DynamicObject bill : e.getDataEntities()) {
            for (LineTypeInfo lineTypeInfo : this.lineTypeInfos) {
                long billTypeId = bill.getLong("ap_finapbill".equals(this.billEntityType.getName()) ? "billtypeid.id" : "billtype.id");
                if (billTypeId != lineTypeInfo.getBillTypeId()) continue;
                if (bill.getDynamicObject("biztype") == null) {
                    bill.set("biztype", (Object)LineTypeHelper.getBizTypebyId(lineTypeInfo.getBizTypeId()));
                }
                String billEntityKey = bill.getDataEntityType().getName();
                DynamicObjectCollection detailEntry = bill.getDynamicObjectCollection(this.getDetailEntryKey(billEntityKey));
                for (DynamicObject row : detailEntry) {
                    if (row.getDynamicObject("linetype") != null) continue;
                    row.set("linetype", (Object)LineTypeHelper.getLineTypebyId(lineTypeInfo.getLineTypeId()));
                }
            }
        }
    }

    private String getDetailEntryKey(String billEntityKey) {
        return "ap_finapbill".equals(billEntityKey) ? "detailentry" : "entry";
    }
}

