/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.opplugin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.operate.IOperationResult;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.plugin.args.ReturnOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPools;
import kd.fi.arapcommon.consts.DBRouteConst;
import kd.fi.arapcommon.helper.ScmParamsHelper;
import kd.fi.arapcommon.service.vchconsist.BillVchouerSyncHelper;
import kd.fi.arapcommon.service.vchconsist.listener.BillVchSyncListener;
import kd.fi.arapcommon.validator.BillVoucherSyncValidator;

public class BillVoucherSyncOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(BillVoucherSyncOp.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new BillVoucherSyncValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        if (!ScmParamsHelper.isEnable("INV0005")) {
            return;
        }
        DynamicObject[] dataEntities = e.getDataEntities();
        Set billIds = Stream.of(dataEntities).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
        final String requestId = RequestContext.get().getRequestId();
        String appId = this.billEntityType.getAppId();
        final IAppCache iAppCache = AppCache.get((String)appId);
        iAppCache.put(requestId, billIds);
        final DBRoute dbRoute = DBRouteConst.AP;
        ThreadPools.executeOnce((String)"BillVoucherSyncOp", (Runnable)new Runnable(){

            @Override
            public void run() {
                Set billIds;
                while ((billIds = (Set)iAppCache.get(requestId, Set.class)) != null) {
                    String updateSql = "update t_ap_taskcollaborate set feffectivetime = ? where fbillid in (?) and frequestid = ?";
                    ArrayList<Object[]> updateParams = new ArrayList<Object[]>(16);
                    long timeMillis = System.currentTimeMillis() + 10000L;
                    for (Object billId : billIds) {
                        Object[] param = new Object[]{timeMillis, billId, requestId};
                        updateParams.add(param);
                    }
                    DB.executeBatch((DBRoute)dbRoute, (String)updateSql, updateParams);
                    try {
                        TimeUnit.SECONDS.sleep(3L);
                    }
                    catch (InterruptedException ex) {
                        logger.error(ex.getMessage(), (Throwable)ex);
                    }
                }
            }
        });
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        if (!ScmParamsHelper.isEnable("INV0005")) {
            return;
        }
        DynamicObject[] dataEntities = e.getDataEntities();
        Set<Long> billIds = Stream.of(dataEntities).map(b -> b.getLong("id")).collect(Collectors.toSet());
        String requestId = RequestContext.get().getRequestId();
        CommonParam commonParam = BillVchouerSyncHelper.createParam(billIds, requestId, this.billEntityType);
        BillVchSyncListener billVchSyncListener = new BillVchSyncListener(commonParam);
        TX.addCommitListener((CommitListener)billVchSyncListener);
    }

    public void onReturnOperation(ReturnOperationArgs e) {
        super.onReturnOperation(e);
        if (!ScmParamsHelper.isEnable("INV0005")) {
            return;
        }
        IOperationResult iOperationResult = e.getOperationResult();
        List successPkIds = iOperationResult.getSuccessPkIds();
        if (iOperationResult instanceof OperationResult) {
            OperationResult operationResult = (OperationResult)iOperationResult;
            Map billNos = operationResult.getBillNos();
            Set billIds = billNos.keySet();
            billIds.removeAll(successPkIds);
            String requestId = RequestContext.get().getRequestId();
            if (!billIds.isEmpty()) {
                String updateSql = "update t_ap_taskcollaborate set feffectivetime = ? where fbillid in (?) and frequestid = ?";
                ArrayList<Object[]> updateParams = new ArrayList<Object[]>(16);
                long currentTimeMillis = System.currentTimeMillis();
                for (Object billId2 : billIds) {
                    Object[] updateParam = new Object[]{currentTimeMillis, billId2, requestId};
                    updateParams.add(updateParam);
                }
                DB.executeBatch((DBRoute)DBRouteConst.AP, (String)updateSql, updateParams);
                Set<Long> failBillIds = billIds.stream().map(billId -> (Long)billId).collect(Collectors.toSet());
                CommonParam commonParam = BillVchouerSyncHelper.createParam(failBillIds, requestId, this.billEntityType);
                try (TXHandle tx = TX.requiresNew();){
                    try {
                        BillVchouerSyncHelper.createSession("BillVchRollBackService", commonParam);
                    }
                    catch (Exception ex) {
                        tx.markRollback();
                        throw ex;
                    }
                }
            }
        }
    }
}

