/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.opplugin;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.helper.BOTPHelper;

public class BusBillBatchWoffValidator
extends AbstractValidator {
    public void validate() {
        String busEntityKey = this.getEntityKey();
        boolean isAr = false;
        if (busEntityKey.startsWith("ar")) {
            isAr = true;
        }
        Tuple<Map<Long, List<Long>>, DynamicObjectCollection> tuple = this.processFinData(this.dataEntities, busEntityKey, isAr);
        Map tarBillIdsMap = (Map)tuple.item1;
        DynamicObjectCollection finCollection = (DynamicObjectCollection)tuple.item2;
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            List unWriteOffList;
            List exist;
            DynamicObject info = dataEntity.getDataEntity();
            List finPkList = (List)tarBillIdsMap.get(info.getLong("id"));
            if (finPkList != null && !finPkList.isEmpty() && finCollection != null && !(exist = finCollection.stream().filter(fin -> finPkList.contains(fin.getLong("id"))).collect(Collectors.toList())).isEmpty()) {
                this.addErrorMessage(dataEntity, isAr ? ResManager.loadKDString((String)"\u5b58\u5728\u5728\u9014\u7684\u8d22\u52a1\u5e94\u6536\u5355\uff0c\u65e0\u6cd5\u51b2\u56de\u3002", (String)"BusBillBatchWoffValidator_1", (String)"fi-arapcommon", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5b58\u5728\u5728\u9014\u7684\u8d22\u52a1\u5e94\u4ed8\u5355\uff0c\u65e0\u6cd5\u51b2\u56de\u3002", (String)"BusBillBatchWoffValidator_2", (String)"fi-arapcommon", (Object[])new Object[0]));
            }
            if (!(unWriteOffList = info.getDynamicObjectCollection("entry").stream().filter(entry -> !entry.getBoolean("e_iswriteoff")).collect(Collectors.toList())).isEmpty()) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u7ecf\u88ab\u51b2\u56de\u7684\u660e\u7ec6\u5206\u5f55\u4e0d\u9700\u8981\u518d\u6b21\u51b2\u56de\u3002", (String)"BusBillBatchWoffValidator_3", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
    }

    private Tuple<Map<Long, List<Long>>, DynamicObjectCollection> processFinData(ExtendedDataEntity[] dataEntities, String busEntityKey, boolean isAr) {
        HashSet<Long> ids = new HashSet<Long>(dataEntities.length);
        HashSet<Long> entryIds = new HashSet<Long>(dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject busBill = dataEntity.getDataEntity();
            ids.add(busBill.getLong("id"));
            DynamicObjectCollection entryColl = busBill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entryColl) {
                entryIds.add(entry.getLong("id"));
            }
        }
        String finEntityKey = isAr ? "ar_finarbill" : "ap_finapbill";
        Map<Long, List<Long>> tarBillIdsMap = BOTPHelper.loadNearTarBillIds(busEntityKey, "entry", ids.toArray(new Long[0]), entryIds.toArray(new Long[0]), finEntityKey);
        Set finPks = tarBillIdsMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        DynamicObjectCollection finCollection = null;
        if (!finPks.isEmpty()) {
            QFilter qf = new QFilter("id", "in", finPks);
            qf.and("billstatus", "!=", (Object)"C");
            finCollection = QueryServiceHelper.query((String)finEntityKey, (String)"id", (QFilter[])new QFilter[]{qf});
        }
        return Tuple.create(tarBillIdsMap, finCollection);
    }
}

