/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.opplugin;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.validator.CloseAccountValidatorBase;

public class CloseAccountBaseOp
extends AbstractOperationServicePlugIn {
    protected Date closeDate;
    protected Date nextCloseDate;

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List selector = e.getFieldKeys();
        selector.add("isfinishinit");
        selector.add("currentdate");
        selector.add("startdate");
        selector.add("entryentity");
        selector.add("entryentity.failedmessage");
        selector.add("entryentity.billtype");
        selector.add("entryentity.count");
        selector.add("entryentity.duedate");
        selector.add("entryentity.status");
    }

    protected Date getCloseDate() {
        if (this.closeDate == null) {
            String closeDateString = this.getOption().getVariableValue("closedate");
            try {
                this.closeDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(closeDateString);
            }
            catch (ParseException e) {
                throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
            }
        }
        return this.closeDate;
    }

    protected Date getNextCloseDate() {
        if (this.nextCloseDate == null) {
            this.nextCloseDate = DateUtils.getNextDay(this.getCloseDate(), 1);
            this.nextCloseDate = DateUtils.getDataFormat(this.nextCloseDate, true);
        }
        return this.nextCloseDate;
    }

    protected String getCloseAccountEntity() {
        throw new RuntimeException(ResManager.loadKDString((String)"\u5b50\u7c7b\u8981\u8986\u5199\uff0c\u8fd4\u56de\u5173\u8d26\u5b9e\u4f53\u6807\u8bc6\uff0c\u77e5\u9053\u4e86\u5417\uff1f", (String)"CloseAccountBaseOp_0", (String)"fi-arapcommon", (Object[])new Object[0]));
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        Object[] infos = e.getDataEntities();
        if (infos.length > 0) {
            for (DynamicObject info : e.getDataEntities()) {
                info.set("currentdate", (Object)this.getNextCloseDate());
                info.set("entryentity", null);
            }
            SaveServiceHelper.save((IDataEntityType)infos[0].getDataEntityType(), (Object[])infos);
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        CloseAccountValidatorBase v = new CloseAccountValidatorBase();
        v.setCloseDate(this.getCloseDate());
        v.setEntityKey(this.getCloseAccountEntity());
        e.addValidator((AbstractValidator)v);
    }
}

