/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.opplugin;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.service.AdjExchService;
import kd.fi.arapcommon.service.BalanceService;
import kd.fi.arapcommon.service.CloseRecordService;
import kd.fi.arapcommon.service.concurrency.ConcurrencyCtrlUtil;
import kd.fi.arapcommon.util.DateUtils;

public class ClosePeriodBaseOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(ClosePeriodBaseOp.class);
    private static final String closeStatus = "bd_closecheckitem";
    private static final String CACHE_KEY_PREFIX = "periodClose_";
    private static IAppCache cache = AppCache.get((String)"gl");

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        Set<Long> orgIds = Arrays.stream(e.getDataEntities()).map(v -> v.getLong("org.id")).collect(Collectors.toSet());
        String bizName = this.getInitEntityKey() + "closeperiod";
        ConcurrencyCtrlUtil.addCtrlInTX("bos_org", bizName, orgIds, false);
        for (DynamicObject init : e.getDataEntities()) {
            DynamicObject org = init.getDynamicObject("org");
            if (ObjectUtils.isEmpty((Object)org)) {
                this.operationResult.setSuccess(false);
                return;
            }
            InitHelper helper = new InitHelper((Long)org.getPkValue(), this.getInitEntityKey());
            this.doClosePeriod(helper.getInitId(), new HashMap<Long, Boolean>());
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        AdjExchService adjExchService = new AdjExchService(this.isAr(this.getInitEntityKey()) ? "ar" : "ap");
        List<Long> orgIds = adjExchService.getOrgIds(e.getDataEntities());
        Map<Long, Boolean> orgAndParamMap = adjExchService.getIsParticipateInAdjExchMap(orgIds);
        for (DynamicObject init : e.getDataEntities()) {
            DynamicObject curinitData;
            DynamicObject org = init.getDynamicObject("org");
            InitHelper helper = new InitHelper((Long)org.getPkValue(), this.getInitEntityKey());
            if (this.operationResult.isSuccess() && orgAndParamMap.get(org.getLong("id")).booleanValue()) {
                curinitData = BusinessDataServiceHelper.loadSingle((Object)helper.getInitId(), (String)this.getInitEntityKey());
                adjExchService.insertAdjExchRecord(curinitData, Boolean.FALSE);
            }
            if (!this.operationResult.isSuccess()) continue;
            curinitData = BusinessDataServiceHelper.loadSingle((Object)helper.getInitId(), (String)this.getInitEntityKey());
            if (curinitData == null) {
                return;
            }
            DynamicObject curperiodDO = curinitData.getDynamicObject("curperiod");
            String appNum = "ap";
            if ("ar_init".equals(this.getInitEntityKey())) {
                appNum = "ar";
            }
            if (curperiodDO == null) continue;
            CloseRecordService closeRecordService = new CloseRecordService(appNum);
            closeRecordService.saveCloseRecord(org.getLong("id"), DateUtils.truncateDate(curperiodDO.getDate("enddate")));
            BalanceService balanceService = new BalanceService(appNum);
            balanceService.saveBalance(org.getLong("id"), curperiodDO);
        }
    }

    protected String getInitEntityKey() {
        return null;
    }

    private void doClosePeriod(Object initId, Map<Long, Boolean> orgAndParamMap) {
        DynamicObject curperiodDO;
        String initKey = this.getInitEntityKey();
        if (initKey == null) {
            return;
        }
        DynamicObject init = BusinessDataServiceHelper.loadSingle((Object)initId, (String)initKey);
        DynamicObject closeCheckItem = BusinessDataServiceHelper.newDynamicObject((String)closeStatus);
        String curperiod = "";
        Long orgId = (Long)init.getDynamicObject("org").getPkValue();
        if (!this.closeCheck(init, closeCheckItem)) {
            this.operationResult.setSuccess(false);
            OperateErrorInfo error = new OperateErrorInfo();
            error.setErrorLevel(ErrorLevel.Error.toString());
            DynamicObjectCollection entries = closeCheckItem.getDynamicObjectCollection("entryentity");
            StringBuilder sb = new StringBuilder();
            for (DynamicObject entry : entries) {
                if (!"0".equals(entry.getString("checkstate"))) continue;
                sb.append(entry.get("checkitem"));
                sb.append('\t');
            }
            if (this.operateOption.containsVariable("reachperiod")) {
                curperiod = this.operateOption.getVariableValue("reachperiod", "0");
            }
            error.setMessage(sb.toString());
            error.setPkValue(init.getPkValue());
            this.operationResult.getAllErrorInfo().add(error);
        }
        if ((curperiodDO = init.getDynamicObject("curperiod")) != null) {
            curperiod = curperiodDO.getPkValue().toString();
        }
        closeCheckItem.set("company", (Object)init.getDynamicObject("org").getPkValue().toString());
        closeCheckItem.set("period", (Object)curperiod);
        closeCheckItem.set("subsysformnum", (Object)initKey);
        closeCheckItem.set("accountbooks", initId);
        Map variables = this.operateOption.getVariables();
        if (variables.get("closeCacheKey") != null) {
            cache.put(CACHE_KEY_PREFIX + (String)variables.get("closeCacheKey"), (Object)DataEntitySerializer.serializerToString((Object)closeCheckItem));
        }
    }

    private boolean isAr(String initKey) {
        String appName = initKey.substring(0, 2);
        return "ar".equals(appName);
    }

    private boolean closeCheck(DynamicObject init, DynamicObject closeCheckItem) {
        String periodPk;
        DynamicObjectCollection entries = closeCheckItem.getDynamicObjectCollection("entryentity");
        entries.clear();
        if (!this.orgIsfinishInit(init, entries)) {
            return false;
        }
        long orgPk = (Long)init.getDynamicObject("org").getPkValue();
        long curPerPk = (Long)init.getDynamicObject("curperiod").getPkValue();
        if (this.operateOption.containsVariable("reachperiod") && !this.isLegalPeriod(curPerPk, entries, Long.parseLong(periodPk = this.getOption().getVariableValue("reachperiod")))) {
            return false;
        }
        boolean isCloseAcct = this.isCloseAcct(orgPk, curPerPk, init.getDate("currentdate"), entries);
        return isCloseAcct;
    }

    private boolean isLegalPeriod(long curPerPk, DynamicObjectCollection entries, long periodPk) {
        DynamicObject periodN = QueryServiceHelper.queryOne((String)"bd_period", (String)"number,isadjustperiod", (QFilter[])new QFilter("id", "=", (Object)periodPk).toArray());
        DynamicObject currentPeriod = QueryServiceHelper.queryOne((String)"bd_period", (String)"number,isadjustperiod", (QFilter[])new QFilter("id", "=", (Object)curPerPk).toArray());
        boolean isTrue = periodN.getBoolean("isadjustperiod") && !currentPeriod.getBoolean("isadjustperiod") ? currentPeriod.getInt("number") <= periodN.getInt("number") : currentPeriod.getInt("number") < periodN.getInt("number");
        String icon = "/icons/pc/entrance/cn_dianzihuidan_48_48.png";
        if (isTrue) {
            this.setSuccessInfo(entries, ResManager.loadKDString((String)"\u662f\u5f53\u524d\u671f\u95f4", (String)"ClosePeriodBaseOp_0", (String)"fi-arapcommon", (Object[])new Object[0]), "1", icon);
            return true;
        }
        this.setCheckInfo(entries, ResManager.loadKDString((String)"\u671f\u95f4\u8303\u56f4\u4e0d\u7b26", (String)"ClosePeriodBaseOp_1", (String)"fi-arapcommon", (Object[])new Object[0]), "0", null, null, ResManager.loadKDString((String)"\u5f53\u524d\u671f\u95f4\u5927\u4e8e\u6216\u7b49\u4e8e\u5f85\u7ed3\u8d26\u671f\u95f4\u3002", (String)"ClosePeriodBaseOp_2", (String)"fi-arapcommon", (Object[])new Object[0]), icon);
        return false;
    }

    private boolean orgIsfinishInit(DynamicObject init, DynamicObjectCollection entries) {
        if (init.getBoolean("isfinishinit") && init.getDynamicObject("curperiod") != null) {
            return true;
        }
        String icon = AppMetadataCache.getAppMenuInfo((String)"gl", (String)"14TBH+QADE14").getShortcutIcon();
        String closeAcctKey = null;
        String initKey = this.getInitEntityKey();
        closeAcctKey = "ar_init".equals(initKey) ? "ar_closeaccount" : "ap_closeaccount";
        QFilter qf = new QFilter("org", "=", init.getPkValue());
        String errorInfo = ResManager.loadKDString((String)"\u7ec4\u7ec7\u672a\u7ed3\u675f\u521d\u59cb\u5316\u6216\u5f53\u524d\u671f\u95f4\u4e3a\u7a7a\u3002", (String)"ClosePeriodBaseOp_3", (String)"fi-arapcommon", (Object[])new Object[0]);
        this.setCheckInfo(entries, errorInfo, "0", qf.toSerializedString(), closeAcctKey, errorInfo, icon);
        return false;
    }

    private boolean isCloseAcct(long orgPk, long periodPk, Date currentDate, DynamicObjectCollection entries) {
        boolean isClose = false;
        DynamicObject currPeriod = BusinessDataServiceHelper.loadSingleFromCache((Object)periodPk, (String)"bd_period");
        Date endDate = currPeriod.getDate("enddate");
        String icon = AppMetadataCache.getAppMenuInfo((String)"gl", (String)"14TBH+QADE14").getShortcutIcon();
        if (currentDate.getTime() >= endDate.getTime()) {
            this.setSuccessInfo(entries, ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u5173\u8d26", (String)"ClosePeriodBaseOp_4", (String)"fi-arapcommon", (Object[])new Object[0]), "1", icon);
            isClose = true;
        } else {
            String closeAcctKey = null;
            String initKey = this.getInitEntityKey();
            closeAcctKey = "ar_init".equals(initKey) ? "ar_closeaccount" : "ap_closeaccount";
            QFilter qf = new QFilter("org", "=", (Object)orgPk);
            this.setCheckInfo(entries, ResManager.loadKDString((String)"\u672a\u5b8c\u6210\u5173\u8d26", (String)"ClosePeriodBaseOp_5", (String)"fi-arapcommon", (Object[])new Object[0]), "0", qf.toSerializedString(), closeAcctKey, "", icon);
        }
        return isClose;
    }

    private DynamicObject setCheckInfo(DynamicObjectCollection entries, String checkitem, String checkstate, String formquery, String formnumber, String message, String menuid) {
        DynamicObject entry = this.setSuccessInfo(entries, checkitem, checkstate, menuid);
        entry.set("formquery", (Object)formquery);
        entry.set("formnumber", (Object)formnumber);
        entry.set("message", (Object)message);
        return entry;
    }

    private DynamicObject setSuccessInfo(DynamicObjectCollection entries, String checkitem, String checkstate, String menuid) {
        DynamicObject entry = new DynamicObject(entries.getDynamicObjectType());
        entry.set("checkitem", (Object)checkitem);
        entry.set("checkstate", (Object)checkstate);
        entry.set("menuid", (Object)menuid);
        entries.add((Object)entry);
        return entry;
    }
}

