/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.opplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.fi.arapcommon.check.helper.DataCheckHelper;
import kd.fi.arapcommon.check.param.DataCheckTaskParam;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.StdConfig;
import kd.fi.arapcommon.util.StringUtils;

public class DataCheckItemExecOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("app");
        e.getFieldKeys().add("plugin");
        e.getFieldKeys().add("bizobj");
        e.getFieldKeys().add("checktype");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList<DynamicObject> apDataEntities = new ArrayList<DynamicObject>(dataEntities.length);
        ArrayList<DynamicObject> arDataEntities = new ArrayList<DynamicObject>(dataEntities.length);
        for (DynamicObject data : dataEntities) {
            String app = data.getString("app");
            if ("ap".equals(app)) {
                apDataEntities.add(data);
                continue;
            }
            if (!"ar".equals(app)) continue;
            arDataEntities.add(data);
        }
        ThreadPools.executeOnceIncludeRequestContext((String)"DataCheckItemExecOp", () -> {
            this.executeCheck("ap", apDataEntities);
            this.executeCheck("ar", arDataEntities);
        });
    }

    private void executeCheck(String appId, List<DynamicObject> dataEntities) {
        if (ObjectUtils.isEmpty(dataEntities)) {
            return;
        }
        Date checkBeginDate = DataCheckHelper.getCheckBeginDate();
        String checkBeginDateDiff = StdConfig.get("checkBeginDateDiff");
        if (StringUtils.isNotEmpty(checkBeginDateDiff)) {
            checkBeginDate = DateUtils.getLastDay(new Date(), Integer.parseInt(checkBeginDateDiff));
        }
        ArrayList<DynamicObject> checkResultList = new ArrayList<DynamicObject>(dataEntities.size());
        Set<Long> orgIds = DataCheckHelper.getInitOrgIds(appId);
        Map<String, List<DynamicObject>> dataMap = dataEntities.stream().collect(Collectors.groupingBy(data -> data.getString("bizobj.id")));
        for (Long orgId : orgIds) {
            for (Map.Entry<String, List<DynamicObject>> entry : dataMap.entrySet()) {
                String bizObj = entry.getKey();
                List<DynamicObject> value = entry.getValue();
                DynamicObject checkResult = DataCheckHelper.genUnExecCheckResult(orgId, bizObj, value, checkBeginDate);
                checkResultList.add(checkResult);
            }
        }
        if (!checkResultList.isEmpty()) {
            DynamicObject[] results = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])checkResultList.toArray(new DynamicObject[0]));
            List<DataCheckTaskParam> taskParamList = DataCheckHelper.convertTaskParam(results);
            DataCheckHelper.batchExecTask(taskParamList);
        }
    }
}

